/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.OpenStyle;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.MutexMappingEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.formula.biz.FormulaService;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandler;
import kd.taxc.bdtaxr.common.onekeygenerate.EngineHandlerFactory;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.engine.EngineModel;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.helper.LicenseCheckServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.exception.ThrowableHelper;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.TaxDeclareReFetchDataTask;

public abstract class AbstractDeclareReportPluginNew
extends AbstractFormPlugin {
    private static final String COMMA = ResManager.loadKDString((String)"\uff0c", (String)"AbstractDeclareReportPluginNew_39", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    private static Log logger = LogFactory.getLog(AbstractDeclareReportPluginNew.class);
    protected static final String ORGID_KEY = "orgid";
    protected static final String OLD_ORGID_KEY = "oldorgid";
    protected static final String CONTENT_TAB = "tabcontent";
    protected static final String SBBID = "cache_sbbid";
    protected static final String EDIT_KEY = "edit";
    protected static final String SAVE_KEY = "save";
    protected static final String CANCEL_KEY = "cancel";
    protected static final String SUBMIT_KEY = "submit";
    protected static final String UNSUBMIT_KEY = "unsubmit";
    protected static final String RECALC_KEY = "recalc";
    protected static final String REGETDATA_KEY = "regetdata";
    private static final String VIEW_DRAFT_KEY = "viewdraft";
    protected static final String AUDIT_KEY = "audit";
    protected static final String UNAUDIT_KEY = "unaudit";
    protected static final String VIEWFLOWCHART_KEY = "viewflowchart";
    protected static final String REFRESH_KEY = "refresh";
    protected static final String CLOSE_KEY = "close";
    private static final String ONE_KEY_GENERATE = "onekeygenerate";
    private static final String LINK_TO_DRAFT_LIST = "linktodraftlist";
    protected static final String ORG_SEL = "org";
    private static final String DECLARE_PAGE_ENTITY_NEW = "bdtaxr_declare";
    protected static final String BILL_STATUS = "cache_billstatus";
    protected static final String BILLNO = "billno";
    private static final String CALLBACKID_MOD = "modifyOrDelete";
    private static final String CALLBACKID_MODIFY = "callback_modify";
    private static final String TEMPLATE_TYPE = "templatetype";
    public static final String TAXPAYER_TYPE_KEY = "taxPayerType";
    protected static final String EDIT = "edit";
    protected static final String VIEW = "read";

    public void registerListener(EventObject e) {
        String BAR_KEY = "toolbarap";
        String TOOL_BAR_DECLARE = "toolbarapdeclare";
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit", SUBMIT_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get(ORGID_KEY) != null && customParams.get("skssqq") != null && customParams.get("skssqz") != null) {
            this.loadFromHyperLinkClick(customParams);
        } else {
            this.loadFromDeclareMenu();
        }
    }

    private void loadFromDeclareMenu() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String paramOrg = (String)customParams.get(ORGID_KEY);
        long org = StringUtil.isNotBlank((CharSequence)paramOrg) ? Long.parseLong(paramOrg) : RequestContext.get().getOrgId();
        HasPermOrgResult hasPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
        DynamicObjectCollection col = TreeUtils.queryOrgListHasPermission((HasPermOrgResult)hasPermOrgs, (boolean)true);
        Long orgid = OrgCheckUtil.setDefaultOrg((IFormView)this.getView(), (Long)org, (DynamicObjectCollection)col);
        if (orgid == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8bbe\u7f6e\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"AbstractDeclareReportPluginNew_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ORGID_KEY, String.valueOf(orgid));
        this.getPageCache().put(OLD_ORGID_KEY, String.valueOf(orgid));
        this.initPeriod(this.getModel(), this.getPageCache(), String.valueOf(orgid), customParams);
        this.beforeOpenInnerPage(String.valueOf(orgid), customParams);
        this.init();
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        boolean checkResult;
        String orgid = (String)customParams.get(ORGID_KEY);
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgid));
        String orgname = ((DynamicObject)org.get(0)).getString("name");
        orgname = orgname == null ? "" : orgname;
        DynamicObject declareMain = this.getDeclareMain(orgid, (String)customParams.get("skssqq"), (String)customParams.get("skssqz"), customParams.get(TEMPLATE_TYPE));
        if (declareMain != null && declareMain.getBoolean("zerodeclare")) {
            if (!"zzstz".equals(this.getTemplateType())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0\u3002", (String)"AbstractDeclareReportPluginNew_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
            }
            checkResult = OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)orgid, (String)appid, (String)Objects.requireNonNull(TaxAppEnum.getEnumInstanceByAppid((String)appid)).getCategoryCode());
        } else {
            checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)Objects.requireNonNull(TaxAppEnum.getEnumInstanceByAppid((String)appid)).getCategoryCode());
        }
        if (!checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, orgid);
            this.getPageCache().put(OLD_ORGID_KEY, orgid);
            String skssqqstr = (String)customParams.get("skssqq");
            Date skssqq = DateUtils.stringToDate((String)skssqqstr);
            this.getModel().setValue("skssqq", (Object)skssqq);
            this.getPageCache().put("skssqq", skssqqstr);
            String skssqzstr = (String)customParams.get("skssqz");
            Date skssqz = DateUtils.stringToDate((String)skssqzstr);
            this.getModel().setValue("skssqz", (Object)skssqz);
            this.getPageCache().put("skssqz", skssqzstr);
            customParams.get(REFRESH_KEY);
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            this.getPageCache().put(TAXPAYER_TYPE_KEY, (String)customParams.get(TEMPLATE_TYPE));
            this.getPageCache().put(TEMPLATE_TYPE + orgid + this.getPageCache().get(TAXPAYER_TYPE_KEY) + startDate + endDate, (String)customParams.get(TAXPAYER_TYPE_KEY));
            this.openDeclarePage(orgid, skssqqstr, skssqzstr, "true".equals(String.valueOf(customParams.get(REFRESH_KEY))));
            this.init();
        }
    }

    private void beforeOpenInnerPage(String orgid, Map<String, Object> customParams) {
        boolean checkResult;
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        DynamicObjectCollection org = TreeUtils.queryOrgListByCondition((Map)TreeUtils.convertParam((String)"id", (Object)orgid));
        String orgname = ((DynamicObject)org.get(0)).getString("name");
        orgname = orgname == null ? "" : orgname;
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)Long.parseLong(orgid));
        if (zerodeclare) {
            if (!"zzstz".equals(this.getTemplateType())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0\u3002", (String)"AbstractDeclareReportPluginNew_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
            }
            checkResult = OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)orgid, (String)appid, (String)Objects.requireNonNull(TaxAppEnum.getEnumInstanceByAppid((String)appid)).getCategoryCode());
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
        } else {
            checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)Objects.requireNonNull(TaxAppEnum.getEnumInstanceByAppid((String)appid)).getCategoryCode());
        }
        if (!checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)orgid);
            this.getPageCache().put(ORGID_KEY, orgid);
            this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), false);
        } else {
            this.getPageCache().put(ORGID_KEY, null);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean noValid;
        DynamicObject declareMain;
        Boolean needMsg;
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appid == null || changeData == null || changeData.length == 0) {
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        if (null == org) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        this.getPageCache().put(ORGID_KEY, org.getString("id"));
        String templateType = this.getTemplateType();
        if (e.getProperty().getName().equals(ORG_SEL)) {
            String orgid;
            DynamicObject declareMain2;
            boolean checkResult;
            Object object = changeData[0].getNewValue();
            if (StringUtils.isBlank((Object)object) && null != changeData[0].getOldValue()) {
                boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)((DynamicObject)changeData[0].getOldValue()).getLong("id"));
                if (zerodeclare) {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
                    if (!"zzstz".equals(templateType)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0\u3002", (String)"AbstractDeclareReportPluginNew_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), ((DynamicObject)changeData[0].getOldValue()).getString("name")));
                    }
                    checkResult = OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)((DynamicObject)changeData[0].getOldValue()).getString("id"), (String)appid, (String)Objects.requireNonNull(TaxAppEnum.getEnumInstanceByAppid((String)appid)).getCategoryCode());
                } else {
                    checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)((DynamicObject)changeData[0].getOldValue()).getString("id"), (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
                }
                if (checkResult) {
                    return;
                }
                this.getModel().setValue(ORG_SEL, changeData[0].getOldValue());
            }
            if (null != (declareMain2 = this.getDeclareMain(orgid = (org = (DynamicObject)this.getModel().getValue(ORG_SEL)).getString("id"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), templateType)) && !declareMain2.getBoolean("zerodeclare")) {
                checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)Objects.requireNonNull(TaxAppEnum.getEnumInstanceByAppid((String)appid)).getCategoryCode());
            } else {
                boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)Long.parseLong(orgid));
                if (zerodeclare) {
                    if (!"zzstz".equals(templateType)) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0\u3002", (String)"AbstractDeclareReportPluginNew_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name")));
                    }
                    checkResult = OrgCheckUtil.zeroDeclareCheck((IFormView)this.getView(), (String)orgid, (String)appid, (String)Objects.requireNonNull(TaxAppEnum.getEnumInstanceByAppid((String)appid)).getCategoryCode());
                } else {
                    checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)TaxAppEnum.getEnumInstanceByAppid((String)appid).getCategoryCode());
                }
            }
            DynamicObject oldOrgDyo = (DynamicObject)changeData[0].getOldValue();
            String oldorgid = oldOrgDyo != null ? oldOrgDyo.getString("id") : null;
            this.orgCheckResultHandle(oldorgid, orgid, checkResult);
        }
        if (e.getProperty().getName().equals("skssqq")) {
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("dateChanged"))) {
                this.getPageCache().remove("dateChanged");
                return;
            }
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            declareMain = this.getDeclareMain(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), templateType);
            if ((null != declareMain && declareMain.getBoolean("zerodeclare") || null == declareMain && SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)Long.parseLong(this.getPageCache().get(ORGID_KEY)))) && !"zzstz".equals(templateType)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0\u3002", (String)"AbstractDeclareReportPluginNew_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name")));
            }
            if (Objects.isNull(changeData[0].getNewValue())) {
                return;
            }
            noValid = this.beforeLoadData((Date)changeData[0].getNewValue());
            if (noValid) {
                return;
            }
            this.extendLoadData((Date)changeData[0].getNewValue(), (Date)this.getModel().getValue("skssqz"), needMsg);
        }
        if (e.getProperty().getName().equals("skssqz")) {
            if (StringUtils.isNotBlank((CharSequence)this.getPageCache().get("dateChanged"))) {
                this.getPageCache().remove("dateChanged");
                return;
            }
            if (null == this.getModel().getValue(ORG_SEL)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            needMsg = StringUtil.isNotBlank((CharSequence)this.getPageCache().get("needMsg")) ? Boolean.valueOf(this.getPageCache().get("needMsg")) : Boolean.TRUE;
            declareMain = this.getDeclareMain(org.getString("id"), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), templateType);
            if ((null != declareMain && declareMain.getBoolean("zerodeclare") || null == declareMain && SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)Long.parseLong(this.getPageCache().get(ORGID_KEY)))) && !"zzstz".equals(templateType)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u7533\u62a5\u8868\u91d1\u989d\u9ed8\u8ba4\u4e3a0\u3002", (String)"AbstractDeclareReportPluginNew_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name")));
            }
            if (Objects.isNull(changeData[0].getNewValue())) {
                return;
            }
            noValid = this.beforeLoadData((Date)changeData[0].getNewValue());
            if (noValid) {
                return;
            }
            this.extendLoadData((Date)this.getModel().getValue("skssqq"), (Date)changeData[0].getNewValue(), needMsg);
        }
        this.getPageCache().remove("needMsg");
        this.init();
    }

    protected boolean beforeLoadData(Date newValue) {
        return false;
    }

    protected void extendLoadData(Date startDate, Date endDate, Boolean needMsg) {
        this.loadData(startDate, endDate, needMsg);
    }

    public void orgCheckResultHandle(String oldorgid, String orgid, boolean checkResult) {
        if (checkResult) {
            this.getModel().setValue(ORG_SEL, (Object)oldorgid);
        } else {
            this.getPageCache().put(ORGID_KEY, orgid);
            this.getPageCache().put(OLD_ORGID_KEY, orgid);
            this.initStartAndEndDate(true);
            this.loadData((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), Boolean.FALSE);
        }
    }

    public void loadData(Date startDate, Date endDate, Boolean needMsg) {
        Boolean flag = this.isValidDates(startDate, endDate, needMsg);
        if (flag.booleanValue()) {
            this.getPageCache().put("skssqq", DateUtils.format((Date)startDate));
            this.getPageCache().put("skssqz", DateUtils.format((Date)endDate));
            this.openDeclarePage(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"), false);
        }
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        String[] taxLimits;
        boolean isvalid = false;
        for (String taxLimit : taxLimits = this.getTaxLimits()) {
            boolean temp = DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate);
            isvalid = isvalid || temp;
        }
        if (!isvalid) {
            if (needMsg.booleanValue()) {
                String errMsg = this.buildErrorMsg(taxLimits);
                this.getView().showTipNotification(errMsg);
            }
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a%s\u3002", (String)"AbstractDeclareReportPluginNew_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        ArrayList nameList = new ArrayList(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void clientCallBack(ClientCallBackEvent e) {
        if (StringUtil.equals((CharSequence)e.getName(), (CharSequence)"reFetchDataTaskcloseback")) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getPageCache().get("reFetchDatataskId"));
            if (taskInfo != null && taskInfo.isTaskEnd()) {
                if (StringUtil.isNotBlank((CharSequence)taskInfo.getData())) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                    if (data == null || data.isEmpty()) {
                        throw new KDBizException("Data Error!");
                    }
                    String pageid = this.getPageCache().get("declarepageid");
                    IFormView childView = this.getView().getView(pageid);
                    IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
                    Map childCacheData = childPageCache.getAll();
                    childCacheData.remove("FormShowParameter");
                    Map customParams = childView.getFormShowParameter().getCustomParams();
                    customParams.putAll(data);
                    FormShowParameter param = new FormShowParameter();
                    param.setFormId(this.getDeclareFormId());
                    param.getOpenStyle().setShowType(ShowType.InContainer);
                    param.getOpenStyle().setTargetKey(CONTENT_TAB);
                    String declarepageid = param.getPageId();
                    this.getPageCache().put("declarepageid", declarepageid);
                    customParams.put("declarepageid", declarepageid);
                    customParams.put("operation", "reFetchData");
                    param.setCustomParams(customParams);
                    this.getView().showForm(param);
                    this.getView().updateView(CONTENT_TAB);
                }
                this.getView().hideLoading(true);
            } else {
                this.getView().addClientCallBack("reFetchDataTaskcloseback", Integer.valueOf(50));
            }
        } else {
            Map dataMap = JsonUtils.strToMap((String)this.getPageCache().get("resultData"));
            this.clientCallBackMethod(dataMap, e.getName());
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String entityname = this.getModel().getDataEntityType().getName();
        String entity = MutexMappingEnum.getEntity((String)entityname);
        String sbbid = this.getPageCache().get(SBBID);
        HashMap<String, String> customparam = new HashMap<String, String>();
        if ("edit".equals(key)) {
            if (StringUtils.isNotBlank((CharSequence)entity)) {
                try {
                    DynamicObject dynamicObject;
                    String orgId = this.getPageCache().get(ORGID_KEY);
                    String startDate = this.getPageCache().get("skssqq");
                    String endDate = this.getPageCache().get("skssqz");
                    String pageid = this.getPageCache().get("declarepageid");
                    IFormView childView = this.getView().getView(pageid);
                    Object type = childView.getFormShowParameter().getCustomParams().get(TEMPLATE_TYPE);
                    DynamicObject declareMain = this.getDeclareMain(orgId, startDate, endDate, type);
                    if (declareMain != null) {
                        sbbid = declareMain.getString("id");
                    }
                    MutexServiceImpl mutexService = new MutexServiceImpl();
                    customparam.put("dataObjId", sbbid);
                    customparam.put("entityKey", entity);
                    customparam.put("operationKey", "edit");
                    customparam.put("groupId", "declare_edit");
                    mutexService.setMutexLockInfo(customparam);
                    boolean isSuccessLock = mutexService.setMutexLock();
                    logger.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entityname, entity, isSuccessLock});
                    if (!isSuccessLock && (dynamicObject = MutexServiceImpl.getMutexData(new QFilter("objectid", "=", (Object)sbbid))) != null) {
                        String user = dynamicObject.getString("user.name");
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractDeclareReportPluginNew_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), user));
                        evt.setCancel(true);
                        return;
                    }
                }
                catch (Exception e) {
                    logger.error(e.getMessage());
                }
            }
        } else if (Sets.newHashSet((Object[])new String[]{ONE_KEY_GENERATE, SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY}).contains(key)) {
            DynamicObject dynamicObject = MutexServiceImpl.getMutexData(new QFilter("objectid", "=", (Object)sbbid));
            if (dynamicObject != null && !dynamicObject.get("user.id").equals(RequestContext.get().getCurrUserId())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"AbstractDeclareReportPluginNew_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), dynamicObject.get("user.name")));
                evt.setCancel(true);
            }
        } else if (SAVE_KEY.equals(key) || CANCEL_KEY.equals(key) || CLOSE_KEY.equals(key)) {
            MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "cancel": {
                LocaleString cancelMsg = new LocaleString(ResManager.loadKDString((String)"\u53d6\u6d88\u7f16\u8f91\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclareReportPluginNew_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                this.getView().showLoading(cancelMsg, 3000);
                this.cancel();
                break;
            }
        }
    }

    private boolean isDataChanged() {
        IPageCache childPageCache;
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        if (childPage != null && (childPageCache = childPage.getPageCache()) != null) {
            Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
            return updateMap != null && updateMap.size() > 0;
        }
        return false;
    }

    private void cancel() {
        if (this.isDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCEL_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"AbstractDeclareReportPluginNew_9", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            String orgId = this.getPageCache().get(ORGID_KEY);
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            DynamicObject dyo = YbnsrService.queryYbnsr((String)orgId, (String)this.getTemplateType(), (String)startDate, (String)endDate, null);
            if (dyo == null) {
                this.closeView();
            } else {
                this.enableSubmitBtn();
                FormulaService.cancel((IPageCache)this.getPageCache());
                this.operationSbb(CANCEL_KEY);
            }
        }
        this.hideBtnWhenEditImportData();
    }

    private void hideBtnWhenEditImportData() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (StringUtils.equals((CharSequence)"2", (CharSequence)((String)customParams.get("datatype")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_DRAFT_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
        }
    }

    protected void closeView() {
        this.getPageCache().put("code_close", "true");
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperationResult().getSuccessPkIds().isEmpty()) {
            return;
        }
        if (this.getModel().getValue(ORG_SEL) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        super.afterDoOperation(afterDoOperationEventArgs);
        String key = afterDoOperationEventArgs.getOperateKey();
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        Long orgId = org.getLong("id");
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)orgId);
        switch (key) {
            case "edit": {
                this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, AUDIT_KEY, CLOSE_KEY, VIEWFLOWCHART_KEY, REFRESH_KEY});
                this.operationSbb("edit");
                this.hideBtnWhenEditImportData();
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "recalc": {
                this.recalc();
                break;
            }
            case "viewdraft": {
                if (zerodeclare && !"zzsxgmnsr".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY))) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"AbstractDeclareReportPluginNew_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name")));
                    return;
                }
                this.viewDraft();
                break;
            }
            case "onekeygenerate": {
                if (zerodeclare && "zzsxgmnsr".equals(this.getPageCache().get(TAXPAYER_TYPE_KEY))) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"AbstractDeclareReportPluginNew_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name")));
                    return;
                }
                this.onekeygenerate();
                break;
            }
            case "print": {
                this.print();
                break;
            }
            case "regetdata": {
                NsrxxValidatorUtils.nsrxxReviewed((Long)orgId);
                NsrxxValidatorUtils.allRequiredFieldValidator((String)String.valueOf(orgId));
                this.reGetDataConform();
                break;
            }
            case "viewflowchart": {
                this.viewFlowChart();
                break;
            }
            case "refresh": {
                this.refresh();
                break;
            }
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"AbstractDeclareReportPluginNew_5", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                this.save();
                break;
            }
        }
    }

    protected void refresh() {
        String orgId = this.getPageCache().get(ORGID_KEY) != null ? this.getPageCache().get(ORGID_KEY) : "0";
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        if (StringUtil.isNotEmpty((CharSequence)orgId) && StringUtil.isNotEmpty((CharSequence)startDate) && StringUtil.isNotEmpty((CharSequence)endDate)) {
            this.setBtnStatus(orgId, startDate, endDate, VIEW);
        }
    }

    protected void viewFlowChart() {
        DynamicObject object;
        String templateType = this.getTemplateType();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        if (StringUtil.isNotEmpty((CharSequence)orgId) && StringUtil.isNotEmpty((CharSequence)startDate) && StringUtil.isNotEmpty((CharSequence)endDate) && (object = YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)startDate, (String)endDate, null)) != null) {
            OpenStyle openStyle = new OpenStyle();
            openStyle.setShowType(ShowType.MainNewTabPage);
            try {
                WorkflowServiceHelper.viewFlowchart((String)this.getView().getPageId(), (Object)object.get("id"), (OpenStyle)openStyle);
            }
            catch (Exception e) {
                logger.error("\u67e5\u770b\u6d41\u7a0b\u56fe\u5f02\u5e38", (Object)ThrowableHelper.toString((Exception)e));
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5355\u636e\u4e0d\u5728\u6d41\u7a0b\u4e2d\uff0c\u65e0\u6cd5\u67e5\u770b\u6d41\u7a0b\u56fe\u3002", (String)"TaxDeclareQueryListPlugin_23", (String)"taxc-bdtaxr-common", (Object[])new Object[0]));
            }
        }
    }

    protected void reGetData() {
        Map<String, String> bussinessUpdateMap;
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareData", DeclareResponseModel.class);
        Map currentMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid_save", Map.class);
        if (requestModel == null) {
            return;
        }
        if (currentMap == null || currentMap.isEmpty()) {
            currentMap = responseModel.getData();
        }
        Map updateMapCache = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        List<String> reGetDataHisCells = TaxDeclarePluginService.queryReGetDataHisCell(String.valueOf(requestModel.getId()));
        List dynamicRowModelList = responseModel.getDynRowList();
        HashMap updateMap = new HashMap(reGetDataHisCells.size());
        for (String string : reGetDataHisCells) {
            if (!StringUtil.isNotBlank((CharSequence)string) || !StringUtil.isNotBlank((CharSequence)((CharSequence)currentMap.get(string))) || DynamicRowService.matchDyn((List)dynamicRowModelList, (String)string) != null) continue;
            updateMap.put(string, currentMap.get(string));
        }
        if (updateMapCache != null && !updateMapCache.isEmpty()) {
            for (Map.Entry entry : updateMapCache.entrySet()) {
                if (DynamicRowService.matchDyn((List)dynamicRowModelList, (String)((String)entry.getKey())) != null) continue;
                updateMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        if ((bussinessUpdateMap = this.bussinessUpdateMap(currentMap)) != null && !bussinessUpdateMap.isEmpty()) {
            updateMap.putAll(bussinessUpdateMap);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>(16);
        hashMap.put("declareRequest", childPageCache.get("declareRequest"));
        hashMap.put("declareData", childPageCache.get("declareData"));
        hashMap.put("updata_cellid_save", childPageCache.get("updata_cellid_save"));
        hashMap.put("updata_cellid", childPageCache.get("updata_cellid"));
        hashMap.put("updateMap", SerializationUtils.toJsonString(updateMap));
        this.dispatch(hashMap, TaxDeclareReFetchDataTask.class.getName(), "reFetchDataTaskcloseback");
        this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7a0d\u7b49......", (String)"TaxDeclarePlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0])), 30000);
        this.getView().addClientCallBack("reFetchDataTaskcloseback", Integer.valueOf(50));
    }

    protected Map<String, String> bussinessUpdateMap(Map<String, String> currentMap) {
        return new HashMap<String, String>(0);
    }

    protected void print() {
        HashMap<String, String> params = new HashMap<String, String>();
        FormShowParameter showParameter = new FormShowParameter();
        params.put("templateId", this.getPageCache().get("templateid"));
        params.put("templateType", this.getTemplateType());
        params.put("sbbid", this.getPageCache().get(SBBID));
        showParameter.setFormId("bdtaxr_declare_print");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    protected void viewDraft() {
        String orgid = this.getPageCache().get(ORGID_KEY);
        String startDate = this.getPageCache().get("skssqq");
        String endDate = this.getPageCache().get("skssqz");
        DynamicObject sbbObject = this.queryNsrxx(orgid, startDate, endDate);
        String billstatus = Optional.ofNullable(sbbObject).map(s -> s.getString("billstatus")).orElseGet(() -> "A");
        if (StringUtil.isEmpty((CharSequence)orgid)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG_SEL);
        String orgName = org != null ? org.getString("name") : "";
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        boolean zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)Long.parseLong(orgid));
        if (zerodeclare) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u4e3a\u6838\u5b9a\u96f6\u7533\u62a5\u7ec4\u7ec7\uff0c\u4e0d\u652f\u6301\u7f16\u5236\u7533\u62a5\u5e95\u7a3f\u3002", (String)"AbstractDeclareReportPluginNew_11", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgName));
            return;
        }
        QFilter orgFilter = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter startFilter = new QFilter("startdate", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter endFilter = new QFilter("enddate", "=", (Object)DateUtils.stringToDate((String)endDate));
        String templateType = this.getTemplateType();
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
        QFilter templateFilter = new QFilter(TEMPLATE_TYPE, "=", (Object)templateEnum.getDraftType());
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"id,type", (QFilter[])new QFilter[]{orgFilter, templateFilter, startFilter, endFilter});
        if (dynamicObject == null && ("B".equals(billstatus) || "C".equals(billstatus))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u8868\u4e0d\u5b58\u5728\u5e95\u7a3f\u3002", (String)"AbstractDeclareReportPluginNew_12", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgName));
            return;
        }
        if (StringUtil.isBlank((CharSequence)templateEnum.getDraftPage())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u8868\u6682\u4e0d\u652f\u6301\u67e5\u770b\u5e95\u7a3f\u3002", (String)"AbstractDeclareReportPluginNew_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put(ORGID_KEY, orgid);
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", endDate);
        customParams.put("type", Optional.ofNullable(dynamicObject).map(s -> s.getString("type")).orElse(""));
        customParams.put("draftpurpose", "nssb");
        customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
        PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
    }

    public void operationSbb(String operationType) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        if (customParams == null) {
            throw new KDBizException("Params Error!");
        }
        if (!SAVE_KEY.equals(operationType)) {
            TreeUtils.removeCache((IPageCache)childPageCache, (String)"oldData");
            customParams.remove("oldData");
        }
        customParams.putAll(childPageCache.getAll());
        customParams.remove("FormShowParameter");
        if (customParams.containsKey("declarePageCache")) {
            customParams.remove("declarePageCache");
        }
        FormShowParameter param = new FormShowParameter();
        String operation = operationType.equals("edit") ? "edit" : VIEW;
        customParams.put("operation", operation);
        customParams.put("customEvent", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put(REFRESH_KEY, "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareRequest", DeclareRequestModel.class);
        if (CANCEL_KEY.equals(operationType)) {
            String orgId = this.getPageCache().get(ORGID_KEY);
            String startDate = this.getPageCache().get("skssqq");
            String endDate = this.getPageCache().get("skssqz");
            requestModel = new DeclareRequestModel();
            this.createZeroDeclareParams(orgId, startDate, endDate, appid, customParams, requestModel);
        }
        if (requestModel.getId() == null && operationType.equals("edit")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5f53\u524d\u6761\u4ef6\u4e0b\u7684\u7533\u62a5\u8868\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AbstractDeclareReportPluginNew_14", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        requestModel.setTemplateType((String)customParams.get(TEMPLATE_TYPE));
        requestModel.setOperation(operation);
        requestModel.setCustomEvent(operationType);
        requestModel.setRefresh(Boolean.FALSE);
        requestModel.getBusinessMap().putAll(this.getBizParams());
        customParams.put("declareRequest", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.setBtnStatus(operationType, requestModel);
    }

    private void setBtnStatus(String operationType, DeclareRequestModel requestModel) {
        if ("edit".equals(operationType)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{VIEW_DRAFT_KEY, RECALC_KEY, REGETDATA_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
            String templatetype = this.getTemplateType();
            if (StringUtils.trimToEmpty((String)templatetype).startsWith("zzs")) {
                OperatorDialogUtils.operateDialog((String)"zzs", (String)TemplateEnum.getEnumByDeclareType((String)templatetype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u6b63\u5728\u7f16\u8f91\u4e2d", (String)"AbstractDeclareReportPluginNew_16", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO)));
            } else if (StringUtils.trimToEmpty((String)templatetype).startsWith("qysds")) {
                OperatorDialogUtils.operateDialog((String)"qysds", (String)TemplateEnum.getEnumByDeclareType((String)templatetype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u6b63\u5728\u7f16\u8f91\u4e2d", (String)"AbstractDeclareReportPluginNew_16", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO)));
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY, VIEWFLOWCHART_KEY, REFRESH_KEY});
            this.getView().setVisible(Boolean.FALSE, new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
            this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
        }
        if ("zzsybnsr_yz_fzjg".equals(requestModel.getTemplateType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ONE_KEY_GENERATE, VIEW_DRAFT_KEY});
        }
        if ("1".equals(requestModel.getBusinessMap().get("zerodeclare"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
        }
    }

    protected Map<String, String> getBizParams() {
        return new HashMap<String, String>(4);
    }

    public void save() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("TaxDeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                DeclareRequestModel declareRequestModel = new DeclareRequestModel();
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startDate = this.getPageCache().get("skssqq");
                String endDate = this.getPageCache().get("skssqz");
                Object type = childView.getFormShowParameter().getCustomParams().get(TEMPLATE_TYPE);
                DynamicObject declareMain = this.getDeclareMain(orgId, startDate, endDate, type);
                if (declareMain != null && !"A".equals(declareMain.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838,\u4e0d\u5141\u8bb8\u4fee\u6539\u4fdd\u5b58\uff01", (String)"AbstractDeclareReportPluginNew_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                declareRequestModel.setId(this.getSbbid(null, orgId, startDate, endDate, type));
                declareRequestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                declareRequestModel.setTemplateType(this.getTemplateType());
                declareRequestModel.setRefresh(Boolean.valueOf(true));
                declareRequestModel.setOperation("edit");
                declareRequestModel.setSkssqq(startDate);
                declareRequestModel.setSkssqz(endDate);
                declareRequestModel.getBusinessMap().putAll(this.getBizParams());
                BaseResult resultMap = (BaseResult)saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                if (500 == resultMap.getCode()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a%s", (String)"AbstractDeclareReportPluginNew_18", (String)"taxc-bdtaxr", (Object[])new Object[0]), resultMap.getMessage()));
                    return;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"AbstractDeclareReportPluginNew_19", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                String billno = this.getPageCache().get(BILLNO);
                String templatetype = this.getTemplateType();
                if (StringUtils.trimToEmpty((String)templatetype).startsWith("zzs")) {
                    OperatorDialogUtils.operateDialog((String)"zzs", (String)TemplateEnum.getEnumByDeclareType((String)templatetype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDeclareReportPluginNew_20", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f", (String)"AbstractDeclareReportPluginNew_21", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                } else if (StringUtils.trimToEmpty((String)templatetype).startsWith("qysds")) {
                    OperatorDialogUtils.operateDialog((String)"qysds", (String)TemplateEnum.getEnumByDeclareType((String)templatetype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"AbstractDeclareReportPluginNew_20", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f", (String)"AbstractDeclareReportPluginNew_21", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                }
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"AbstractDeclareReportPluginNew_22", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                } else if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDException && e.getCause().toString().contains("10^13")) {
                    msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u91d1\u989d\u6574\u6570\u4f4d\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc713\u4f4d\u3002", (String)"AbstractDeclareReportPluginNew_23", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                    this.getView().showErrorNotification(msg);
                } else {
                    if (((InvocationTargetException)e).getTargetException().getCause() != null && ((InvocationTargetException)e).getTargetException().getCause().toString().contains("already exists")) {
                        msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff0c\u76f8\u540c\u6570\u636e\u91cd\u590d\u4fdd\u5b58\uff0c\u8bf7\u9000\u51fa\u540e\u91cd\u65b0\u4fee\u6539\u4fdd\u5b58\u3002", (String)"AbstractDeclareReportPluginNew_47", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                    }
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.operationSbb(SAVE_KEY);
        }
        this.enableSubmitBtn();
        this.hideBtnWhenEditImportData();
    }

    public void enableSubmitBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY});
    }

    public void submit(String key) {
        String sbbid = null;
        DynamicObject declare = this.queryNsrxx(this.getPageCache().get(ORGID_KEY), this.getPageCache().get("skssqq"), this.getPageCache().get("skssqz"));
        if (declare != null) {
            sbbid = declare.getString("id");
        }
        if (!StringUtils.isEmpty(sbbid)) {
            ArrayList<String> pklist = new ArrayList<String>();
            pklist.add(sbbid);
            boolean flag = DeclareUtils.submit((IFormView)this.getView(), pklist, (String)key, (String)"tcvat_nsrxx", (boolean)false);
            if (flag) {
                String orgId = this.getPageCache().get(ORGID_KEY);
                String startDate = this.getPageCache().get("skssqq");
                String endDate = this.getPageCache().get("skssqz");
                this.setBtnStatus(orgId, startDate, endDate, VIEW);
                if (AUDIT_KEY.equals(key) && this.getTemplateType().contains("qysdsnb")) {
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tccit", (String)"MbksTaxbookSyncService", (String)"syncData", (Object[])new Object[]{pklist});
                }
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"AbstractDeclareReportPluginNew_24", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    private DynamicObject queryNsrxx(String orgId, String startdate, String enddate) {
        if (StringUtils.isBlank((CharSequence)orgId) || StringUtils.isBlank((CharSequence)startdate) || StringUtils.isBlank((CharSequence)enddate)) {
            return null;
        }
        return YbnsrService.queryYbnsr((String)orgId, (String)this.getTemplateType(), (String)startdate, (String)enddate, Collections.emptyMap());
    }

    private void recalc() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPluginNew_25", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPluginNew_26", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u7f6e\u62a5\u8868\u5c06\u5bfc\u81f4\u539f\u6709\u6570\u636e\uff08\u5305\u62ec\u624b\u5de5\u8c03\u6574\u7684\u6570\u636e\uff09\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPluginNew_48", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void reGetDataConform() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REGETDATA_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractDeclareReportPluginNew_25", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractDeclareReportPluginNew_26", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u4f1a\u4fdd\u7559\u5355\u5143\u683c\u7684\u624b\u5de5\u8c03\u6574\u503c\uff0c\u5355\u5143\u683c\u7684\u53d6\u6570\u516c\u5f0f\u4e0e\u5355\u5143\u683c\u95f4\u7684\u8ba1\u7b97\u516c\u5f0f\u5c06\u4f1a\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPluginNew_49", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void onekeygenerate() {
        logger.info("start onekeygenerate=============");
        long start = System.currentTimeMillis();
        String orgid = this.getPageCache().get(ORGID_KEY);
        LicenseCheckResult checkResult = LicenseCheckServiceHelper.checkTxftPerformGroup((String)"tcdrs");
        if (!checkResult.getHasLicense().booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8ba1\u7a0e\u5e95\u7a3f\u670d\u52a1\u7279\u6027\u5206\u7ec4\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458", (String)"AbstractDeclareReportPluginNew_28", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)this.getTemplateType());
        String draftType = templateEnum.getDraftType();
        DynamicObject draft = StatusUtils.queryOne((String)draftType, (String)orgid, (String)skssqq, (String)skssqz, (String)draftpurpose);
        if (draft != null) {
            DynamicObject orgObj = BusinessDataServiceHelper.loadSingleFromCache((Object)Long.parseLong(orgid), (String)"bos_org");
            String msg = String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u5728\u3010%2$s\u3011\u81f3\u3010%3$s\u3011\u5df2\u5b58\u5728\u5e95\u7a3f\u6570\u636e\uff0c\u91cd\u65b0\u751f\u6210\u5c06\u5bfc\u81f4\u539f\u6709\u7684\u5e95\u7a3f\u548c\u7533\u62a5\u8868\u6570\u636e\u88ab\u6e05\u9664\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"AbstractDeclareReportPluginNew_29", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgObj.getString("name"), skssqq, skssqz);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ONE_KEY_GENERATE, (IFormPlugin)this);
            this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks, null, SerializationUtils.toJsonString((Object)draft));
        } else {
            long startEng = System.currentTimeMillis();
            this.executeEngineHandler(orgid, skssqq, skssqz, this.getTemplateType());
            logger.info("exec executeEngineHandler\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startEng));
        }
        logger.info("end onekeygenerate\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        String orgId = this.getPageCache().get(ORGID_KEY);
        String skssqq = this.getPageCache().get("skssqq");
        String skssqz = this.getPageCache().get("skssqz");
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        String templateType = this.getTemplateType();
        switch (callBackId) {
            case "recalc": {
                if (!this.isValidDates((Date)this.getModel().getValue("skssqq"), (Date)this.getModel().getValue("skssqz"), Boolean.TRUE).booleanValue()) {
                    return;
                }
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (orgId == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"AbstractDeclareReportPluginNew_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                this.getView().getFormShowParameter().setCustomParam(RECALC_KEY, (Object)true);
                this.openDeclarePage(orgId, skssqq, skssqz, true);
                String billno = this.getPageCache().get(BILLNO);
                String templatetype = this.getTemplateType();
                if (StringUtils.trimToEmpty((String)templatetype).startsWith("zzs")) {
                    OperatorDialogUtils.operateDialog((String)"zzs", (String)TemplateEnum.getEnumByDeclareType((String)templatetype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"AbstractDeclareReportPluginNew_30", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"AbstractDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                    break;
                }
                if (!StringUtils.trimToEmpty((String)templatetype).startsWith("qysds")) break;
                OperatorDialogUtils.operateDialog((String)"qysds", (String)TemplateEnum.getEnumByDeclareType((String)templatetype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"AbstractDeclareReportPluginNew_30", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"AbstractDeclareReportPluginNew_31", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                break;
            }
            case "viewdraft": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
                if (StringUtil.isBlank((CharSequence)templateEnum.getDraftPage())) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u8868\u6682\u4e0d\u652f\u6301\u67e5\u770b\u5e95\u7a3f\u3002", (String)"AbstractDeclareReportPluginNew_13", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                customParams.put("draftpurpose", "nssb");
                customParams.put(TEMPLATE_TYPE, templateEnum.getDraftType());
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "callback_modify": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    this.showInnerPage(orgId, skssqq, skssqz, false, VIEW);
                    break;
                }
                this.closeView();
                break;
            }
            case "modifyOrDelete": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
                    if (StringUtil.isBlank((CharSequence)templateEnum.getDraftPage())) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7533\u62a5\u8868\u6682\u4e0d\u652f\u6301\u91cd\u65b0\u8ba1\u7a0e", (String)"AbstractDeclareReportPluginNew_32", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        return;
                    }
                    TemplateUtils.deleteReport((Long)Long.parseLong(orgId), (String)templateType, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz), null);
                    StatusUtils.delete((String)templateEnum.getDraftType(), (String)orgId, (String)skssqq, (String)skssqz, (String)draftpurpose);
                    HashMap<String, String> customParams = new HashMap<String, String>();
                    customParams.put(ORGID_KEY, orgId);
                    customParams.put("skssqq", skssqq);
                    customParams.put("draftpurpose", draftpurpose);
                    customParams.put("skssqz", skssqz);
                    PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
                    this.closeView();
                    break;
                }
                if (e.getResult() == MessageBoxResult.No) {
                    this.showInnerPage(orgId, skssqq, skssqz, false, "edit");
                    this.getView().setVisible(Boolean.FALSE, new String[]{VIEW_DRAFT_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
                    break;
                }
                this.closeView();
                break;
            }
            case "onekeygenerate": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String customVaule = e.getCustomVaule();
                JSONObject object = JSONObject.parseObject((String)customVaule);
                if (!"A".equals(object.getString("billstatus"))) {
                    String msg = String.format(ResManager.loadKDString((String)"\u3010%s\u3011\u5df2\u63d0\u4ea4\u5ba1\u6838\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u662f\u5426\u9700\u8981\u524d\u5f80\u5e95\u7a3f\u67e5\u8be2\u754c\u9762\u4fee\u6539\uff1f", (String)"AbstractDeclareReportPluginNew_33", (String)"taxc-bdtaxr", (Object[])new Object[0]), object.getString(BILLNO));
                    ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(LINK_TO_DRAFT_LIST, (IFormPlugin)this);
                    this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, null, object.getString(BILLNO));
                    break;
                }
                this.executeEngineHandler(orgId, skssqq, skssqz, templateType);
                break;
            }
            case "linktodraftlist": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String draftQueryPage = TemplateEnum.getEnumByDeclareType((String)this.getTemplateType()).getDraftQueryPage();
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                customParams.put(ORGID_KEY, Collections.singletonList(orgId));
                customParams.put("startdate", DateUtils.stringToDate((String)skssqq));
                customParams.put("enddate", DateUtils.stringToDate((String)skssqz));
                String title = null;
                if (TemplateEnum.QYSDSJB.getDraftQueryPage().equals(draftQueryPage)) {
                    customParams.put("drafttype", "qysdsjb");
                    title = ResManager.loadKDString((String)"\u9884\u7f34\u7533\u62a5\u5e95\u7a3f\u67e5\u8be2", (String)"AbstractDeclareReportPluginNew_34", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                }
                PageShowCommon.showBillList((ShowType)ShowType.MainNewTabPage, (String)draftQueryPage, (IFormView)this.getView(), (Map)customParams, title);
                break;
            }
            case "handle_onekey_generate_exception": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                String declareType = this.getTemplateType();
                String draftPage = TemplateEnum.getEnumByDeclareType((String)declareType).getDraftPage();
                HashMap<String, String> customParams = new HashMap<String, String>();
                customParams.put(ORGID_KEY, orgId);
                customParams.put("skssqq", skssqq);
                customParams.put("skssqz", skssqz);
                PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)draftPage, (IFormView)this.getView(), customParams, (IFormPlugin)this);
                break;
            }
            case "cancel": {
                DynamicObject dyo = YbnsrService.queryYbnsr((String)orgId, (String)templateType, (String)skssqq, (String)skssqz, null);
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (dyo == null) {
                    this.closeView();
                    break;
                }
                this.enableSubmitBtn();
                FormulaService.cancel((IPageCache)this.getPageCache());
                this.operationSbb(VIEW);
                break;
            }
            case "close": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.closeView();
                break;
            }
            case "regetdata": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.reGetData();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        if (SUBMIT_KEY.equals(operate.getOperateKey())) {
            operate.getOption().setVariableValue("sbbid", this.getPageCache().get(SBBID));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String code_close = this.getPageCache().get("code_close");
        if (this.isDataChanged() && !"true".equals(code_close)) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"AbstractDeclareReportPluginNew_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"AbstractDeclareReportPluginNew_9", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeEngineHandler(String orgId, String skssqq, String skssqz, String templateType) {
        logger.info("start executeEngineHandler=============");
        long start = System.currentTimeMillis();
        String key = String.format("%s_%s_%s_%s", orgId, skssqq, skssqz, templateType);
        DLock lock = DLock.create((String)key);
        EngineHandler handler = EngineHandlerFactory.createHandler((String)templateType);
        EngineModel engineModel = this.buildEngineModel(orgId, skssqq, skssqz, templateType, this.getPageCache());
        try {
            if (lock.tryLock(30000L)) {
                handler.validate(engineModel);
                long startExe = System.currentTimeMillis();
                handler.execute(engineModel);
                logger.info("\u6267\u884c executeEngineHandler exec\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startExe));
                long startOpen = System.currentTimeMillis();
                this.openDeclarePage(orgId, skssqq, skssqz, true);
                logger.info("\u6267\u884c executeEngineHandler openDeclarePage\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - startOpen));
            }
        }
        catch (KDBizException exception) {
            if ("need_show_confirm".equals(exception.getErrorCode().getCode())) {
                String msg = exception.getMessage();
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(VIEW_DRAFT_KEY, (IFormPlugin)this);
                this.getView().showConfirm(msg, "", MessageBoxOptions.OKCancel, ConfirmTypes.Delete, confirmCallBacks);
            } else {
                handler.handleException(exception, this.getView(), (IFormPlugin)this);
            }
            return;
        }
        finally {
            lock.unlock();
        }
        logger.info("end executeEngineHandler\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
    }

    private boolean isDeclared(String rootPageId, String orgId, String startdate, String enddate) {
        DynamicObject declare = this.queryNsrxx(orgId, startdate, enddate);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, "A");
        this.getPageCache().remove("templateid");
        if (declare != null) {
            if (StringUtil.isNotEmpty((CharSequence)declare.getString("templateid"))) {
                this.getPageCache().put("templateid", declare.getString("templateid"));
            }
            String status = declare.getString("declarestatus");
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put(BILL_STATUS, billstatus);
            rootCache.put(SBBID, id);
            rootCache.put(BILLNO, declare.getString(BILLNO));
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG_SEL);
                String orgName = null != org ? org.getString("name") : "";
                String statusName = this.getStatusLocaleName(status, billstatus);
                String taxlimitStr = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)startdate), (Date)DateUtils.stringToDate((String)enddate));
                if (!taxlimitStr.equals("") && !"zzstz".equals(this.getTemplateType())) {
                    String msg = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2%3$s\uff0c\u4e0d\u652f\u6301\u4fee\u6539\u3002", (String)"AbstractDeclareReportPluginNew_35", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgName, taxlimitStr, statusName);
                    rootView.showTipNotification(msg, Integer.valueOf(5000));
                    this.getView().sendFormAction(rootView);
                }
                return true;
            }
        }
        return false;
    }

    private String getStatusLocaleName(String status, String billstatus) {
        String statusName = ResManager.loadKDString((String)"\u63d0\u4ea4\u5ba1\u6279", (String)"AbstractDeclareReportPluginNew_36", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        if ("C".equals(billstatus)) {
            statusName = ResManager.loadKDString((String)"\u5ba1\u6279", (String)"AbstractDeclareReportPluginNew_37", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        if ("declared".equals(status)) {
            statusName = ResManager.loadKDString((String)"\u7533\u62a5", (String)"AbstractDeclareReportPluginNew_38", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        return statusName;
    }

    protected String[] getTaxLimits() {
        return new String[]{"month"};
    }

    protected void initStartAndEndDate(boolean orgChange) {
        Date skssqz;
        Date skssqq;
        String taxLimit;
        switch (taxLimit = this.getTaxLimits()[0]) {
            case "year": {
                skssqq = DateUtils.getFirstDateOfYear((Date)DateUtils.addYear((Date)new Date(), (int)-1));
                skssqz = DateUtils.getLastDateOfYear((Date)skssqq);
                break;
            }
            case "halfyear": {
                skssqq = DateUtils.getFirstDateOfHalfYear((Date)DateUtils.addMonth((Date)new Date(), (int)-6));
                skssqz = DateUtils.getLastDateOfHalfYear((Date)skssqq);
                break;
            }
            case "season": {
                skssqq = DateUtils.getFirstDateOfSeason((Date)DateUtils.addMonth((Date)new Date(), (int)-3));
                skssqz = DateUtils.getLastDateOfSeason((Date)skssqq);
                break;
            }
            default: {
                skssqq = DateUtils.getFirstDateOfMonth((Date)DateUtils.addMonth((Date)new Date(), (int)-1));
                skssqz = DateUtils.getLastDateOfMonth((Date)skssqq);
            }
        }
        this.getPageCache().put("needMsg", "false");
        this.getModel().setValue("skssqq", (Object)skssqq);
        this.getPageCache().put("skssqq", DateUtils.format((Date)skssqq));
        this.getModel().setValue("skssqz", (Object)skssqz);
        this.getPageCache().put("skssqz", DateUtils.format((Date)skssqz));
        this.getPageCache().remove("needMsg");
    }

    private void openDeclarePage(String orgid, String skssqq, String skssqz, boolean refresh) {
        if (!this.checkOrgTaxConfig(orgid, skssqq, skssqz)) {
            return;
        }
        String templateType = StringUtil.isBlank((CharSequence)this.getPageCache().get(TAXPAYER_TYPE_KEY)) ? this.getTemplateType() : this.getPageCache().get(TAXPAYER_TYPE_KEY);
        Map<String, Object> map = this.chooseDeclareFormByDataType(orgid, templateType, skssqq, skssqz);
        if (StringUtils.equals((CharSequence)"2", (CharSequence)((String)map.get("datatype")))) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)((String)map.get("billstatus")))) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                String taxLimitTips = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
                String orgname = this.getModel().getValue(ORG_SEL) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG_SEL)).getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"AbstractDeclareReportPluginNew_39", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if ("yhs".equals(templateType)) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPluginNew_40", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPluginNew_41", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e", (String)"AbstractDeclareReportPluginNew_42", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACKID_MODIFY, (IFormPlugin)this), btnNameMaps);
                } else {
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"AbstractDeclareReportPluginNew_40", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"AbstractDeclareReportPluginNew_41", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"AbstractDeclareReportPluginNew_43", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e", (String)"AbstractDeclareReportPluginNew_44", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
                }
            } else {
                this.showInnerPage(orgid, skssqq, skssqz, refresh, VIEW);
            }
        } else if (StringUtil.isBlank((CharSequence)((String)map.get("billstatus")))) {
            this.showInnerPage(orgid, skssqq, skssqz, true, "edit");
        } else if ("A".equals(map.get("billstatus"))) {
            this.showInnerPage(orgid, skssqq, skssqz, refresh, refresh ? "edit" : VIEW);
        } else {
            this.showInnerPage(orgid, skssqq, skssqz, false, VIEW);
        }
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        return true;
    }

    public Map<String, Object> chooseDeclareFormByDataType(String orgid, String type, String startDate, String endDate) {
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgid, (String)type, (String)startDate, (String)endDate, null);
        String declareStatus = "";
        String billstatus = "";
        String datatype = "";
        if (null != dyo) {
            declareStatus = dyo.getString("declarestatus");
            billstatus = dyo.getString("billstatus");
            datatype = dyo.getString("datatype");
        }
        map.put("declarestatus", declareStatus);
        map.put("billstatus", billstatus);
        map.put("datatype", datatype);
        return map;
    }

    protected void showInnerPage(String orgid, String startDate, String endDate, boolean refresh, String operationStatus) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("rootPageId", this.getView().getPageId());
        String taxLimit = DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        customParams.put("taxlimit", taxLimit);
        customParams.put(TEMPLATE_TYPE, StringUtil.isBlank((CharSequence)this.getPageCache().get(TAXPAYER_TYPE_KEY)) || refresh ? this.getTemplateType() : this.getPageCache().get(TAXPAYER_TYPE_KEY));
        customParams.put("ParentCache", "true");
        if ("zzsybnsr_fzjg".equals(customParams.get(TEMPLATE_TYPE)) || "zzsybnsr_zjg".equals(customParams.get(TEMPLATE_TYPE))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6c47\u603b\u822a\u7a7a\u6682\u4e0d\u652f\u6301\u7eb3\u7a0e\u7533\u62a5", (String)"AbstractDeclareReportPluginNew_45", (String)"taxc-bdtaxr", (Object[])new Object[0]), null);
            return;
        }
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(this.getView().getPageId(), orgid, startDate, endDate);
        if (isDeclare) {
            readonly = true;
        }
        customParams.put("readonly", readonly);
        customParams.put("templateid", this.getPageCache().get("templateid"));
        DeclareRequestModel requestModel = new DeclareRequestModel();
        this.createZeroDeclareParams(orgid, startDate, endDate, appid, customParams, requestModel);
        if ("0".equals(requestModel.getBusinessMap().get("zerodeclare")) && "zzsybnsr_ybfz".equals(customParams.get(TEMPLATE_TYPE))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u6c47\u603b\u7ec4\u7ec7\u65e0\u987b\u7533\u62a5", (String)"AbstractDeclareReportPluginNew_46", (String)"taxc-bdtaxr", (Object[])new Object[0]), null);
            return;
        }
        String billNo = DeclareUtils.getBillNo((String)orgid, (Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate), (String)((String)customParams.get(TEMPLATE_TYPE)));
        this.getPageCache().put(BILLNO, billNo);
        requestModel.setBillNo(billNo);
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgid)));
        String templateType = (String)customParams.get(TEMPLATE_TYPE);
        requestModel.setTemplateType(templateType);
        requestModel.setOperation(operationStatus);
        requestModel.setSkssqq(startDate);
        requestModel.setSkssqz(endDate);
        requestModel.setRefresh(Boolean.valueOf(refresh));
        requestModel.getBusinessMap().putAll(this.getBizParams());
        requestModel.setUniKey(this.getUniKey(orgid, startDate, endDate, templateType));
        customParams.put("declareRequest", SerializationUtils.toJsonString((Object)requestModel));
        this.showDeclareForm(customParams, orgid, startDate, endDate, operationStatus);
        if (requestModel.getBusinessMap() != null && "1".equals(requestModel.getBusinessMap().get("zerodeclare"))) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
        }
    }

    protected void dispatch(Map<String, Object> customParams, String taskClassname, String actionId) {
        String appId = this.getView().getFormShowParameter().getAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u8868", (String)"AbstractDeclareReportPluginNew_51", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0]));
        jobInfo.setId(UUID.randomUUID());
        jobInfo.setTaskClassname(taskClassname);
        jobInfo.setRunByUserId(RequestContext.getOrCreate().getCurrUserId());
        jobInfo.setParams(customParams);
        String taskId = JobClient.dispatch((JobInfo)jobInfo);
        this.getPageCache().put("reFetchDatataskId", taskId);
    }

    protected void showDeclareForm(Map<String, Object> customParams, String orgid, String startDate, String endDate, String operationStatus) {
        FormShowParameter param = new FormShowParameter();
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.getView().updateView(CONTENT_TAB);
        this.setBtnStatus(orgid, startDate, endDate, operationStatus);
    }

    public void createZeroDeclareParams(String orgid, String startDate, String endDate, String appid, Map<String, Object> customParams, DeclareRequestModel requestModel) {
        boolean zerodeclare;
        DynamicObject declareMain = this.getDeclareMain(orgid, startDate, endDate, customParams.get(TEMPLATE_TYPE));
        Long sbbid = null;
        if (declareMain != null) {
            sbbid = declareMain.getLong("id");
            zerodeclare = declareMain.getBoolean("zerodeclare");
        } else {
            zerodeclare = SystemParamUtil.getZeroDeclareParameter((String)appid, (String)"zerodeclare", (long)Long.parseLong(orgid));
        }
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("zerodeclare", zerodeclare ? "1" : "0");
        requestModel.setExtendParams(extendParams);
        requestModel.addBusinessValue("zerodeclare", zerodeclare ? "1" : "0");
        requestModel.setId(sbbid);
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgid)));
        requestModel.setSkssqq(startDate);
        requestModel.setSkssqz(endDate);
    }

    public String getDeclareFormId() {
        return DECLARE_PAGE_ENTITY_NEW;
    }

    protected void setBtnStatus(String orgid, String startDate, String endDate, String operationStatus) {
        String templateType = this.getTemplateType();
        DynamicObject dyo = YbnsrService.queryYbnsr((String)orgid, (String)templateType, (String)startDate, (String)endDate, null);
        if (dyo != null && VIEW.equals(operationStatus)) {
            String billstatus = dyo.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY, VIEWFLOWCHART_KEY, REFRESH_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.TRUE, new String[]{SUBMIT_KEY});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY, VIEWFLOWCHART_KEY, REFRESH_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.FALSE, new String[]{SUBMIT_KEY});
                this.getView().setEnable(Boolean.TRUE, new String[]{AUDIT_KEY});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.TRUE, new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, CLOSE_KEY, VIEWFLOWCHART_KEY, REFRESH_KEY});
                this.getView().setVisible(Boolean.FALSE, new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, SUBMIT_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.FALSE, new String[]{AUDIT_KEY});
            }
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY, VIEWFLOWCHART_KEY, REFRESH_KEY});
            this.getView().setVisible(Boolean.TRUE, new String[]{VIEW_DRAFT_KEY, RECALC_KEY, REGETDATA_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
        }
        if ("zzsybnsr_yz_fzjg".equals(this.getTemplateType())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{ONE_KEY_GENERATE, VIEW_DRAFT_KEY});
        }
    }

    private Long getSbbid(OperationStatus operationStatus, String orgid, String startDate, String endDate, Object type) {
        DynamicObject declareMain = this.getDeclareMain(orgid, startDate, endDate, type);
        if (declareMain != null) {
            return declareMain.getLong("id");
        }
        return null;
    }

    public DynamicObject getDeclareMain(String orgid, String startDate, String endDate, Object type) {
        QFilter q1 = new QFilter(ORG_SEL, "=", (Object)Long.valueOf(orgid));
        QFilter q2 = new QFilter("skssqq", "=", (Object)DateUtils.stringToDate((String)startDate));
        QFilter q3 = new QFilter("skssqz", "=", (Object)DateUtils.stringToDate((String)endDate));
        QFilter q4 = new QFilter("type", "=", type);
        return QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"id,billstatus,billno,zerodeclare", (QFilter[])new QFilter[]{q1, q2, q3, q4});
    }

    protected EngineModel buildEngineModel(String orgId, String skssqq, String skssqz, String templateType, IPageCache pageCache) {
        return new EngineModel(orgId, skssqq, skssqz, templateType, pageCache);
    }

    public abstract void init();

    public abstract String getTaxType();

    public abstract String getTemplateType();

    public abstract void clientCallBackMethod(Map<String, String> var1, String var2);

    public abstract void initPeriod(IDataModel var1, IPageCache var2, String var3, Map<String, Object> var4);

    public void pageRelease(EventObject e) {
        String sbbid = this.getPageCache().get(SBBID);
        if (StringUtils.isNotBlank((CharSequence)sbbid)) {
            MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
        }
    }

    protected String getUniKey(String orgid, String startDate, String endDate, String templateType) {
        return "";
    }
}

