/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.spread.event.ISpreadAction;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.DeclareReportHideFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporthide.service.DeclareReportHideService;
import kd.taxc.bdtaxr.business.template.impl.DynamicRowMSServiceImpl;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.formula.db.formula.QueryFormulaService;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.SpreadUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.refactor.template.domain.SpreadDataModel;
import kd.taxc.bdtaxr.common.refactor.template.dynamic.DynamicRowService;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.BeanMapUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.ComboBoxFormulaName;

public class DeclarePrintPlugin
extends AbstractFormPlugin {
    private static Log LOGGER = LogFactory.getLog(DeclarePrintPlugin.class);
    private DeclareReportHideService declareReportHideService;
    private static final String SPREAD_NAME = "spreadap";
    private static final String TEMPLATE_ENTITY_NAME = "bdtaxr_template_main";
    private static final String OLD_TEMPLATE_ENTITY_NAME = "tctb_template";
    private static final String MULTI_TEMPLATE_ENTITY_NAME = "tpo_template";
    private static List<String> NEW_VERSION_TEMPLATE_LIST = Arrays.asList("totf_cjrjybzj", "xfsjfj");

    public void initialize() {
        super.initialize();
        Object templateType = this.getView().getFormShowParameter().getCustomParam("templateType");
        SpreadDataModel spreadDataModel = "zzsyjskb".equals(templateType) ? new SpreadDataModel((AbstractFormPlugin)this, SPREAD_NAME, OLD_TEMPLATE_ENTITY_NAME) : (NEW_VERSION_TEMPLATE_LIST.contains(templateType) ? new SpreadDataModel((AbstractFormPlugin)this, SPREAD_NAME, MULTI_TEMPLATE_ENTITY_NAME) : new SpreadDataModel((AbstractFormPlugin)this, SPREAD_NAME, TEMPLATE_ENTITY_NAME));
        spreadDataModel.setPageCache(this.getPageCache());
        this.getView().addService(ISpreadAction.class, (Object)spreadDataModel);
    }

    private SpreadDataModel getSpreadDataModel() {
        return (SpreadDataModel)this.getView().getService(ISpreadAction.class);
    }

    public void afterCreateNewData(EventObject e) {
        this.getSpreadDataModel().init();
    }

    public void afterBindData(EventObject e) {
        Object templateId = this.getView().getFormShowParameter().getCustomParam("templateId");
        String templateType = (String)this.getView().getFormShowParameter().getCustomParam("templateType");
        String sbbid = (String)this.getView().getFormShowParameter().getCustomParam("sbbid");
        if (StringUtil.isBlank((CharSequence)sbbid)) {
            return;
        }
        DynamicObject template = this.getTemplate(templateId, templateType, sbbid);
        if (template == null) {
            return;
        }
        this.getPageCache().put("templateid", String.valueOf(template.get("id")));
        String json = template.getString("content_tag");
        DynamicObject typeObject = BusinessDataServiceHelper.loadSingle((Object)template.getDynamicObject("type").get("id"), (String)"tpo_template_type");
        String showData = this.getView().getParentView().getPageCache().get("showData");
        Map<String, String> showDataMap = StringUtils.isNotBlank((CharSequence)showData) ? (Map<String, String>)JsonUtil.fromJson((String)showData, Map.class) : this.queryDeclareData(sbbid, typeObject);
        try {
            json = this.replaceKeyToValue(json, typeObject, showDataMap);
        }
        catch (Exception e1) {
            LOGGER.error((Throwable)e1);
        }
        this.getSpreadDataModel().setSpreadJson(json);
    }

    private DynamicObject getTemplate(Object templateId, String templateType, String sbbid) {
        DynamicObject template;
        if ("zzsyjskb".equals(templateType)) {
            if (templateId == null) {
                DynamicObject nxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"templateid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
                templateId = nxx.get("templateid");
            }
            template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)OLD_TEMPLATE_ENTITY_NAME);
        } else if (NEW_VERSION_TEMPLATE_LIST.contains(templateType)) {
            if (templateId == null) {
                DynamicObject nxx = QueryServiceHelper.queryOne((String)"tpo_declare_main_tsc", (String)"templateid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
                templateId = nxx.get("templateid");
            }
            template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)MULTI_TEMPLATE_ENTITY_NAME);
        } else {
            if (templateId == null) {
                DynamicObject nxx = QueryServiceHelper.queryOne((String)"tcvat_nsrxx", (String)"templateid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
                templateId = nxx.get("templateid");
            }
            template = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)TEMPLATE_ENTITY_NAME);
        }
        return template;
    }

    private Map<String, String> queryDeclareData(String sbbid, DynamicObject typeObject) {
        String mainTable = typeObject.getString("maintable");
        Map<String, String> dataMap = new HashMap<String, String>();
        try {
            dataMap = TemplateUtils.dataToMap((String)mainTable, (String)"#", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(sbbid))});
        }
        catch (Exception e) {
            return dataMap;
        }
        DynamicObjectCollection entityList = typeObject.getDynamicObjectCollection("entryentity");
        QFilter sbbIdFilter = new QFilter("sbbid", "=", (Object)sbbid);
        if (entityList != null && !entityList.isEmpty()) {
            for (DynamicObject dobj : entityList) {
                try {
                    String entityId = dobj.getString("entityid");
                    if (entityId.equals("tcvat_nsrxx")) continue;
                    Map dMap = TemplateUtils.dataToMap((String)entityId, (String)"#", (QFilter[])new QFilter[]{sbbIdFilter});
                    dataMap.putAll(dMap);
                }
                catch (Exception exception) {}
            }
        }
        return dataMap;
    }

    private String replaceKeyToValue(String templateJson, DynamicObject typeObject, Map<String, String> dataMap) {
        Map<String, FormulaVo> comboCells = new HashMap<String, FormulaVo>(8);
        Map<String, FormulaVo> f7Cells = new HashMap<String, FormulaVo>(8);
        if (NEW_VERSION_TEMPLATE_LIST.contains(typeObject.getString("number"))) {
            this.getFormula(comboCells, f7Cells, dataMap);
        } else {
            comboCells = this.getComboCells(typeObject, dataMap);
            f7Cells = this.getF7Cells(typeObject, dataMap);
        }
        return JSONObject.toJSONString((Object)this.replaceCellStyleAndValue(templateJson, dataMap, comboCells, f7Cells));
    }

    private void getFormula(Map<String, FormulaVo> comboCells, Map<String, FormulaVo> f7Cells, Map<String, String> dataMap) {
        long templateId = Long.parseLong(this.getPageCache().get("templateid"));
        String sbbid = (String)this.getView().getFormShowParameter().getCustomParam("sbbid");
        Long modelid = (Long)this.getView().getFormShowParameter().getCustomParam("modelid");
        HashMap<String, Object> ruleParamMap = new HashMap<String, Object>();
        ruleParamMap.put("sbbid", sbbid);
        ruleParamMap.put("skssqq", dataMap.get("tpo_declare_main_tsc#skssqq"));
        ruleParamMap.put("skssqz", dataMap.get("tpo_declare_main_tsc#skssqz"));
        ruleParamMap.put("modelId", modelid);
        ruleParamMap.put("templateId", templateId);
        ruleParamMap.put("cacheId", UUID.randomUUID());
        DynamicRowMSServiceImpl dynamicRowService = new DynamicRowMSServiceImpl();
        String result = dynamicRowService.getDynamicRowList(templateId, ruleParamMap);
        Map cellTypeFormulas = (Map)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_CELLTYPE_FORMULAS, (Object[])new Object[]{templateId, JsonUtil.fromJsonList((String)result, DynamicRowModel.class)});
        if (cellTypeFormulas == null) {
            return;
        }
        for (Map.Entry entry : cellTypeFormulas.entrySet()) {
            if ("5".equals(((FormulaVo)entry.getValue()).getCellType())) {
                f7Cells.put((String)entry.getKey(), (FormulaVo)entry.getValue());
            }
            if (!Arrays.asList("2", "3", "4").contains(((FormulaVo)entry.getValue()).getCellType())) continue;
            comboCells.put((String)entry.getKey(), (FormulaVo)entry.getValue());
        }
    }

    private JSONObject replaceCellStyleAndValue(String templateJson, Map<String, String> dataMap, Map<String, FormulaVo> comboCells, Map<String, FormulaVo> f7Cells) {
        Map<String, String> allCells = this.getAllCells(SpreadUtils.getSheets((String)templateJson, null));
        JSONObject jsonObject = JSONObject.parseObject((String)templateJson);
        JSONObject sheets = jsonObject.getJSONObject("sheets");
        LinkedHashMap sheetMap = (LinkedHashMap)JSON.parseObject((String)sheets.toJSONString(), (TypeReference)new TypeReference<LinkedHashMap<String, LinkedHashMap>>(){}, (Feature[])new Feature[0]);
        this.replaceSheet(allCells, dataMap, sheetMap, comboCells, f7Cells);
        jsonObject.put("sheets", (Object)sheetMap);
        return jsonObject;
    }

    private List<String> getHideSheets() {
        Object templateType = this.getView().getFormShowParameter().getCustomParam("templateType");
        String sbbid = (String)this.getView().getFormShowParameter().getCustomParam("sbbid");
        String templateid = this.getPageCache().get("templateid");
        this.declareReportHideService = DeclareReportHideFactory.createHandler(String.valueOf(templateType));
        if (this.declareReportHideService != null) {
            DeclareRequestModel requestModel = new DeclareRequestModel();
            requestModel.setTemplateId(Long.valueOf(templateid));
            requestModel.setTemplateType(String.valueOf(templateType));
            requestModel.setId(Long.valueOf(Long.parseLong(sbbid)));
            return this.declareReportHideService.hideSheets(requestModel);
        }
        return new ArrayList<String>();
    }

    private Map<String, String> getAllCells(List<Sheet> sheets) {
        HashMap<String, String> allCells = new HashMap<String, String>();
        List<List> sheetList = sheets.stream().map(s -> s.getRowList()).collect(Collectors.toList());
        sheetList.forEach(s -> s.forEach(r -> r.forEach(c -> {
            if (StringUtils.isNotBlank((CharSequence)c.getCellKey()) && c.getCellKey().contains("#")) {
                allCells.put(c.getCellKey(), c.getCellKey());
            }
        })));
        return allCells;
    }

    private void replaceSheet(Map<String, String> allCells, Map<String, String> dataMap, LinkedHashMap<String, LinkedHashMap> sheetMap, Map<String, FormulaVo> comboCells, Map<String, FormulaVo> f7Cells) {
        String templateType = (String)this.getView().getFormShowParameter().getCustomParam("templateType");
        this.addDynToAllCells(allCells, dataMap);
        Map<String, DynamicRowModel> dynKeys = this.getDynKeysByDynRowList(allCells);
        sheetMap.forEach((sheet, value) -> {
            JSONObject data = (JSONObject)value.get("data");
            JSONArray spans = (JSONArray)value.get("spans");
            JSONObject dataTableJson = data.getJSONObject("dataTable");
            TreeMap dataTableMap = (TreeMap)JSON.parseObject((String)dataTableJson.toJSONString(), (TypeReference)new TypeReference<TreeMap<Integer, JSONObject>>(){}, (Feature[])new Feature[0]);
            LinkedHashMap dataTableDynMap = new LinkedHashMap();
            dataTableMap.forEach((key, lineJson) -> {
                LinkedHashMap lineMap = (LinkedHashMap)JSON.parseObject((String)lineJson.toJSONString(), (TypeReference)new TypeReference<LinkedHashMap<String, JSONObject>>(){}, (Feature[])new Feature[0]);
                lineMap.values().forEach(v -> {
                    String valueStr = v.getString("value");
                    if (StringUtils.isNotBlank((CharSequence)valueStr)) {
                        DynamicRowModel rowModel = (DynamicRowModel)dynKeys.get(valueStr);
                        if (rowModel != null) {
                            dataTableDynMap.put(key, rowModel);
                        } else if (valueStr.startsWith("${") && valueStr.endsWith("}") && dynKeys.containsKey(valueStr.substring(2, valueStr.length() - 1))) {
                            dataTableDynMap.put(key, dynKeys.get(valueStr.substring(2, valueStr.length() - 1)));
                        } else if (valueStr.startsWith("${") && valueStr.endsWith("}%") && dynKeys.containsKey(valueStr.substring(2, valueStr.length() - 2))) {
                            dataTableDynMap.put(key, dynKeys.get(valueStr.substring(2, valueStr.length() - 2)));
                        }
                    }
                });
            });
            Map<String, List<JSONObject>> rowMap = this.getRowSpanMap(spans);
            LinkedHashMap<String, List<JSONObject>> newRowMap = new LinkedHashMap<String, List<JSONObject>>();
            TreeMap<String, JSONObject> newDataTableMap = new TreeMap<String, JSONObject>();
            AtomicInteger offset = new AtomicInteger(0);
            dataTableMap.forEach((k, v) -> {
                DynamicRowModel dynLine;
                List rowList;
                newDataTableMap.put(String.valueOf(k + offset.get()), (JSONObject)v);
                newRowMap.put(String.valueOf(k + offset.get()), this.replaceDynSpans((List)rowMap.get(String.valueOf(k)), (int)k, offset.get()));
                if (dataTableDynMap.containsKey(k) && !CollectionUtils.isEmpty((Collection)(rowList = (dynLine = (DynamicRowModel)dataTableDynMap.get(k)).getRowList())) && rowList.size() > (NEW_VERSION_TEMPLATE_LIST.contains(templateType) ? 0 : 1)) {
                    for (int i = 0; i < rowList.size(); ++i) {
                        newDataTableMap.put(String.valueOf(k + offset.get() + i), this.replaceDynCell(dynLine, (JSONObject)v, i, comboCells, f7Cells));
                        newRowMap.put(String.valueOf(k + offset.get() + i), this.replaceDynSpans((List)rowMap.get(String.valueOf(k)), (int)k, offset.get() + i));
                    }
                    offset.set(offset.get() + rowList.size() - 1);
                    if (value.get("rowCount") != null) {
                        value.put("rowCount", Integer.parseInt(value.get("rowCount").toString()) + rowList.size() - 1);
                    }
                }
            });
            newDataTableMap.forEach((key, lineJson) -> {
                LinkedHashMap lineMap = (LinkedHashMap)JSON.parseObject((String)lineJson.toJSONString(), (TypeReference)new TypeReference<LinkedHashMap<String, JSONObject>>(){}, (Feature[])new Feature[0]);
                lineMap.values().forEach(v -> {
                    String valueStr;
                    Object styleObj = v.get((Object)"style");
                    if (styleObj instanceof JSONObject) {
                        JSONObject styleJson = (JSONObject)styleObj;
                        styleJson.put("locked", (Object)Boolean.TRUE);
                        v.put("style", (Object)styleJson);
                    }
                    if (StringUtils.isNotBlank((CharSequence)(valueStr = v.getString("value")))) {
                        if (allCells.containsKey(valueStr)) {
                            this.doAdaptSetCellValue(dataMap, comboCells, f7Cells, (JSONObject)v, valueStr);
                        } else if (valueStr.startsWith("${") && valueStr.endsWith("}") && allCells.containsKey(valueStr.substring(2, valueStr.length() - 1))) {
                            this.doAdaptSetCellValue(dataMap, comboCells, f7Cells, (JSONObject)v, valueStr.substring(2, valueStr.length() - 1));
                        } else if (valueStr.startsWith("${") && valueStr.endsWith("}%") && allCells.containsKey(valueStr.substring(2, valueStr.length() - 2))) {
                            this.doAdaptSetCellValue(dataMap, comboCells, f7Cells, (JSONObject)v, valueStr.substring(2, valueStr.length() - 2));
                            v.put("value", (Object)v.getString("value").concat("%"));
                        }
                    }
                });
                newDataTableMap.put((String)key, JSONObject.parseObject((String)JSONObject.toJSONString((Object)lineMap)));
            });
            data.put("dataTable", newDataTableMap);
            this.resetSpans((LinkedHashMap)value, spans, (Map<String, List<JSONObject>>)newRowMap);
        });
    }

    private void resetSpans(LinkedHashMap value, JSONArray spans, Map<String, List<JSONObject>> newRowMap) {
        if (spans == null) {
            return;
        }
        spans.clear();
        newRowMap.values().forEach(l -> {
            if (l != null) {
                spans.addAll((Collection)l);
            }
        });
        value.put("spans", spans);
    }

    private Map<String, List<JSONObject>> getRowSpanMap(JSONArray spans) {
        LinkedHashMap<String, List<JSONObject>> rowMap = new LinkedHashMap<String, List<JSONObject>>();
        if (!CollectionUtils.isEmpty((Collection)spans) && spans.size() > 1) {
            for (int i = 0; i < spans.size(); ++i) {
                JSONObject jsonObject = spans.getJSONObject(i);
                String row = jsonObject.getString("row");
                if (rowMap.containsKey(row)) {
                    List jsonObjects = (List)rowMap.get(row);
                    jsonObjects.add(jsonObject);
                    rowMap.put(row, jsonObjects);
                    continue;
                }
                ArrayList<JSONObject> objects = new ArrayList<JSONObject>();
                objects.add(jsonObject);
                rowMap.put(row, objects);
            }
        }
        return rowMap;
    }

    private List<JSONObject> replaceDynSpans(List<JSONObject> jsonObjects, int origin, int offset) {
        if (CollectionUtils.isEmpty(jsonObjects) || offset == 0) {
            return jsonObjects;
        }
        List result = JsonUtil.fromJsonList((String)JsonUtil.toJson(jsonObjects), JSONObject.class);
        result.forEach(j -> j.put("row", (Object)(origin + offset)));
        return result;
    }

    private void doAdaptSetCellValue(Map<String, String> dataMap, Map<String, FormulaVo> comboCells, Map<String, FormulaVo> f7Cells, JSONObject v, String valueStr) {
        if (comboCells.containsKey(valueStr) && comboCells.get(valueStr) != null) {
            String formulaName = comboCells.get(valueStr).getFormulaName();
            List combos = JsonUtil.fromJsonList((String)formulaName, ComboBoxFormulaName.class);
            v.put("value", (Object)combos.stream().filter(c -> c.getVal().equals(dataMap.get(valueStr))).findFirst().orElseGet(ComboBoxFormulaName::new).getText());
        } else if (f7Cells.containsKey(valueStr)) {
            if ("zzsyjskb".equals(this.getView().getFormShowParameter().getCustomParam("templateType"))) {
                String f7Value = this.getV1F7TextValue(dataMap, f7Cells, v, valueStr);
                if (f7Value == null) {
                    return;
                }
                v.put("value", (Object)f7Value);
            } else {
                v.put("value", (Object)dataMap.getOrDefault(valueStr + "_text", ""));
            }
        } else {
            v.put("value", (Object)dataMap.getOrDefault(valueStr, ""));
        }
    }

    private String getV1F7TextValue(Map<String, String> dataMap, Map<String, FormulaVo> f7Cells, JSONObject v, String valueStr) {
        String f7Id = dataMap.get(valueStr);
        if (StringUtils.isBlank((CharSequence)f7Id) || "0".equals(f7Id)) {
            v.put("value", (Object)"");
            return null;
        }
        FormulaVo formulaVo = f7Cells.get(valueStr);
        String formulaName = formulaVo.getFormulaName();
        List combos = JsonUtil.fromJsonList((String)formulaName, ComboBoxFormulaName.class);
        if (CollectionUtils.isEmpty((Collection)combos)) {
            return null;
        }
        String f7Meta = ((ComboBoxFormulaName)combos.get(0)).getVal();
        if (StringUtils.isBlank((CharSequence)f7Meta)) {
            return null;
        }
        DynamicObject f7Obj = BusinessDataServiceHelper.loadSingle((Object)f7Id, (String)f7Meta);
        if (f7Obj == null) {
            return null;
        }
        return f7Obj.getString("number") + "|" + f7Obj.getString("name");
    }

    private JSONObject replaceDynCell(DynamicRowModel model, JSONObject lineJson, int i, Map<String, FormulaVo> comboCells, Map<String, FormulaVo> f7Cells) {
        LinkedHashMap lineMap = (LinkedHashMap)JSON.parseObject((String)lineJson.toJSONString(), (TypeReference)new TypeReference<LinkedHashMap<String, JSONObject>>(){}, (Feature[])new Feature[0]);
        lineMap.values().forEach(v -> {
            String valueStr = v.getString("value");
            if (StringUtils.isNotEmpty((CharSequence)valueStr)) {
                String newValueStr;
                String[] split = valueStr.split("#");
                if (split.length > 2) {
                    newValueStr = split[0] + "#" + ((long)i + model.getStartRow()) + "#" + split[2];
                    v.put("value", (Object)newValueStr);
                    if (comboCells.containsKey(valueStr)) {
                        comboCells.put(newValueStr, (FormulaVo)comboCells.get(valueStr));
                    } else if (comboCells.containsKey(valueStr.substring(2, newValueStr.length() - 1))) {
                        comboCells.put(newValueStr.substring(2, newValueStr.length() - 1), (FormulaVo)comboCells.get(valueStr));
                    }
                    if (f7Cells.containsKey(valueStr)) {
                        f7Cells.put(newValueStr, (FormulaVo)f7Cells.get(valueStr));
                    } else if (f7Cells.containsKey(valueStr.substring(2, newValueStr.length() - 1))) {
                        f7Cells.put(newValueStr.substring(2, newValueStr.length() - 1), (FormulaVo)f7Cells.get(valueStr));
                    }
                }
                if (split.length == 2) {
                    newValueStr = split[0] + "#" + ((long)i + model.getStartRow()) + "#" + split[1];
                    v.put("value", (Object)newValueStr);
                }
            }
        });
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)lineMap));
    }

    private Map<String, DynamicRowModel> getDynKeysByDynRowList(Map<String, String> allCells) {
        String dynRowStr = this.getView().getParentView().getPageCache().get("dynRowList");
        List<LinkedHashMap<String, Object>> dynRowList = new ArrayList<LinkedHashMap<String, Object>>();
        if (StringUtils.isNotBlank((CharSequence)dynRowStr)) {
            dynRowList = (List)JsonUtil.fromJson((String)dynRowStr, List.class);
        }
        return this.getDynKeys(allCells, dynRowList);
    }

    private void addDynToAllCells(Map<String, String> allCells, Map<String, String> dataMap) {
        dataMap.forEach((k, v) -> {
            if (!allCells.containsKey(k)) {
                allCells.put((String)k, (String)v);
            }
        });
    }

    private Map<String, DynamicRowModel> getDynKeys(Map<String, String> allCells, List<LinkedHashMap<String, Object>> dynRowList) {
        HashMap<String, DynamicRowModel> result = new HashMap<String, DynamicRowModel>();
        if (CollectionUtils.isEmpty(dynRowList)) {
            return result;
        }
        List collect = dynRowList.stream().map(this::convert).collect(Collectors.toList());
        allCells.forEach((k, v) -> {
            DynamicRowModel dyn = DynamicRowService.matchDyn((List)collect, (String)k);
            if (dyn != null) {
                result.put((String)k, dyn);
            }
        });
        return result;
    }

    private DynamicRowModel convert(LinkedHashMap<String, Object> d) {
        try {
            return (DynamicRowModel)BeanMapUtils.mapToBean(d, DynamicRowModel.class);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            return new DynamicRowModel();
        }
    }

    private Map<String, FormulaVo> getF7Cells(DynamicObject typeObject, Map<String, String> dataMap) {
        QFilter q1 = new QFilter("taxtype", "=", (Object)typeObject.getString("number"));
        QFilter q2 = new QFilter("formulatype", "=", (Object)"3");
        QFilter q3 = new QFilter("templateid", "=", (Object)this.getPageCache().get("templateid"));
        QFilter q4 = new QFilter("celltype", "=", (Object)"5");
        Map<String, FormulaVo> formulaVoMap = this.getFormulaVoMap(typeObject, Arrays.asList(q1, q2, q3, q4));
        if (CollectionUtils.isEmpty(formulaVoMap)) {
            return new HashMap<String, FormulaVo>();
        }
        return formulaVoMap;
    }

    private Map<String, FormulaVo> getComboCells(DynamicObject typeObject, Map<String, String> dataMap) {
        QFilter q1 = new QFilter("taxtype", "=", (Object)typeObject.getString("number"));
        QFilter q2 = new QFilter("formulatype", "=", (Object)"3");
        QFilter q3 = new QFilter("templateid", "=", (Object)this.getPageCache().get("templateid"));
        QFilter q4 = new QFilter("celltype", "in", Arrays.asList("2", "3", "4"));
        Map<String, FormulaVo> formulaVoMap = this.getFormulaVoMap(typeObject, Arrays.asList(q1, q2, q3, q4));
        if (CollectionUtils.isEmpty(formulaVoMap)) {
            return new HashMap<String, FormulaVo>();
        }
        return formulaVoMap;
    }

    private Map<String, FormulaVo> getFormulaVoMap(DynamicObject typeObject, List<QFilter> filters) {
        if ("zzsyjskb".equals(typeObject.getString("number"))) {
            return QueryFormulaService.getFormulaVoMap(filters);
        }
        return kd.taxc.bdtaxr.common.refactor.formula.db.QueryFormulaService.getFormulaVoMap(filters);
    }
}

