/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.taxc.bdtaxr.business.formula.FormulaService;
import kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareTemplateService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.ChangeDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareTemplateServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.SavetaxDeclareServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.DeclareReportTreeFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.TctrcwarningVo;

public class TaskDeclareCalService {
    private static final String ARSEDATAFORSHOW = "parseDataForShow";
    private static final TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private static final DeclareTemplateService declareTemplateService = new DeclareTemplateServiceImpl();
    private static DeclareRequestService declareRequestService = new DeclareRequestServiceImpl();
    private static DeclareReportCalculateService declareReportCalculateService;
    private static DeclareReportTreeService declareReportTreeService;
    private static final BaseDataService baseDataService;
    private static final FormulaService formulaService;
    private static final SavetaxDeclareService savetaxDeclareService;
    private static final ChangeDataService changeDataService;

    public static Map<String, Object> declareCal(Map<String, Object> params) {
        String feedbackMsg = ResManager.loadKDString((String)"\u6570\u636e\u8ba1\u7b97\u4e2d\uff0c\u8bf7\u7a0d\u540e\u3002", (String)"TaxDeclareCalTask_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        String requestStr = (String)(params.containsKey("declareRequest") ? params.get("declareRequest") : params.get("declareRequestData"));
        DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)requestStr, DeclareRequestModel.class);
        requestModel = declareRequestService.build(requestStr);
        String selectNode = (String)params.getOrDefault("selectNode", "");
        String sourceFrom = (String)params.getOrDefault("sourceFrom", "");
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, null);
        DeclareResponseModel responseModel = TaskDeclareCalService.queryData(requestModel, typeMap, params);
        TaxDeclarePluginService.checkResponse(requestModel, responseModel);
        Map<String, String> showData = new HashMap<String, String>(responseModel.getData());
        baseDataService.queryBaseData(showData, responseModel.getDynRowList(), requestModel);
        GetTemplateVo getTemplateVo = DeclareReportHelpService.getTemplateVo(requestModel, responseModel);
        getTemplateVo.setTypeMap(typeMap);
        TemplateVo template = declareTemplateService.getTemplate(getTemplateVo);
        template = DeclareReportHelpService.parseTemplateByCalResponse(template, requestModel, responseModel, typeMap);
        Map<String, Object> treeData = null;
        declareReportTreeService = DeclareReportTreeFactory.createHandler(requestModel.getTemplateType());
        if (declareReportTreeService != null) {
            treeData = declareReportTreeService.loadTreeByCurrentData(requestModel, responseModel, selectNode, sourceFrom, showData);
        }
        List<Map<String, String>> checkFormulaList = formulaService.checkFormulasNew(requestModel, showData, responseModel.getParamMap(), responseModel.getDynRowList());
        showData = changeDataService.changeToShow(showData, responseModel, typeMap, requestModel.getOperation());
        TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
        if ("read".equals(requestModel.getOperation())) {
            savetaxDeclareService.saveRiskItem(requestModel.getId().toString(), checkFormulaList, riskResultMap.getTctrcwarning(), 2);
        }
        HashMap<String, String> newTypeMap = new HashMap<String, String>(typeMap.size());
        HashMap<String, String> baseTypeMap = new HashMap<String, String>(50);
        TaxDeclarePluginService.parseTypeMap(typeMap, newTypeMap, baseTypeMap);
        Map<String, Map<String, String>> parseDataForShow = TaxDeclarePluginService.parseShowData(showData, newTypeMap);
        List<String> hisCellList = null;
        if ("read".equals(requestModel.getOperation())) {
            hisCellList = TaxDeclarePluginService.queryHasHisCell(requestModel.getId().toString());
        }
        Map sheetCellMap = template.getSheetCellMap();
        params.put("sheetCellMap", SerializationUtils.toJsonString((Object)sheetCellMap));
        params.put("declareRequest", SerializationUtils.toJsonString((Object)requestModel));
        params.put("declareData", SerializationUtils.toJsonString((Object)responseModel));
        params.put("resultData", SerializationUtils.toJsonString((Object)responseModel.getData()));
        params.put("showData", SerializationUtils.toJsonString(showData));
        params.put("htmlTemplate", SerializationUtils.toJsonString((Object)template));
        params.put("riskResultMap", SerializationUtils.toJsonString((Object)riskResultMap));
        params.put("treeData", SerializationUtils.toJsonString(treeData));
        params.put(ARSEDATAFORSHOW, SerializationUtils.toJsonString(parseDataForShow));
        params.put("baseTypeMap", SerializationUtils.toJsonString(baseTypeMap));
        params.put("newTypeMap", SerializationUtils.toJsonString(newTypeMap));
        return params;
    }

    private static DeclareResponseModel queryData(DeclareRequestModel requestModel, Map<String, EntityField> metaTypeMap, Map<String, Object> params) {
        if (requestModel.getRefresh() == null) {
            requestModel.setRefresh(Boolean.FALSE);
        }
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (requestModel.getRefresh().booleanValue()) {
            responseModel = TaskDeclareCalService.refreshData(requestModel, metaTypeMap);
        }
        if (!requestModel.getRefresh().booleanValue()) {
            responseModel = TaskDeclareCalService.queryDBData(requestModel, params);
            metaTypeMap = TaxDeclarePluginService.expanFieldsTypeByDynRow(metaTypeMap, responseModel.getDynRowList());
        }
        return responseModel;
    }

    private static DeclareResponseModel refreshData(DeclareRequestModel requestModel, Map<String, EntityField> metaTypeMap) {
        DeclareResponseModel responseModel = taxDeclareDataService.refreshData(requestModel, metaTypeMap);
        declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (declareReportCalculateService != null) {
            responseModel = declareReportCalculateService.afterCalculate(requestModel, responseModel, responseModel.getDynRowList(), metaTypeMap);
        }
        return responseModel;
    }

    private static DeclareResponseModel queryDBData(DeclareRequestModel requestModel, Map<String, Object> customParams) {
        DeclareResponseModel responseModel = new DeclareResponseModel();
        responseModel = "history".equals(requestModel.getDataSource()) ? taxDeclareDataService.queryHistoryData(requestModel, customParams) : ("taxBureau".equals(requestModel.getDataSource()) ? taxDeclareDataService.queryTaxBureauData(requestModel, customParams) : taxDeclareDataService.queryData(requestModel));
        return responseModel;
    }

    private static void allRequiredFieldValidator(String orgId) {
        DynamicObject taxMain;
        if (StringUtils.isNotBlank((CharSequence)orgId) && (taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData()) != null) {
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            String orgname = taxorg.getString("org.name");
            String taxoffice = taxMain.getString("taxoffice.id");
            String registertype = taxMain.getString("registertype.id");
            String registertime = taxMain.getString("registertime");
            String registeraddress = taxMain.getString("registeraddress");
            String codeandname = taxMain.getString("codeandname.id");
            String actualaddress = taxMain.getString("actualaddress");
            String admindivisionObject = taxMain.getString("accountingstandards.id");
            if (StringUtils.isEmpty((CharSequence)registeraddress) || "0".equalsIgnoreCase(admindivisionObject) || "0".equalsIgnoreCase(taxoffice) || "0".equalsIgnoreCase(registertype) || StringUtils.isEmpty((CharSequence)registertime) || "0".equalsIgnoreCase(codeandname) || StringUtils.isEmpty((CharSequence)actualaddress)) {
                ErrorCode errorCode = new ErrorCode("allRequiredField", String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxDeclarePlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }

    static {
        baseDataService = new BaseDataServiceImpl();
        formulaService = new FormulaServiceImpl();
        savetaxDeclareService = new SavetaxDeclareServiceImpl();
        changeDataService = new ChangeDataServiceImpl();
    }
}

