/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.form.control.CustomControl;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.cache.PageCache;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.taxc.bdtaxr.business.constant.TaxDeclareConstant;
import kd.taxc.bdtaxr.business.formula.FormulaService;
import kd.taxc.bdtaxr.business.formula.impl.FormulaServiceImpl;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.BaseDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.ChangeDataService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareTemplateService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BaseDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.BizChangeDataHandler;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.ChangeDataServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareTemplateServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.SavetaxDeclareServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.business.subplugin.declare.DeclareBizExtendHelper;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.DeclareReportCalculateFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportcalculate.service.DeclareReportCalculateService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.DeclareReportSaveFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereportsave.service.DeclareReportSaveService;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.DeclareReportTreeFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.declare.helper.DeclareServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckFactory;
import kd.taxc.bdtaxr.common.refactor.declare.savecheck.TaxDeclareCheckHandler;
import kd.taxc.bdtaxr.common.refactor.formula.verify.CheckResult;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.taxdeclare.AbstractTaxDeclarePluginNew;
import kd.taxc.bdtaxr.common.taxdeclare.NsrxxValidatorUtils;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.UUID;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityInfo;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.DeclareChangeDataCheckCustomVo;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.TaxDeclareCalTask;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.GetTemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.LoadDeclareDataVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.vo.TctrcwarningVo;
import org.apache.commons.lang.StringUtils;

public class TaxDeclarePlugin
extends AbstractTaxDeclarePluginNew {
    private static final String CHECK_RESULT_LIST = "checkResultList";
    private static final String RISK_RESULT_LIST = "riskResultMap";
    private static final String ATTACHMENTPANELAP = "attachmentpanelap";
    private static final String ARSEDATAFORSHOW = "parseDataForShow";
    private static Log LOGGER = LogFactory.getLog(TaxDeclarePlugin.class);
    private IPageCache pageCache;
    private CustomControl control;
    private TaxDeclareCheckHandler check_handler;
    private DeclareReportTreeService declareReportTreeService;
    private DeclareReportSaveService declareReportSaveService;
    private DeclareReportCalculateService declareReportCalculateService;
    private DeclareRequestService declareRequestService = new DeclareRequestServiceImpl();
    private TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private DeclareTemplateService declareTemplateService = new DeclareTemplateServiceImpl();
    private FormulaService formulaService = new FormulaServiceImpl();
    private BaseDataService baseDataService = new BaseDataServiceImpl();
    private SavetaxDeclareService savetaxDeclareService = new SavetaxDeclareServiceImpl();
    private ChangeDataService changeDataService = new ChangeDataServiceImpl();

    public void registerListener(EventObject e) {
        this.addItemClickListeners(new String[]{"toolbarap"});
        super.registerListener(e);
    }

    public void initialize() {
        this.pageCache = this.getPageCache();
        this.control = (CustomControl)this.getControl(TaxDeclareConstant.CUSTOM_CONTROL);
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String operateType = customParams.getOrDefault("customEvent", "");
        String declareRequest = customParams.getOrDefault("declareRequest", "");
        if (StringUtil.isBlank((CharSequence)declareRequest)) {
            declareRequest = customParams.getOrDefault("declareRequestData", "");
            customParams.put("declareRequest", declareRequest);
        }
        String showData = customParams.getOrDefault(ARSEDATAFORSHOW, "");
        IFormView parentView = this.getView().getParentView();
        if (parentView != null) {
            parentView.setEnable(Boolean.FALSE, new String[]{"edit", "save", "bar_save"});
            this.getView().sendFormAction(parentView);
        }
        if (Arrays.asList("reFetchData", "edit").contains(operateType) && StringUtil.isNotBlank((CharSequence)showData)) {
            this.loadDeclarePage(customParams);
        } else {
            DeclareRequestModel requestModel = (DeclareRequestModel)SerializationUtils.fromJsonString((String)declareRequest, DeclareRequestModel.class);
            NsrxxValidatorUtils.nsrxxReviewed((Long)requestModel.getOrgId());
            this.allRequiredFieldValidator(requestModel.getOrgId().toString());
            customParams.remove("htmlTemplate");
            customParams.remove("showData");
            customParams.remove("resultData");
            this.dispatch(customParams);
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8bf7\u7a0d\u7b49......", (String)"TaxDeclarePlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0])));
            this.getView().addClientCallBack("taskcloseback", Integer.valueOf(200));
        }
    }

    private void loadDeclarePage(Map<String, Object> data) {
        try {
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                if (entry.getValue() == null) continue;
                this.pageCache.put(entry.getKey().toString(), entry.getValue().toString());
            }
            DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
            DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
            this.getCache().put("resultData", SerializationUtils.toJsonString((Object)responseModel.getData()));
            TemplateVo template = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
            List checkFormulaList = (List)TreeUtils.getCache((IPageCache)this.pageCache, (String)CHECK_RESULT_LIST, List.class);
            Map treeData = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"treeData", Map.class);
            Map showData = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"showData", Map.class);
            TctrcwarningVo riskResultMap = (TctrcwarningVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)RISK_RESULT_LIST, TctrcwarningVo.class);
            String currentSheetId = this.pageCache.get("sheetid");
            Map baseTypeMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"baseTypeMap", Map.class);
            Map parseDataForShow = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)ARSEDATAFORSHOW, Map.class);
            LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(showData, checkFormulaList, riskResultMap, requestModel, responseModel, template, this.control, treeData, null);
            loadDeclareDataVo.setBaseTypeMap(baseTypeMap);
            loadDeclareDataVo.setParseDataForShow(parseDataForShow);
            List hisCellList = null;
            if ("read".equals(requestModel.getOperation())) {
                hisCellList = (List)TreeUtils.getCache((IPageCache)this.pageCache, (String)"hisCellList", List.class);
            }
            loadDeclareDataVo.setHisCellList(hisCellList);
            TaxDeclarePluginService.loadPage(loadDeclareDataVo);
            IFormView parentView = this.getView().getParentView();
            if (parentView != null) {
                parentView.setEnable(Boolean.TRUE, new String[]{"edit", "save", "bar_save"});
                this.getView().sendFormAction(parentView);
            }
            String sbbid = String.valueOf(requestModel.getId());
            if (null != this.getView().getParentView()) {
                this.getView().getParentView().getPageCache().put("showData", SerializationUtils.toJsonString((Object)showData));
                this.getView().getParentView().getPageCache().put("dynRowList", SerializationUtils.toJsonString((Object)responseModel.getDynRowList()));
                this.getView().getParentView().getPageCache().put("cache_sbbid", sbbid);
                this.getView().getParentView().getPageCache().put("templateid", responseModel.getTemplateId().toString());
                this.getView().getParentView().addClientCallBack(null == this.getPageCache().get("sheetid") ? "0" : this.getPageCache().get("sheetid"), Integer.valueOf(0));
                this.getView().sendFormAction(this.getView().getParentView());
            }
            this.showAttachment(sbbid, requestModel.getOperation(), requestModel.getTemplateType());
        }
        catch (KDBizException ex) {
            LOGGER.error((Throwable)ex);
            this.getView().getParentView().showErrorNotification(ex.getMessage());
            this.getView().sendFormAction(this.getView().getParentView());
        }
    }

    protected void dispatch(Map<String, Object> customParams) {
        String appId = this.getView().getFormShowParameter().getServiceAppId();
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(appId);
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u7533\u62a5\u8868", (String)"AbstractDeclareReportPluginNew_51", (String)"taxc-bdtaxr", (Object[])new Object[0]), new Object[0]));
        jobInfo.setId(UUID.randomUUID());
        jobInfo.setTaskClassname(TaxDeclareCalTask.class.getName());
        jobInfo.setRunByUserId(RequestContext.getOrCreate().getCurrUserId());
        jobInfo.setRunConcurrently(false);
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setParams(customParams);
        String msg = SerializationUtils.toJsonString(customParams);
        LOGGER.info("\u6d88\u606f\u5927\u5c0f\uff1a{}\uff0c\u6d88\u606f\u5185\u5bb9\uff1a{}", (Object)msg.length(), (Object)msg);
        String taskId = JobClient.dispatch((JobInfo)jobInfo);
        this.getPageCache().put("taskId", taskId);
    }

    private void cacheRiskItem(List<Map<String, String>> checkFormulaList) {
        this.pageCache.put(CHECK_RESULT_LIST, SerializationUtils.toJsonString(checkFormulaList));
    }

    private Object getParentViewCustomParam(String key) {
        if (this.getView().getParentView() != null) {
            return this.getView().getParentView().getFormShowParameter().getCustomParam(key);
        }
        return null;
    }

    public void customEvent(CustomEventArgs e) {
        String args = e.getEventArgs();
        String eventName = e.getEventName();
        Map argsMap = (Map)SerializationUtils.fromJsonString((String)args, Map.class);
        DeclareRequestModel requestModel = this.getRequestModel();
        if (null == requestModel) {
            return;
        }
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        Map<String, String> currentMap = this.getCurrentMap();
        if ("changeData".equals(eventName)) {
            IFormView parentView;
            LoadDeclareDataVo loadDeclareDataVo;
            String cellKey = argsMap.getOrDefault("cellKey", "");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)cellKey)) {
                this.getView().showErrorNotification("the cell cannot be edit!");
                return;
            }
            if (argsMap.get("value") == null) {
                this.getView().showErrorNotification("edit params error!");
                return;
            }
            if (cellKey.endsWith("%")) {
                cellKey = cellKey.replace("%", "");
                argsMap.put("cellKey", cellKey);
                String value = (String)argsMap.get("value");
                argsMap.put("value", value.replace("%", ""));
            }
            if (!this.checkData(argsMap)) {
                loadDeclareDataVo = new LoadDeclareDataVo();
                loadDeclareDataVo.setControl(this.control);
                TaxDeclarePluginService.loadPage(loadDeclareDataVo);
            }
            if (this.isSame(requestModel, responseModel.getDynRowList(), cellKey, currentMap.get(cellKey), (String)argsMap.get("value"))) {
                loadDeclareDataVo = new LoadDeclareDataVo();
                loadDeclareDataVo.setControl(this.control);
                TaxDeclarePluginService.loadPage(loadDeclareDataVo);
            }
            if ((parentView = this.getView().getParentView()) != null) {
                parentView.setEnable(Boolean.FALSE, new String[]{"save"});
                this.getView().sendFormAction(parentView);
            }
            TreeUtils.putCache((IPageCache)this.pageCache, (String)("changeDataFunc" + cellKey), (Object)argsMap);
            this.getView().addClientCallBack("changeDataFunc" + cellKey);
        } else if ("showAddRemark".equals(eventName)) {
            this.showAddRemark(argsMap.get("cellKey").toString());
        } else if ("detail".equals(eventName)) {
            this.showDetail(requestModel, argsMap);
        } else if ("selectSheet".equals(eventName)) {
            if (argsMap.get("data") == null) {
                return;
            }
            this.pageCache.put("sheetid", argsMap.get("data").toString());
            TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
            List<Map<String, String>> checkFormulaList = this.formulaService.checkFormulasNew(requestModel, currentMap, responseModel.getParamMap(), responseModel.getDynRowList());
            this.cacheRiskItem(checkFormulaList);
            Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
            Map<String, Object> riskResultMap = TaxDeclarePluginService.getRiskResultMap(requestModel);
            LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(this.getCurrentMap(), null, null, requestModel, responseModel, templateMap, this.control, null, null);
            Map parseDataForShow = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)ARSEDATAFORSHOW, Map.class);
            loadDeclareDataVo.setParseDataForShow(parseDataForShow);
            loadDeclareDataVo.setCurrentSheetId(argsMap.get("data").toString());
            TaxDeclarePluginService.loadPage(loadDeclareDataVo);
            if (null != this.getView().getParentView()) {
                this.getView().getParentView().addClientCallBack(argsMap.get("data").toString());
                this.getView().sendFormAction(this.getView().getParentView());
            }
        } else if ("showBaseData".equals(eventName)) {
            Map map = (Map)argsMap.get("formulaVo");
            String cellId = (String)map.get("formulaKey");
            String value = null == argsMap.get("value") ? "" : argsMap.get("value").toString();
            String formulaName = (String)map.get("formulaName");
            Map<String, String> changCellMap = this.changCellMap(cellId, value, requestModel, responseModel.getDynRowList());
            JSONArray jsonArray = JSONArray.parseArray((String)formulaName);
            JSONObject o = (JSONObject)jsonArray.get(0);
            HashMap<String, String> baseDataCache = new HashMap<String, String>(1);
            baseDataCache.put(cellId, value);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"baseDataCache", baseDataCache);
            String entityId = o.getString("val");
            String minCompany = currentMap.get("tccit_qysds_zb#1#xxwlqy");
            String rjjcdlqyyhzc = currentMap.get("tccit_qysds_ext#18#itemname");
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            if (cellId.startsWith("tccit_qysds_ext_dyn")) {
                String beforeValue = currentMap.get(cellId);
                String amountCellId = cellId + "amount";
                String beforeAmountValue = currentMap.get(amountCellId);
                if (TaxDeclarePluginService.StringValueExist(beforeValue) || TaxDeclarePluginService.StringValueExist(beforeAmountValue)) {
                    HashMap<String, String> baseParamMap = new HashMap<String, String>();
                    baseParamMap.put("cellId", cellId);
                    baseParamMap.put("entityId", entityId);
                    baseParamMap.put("minCompany", minCompany);
                    this.remindChange(baseParamMap);
                } else {
                    customParams.put("rjjcdlqyyhzc", rjjcdlqyyhzc);
                    this.showBaseData(cellId, entityId, minCompany, formulaName);
                }
            } else if (cellId.matches("totf_sjfzsf_dtb#(\\d+)#deductioncode")) {
                String s = (String)responseModel.getData().get(cellId.substring(0, cellId.lastIndexOf(35)) + "#zsxm");
                customParams.put("currentZsxm", s);
                this.showBaseData(cellId, entityId, minCompany, formulaName);
            } else {
                this.showBaseData(cellId, entityId, minCompany, formulaName);
            }
        } else if ("datahref".equals(eventName)) {
            this.hyperLinkClick(argsMap, requestModel);
        } else if ("addRow".equals(eventName)) {
            Map dynRow;
            String dynamicRowNo = (String)argsMap.get("data");
            TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
            boolean addTemplate = false;
            DynamicRowModel dynamicRow = null;
            for (DynamicRowModel m : responseModel.getDynRowList()) {
                if (!dynamicRowNo.equals(m.getDynRowNo()) || m.getRowList() == null || m.getRowList().size() <= 0) continue;
                dynamicRow = m;
                addTemplate = true;
            }
            if (addTemplate) {
                templateMap = this.changeDataService.addTemplateRow(templateMap, dynamicRow);
            }
            List listRow = (dynRow = templateMap.getDynamicRow()) != null ? (List)dynRow.get(dynamicRowNo) : new ArrayList(0);
            ArrayList list = listRow.size() > 0 ? (List)listRow.get(listRow.size() - 1) : new ArrayList(0);
            HashMap<String, String> changCellMap = new HashMap<String, String>(list.size());
            ArrayList<String> cellKeyList = new ArrayList<String>(list.size());
            ArrayList<Map<String, Object>> listKeyValue = new ArrayList<Map<String, Object>>(list.size());
            EntityInfo entityInfo = MetadataUtil.getEntityById((String)dynamicRowNo.split("#")[0]);
            List filedLiust = entityInfo.getFieldList();
            for (Cell el2 : list) {
                if (el2 == null || el2.getCellKey() == null) continue;
                EntityField filed = filedLiust.stream().filter(l -> l.getFieldId().equals(el2.getCellKey().split("#")[2])).findFirst().orElseGet(null);
                String cellKey = el2.getCellKey();
                String value = filed != null && (filed.getFieldType().equals("Text") || filed.getFieldType().equals("Date")) ? "" : "0";
                HashMap<String, String> keyValue = new HashMap<String, String>(1);
                keyValue.put("cellKey", cellKey);
                keyValue.put("value", value);
                listKeyValue.add(keyValue);
                changCellMap.put(cellKey, value);
                cellKeyList.add(cellKey);
            }
            String matchKey = ((Cell)list.get(0)).getCellKey();
            this.changeDataService.addDataRow(responseModel, currentMap, listKeyValue, matchKey);
            currentMap = this.changeData(currentMap, responseModel, requestModel, "0", changCellMap, listKeyValue, cellKeyList.toArray(new String[cellKeyList.size()]));
            List<Map<String, String>> checkFormulaList = this.formulaService.checkFormulasNew(requestModel, currentMap, responseModel.getParamMap(), responseModel.getDynRowList());
            this.cacheRiskItem(checkFormulaList);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)templateMap);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"sheetCellMap", (Object)templateMap.getSheetCellMap());
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", currentMap);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
            this.baseDataService.queryBaseData(currentMap, responseModel.getDynRowList(), requestModel);
            Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
            currentMap = this.changeDataService.changeToShow(currentMap, responseModel, typeMap, requestModel.getOperation());
            TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)RISK_RESULT_LIST, (Object)riskResultMap);
            String currentSheetId = this.pageCache.get("sheetid");
            HashMap<String, String> newTypeMap = new HashMap<String, String>(typeMap.size());
            HashMap<String, String> baseTypeMap = new HashMap<String, String>(50);
            TaxDeclarePluginService.parseTypeMap(typeMap, newTypeMap, baseTypeMap);
            Map<String, Map<String, String>> parseDataForShow = TaxDeclarePluginService.parseShowData(currentMap, newTypeMap);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)ARSEDATAFORSHOW, parseDataForShow);
            LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(currentMap, checkFormulaList, riskResultMap, requestModel, responseModel, templateMap, this.control, null, typeMap);
            loadDeclareDataVo.setParseDataForShow(parseDataForShow);
            loadDeclareDataVo.setCurrentSheetId(currentSheetId);
            TaxDeclarePluginService.loadPage(loadDeclareDataVo);
        } else if ("delRow".equals(eventName)) {
            ArrayList list = (ArrayList)argsMap.get("data");
            Map map = (Map)list.get(0);
            String dynamicRowNo = (String)map.get("dynRowNo");
            String cellKey = (String)map.get("cellKey");
            ArrayList cellKeyList = new ArrayList();
            TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
            Map<String, List<List<Cell>>> dynamicRowMap = templateMap.getDynamicRow();
            HashMap<String, String> changCellMap = new HashMap<String, String>();
            boolean deleteTemplate = false;
            int dyrowListSize = 0;
            for (DynamicRowModel m : responseModel.getDynRowList()) {
                if (!cellKey.split("#")[0].equals(m.getDynRowNo().split("#")[0])) continue;
                dyrowListSize = m.getRowList().size();
                if (m.getRowList() == null || m.getRowList().size() == 0) {
                    return;
                }
                if (m.getRowList().size() <= 1) continue;
                deleteTemplate = true;
            }
            int deleteRowNo = Integer.parseInt(cellKey.split("#")[1]);
            int startRow = Integer.parseInt(dynamicRowNo.split("#")[1]);
            list.forEach(el -> {
                if (deleteRowNo > startRow) {
                    String[] str = ((String)el.get("cellKey")).split("#");
                    String newCellKey = str[0] + "#" + (Integer.parseInt(str[1]) - 1) + "#" + str[2];
                    cellKeyList.add(newCellKey);
                    changCellMap.put(newCellKey, "");
                    return;
                }
                cellKeyList.add(el.get("cellKey"));
                changCellMap.put((String)el.get("cellKey"), "");
            });
            if (deleteTemplate) {
                dynamicRowMap = this.changeDataService.deleteTemplateRow(dynamicRowMap, dynamicRowNo, cellKey);
                templateMap.setDynamicRow(dynamicRowMap);
            }
            this.changeDataService.deleteDataRow(responseModel, currentMap, startRow, cellKey, list);
            currentMap = this.changeData(currentMap, responseModel, requestModel, null, changCellMap, null, cellKeyList.toArray(new String[cellKeyList.size()]));
            if (dyrowListSize == 1) {
                for (int j = 0; j < list.size(); ++j) {
                    if (!currentMap.containsKey(((Map)list.get(j)).get("cellKey"))) continue;
                    currentMap.remove(((Map)list.get(j)).get("cellKey"));
                }
            }
            List<Map<String, String>> checkFormulaList = this.formulaService.checkFormulasNew(requestModel, currentMap, responseModel.getParamMap(), responseModel.getDynRowList());
            this.cacheRiskItem(checkFormulaList);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)templateMap);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", currentMap);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
            this.baseDataService.queryBaseData(currentMap, responseModel.getDynRowList(), requestModel);
            Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
            currentMap = this.changeDataService.changeToShow(currentMap, responseModel, typeMap, requestModel.getOperation());
            TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)RISK_RESULT_LIST, (Object)riskResultMap);
            String currentSheetId = this.pageCache.get("sheetid");
            HashMap<String, String> newTypeMap = new HashMap<String, String>(typeMap.size());
            HashMap<String, String> baseTypeMap = new HashMap<String, String>(50);
            TaxDeclarePluginService.parseTypeMap(typeMap, newTypeMap, baseTypeMap);
            Map<String, Map<String, String>> parseDataForShow = TaxDeclarePluginService.parseShowData(currentMap, newTypeMap);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)ARSEDATAFORSHOW, parseDataForShow);
            LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(currentMap, checkFormulaList, riskResultMap, requestModel, responseModel, templateMap, this.control, null, typeMap);
            loadDeclareDataVo.setParseDataForShow(parseDataForShow);
            loadDeclareDataVo.setCurrentSheetId(currentSheetId);
            TaxDeclarePluginService.loadPage(loadDeclareDataVo);
        } else if ("jumptotctrcrisk".equals(eventName)) {
            String tctrcResultId = (String)argsMap.get("data");
            this.jumpToTctrcRisk(tctrcResultId);
        }
    }

    private boolean isSame(DeclareRequestModel requestModel, List<DynamicRowModel> dynRowList, String cellKey, String lastValue, String newValue) {
        boolean result = false;
        if (lastValue == null && newValue == null) {
            result = true;
        } else if (lastValue == null || newValue == null) {
            result = false;
        } else if (Objects.equals(lastValue, newValue)) {
            result = true;
        } else {
            String[] split = cellKey.split("#");
            if (split.length == 3) {
                try {
                    HashMap<String, String> listTab = new HashMap<String, String>();
                    listTab.put(split[0], split[0]);
                    Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, dynRowList);
                    EntityField entityField = typeMap.get(cellKey);
                    lastValue = TemplateUtils.dataFormatPreSave((Object)lastValue, (EntityField)entityField);
                    newValue = TemplateUtils.dataFormatPreSave((Object)newValue, (EntityField)entityField);
                    result = Objects.equals(lastValue, newValue);
                }
                catch (Exception e) {
                    LOGGER.error("isSame error:" + cellKey, (Throwable)e);
                }
            }
        }
        return result;
    }

    private boolean checkData(Map<String, Object> argsMap) {
        String cell = (String)argsMap.get("cellKey");
        Map<String, String> formulaKey = this.getAllFieldToSave();
        String[] array = null;
        if (null != cell) {
            array = cell.split("#");
        }
        if (null != array && array.length == 3) {
            String matedata = array[0];
            String key = array[2];
            EntityInfo entity = MetadataUtil.getEntityById((String)matedata);
            Optional<EntityField> object = entity.getFieldList().stream().filter(e -> key.equals(e.getFieldId())).findFirst();
            if (object.isPresent()) {
                EntityField entityField = object.get();
                String fieldType = entityField.getFieldType();
                if ("Text".equals(fieldType)) {
                    boolean result = true;
                    if (entityField.getMaxLength() > 0) {
                        String value;
                        result = this.checkLength(argsMap, entityField);
                        if ("tccit_qysds_ext_dyn3".equals(matedata) && "sprate".equals(key) && (value = (String)argsMap.get("value")) != null) {
                            if (!StringUtil.isNumeric((String)value)) {
                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u5360\u6bd4\u5fc5\u987b\u4e3a\u6570\u503c", (String)"TaxDeclarePlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                                return false;
                            }
                            if (value.compareTo("0.6") < 0 || value.compareTo("1.0") > 0 || value.split("\\.").length == 2 && value.split("\\.")[1].length() > 4) {
                                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u201c\u4e3b\u8425\u4e1a\u52a1\u6536\u5165\u5360\u6bd4\uff08%\uff09\u201d\u987b\u6ee1\u8db3\u6761\u4ef6\uff1a60.00%~100.00%\u3002", (String)"TaxDeclarePlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                                return false;
                            }
                        }
                    }
                    return result;
                }
                if ("Date".equals(fieldType)) {
                    return this.checkDateFormat(argsMap, entityField);
                }
            }
        }
        return true;
    }

    private boolean checkLength(Map<String, Object> argsMap, EntityField entityField) {
        String value = (String)argsMap.get("value");
        int maxLength = entityField.getMaxLength();
        int currentLength = value.length();
        if (currentLength > maxLength) {
            String msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u4e0d\u5f97\u8d85\u8fc7%2$s\u5b57\u7b26", (String)"TaxDeclarePlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), entityField.getFieldName(), maxLength);
            this.getView().showErrorNotification(msg);
            return false;
        }
        return true;
    }

    private boolean checkDateFormat(Map<String, Object> argsMap, EntityField entityField) {
        String value = (String)argsMap.get("value");
        if ("".equals(value)) {
            return true;
        }
        String barDfStr = entityField.getFormatStr();
        if (StringUtil.isBlank((CharSequence)barDfStr)) {
            barDfStr = "yyyy-MM-dd";
            Format format = entityField.getFormat();
            if (format != null) {
                barDfStr = ((SimpleDateFormat)format).toPattern();
            }
        }
        SimpleDateFormat barDf = new SimpleDateFormat(barDfStr);
        SimpleDateFormat chinessDf = new SimpleDateFormat(DateUtils.YYYYMMDD_CHINESE);
        try {
            if (value.contains("-")) {
                barDf.parse(value);
            } else {
                chinessDf.parse(value);
            }
            return true;
        }
        catch (ParseException e) {
            String msg = String.format(ResManager.loadKDString((String)"\u65e5\u671f[%1$s]\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f\u4e3a:yyyy-MM-dd", (String)"TaxDeclarePlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), value);
            this.getView().showErrorNotification(msg);
            return false;
        }
    }

    public void clientCallBack(ClientCallBackEvent e) {
        String name = e.getName();
        if (name != null && name.startsWith("changeDataFunc")) {
            String[] split = name.split("changeDataFunc");
            Map argsMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)("changeDataFunc" + split[1]), Map.class);
            if (argsMap == null) {
                this.getView().showErrorNotification("change data cache is null!");
                return;
            }
            String cellId = argsMap.get("cellKey").toString();
            String value = argsMap.get("value").toString();
            LOGGER.error("cellKey:" + cellId);
            this.changeDataBusiness(cellId, value);
        }
        if (StringUtil.equals((CharSequence)e.getName(), (CharSequence)"taskcloseback")) {
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.getPageCache().get("taskId"));
            if (taskInfo != null && taskInfo.isTaskEnd()) {
                if (taskInfo.isFailure()) {
                    this.getView().hideLoading(true);
                    throw new KDBizException(taskInfo.getFailureReason());
                }
                if (StringUtil.isNotBlank((CharSequence)taskInfo.getData())) {
                    Map data = (Map)SerializationUtils.fromJsonString((String)taskInfo.getData(), Map.class);
                    if (data == null || data.isEmpty()) {
                        this.getView().hideLoading(true);
                        throw new KDBizException("Data Error!");
                    }
                    String resultStatus = data.getOrDefault("resultStatus", "");
                    if ("false".equals(resultStatus)) {
                        String failureReason = (String)data.get("failureReason");
                        this.getView().hideLoading(true);
                        if (StringUtil.isBlank((CharSequence)failureReason)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"DeclarePayHelper_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        }
                        throw new KDBizException(failureReason);
                    }
                    this.loadDeclarePage(new HashMap<String, Object>(data));
                }
                this.getView().hideLoading(true);
            } else {
                this.getView().addClientCallBack("taskcloseback", Integer.valueOf(100));
            }
        }
    }

    private void close() {
        IFormView parentView = this.getView().getParentView();
        parentView.close();
        this.getView().sendFormAction(parentView);
        this.getView().close();
    }

    private void refresh() {
        IFormView parentView = this.getView().getParentView();
        IFormView grandparentView = parentView.getParentView();
        grandparentView.invokeOperation("refresh");
        this.getView().sendFormAction(grandparentView);
    }

    private void changeDataBusiness(String cellId, String value) {
        long l = System.currentTimeMillis();
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
        if (requestModel == null) {
            return;
        }
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
        TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        IFormView parentView = this.getView().getParentView();
        Map<String, String> currentMap = this.getCurrentMap();
        DeclareChangeDataCheckCustomVo declareChangeDataCheckCustomVo = new DeclareChangeDataCheckCustomVo(cellId, value, currentMap, requestModel, responseModel, typeMap, templateMap.getSheetCellMap(), templateMap.getSheetIdNames());
        CheckResult result = DeclareReportHelpService.checkDataCustomBeforeChange(declareChangeDataCheckCustomVo);
        if (!result.isSuccess()) {
            this.getView().showErrorNotification(result.getReason());
            LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo();
            loadDeclareDataVo.setControl(this.control);
            TaxDeclarePluginService.loadPage(loadDeclareDataVo);
            if (parentView != null) {
                parentView.setEnable(Boolean.TRUE, new String[]{"save"});
                this.getView().sendFormAction(parentView);
            }
            return;
        }
        long l1 = System.currentTimeMillis();
        LOGGER.info("logflag getCurrentMap cost:{}ms", (Object)(l1 - l));
        Map<String, String> changCellMap = this.changCellMap(cellId, value, requestModel, responseModel.getDynRowList());
        value = changCellMap.get(cellId);
        long l2 = System.currentTimeMillis();
        LOGGER.info("logflag changCellMap cost:{}ms", (Object)(l2 - l1));
        Map<String, String> showData = this.changeData(currentMap, responseModel, requestModel, value, changCellMap, null, cellId);
        long l3 = System.currentTimeMillis();
        LOGGER.info("logflag changeData cost:{}ms", (Object)(l3 - l2));
        this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportCalculateService != null) {
            showData = this.declareReportCalculateService.afterCalculate(showData);
        }
        declareChangeDataCheckCustomVo.setCurrentMap(showData);
        showData = DeclareReportHelpService.adjustDataCustomAfterChange(declareChangeDataCheckCustomVo);
        Map<String, Object> treeData = null;
        this.declareReportTreeService = DeclareReportTreeFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportTreeService != null) {
            treeData = this.declareReportTreeService.loadTreeByCurrentData(requestModel, responseModel, (String)this.getView().getFormShowParameter().getCustomParam("sheetname"), (String)this.getParentViewCustomParam("datatype"), showData);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"treeData", treeData);
        }
        long l4 = System.currentTimeMillis();
        LOGGER.info("logflag \u6570\u636e\u8ba1\u7b97\u540e\u81ea\u5b9a\u4e49\u5904\u7406 cost:{}ms", (Object)(l4 - l3));
        List<Map<String, String>> checkFormulaList = this.formulaService.checkFormulasNew(requestModel, showData, responseModel.getParamMap(), responseModel.getDynRowList());
        this.cacheRiskItem(checkFormulaList);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", showData);
        this.baseDataService.queryBaseData(showData, responseModel.getDynRowList(), requestModel);
        showData = this.changeDataService.changeToShow(showData, responseModel, typeMap, requestModel.getOperation());
        TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)RISK_RESULT_LIST, (Object)riskResultMap);
        String currentSheetId = this.pageCache.get("sheetid");
        HashMap<String, String> newTypeMap = new HashMap<String, String>(typeMap.size());
        HashMap<String, String> baseTypeMap = new HashMap<String, String>(50);
        TaxDeclarePluginService.parseTypeMap(typeMap, newTypeMap, baseTypeMap);
        Map<String, Map<String, String>> parseDataForShow = TaxDeclarePluginService.parseShowData(showData, newTypeMap);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)ARSEDATAFORSHOW, parseDataForShow);
        LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(showData, checkFormulaList, riskResultMap, requestModel, responseModel, templateMap, this.control, treeData, typeMap);
        loadDeclareDataVo.setParseDataForShow(parseDataForShow);
        loadDeclareDataVo.setCurrentSheetId(currentSheetId);
        TaxDeclarePluginService.loadPage(loadDeclareDataVo);
        if (parentView != null) {
            parentView.addClientCallBack("0", Integer.valueOf(0));
            parentView.getPageCache().put("showData", SerializationUtils.toJsonString(showData));
            parentView.getPageCache().put("dynRowList", SerializationUtils.toJsonString((Object)responseModel.getDynRowList()));
            parentView.setEnable(Boolean.TRUE, new String[]{"save"});
            this.getView().sendFormAction(parentView);
        }
        long l6 = System.currentTimeMillis();
        LOGGER.info("logflag changeDataBusiness cost:{}ms", (Object)(l6 - l));
    }

    public void closedCallBack(ClosedCallBackEvent event) {
        Object returnObj = event.getReturnData();
        if (returnObj != null && "bdtaxr_declare_remark".equals(event.getActionId())) {
            Map returnData = (Map)returnObj;
            HashMap<String, String> remarkMap = (HashMap<String, String>)TreeUtils.getCache((IPageCache)this.pageCache, (String)"remark_data", Map.class);
            if (remarkMap == null) {
                remarkMap = new HashMap<String, String>(16);
            }
            String cellId = (String)returnData.get("cellid");
            String remark = (String)returnData.get("remark");
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)cellId) && kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)remark)) {
                remarkMap.put(cellId, remark);
                TreeUtils.putCache((IPageCache)this.pageCache, (String)"remark_data", remarkMap);
            }
        } else if (event.getActionId().startsWith("showBaseData") && returnObj != null) {
            ListSelectedRowCollection returnList = (ListSelectedRowCollection)returnObj;
            if (returnList != null && !returnList.isEmpty()) {
                ListSelectedRow row = returnList.get(0);
                Map dataMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"baseDataCache", Map.class);
                String cellId = "";
                String beforeValue = "";
                for (Map.Entry entry : dataMap.entrySet()) {
                    cellId = entry.getKey().toString();
                    beforeValue = entry.getValue().toString();
                }
                String value = row.getPrimaryKeyValue().toString();
                String number = row.getNumber();
                if (!value.equals(beforeValue)) {
                    DeclareRequestModel requestModel = this.getRequestModel();
                    DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
                    Map<String, String> currentMap = this.getCurrentMap();
                    this.check_handler = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType());
                    List dynamicRowList = responseModel.getDynRowList();
                    Map<String, String> changCellMap = this.changCellMap(cellId, value, requestModel, responseModel.getDynRowList());
                    String sheetId = this.getPageCache().get("sheetid");
                    if (!this.duplicatCheck(cellId, value, number)) {
                        return;
                    }
                    Map<String, String> showData = this.changeData(currentMap, responseModel, requestModel, value, changCellMap, null, cellId);
                    List<Map<String, String>> checkFormulaList = this.formulaService.checkFormulasNew(requestModel, currentMap, responseModel.getParamMap(), responseModel.getDynRowList());
                    this.cacheRiskItem(checkFormulaList);
                    TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
                    this.baseDataService.queryBaseData(showData, dynamicRowList, requestModel);
                    Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, responseModel.getDynRowList());
                    showData = this.changeDataService.changeToShow(showData, responseModel, typeMap, requestModel.getOperation());
                    TctrcwarningVo riskResultMap = TaxDeclarePluginService.getRiskResult(requestModel);
                    TreeUtils.putCache((IPageCache)this.pageCache, (String)RISK_RESULT_LIST, (Object)riskResultMap);
                    TemplateVo template = null;
                    if ("CITQR2023".equals(requestModel.getTemplateNumber()) && cellId.matches("tccit_qysds_ext_dyn3#\\d+#item")) {
                        TreeUtils.removeCache((IPageCache)this.pageCache, (String)"htmlTemplate");
                        template = this.getTemplate(new GetTemplateVo(requestModel, responseModel, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>(), new ArrayList<String>()));
                    }
                    if (template == null) {
                        template = new TemplateVo();
                        template.setSheetCellMap((Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"sheetCellMap", Map.class));
                    }
                    String currentSheetId = this.pageCache.get("sheetid");
                    HashMap<String, String> newTypeMap = new HashMap<String, String>(typeMap.size());
                    HashMap<String, String> baseTypeMap = new HashMap<String, String>(50);
                    TaxDeclarePluginService.parseTypeMap(typeMap, newTypeMap, baseTypeMap);
                    Map<String, Map<String, String>> parseDataForShow = TaxDeclarePluginService.parseShowData(showData, newTypeMap);
                    TreeUtils.putCache((IPageCache)this.pageCache, (String)ARSEDATAFORSHOW, parseDataForShow);
                    LoadDeclareDataVo loadDeclareDataVo = new LoadDeclareDataVo(showData, checkFormulaList, riskResultMap, requestModel, responseModel, template, this.control, null, typeMap);
                    loadDeclareDataVo.setParseDataForShow(parseDataForShow);
                    loadDeclareDataVo.setCurrentSheetId(currentSheetId);
                    TaxDeclarePluginService.loadPage(loadDeclareDataVo);
                }
            }
        } else if (returnObj != null && "cell_click_popup".equals(event.getActionId())) {
            Map returnData = (Map)returnObj;
            String cellId = (String)returnData.get("cellid");
            String value = (String)returnData.get("adjustsumamout");
            this.changeDataBusiness(cellId, value);
        }
    }

    public BaseResult saveClick(IPageCache pageCache, DeclareRequestModel declareRequestModel) {
        Map updateMap = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"updata_cellid", Map.class);
        Map remarkMap = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"remark_data", Map.class);
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)pageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)pageCache, (String)"oldData", DeclareResponseModel.class);
        if (responseModel == null) {
            responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)pageCache, (String)"declareData", DeclareResponseModel.class);
        }
        Map treeData = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"treeData", Map.class);
        List checkResultList = (List)TreeUtils.getCache((IPageCache)pageCache, (String)CHECK_RESULT_LIST, List.class);
        TctrcwarningVo riskResultList = (TctrcwarningVo)TreeUtils.getCache((IPageCache)pageCache, (String)RISK_RESULT_LIST, TctrcwarningVo.class);
        Map currMap = responseModel.getData();
        Map newData = (Map)TreeUtils.getCache((IPageCache)pageCache, (String)"updata_cellid_save", Map.class);
        String ssbId = String.valueOf(requestModel.getId());
        BaseResult baseResult = TaxDeclareCheckFactory.createHandler((String)requestModel.getTemplateType()).beforeSaveCheck(updateMap, newData, responseModel);
        if (500 == baseResult.getCode()) {
            return baseResult;
        }
        Map<String, String> resultMap = this.savetaxDeclareService.saveTaxDeclare(ssbId, updateMap, currMap, remarkMap, requestModel, responseModel, newData == null ? currMap : newData);
        this.savetaxDeclareService.saveRiskItem(ssbId, checkResultList, riskResultList.getTctrcwarning(), 2);
        HashMap<String, Object> requestMap = new HashMap<String, Object>(1);
        if (requestModel.getExtendParams() != null) {
            requestMap.putAll(requestModel.getExtendParams());
        }
        requestMap.put("orgId", requestModel.getOrgId());
        requestMap.put("skssqq", requestModel.getSkssqq());
        requestMap.put("skssqz", requestModel.getSkssqz());
        requestMap.put("Id", requestModel.getId());
        requestMap.putAll(requestModel.getBusinessMap());
        requestMap.put("remarks", declareRequestModel.getBusinessValue("remarks"));
        HashMap<String, Object> resultMap1 = new HashMap<String, Object>(resultMap);
        this.declareReportSaveService = DeclareReportSaveFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportSaveService != null) {
            BaseResult saveResult = this.declareReportSaveService.saveTeeData(requestModel, treeData);
            BaseResult baseResult2 = this.declareReportSaveService.saveBusinessData(requestMap, resultMap1);
        }
        if (this.getView().getParentView() != null) {
            requestMap.put("pageId", this.getView().getParentView().getPageId());
        }
        DeclareBizExtendHelper.saveBusinessData(requestMap, resultMap1);
        try {
            this.saveAttachment(ssbId, requestModel.getTemplateType());
        }
        catch (Exception e) {
            LOGGER.error("save attachments error", (Throwable)e);
        }
        this.sendRiskCalRealTimeTask(requestModel, updateMap, resultMap);
        requestModel.setRefresh(Boolean.FALSE);
        DeclareResponseModel responseModelNew = DeclareServiceHelper.queryData((DeclareRequestModel)requestModel);
        responseModelNew.setBillNo(requestModel.getBillNo());
        TreeUtils.putCache((IPageCache)pageCache, (String)"declareData", (Object)responseModelNew);
        TreeUtils.putCache((IPageCache)pageCache, (String)"declareRequest", (Object)requestModel);
        TreeUtils.putCache((IPageCache)pageCache, (String)"updata_cellid_save", (Object)responseModelNew.getData());
        TreeUtils.removeCache((IPageCache)pageCache, (String)"updata_cellid");
        TreeUtils.removeCache((IPageCache)pageCache, (String)"oldData");
        if (this.pageCache != null) {
            TreeUtils.removeCache((IPageCache)this.pageCache, (String)"oldData");
        }
        return BaseResult.ok((Object)responseModelNew);
    }

    private DeclareRequestModel getRequestModel() {
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareRequest", DeclareRequestModel.class);
        if (requestModel == null) {
            Map customParams = this.getView().getFormShowParameter().getCustomParams();
            LOGGER.info("TaxDeclarePlugin customParams=" + JsonUtil.toJson((Object)customParams));
            requestModel = this.declareRequestService.build((String)customParams.get("declareRequestData"));
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareRequest", (Object)requestModel);
        }
        return requestModel;
    }

    private DeclareResponseModel queryData(DeclareRequestModel requestModel, Map<String, EntityField> metaTypeMap) {
        if (requestModel.getRefresh() == null) {
            requestModel.setRefresh(Boolean.FALSE);
        }
        DeclareResponseModel responseModel = new DeclareResponseModel();
        if (requestModel.getRefresh().booleanValue()) {
            responseModel = this.refreshData(requestModel, metaTypeMap);
        }
        if (!requestModel.getRefresh().booleanValue()) {
            responseModel = this.queryDBData(requestModel, this.getView().getFormShowParameter().getCustomParams());
            metaTypeMap = TaxDeclarePluginService.expanFieldsTypeByDynRow(metaTypeMap, responseModel.getDynRowList());
        }
        return responseModel;
    }

    private DeclareResponseModel queryDBData(DeclareRequestModel requestModel, Map<String, Object> customParams) {
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
        responseModel = "history".equals(requestModel.getDataSource()) ? this.taxDeclareDataService.queryHistoryData(requestModel, customParams) : ("taxBureau".equals(requestModel.getDataSource()) ? this.taxDeclareDataService.queryTaxBureauData(requestModel, customParams) : (null != responseModel ? responseModel : this.taxDeclareDataService.queryData(requestModel)));
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
        return responseModel;
    }

    private DeclareResponseModel refreshData(DeclareRequestModel requestModel, Map<String, EntityField> metaTypeMap) {
        NsrxxValidatorUtils.nsrxxReviewed((Long)requestModel.getOrgId());
        this.allRequiredFieldValidator(requestModel.getOrgId().toString());
        DeclareResponseModel responseModel = this.taxDeclareDataService.refreshData(requestModel, metaTypeMap);
        this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportCalculateService != null) {
            responseModel = this.declareReportCalculateService.afterCalculate(requestModel, responseModel, responseModel.getDynRowList(), metaTypeMap);
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"declareData", (Object)responseModel);
        return responseModel;
    }

    private void allRequiredFieldValidator(String orgId) {
        DynamicObject taxMain;
        if (kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)orgId) && (taxMain = (DynamicObject)TaxcMainDataServiceHelper.queryTaxcMainByOrgId((Long)Long.parseLong(orgId)).getData()) != null) {
            DynamicObject taxorg = taxMain.getDynamicObject("taxorg");
            String orgname = taxorg.getString("org.name");
            String taxoffice = taxMain.getString("taxoffice.id");
            String registertype = taxMain.getString("registertype.id");
            String registertime = taxMain.getString("registertime");
            String registeraddress = taxMain.getString("registeraddress");
            String codeandname = taxMain.getString("codeandname.id");
            String actualaddress = taxMain.getString("actualaddress");
            String admindivisionObject = taxMain.getString("accountingstandards.id");
            if (kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)registeraddress) || "0".equalsIgnoreCase(admindivisionObject) || "0".equalsIgnoreCase(taxoffice) || "0".equalsIgnoreCase(registertype) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)registertime) || "0".equalsIgnoreCase(codeandname) || kd.bos.dataentity.utils.StringUtils.isEmpty((CharSequence)actualaddress)) {
                ErrorCode errorCode = new ErrorCode("allRequiredField", String.format(ResManager.loadKDString((String)"\u3010%1$s\u3011\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u7ef4\u62a4\u4e0d\u5b8c\u6574\uff0c\u8bf7\u5148\u5b8c\u5584\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"TaxDeclarePlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), orgname));
                throw new KDBizException(errorCode, new Object[0]);
            }
        }
    }

    private Map<String, String> changCellMap(String cellId, String value, DeclareRequestModel requestModel, List<DynamicRowModel> dynRowList) {
        HashMap<String, String> dataMap = (HashMap<String, String>)TreeUtils.getCache((IPageCache)this.pageCache, (String)"updata_cellid", Map.class);
        Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, dynRowList);
        value = this.changeDataService.parasValue(cellId, value, dynRowList, typeMap);
        if (dataMap == null) {
            dataMap = new HashMap<String, String>(1);
        }
        dataMap.put(cellId, value);
        Map<String, String> bizChangedata = BizChangeDataHandler.handle(this.getRequestModel().getTemplateType(), dataMap);
        dataMap.putAll(bizChangedata);
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid", dataMap);
        return dataMap;
    }

    private Map<String, String> changeData(Map<String, String> currentMap, DeclareResponseModel responseModel, DeclareRequestModel requestModel, String value, Map<String, String> changCellMap, List<Map<String, Object>> listKeyValue, String ... cellId) {
        if (cellId.length == 1 && "qysdsjb".equals(requestModel.getTemplateType())) {
            for (String id : cellId) {
                if (!id.startsWith("tccit_qysds_ext_dyn#") || !id.endsWith("#item")) continue;
                responseModel.getData().put(id + "amount", "0");
                currentMap.put(id + "amount", "0");
                String cellIdAmount = id + "amount";
                String valueAmount = "0";
                currentMap = this.changeDataService.changeData(responseModel, requestModel, valueAmount, changCellMap, currentMap, listKeyValue, cellIdAmount);
            }
        }
        currentMap = this.changeDataService.changeData(responseModel, requestModel, value, changCellMap, currentMap, listKeyValue, cellId);
        this.declareReportCalculateService = DeclareReportCalculateFactory.createHandler(requestModel.getTemplateType());
        if (this.declareReportCalculateService != null) {
            currentMap = this.declareReportCalculateService.customAdjustAndCascade(requestModel, responseModel, currentMap);
        }
        TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", currentMap);
        return currentMap;
    }

    private Map<String, String> getCurrentMap() {
        Map currentMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"updata_cellid_save", Map.class);
        if (null == currentMap) {
            DeclareRequestModel requestModel = this.getRequestModel();
            DeclareResponseModel responseModel = this.queryDBData(requestModel, this.getView().getFormShowParameter().getCustomParams());
            currentMap = responseModel.getData();
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"updata_cellid_save", (Object)currentMap);
        }
        return currentMap;
    }

    private void hyperLinkClick(Map<String, Object> argsMap, DeclareRequestModel requestModel) {
        String operation = requestModel.getOperation();
        String hrefpara = argsMap.get("hrefData").toString();
        String cellid = argsMap.get("cellKey").toString();
        IFormView parentView = this.getView().getParentView();
        if (hrefpara.startsWith("[")) {
            hrefpara = hrefpara.substring(1, hrefpara.length() - 1);
        }
        if (hrefpara.endsWith("]")) {
            hrefpara = hrefpara.substring(0, hrefpara.length() - 2);
        }
        JSONObject jsonObject = (JSONObject)JSONObject.parseObject((String)hrefpara).get((Object)"text");
        String pluginName = jsonObject.getString("plugin");
        String method = jsonObject.getString("method");
        JSONObject param = jsonObject.getJSONObject("param");
        param.put("operation", (Object)operation);
        param = this.replaceCellValue(param, cellid);
        try {
            Class<?> aClass = Class.forName(pluginName);
            if (aClass == null) {
                throw new RuntimeException(String.format(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u63d2\u4ef6%s", (String)"TaxDeclarePlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]), pluginName));
            }
            Method hyperLinkClick = aClass.getMethod(method, String.class, JSONObject.class, IFormView.class, IFormPlugin.class);
            hyperLinkClick.invoke(aClass.newInstance(), new Object[]{cellid, param, this.getView(), this});
            this.getView().sendFormAction(parentView);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public JSONObject replaceCellValue(JSONObject param, String cellid) {
        Map<String, String> resultCache = this.getCurrentMap();
        param.put("cellvalue", (Object)resultCache.get(cellid));
        for (Map.Entry entry : param.entrySet()) {
            if (resultCache.get(entry.getValue()) == null) continue;
            entry.setValue(resultCache.get(entry.getValue()));
        }
        return param;
    }

    private void showAddRemark(String cellId) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_remark");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)cellId);
        Map remarkMap = (Map)TreeUtils.getCache((IPageCache)this.pageCache, (String)"remark_data", Map.class);
        showParameter.setCustomParam("remarkValue", remarkMap == null ? null : remarkMap.get(cellId));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_remark");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showDetail(DeclareRequestModel requestModel, Map<String, Object> argsMap) {
        Map map = (Map)argsMap.get("formulaVo");
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bdtaxr_declare_detail");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("cellid", (Object)argsMap.get("cellKey").toString());
        showParameter.setCustomParam("sbbid", (Object)String.valueOf(requestModel.getId()));
        showParameter.setCustomParam("formulaVo", (Object)map);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "bdtaxr_declare_detail");
        showParameter.setCloseCallBack(closeCallBack);
        this.getView().showForm(showParameter);
    }

    private void showBaseData(String cellId, String entityId, String minCompany, String formulaName) {
        DynamicObjectCollection preDatas;
        List collect;
        String preSbb;
        Date skssqq = (Date)Optional.ofNullable(this.getView().getParentView()).filter(s -> s.getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"skssqq")).map(s -> s.getModel().getValue("skssqq")).orElseGet(() -> null);
        Date skssqz = (Date)Optional.ofNullable(this.getView().getParentView()).filter(s -> s.getModel().getDataEntity().getDataEntityType().getProperties().containsKey((Object)"skssqz")).map(s -> s.getModel().getValue("skssqz")).orElseGet(() -> null);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "showBaseData");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        customParams.put("skssqq", skssqq);
        customParams.put("skssqz", skssqz);
        ListShowParameter formShowParameter = TaxDeclarePluginService.setBaseData(cellId, entityId, minCompany, customParams, closeCallBack, formulaName);
        String[] split = cellId.split("#");
        if (("tcvat_ybnsr_jsxm".equals(split[0]) || "tcvat_ybnsr_msxm".equals(split[0])) && "swsxdm".equals(split[2]) && kd.bos.dataentity.utils.StringUtils.isNotBlank((CharSequence)(preSbb = ((JSONObject)SerializationUtils.fromJsonString((String)this.getPageCache().get("declareData"), JSONObject.class)).getJSONObject("paramMap").getString("sbbid"))) && !(collect = (preDatas = QueryServiceHelper.query((String)split[0], (String)split[2], (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)preSbb)})).stream().map(o -> o.getLong(split[2])).filter(o -> o > 0L).collect(Collectors.toList())).isEmpty()) {
            formShowParameter.setCustomParam("fastIds", collect);
        }
        if ("tpo_ictm_bizdef_entry".equals(entityId) && cellId != null && cellId.endsWith("#gjbasedata")) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u56fd\u5bb6\u5730\u533a", (String)"TaxDeclarePlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if ("tpo_tccit_bizdef_entry".equals(entityId) && cellId != null && cellId.endsWith("#fzjgxsqyyhbasedata")) {
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u5206\u652f\u673a\u6784\u4eab\u53d7\u533a\u57df\u6027\u4f18\u60e0\u60c5\u51b5", (String)"TaxDeclarePlugin_29", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        if ("tpo_tccit_bizdef_entry".equals(entityId) && cellId != null && cellId.matches("tccit_qysds_a06779#\\d+#techtype")) {
            List qFilters = formShowParameter.getListFilterParameter().getQFilters();
            qFilters.add(new QFilter("parentnumber", "=", (Object)"JSCGLX"));
            qFilters.add(new QFilter("number", "!=", (Object)"0"));
            formShowParameter.setCaption(ResManager.loadKDString((String)"\u6280\u672f\u6210\u679c\u7c7b\u578b", (String)"TaxDeclarePlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private TemplateVo getTemplate(GetTemplateVo getTemplateVo) {
        TemplateVo templateMap = (TemplateVo)TreeUtils.getCache((IPageCache)this.pageCache, (String)"htmlTemplate", TemplateVo.class);
        if (templateMap == null) {
            templateMap = this.declareTemplateService.getTemplate(getTemplateVo);
            TreeUtils.putCache((IPageCache)this.pageCache, (String)"htmlTemplate", (Object)templateMap);
        }
        return templateMap;
    }

    private void remindChange(Map<String, String> argsMap) {
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"orgModifyParams", argsMap);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("orgModifyConform", (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"TaxDeclarePlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"TaxDeclarePlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        this.getView().showConfirm(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u5f53\u524d\u884c\u6b21\u5df2\u5b58\u5728\u6570\u636e\uff0c\u91cd\u65b0\u9009\u62e9\u4f18\u60e0\u9879\u76ee\u5c06\u4f1a\u8986\u76d6\u5f53\u524d\u5df2\u6709\u4f18\u60e0\u9879\u76ee\u53ca\u91d1\u989d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u9700\u8981\u7f16\u8f91\uff1f", (String)"TaxDeclarePlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]), "", MessageBoxOptions.OKCancel, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equals((String)"orgModifyConform", (String)callBackId)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                Map baseParamMap = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"orgModifyParams", Map.class);
                this.showBaseData((String)baseParamMap.get("cellId"), (String)baseParamMap.get("entityId"), (String)baseParamMap.get("minCompany"), null);
            } else if (MessageBoxResult.Cancel.equals((Object)messageBoxClosedEvent.getResult())) {
                return;
            }
        }
    }

    private Map<String, String> getAllFieldToSave() {
        String templateType = this.pageCache.get("templatetype");
        Map saveFieldMap = (Map)TreeUtils.getCache((IPageCache)this.getCache(), (String)("AllFieldToSave" + templateType), Map.class);
        if (saveFieldMap == null) {
            DeclareResponseModel model = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.pageCache, (String)"declareData", DeclareResponseModel.class);
            Map map = model.getMetaDataMap();
            saveFieldMap = TemplateUtils.getAllFieldToSave(EmptyCheckUtils.isNotEmpty((Object)map) ? map : Collections.emptyMap());
            TreeUtils.putCache((IPageCache)this.getCache(), (String)("AllFieldToSave" + templateType), (Object)saveFieldMap);
        }
        return saveFieldMap;
    }

    private IPageCache getCache() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String ParentCache = (String)customParams.get("ParentCache");
        if (Boolean.TRUE.toString().equals(ParentCache)) {
            String parentpageId = (String)customParams.get("rootPageId");
            IFormView parentView = this.getView().getParentView();
            if (kd.bos.dataentity.utils.StringUtils.isNotEmpty((CharSequence)parentpageId)) {
                parentView = this.getView().getView(parentpageId);
            }
            return parentView == null ? new PageCache(parentpageId) : (IPageCache)parentView.getService(IPageCache.class);
        }
        return this.pageCache;
    }

    private boolean duplicatCheck(String cellId, String value, String number) {
        DeclareResponseModel declareMode = (DeclareResponseModel)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"declareData", DeclareResponseModel.class);
        Map data = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"updata_cellid_save", Map.class);
        List dyData = declareMode.getDynRowList();
        if (null != data && !this.duplicatCheckMap(data, value)) {
            return false;
        }
        return this.check_handler.dynCheck(data, cellId, number);
    }

    private boolean duplicatCheckMap(Map<String, String> map, String value) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!entry.getKey().startsWith("tccit_qysds_ext_dyn") && !entry.getKey().startsWith("tccit_nontax_summary_m") && !entry.getKey().startsWith("tccit_qysds_a201020_dyn1") && !entry.getKey().startsWith("tccit_qysds_a201020_dyn2") || !entry.getKey().endsWith("item")) continue;
            if (entry.getValue().equals(value)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u76f8\u540c\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"TaxDeclarePlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return false;
            }
            if (!this.isConflict(entry.getValue(), value)) continue;
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u52a0\u8ba1\u6263\u9664\u4f18\u60e0\u9879\u76ee\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"TaxDeclarePlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean isConflict(String ... items) {
        ArrayList conflicts = Lists.newArrayList((Object[])new String[]{"1315279067611882499", "1315279067611882500", "1315279067611882497", "1315279067611882498"});
        return items.length > 1 && conflicts.containsAll(Stream.of(items).collect(Collectors.toList()));
    }

    private void jumpToTctrcRisk(String tctrcResultId) {
        FormShowParameter param = TaxDeclarePluginService.jumpToTctrcRiskParam(tctrcResultId);
        if (param == null) {
            return;
        }
        this.getView().showForm(param);
    }

    public String getAttachmentFieldName() {
        return ATTACHMENTPANELAP;
    }

    public String getAttachmentPanelName() {
        return "attachmentflex";
    }
}

