/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare;

import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClientCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceHandler;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.mutex.MutexServiceImpl;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportedit.UnifiedDeclareReportEditFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.unifieddeclarereportedit.service.UnifiedDeclareReportEditService;
import kd.taxc.bdtaxr.common.constant.TaxAppEnum;
import kd.taxc.bdtaxr.common.constant.TaxConstant;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.dto.DeclareTable;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.MutexMappingEnum;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.refactor.formula.utils.JsonUtils;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.draft.StatusUtils;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgCheckUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.multideclarelist.MultiDeclareUtils;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.DynamicObjectUtils;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.bdtaxr.formplugin.taxdeclare.helper.UnifiedDeclareReportEditAdapter;
import org.apache.commons.lang3.ObjectUtils;

public class UnifiedDeclareReportEditPlugin
extends AbstractFormPlugin {
    private static Log logger = LogFactory.getLog(UnifiedDeclareReportEditPlugin.class);
    private static final String COMMA = ResManager.loadKDString((String)"\uff0c", (String)"AbstractDeclareReportPluginNew_39", (String)"taxc-bdtaxr", (Object[])new Object[0]);
    private static final String ORGID_KEY = "orgid";
    private static final String CONTENT_TAB = "tabcontent";
    private static final String SBBID = "cache_sbbid";
    private static final String BILLNO = "billno";
    private static final String EDIT_KEY = "edit";
    private static final String SAVE_KEY = "save";
    private static final String CANCEL_KEY = "cancel";
    private static final String SUBMIT_KEY = "submit";
    private static final String UNSUBMIT_KEY = "unsubmit";
    private static final String RECALC_KEY = "recalc";
    private static final String VIEW_DRAFT_KEY = "viewdraft";
    private static final String AUDIT_KEY = "audit";
    private static final String UNAUDIT_KEY = "unaudit";
    private static final String REGETDATA_KEY = "regetdata";
    private static final String CLOSE_KEY = "close";
    private static final String ONE_KEY_GENERATE = "onekeygenerate";
    private static final String CREATESBB = "createsbb";
    private static final String ORG = "org";
    private static final String BILL_STATUS = "cache_billstatus";
    private static final String CALLBACKID_MOD = "modifyOrDelete";
    private static final String CALLBACKID_MODIFY = "callback_modify";
    private static final String EDIT = "edit";
    private static final String VIEW = "read";
    private static final String TOOL_BAR_DECLARE = "toolbarapdeclare";
    private DeclareReportService declareReportService;

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        String BAR_KEY = "toolbarap";
        this.addItemClickListeners(new String[]{BAR_KEY, TOOL_BAR_DECLARE});
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"edit", SUBMIT_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE, AUDIT_KEY, RECALC_KEY, REGETDATA_KEY});
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.get("checkisopenbyworkflow") != null && this.getModel().getProperty("checkisopenbyworkflow") != null) {
            this.getModel().setValue("checkisopenbyworkflow", (Object)true);
        }
        this.beforeInit();
        if (customParams.get(ORGID_KEY) != null && customParams.get("skssqq") != null && customParams.get("skssqz") != null) {
            if (customParams.get(CREATESBB) != null) {
                this.loadFromOtherPage(customParams);
            } else {
                this.beforeLoadFromHyperLinkClick(customParams);
                this.loadFromHyperLinkClick(customParams);
            }
        } else {
            this.loadFromDeclareMenu();
        }
    }

    protected void beforeLoadFromHyperLinkClick(Map<String, Object> customParams) {
        this.getUnifiedDeclareReportEditService().beforeLoadFromHyperLinkClick(customParams);
    }

    private void loadFromDeclareMenu() {
        Map customParams;
        String paramOrg = (String)(customParams = this.getView().getFormShowParameter().getCustomParams()).get(ORGID_KEY);
        long org = StringUtil.isNotBlank((CharSequence)paramOrg) ? Long.parseLong(paramOrg) : RequestContext.get().getOrgId();
        Long orgid = this.setDefaultOrg(customParams, org);
        if (this.checkNcpOrgConfig(orgid)) {
            return;
        }
        if (orgid == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6ca1\u6709\u53ef\u7528\u7684\u7a0e\u52a1\u7ec4\u7ec7\uff0c\u8bf7\u524d\u5f80\u57fa\u7840\u8d44\u6599\u8fdb\u884c\u914d\u7f6e\u6216\u8054\u7cfb\u7ba1\u7406\u5458\uff01", (String)"UnifiedDeclareReportEditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        this.initPeriod(String.valueOf(orgid), customParams);
        this.beforeOpenInnerPage(String.valueOf(orgid));
        this.init();
    }

    protected boolean checkNcpOrgConfig(Long orgid) {
        return this.getUnifiedDeclareReportEditService().checkNcpOrgConfig(orgid);
    }

    public Long setDefaultOrg(Map<String, Object> customParams, long org) {
        long currUserId = RequestContext.get().getCurrUserId();
        return this.isDefaultOrg() ? OrgCheckUtil.setDefaultOrg((Long)org, (Long)currUserId, (IFormView)this.getView()) : this.getCustomOrg(customParams);
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        return this.getUnifiedDeclareReportEditService().checkArgsBeforeOpenInnerPage();
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        return this.getUnifiedDeclareReportEditService().getCustomOrg(customParams);
    }

    protected boolean isDefaultOrg() {
        return this.getUnifiedDeclareReportEditService().isDefaultOrg();
    }

    private void loadFromHyperLinkClick(Map<String, Object> customParams) {
        String orgid = ObjectUtils.isNotEmpty((Object)customParams.get(ORGID_KEY)) ? customParams.get(ORGID_KEY).toString() : "0";
        String sbbId = (String)(Objects.nonNull(customParams.get("entryid")) ? customParams.get("entryid") : customParams.get("sbbid"));
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        TaxAppEnum licenseTaxEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        String categoryType = Optional.ofNullable(licenseTaxEnum).isPresent() ? licenseTaxEnum.getCategoryCode() : null;
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)categoryType);
        if (!checkResult) {
            this.getModel().setValue(ORG, (Object)orgid);
            String skssqqstr = (String)customParams.get("skssqq");
            Date skssqq = DateUtils.stringToDate((String)skssqqstr);
            DynamicObjectUtils.setValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq", (Object)skssqq);
            String skssqzstr = (String)customParams.get("skssqz");
            Date skssqz = DateUtils.stringToDate((String)skssqzstr);
            DynamicObjectUtils.setValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz", (Object)skssqz);
            this.paraCustomParams(customParams);
            this.doInLoadFromHyperLinkClick(sbbId);
            this.openDeclarePage(orgid, skssqqstr, skssqzstr, "true".equals(String.valueOf(customParams.get("refresh"))), "query");
            this.init();
        }
    }

    protected void doInLoadFromHyperLinkClick(String sbbid) {
        this.getUnifiedDeclareReportEditService().doInLoadFromHyperLinkClick(sbbid);
    }

    private void beforeOpenInnerPage(String orgid) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        TaxAppEnum taxAppEnum = TaxAppEnum.getEnumInstanceByAppid((String)appid);
        if (taxAppEnum == null) {
            this.getView().showErrorNotification("no such configration in TaxAppEnum!");
            return;
        }
        boolean checkResult = OrgCheckUtil.check((IFormView)this.getView(), (String)orgid, (String)appid, (String)taxAppEnum.getCategoryCode());
        if (!checkResult) {
            this.getModel().setValue(ORG, (Object)orgid);
            if (this.checkArgsBeforeOpenInnerPage()) {
                String skssqq = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq");
                String skssqz = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz");
                this.openDeclarePage(orgid, skssqq, skssqz, false, "query");
            }
        }
    }

    public void loadData(Long orgId, Date startDate, Date endDate, Boolean needMsg, boolean refresh) {
        Boolean flag = this.isValidDates(startDate, endDate, needMsg);
        if (flag.booleanValue()) {
            String orgIdStr = String.valueOf(orgId);
            String skssqq = DateUtils.format((Date)startDate);
            String skssqz = DateUtils.format((Date)endDate);
            this.openDeclarePage(orgIdStr, skssqq, skssqz, refresh, "load");
        }
    }

    public Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        Boolean result = this.getUnifiedDeclareReportEditService().isValidDates(startDate, endDate, needMsg);
        if (result == null) {
            String[] taxLimits;
            boolean isvalid = Boolean.FALSE;
            for (String taxLimit : taxLimits = this.getTaxLimits()) {
                boolean temp = DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate);
                isvalid |= temp;
            }
            if (!isvalid) {
                if (needMsg.booleanValue()) {
                    String errMsg = this.buildErrorMsg(taxLimits);
                    this.getView().showTipNotification(errMsg);
                }
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return result;
    }

    private String buildErrorMsg(String[] taxLimits) {
        String msgTmp = ResManager.loadKDString((String)"\u6240\u5c5e\u7a0e\u671f\u5fc5\u987b\u4e3a%s\u3002", (String)"UnifiedDeclareReportEditPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        ArrayList nameList = new ArrayList(4);
        for (String taxLimit : taxLimits) {
            nameList.add(TaxConstant.getTaxLimitNameMap().get(taxLimit));
        }
        return String.format(msgTmp, String.join((CharSequence)"\u3001", nameList));
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key = evt.getItemKey();
        String sbbid = this.getPageCache().get(SBBID);
        if ("edit".equals(key)) {
            boolean success = this.requestMutexLock(sbbid);
            if (!success) {
                evt.setCancel(true);
            }
        } else if (Sets.newHashSet((Object[])new String[]{ONE_KEY_GENERATE, SUBMIT_KEY, UNSUBMIT_KEY, AUDIT_KEY, UNAUDIT_KEY}).contains(key)) {
            DynamicObject dynamicObject = MutexServiceImpl.getMutexData(new QFilter("objectid", "=", (Object)sbbid));
            if (dynamicObject != null && !dynamicObject.get("user.id").equals(RequestContext.get().getCurrUserId())) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"UnifiedDeclareReportEditPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), dynamicObject.get("user.name")));
                evt.setCancel(true);
            }
        } else if (SAVE_KEY.equals(key) || CANCEL_KEY.equals(key)) {
            MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
        }
    }

    private boolean requestMutexLock(String sbbid) {
        if (StringUtil.isBlank((CharSequence)sbbid) || "0".equals(sbbid)) {
            return true;
        }
        String entityname = this.getModel().getDataEntityType().getName();
        String entity = MutexMappingEnum.getEntity((String)entityname);
        if (StringUtils.isNotBlank((CharSequence)entity)) {
            try {
                DynamicObject dynamicObject;
                HashMap<String, String> customparam = new HashMap<String, String>();
                MutexServiceImpl mutexService = new MutexServiceImpl();
                customparam.put("dataObjId", sbbid);
                customparam.put("entityKey", entity);
                customparam.put("operationKey", "edit");
                customparam.put("groupId", "declare_edit");
                mutexService.setMutexLockInfo(customparam);
                boolean isSuccessLock = mutexService.setMutexLock();
                logger.info("DynamicEntity:{},Entity:{} lock : {}", new Object[]{entityname, entity, isSuccessLock});
                if (!isSuccessLock && (dynamicObject = MutexServiceImpl.getMutexData(new QFilter("objectid", "=", (Object)sbbid))) != null) {
                    String user = dynamicObject.getString("user.name");
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6b63\u5728\u7f16\u8f91\u8be5\u8bb0\u5f55\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u6216\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u3002", (String)"UnifiedDeclareReportEditPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), user));
                    return false;
                }
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        return true;
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "cancel": {
                this.cancel(key);
                break;
            }
        }
    }

    private boolean isDataChanged() {
        IPageCache childPageCache;
        IFormView childPage = this.getView().getView(this.getPageCache().get("declarepageid"));
        if (childPage != null && (childPageCache = childPage.getPageCache()) != null) {
            Map updateMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
            return updateMap != null && updateMap.size() > 0;
        }
        return false;
    }

    private void cancel(String customEvent) {
        if (this.isDataChanged()) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CANCEL_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"UnifiedDeclareReportEditPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"UnifiedDeclareReportEditPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"UnifiedDeclareReportEditPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        } else {
            String orgId = DynamicObjectUtils.getDynamicObjectStringValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
            String startDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq");
            String endDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz");
            DynamicObject dyo = this.getDeclareMain(orgId, startDate, endDate);
            TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
            TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
            TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
            if (dyo == null) {
                this.closeView();
            } else {
                this.enableSubmitBtn();
                this.operationSbb(VIEW, Boolean.FALSE, customEvent);
            }
        }
    }

    protected void closeView() {
        this.getPageCache().put("code_close", "true");
        this.getView().close();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key;
        if (this.getModel().getValue(ORG) == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"UnifiedDeclareReportEditPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        super.afterDoOperation(afterDoOperationEventArgs);
        switch (key = afterDoOperationEventArgs.getOperateKey()) {
            case "edit": {
                boolean isOpen = this.beforeClickCheckStatus(key);
                if (!isOpen) break;
                this.edit(key);
                break;
            }
            case "submit": 
            case "unsubmit": 
            case "audit": 
            case "unaudit": {
                this.submit(key);
                break;
            }
            case "recalc": {
                if (!this.beforeClickCheckStatus(key)) break;
                this.recalc();
                break;
            }
            case "print": {
                this.print();
                break;
            }
            case "save": {
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09", (String)"UnifiedDeclareReportEditPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                this.save();
                break;
            }
            case "regetdata": {
                if (!this.beforeClickCheckStatus(key)) break;
                this.reGetDataConform();
                break;
            }
        }
    }

    protected void print() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        FormShowParameter showParameter = new FormShowParameter();
        params.put("templateId", this.getPageCache().get("templateId"));
        params.put("templateType", this.getTemplateType());
        params.put("modelid", this.getModelId());
        params.put("sbbid", this.getPageCache().get(SBBID));
        showParameter.setFormId("bdtaxr_declare_print");
        showParameter.setParentPageId(this.getView().getPageId());
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
        String billno = this.getPageCache().get(BILLNO);
        Long orgid = DynamicObjectUtils.getDynamicObjectValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
        String operate = OperateCodeEnum.getByCode((String)"print");
        String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s%2$s\u6210\u529f", (String)"UnifiedDeclareReportEditPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno, operate);
        OperatorDialogUtils.operateDialog((String)this.getTemplateType(), (String)this.getView().getFormShowParameter().getFormId(), (String)operate, (String)operateDescription, (Long)orgid);
    }

    protected boolean beforeClickCheckStatus(String operateKey) {
        String endDate;
        String startDate;
        Date endDate2;
        Date startDate2;
        Boolean flag;
        if (this.getModel().getDataEntity().containsProperty("skssqq") && this.getModel().getDataEntity().containsProperty("skssqz") && !(flag = this.isValidDates(startDate2 = (Date)this.getModel().getValue("skssqq"), endDate2 = (Date)this.getModel().getValue("skssqz"), Boolean.TRUE)).booleanValue()) {
            String sbbid;
            if ("edit".equals(operateKey) && StringUtils.isNotBlank((CharSequence)(sbbid = this.getPageCache().get(SBBID)))) {
                MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
            }
            return false;
        }
        String orgId = DynamicObjectUtils.getDynamicObjectStringValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
        DynamicObject declare = this.getDeclareMain(orgId, startDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq"), endDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz"));
        if (declare != null) {
            String billstatus = declare.getString("billstatus");
            if (!"A".equalsIgnoreCase(billstatus)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u6570\u636e\u624d\u5141\u8bb8\u7f16\u8f91", (String)"UnifiedDeclareReportEditPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return false;
            }
        } else if ("edit".equals(operateKey)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"UnifiedDeclareReportEditPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return false;
        }
        return this.getUnifiedDeclareReportEditService().beforeClickCheckStatus(operateKey);
    }

    public void operationSbb(String operationType, boolean isRefresh, String customEvent) {
        String oldPageId = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(oldPageId);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        String sheetId = childPageCache.get("sheetid");
        String sheetname = childPageCache.get("sheetname");
        Map customParams = childView.getFormShowParameter().getCustomParams();
        FormShowParameter param = new FormShowParameter();
        customParams.put("operation", operationType);
        customParams.put("sheetid", sheetId);
        customParams.put("refresh", "false");
        if (StringUtils.isNotBlank((CharSequence)sheetname)) {
            customParams.put("sheetname", sheetname);
        }
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"declareRequest", DeclareRequestModel.class);
        requestModel.setCustomEvent(customEvent);
        requestModel.setOperation(operationType);
        requestModel.setRefresh(Boolean.valueOf(isRefresh));
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        param.setFormId(this.getDeclareFormId());
        if ("edit".equals(customEvent)) {
            RuleFetchMainDto fetchMainDto = new RuleFetchMainDto(requestModel.getOrgId(), kd.taxc.bdtaxr.common.utils.date.DateUtils.stringToDate((String)requestModel.getSkssqq()), kd.taxc.bdtaxr.common.utils.date.DateUtils.stringToDate((String)requestModel.getSkssqz()), requestModel.getTemplateId(), (String)requestModel.getBusinessMap().get("draftpurpose"), "0");
            String taxsystem = requestModel.getBusinessValue("taxsystem");
            String taxareagroup = requestModel.getBusinessValue("taxareagroup");
            RuleFetchServiceHandler.setInfo(fetchMainDto, taxsystem, taxareagroup);
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.delRuleFetchData(fetchMainDto);
        }
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        customParams.put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        if ("edit".equals(operationType)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, RECALC_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE, REGETDATA_KEY});
            if (StringUtils.equals((CharSequence)"2", (CharSequence)this.getPageCache().get("datatype"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
            }
            this.setExtendControllsStatus(operationType);
            String templateType = (String)customParams.get("templatetype");
            String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u6b63\u5728\u7f16\u8f91\u4e2d", (String)"UnifiedDeclareReportEditPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
            DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.getModelId());
            if (declareTable != null && declareTable.isDraftModel()) {
                operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e95\u7a3f\u6b63\u5728\u7f16\u8f91\u4e2d", (String)"UnifiedDeclareReportEditPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
            }
            OperatorDialogUtils.operateDialog((String)templateType, (String)this.getEntity(templateType), (String)ResManager.loadKDString((String)"\u7f16\u8f91", (String)"UnifiedDeclareReportEditPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)operateDescription);
        } else {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, ONE_KEY_GENERATE, REGETDATA_KEY});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
            this.setExtendControllsStatus(operationType);
        }
    }

    protected void setExtendControllsStatus(String operationType) {
        this.getModel().setValue("operationStatus", (Object)operationType);
        this.getUnifiedDeclareReportEditService().setExtendControllsStatus(operationType);
    }

    public Map<String, String> getUpdateNsrxxMap() {
        return this.getUnifiedDeclareReportEditService().getUpdateNsrxxMap();
    }

    public void save() {
        if (!this.beforeSave()) {
            return;
        }
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("DeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method saveClick = pluginClass.getMethod("saveClick", IPageCache.class, DeclareRequestModel.class);
                DeclareRequestModel declareRequestModel = new DeclareRequestModel();
                String orgId = DynamicObjectUtils.getDynamicObjectStringValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
                String startDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq");
                String endDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz");
                DynamicObject declareMain = this.getDeclareMain(orgId, startDate, endDate);
                if (declareMain != null && !"A".equals(declareMain.getString("billstatus"))) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u7ecf\u63d0\u4ea4\u6216\u5df2\u5ba1\u6838,\u4e0d\u5141\u8bb8\u4fee\u6539\u4fdd\u5b58\uff01", (String)"UnifiedDeclareReportEditPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                String templateType = this.getTemplateType();
                declareRequestModel.setCustomEvent(SAVE_KEY);
                declareRequestModel.setModelId(this.getModelId());
                declareRequestModel.setId(this.getSbbid(null, orgId, startDate, endDate));
                declareRequestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                declareRequestModel.setTemplateType(templateType);
                declareRequestModel.setRefresh(Boolean.valueOf(true));
                declareRequestModel.setOperation("edit");
                declareRequestModel.setSkssqq(startDate);
                declareRequestModel.setSkssqz(endDate);
                declareRequestModel.getBusinessMap().putAll(this.getMainTableExtendParams());
                declareRequestModel.getUpdateNsrxxMap().putAll(this.getUpdateNsrxxMap());
                BaseResult resultMap = (BaseResult)saveClick.invoke(taxDeclarePlugin, childPageCache, declareRequestModel);
                if (500 == resultMap.getCode()) {
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a%s", (String)"UnifiedDeclareReportEditPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), resultMap.getMessage()));
                    return;
                }
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u4fdd\u5b58\u6210\u529f", (String)"UnifiedDeclareReportEditPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.getModelId());
                if (declareTable != null && declareTable.isDraftModel()) {
                    operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e95\u7a3f\u4fdd\u5b58\u6210\u529f", (String)"UnifiedDeclareReportEditPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"UnifiedDeclareReportEditPlugin_18", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                OperatorDialogUtils.operateDialog((String)templateType, (String)this.getEntity(templateType), (String)ResManager.loadKDString((String)"\u4fdd\u5b58", (String)"UnifiedDeclareReportEditPlugin_19", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)operateDescription);
                this.doAfterSuccessSave();
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
                String sbbid = String.valueOf(this.getSbbid(null, orgId, startDate, endDate));
                this.getPageCache().put(SBBID, sbbid);
            }
            catch (Exception e) {
                logger.error("\u4fdd\u5b58\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25", (String)"UnifiedDeclareReportEditPlugin_20", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                } else {
                    this.getView().showErrorNotification(msg);
                }
                return;
            }
            this.operationSbb(VIEW, Boolean.FALSE, SAVE_KEY);
        }
        this.enableSubmitBtn();
    }

    protected boolean beforeSave() {
        return this.fireBeforeSave();
    }

    protected void doAfterSuccessSave() {
        this.getUnifiedDeclareReportEditService().doAfterSuccessSave();
        this.fireDoAfterSuccessSave();
    }

    public void enableSubmitBtn() {
        this.getView().setVisible(Boolean.TRUE, new String[]{SUBMIT_KEY});
        this.getUnifiedDeclareReportEditService().enableSubmitBtn();
    }

    public void submit(String key) {
        String endDate;
        String startDate;
        String sbbid = null;
        String orgId = DynamicObjectUtils.getDynamicObjectStringValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
        DynamicObject declare = this.getDeclareMain(orgId, startDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq"), endDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz"));
        if (declare != null) {
            sbbid = declare.getString("id");
        }
        if (!StringUtils.isEmpty(sbbid)) {
            ArrayList<String> pklist = new ArrayList<String>();
            pklist.add(sbbid);
            boolean flag = MultiDeclareUtils.submit((IFormView)this.getView(), pklist, (String)key, (String)this.getMainTable(), (boolean)false);
            if (flag) {
                this.setBtnStatus(orgId, startDate, endDate, VIEW);
                this.customEvent(orgId, startDate, endDate, key);
            }
        } else {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7533\u62a5\u8868\u672a\u751f\u6210\u6216\u5df2\u88ab\u5220\u9664, \u8bf7\u91cd\u65b0\u751f\u6210", (String)"UnifiedDeclareReportEditPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    protected void customEvent(String orgId, String startDate, String endDate, String operationKey) {
        this.getUnifiedDeclareReportEditService().customEvent(orgId, startDate, endDate, operationKey);
    }

    public void edit(String key) {
        this.getView().setVisible(Boolean.FALSE, new String[]{SUBMIT_KEY, AUDIT_KEY, CLOSE_KEY});
        this.operationSbb("edit", Boolean.FALSE, key);
    }

    private void recalc() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(RECALC_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"UnifiedDeclareReportEditPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"UnifiedDeclareReportEditPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u7f6e\u62a5\u8868\u5c06\u5bfc\u81f4\u539f\u6709\u6570\u636e\uff08\u5305\u62ec\u624b\u5de5\u8c03\u6574\u7684\u6570\u636e\uff09\u88ab\u6e05\u7a7a\u4e14\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"UnifiedDeclareReportEditPlugin_23", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    private void reGetDataConform() {
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(REGETDATA_KEY, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"UnifiedDeclareReportEditPlugin_21", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"UnifiedDeclareReportEditPlugin_22", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        MessageBoxOptions options = MessageBoxOptions.OKCancel;
        String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u53d6\u6570\u4f1a\u4fdd\u7559\u624b\u5de5\u4fee\u6539\u8fc7\u7684\u5355\u5143\u683c\u6570\u503c\uff0c\u5176\u4ed6\u5355\u5143\u683c\u53ca\u5355\u5143\u683c\u95f4\u7684\u8ba1\u7b97\u516c\u5f0f\u5c06\u4f1a\u91cd\u65b0\u8ba1\u7b97\uff0c\u662f\u5426\u8981\u6267\u884c\u6b64\u64cd\u4f5c\uff1f", (String)"UnifiedDeclareReportEditPlugin_24", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId = e.getCallBackId();
        String orgId = DynamicObjectUtils.getDynamicObjectStringValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
        String skssqq = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq");
        String skssqz = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz");
        Date skssqqDate = DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM-dd");
        Date skssqzDate = DateUtils.stringToDate((String)skssqz, (String)"yyyy-MM-dd");
        String draftpurpose = this.getPageCache().get("draftpurpose") != null ? this.getPageCache().get("draftpurpose") : "nssb";
        String templateType = this.getTemplateType();
        switch (callBackId) {
            case "recalc": {
                if (!this.isValidDates(skssqqDate, skssqzDate, Boolean.TRUE).booleanValue()) {
                    return;
                }
                if (e.getResult() != MessageBoxResult.Yes) break;
                if (orgId == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7a0e\u52a1\u7ec4\u7ec7\u201d\u3002", (String)"UnifiedDeclareReportEditPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    return;
                }
                this.openDeclarePage(orgId, skssqq, skssqz, true, callBackId);
                String templatetype = this.getTemplateType();
                if ("kjqysds".equals(templateType) || "dkdj".equals(templateType)) {
                    return;
                }
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
                TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"UnifiedDeclareReportEditPlugin_25", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                if (this.isDraftType()) {
                    operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u5e95\u7a3f\u91cd\u65b0\u8ba1\u7b97\u6210\u529f", (String)"UnifiedDeclareReportEditPlugin_26", (String)"taxc-bdtaxr", (Object[])new Object[0]), this.getPageCache().get(BILLNO));
                }
                OperatorDialogUtils.operateDialog((String)templatetype, (String)this.getEntity(templatetype), (String)ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97", (String)"UnifiedDeclareReportEditPlugin_27", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)operateDescription);
                break;
            }
            case "callback_modify": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    this.showInnerPage(orgId, skssqq, skssqz, false, VIEW, callBackId);
                    break;
                }
                this.closeView();
                break;
            }
            case "modifyOrDelete": {
                if (e.getResult() == MessageBoxResult.Yes) {
                    TemplateUtils.deleteReport((Long)Long.parseLong(orgId), (String)templateType, (Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz), null);
                    TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)templateType);
                    StatusUtils.delete((String)templateEnum.getDraftType(), (String)orgId, (String)skssqq, (String)skssqz, (String)draftpurpose);
                    HashMap<String, String> customParams = new HashMap<String, String>();
                    customParams.put(ORGID_KEY, orgId);
                    customParams.put("skssqq", skssqq);
                    customParams.put("skssqz", skssqz);
                    if (StringUtil.isEmpty((CharSequence)templateEnum.getDraftPage())) {
                        this.getView().showErrorNotification("No Draft Page!");
                        return;
                    }
                    PageShowCommon.showForm((ShowType)ShowType.MainNewTabPage, (String)templateEnum.getDraftPage(), (IFormView)this.getView(), customParams, (IFormPlugin)this);
                    this.closeView();
                    break;
                }
                if (e.getResult() == MessageBoxResult.No) {
                    Long sbbid = this.getSbbid(null, orgId, skssqq, skssqz);
                    boolean success = this.requestMutexLock(sbbid + "");
                    if (success) {
                        this.showInnerPage(orgId, skssqq, skssqz, false, "edit", callBackId);
                        this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY, REGETDATA_KEY});
                        break;
                    }
                    this.showInnerPage(orgId, skssqq, skssqz, false, VIEW, callBackId);
                    this.getView().setVisible(Boolean.FALSE, new String[]{RECALC_KEY, REGETDATA_KEY});
                    break;
                }
                this.closeView();
                break;
            }
            case "cancel": {
                DynamicObject dyo = this.getDeclareMain(null == orgId ? "0" : orgId, skssqq, skssqz);
                if (e.getResult() == MessageBoxResult.Yes) {
                    TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent");
                    TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap");
                    TreeUtils.removeCache((IPageCache)this.getPageCache(), (String)"remark_data");
                    if (dyo == null) {
                        this.closeView();
                    } else {
                        this.enableSubmitBtn();
                        this.operationSbb(VIEW, Boolean.FALSE, CANCEL_KEY);
                        break;
                    }
                }
            }
            case "close": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.closeView();
                break;
            }
            case "regetdata": {
                if (!this.isValidDates(skssqqDate, skssqzDate, Boolean.TRUE).booleanValue()) {
                    return;
                }
                if (e.getResult() != MessageBoxResult.Yes) break;
                this.reGetData();
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        String code_close = this.getPageCache().get("code_close");
        if (this.isDataChanged() && !"true".equals(code_close)) {
            e.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CLOSE_KEY, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"UnifiedDeclareReportEditPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u9000\u51fa\u7f16\u8f91", (String)"UnifiedDeclareReportEditPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\u7f16\u8f91\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539", (String)"UnifiedDeclareReportEditPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    protected void reGetData() {
        Map remarkDataMapCache;
        Map<String, String> bussinessUpdateMap;
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        if (childView == null) {
            return;
        }
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        if (childPageCache == null) {
            return;
        }
        DeclareRequestModel requestModel = (DeclareRequestModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareRequest", DeclareRequestModel.class);
        DeclareResponseModel responseModel = (DeclareResponseModel)TreeUtils.getCache((IPageCache)childPageCache, (String)"declareData", DeclareResponseModel.class);
        Map currentMap = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid_save", Map.class);
        String updateCellEntityMap = childPageCache.get("updateCellEntityMap");
        if (updateCellEntityMap == null) {
            updateCellEntityMap = this.getPageCache().get("updateCellEntityMap");
        }
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"updateCellEntityMap", (Object)updateCellEntityMap);
        if (currentMap == null || currentMap.isEmpty()) {
            currentMap = responseModel.getData();
        }
        Map updateMapCache = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"updata_cellid", Map.class);
        List<String> reGetDataHisCells = TaxDeclarePluginService.queryReGetDataHisCell(String.valueOf(requestModel.getId()));
        HashMap updateMap = new HashMap(reGetDataHisCells.size());
        for (String cellKey : reGetDataHisCells) {
            if (!StringUtil.isNotBlank((CharSequence)cellKey) || !StringUtil.isNotBlank((CharSequence)((CharSequence)currentMap.get(cellKey)))) continue;
            updateMap.put(cellKey, currentMap.get(cellKey));
        }
        if (updateMapCache != null && !updateMapCache.isEmpty()) {
            updateMap.putAll(updateMapCache);
        }
        if ((bussinessUpdateMap = this.bussinessUpdateMap(currentMap)) != null && !bussinessUpdateMap.isEmpty()) {
            updateMap.putAll(bussinessUpdateMap);
        }
        if ((remarkDataMapCache = (Map)TreeUtils.getCache((IPageCache)childPageCache, (String)"remark_data", Map.class)) != null) {
            HashMap remarkDataMap = new HashMap();
            updateMap.forEach((k, v) -> {
                if (remarkDataMapCache.containsKey(k)) {
                    remarkDataMap.put(k, (String)remarkDataMapCache.get(k));
                }
            });
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"remark_data", remarkDataMap);
        }
        updateMap.entrySet().removeIf(entry -> this.checkIsDynCell((String)entry.getKey()));
        requestModel.setCustomEvent(REGETDATA_KEY);
        requestModel.setPreData(updateMap);
        requestModel.setRefresh(Boolean.valueOf(true));
        requestModel.setOperation("edit");
        try {
            HashMap<String, String> ruleFetchData = StringUtil.isEmpty((CharSequence)updateCellEntityMap) ? new HashMap() : (Map)SerializationUtils.fromJsonString((String)updateCellEntityMap, Map.class);
            RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
            ruleFetchService.saveTempRuleFetchAdjustData(ruleFetchData, requestModel);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0b\u94bb\u4e34\u65f6\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff01", (String)"UnifiedDeclareReportEditPlugin_28", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.setRequestModel(requestModel);
        TreeUtils.putCache((IPageCache)childPageCache, (String)"declareRequest", (Object)SerializationUtils.toJsonString((Object)requestModel));
        TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"updata_cellid_parent", (Object)updateMapCache);
        TreeUtils.putCache((IPageCache)childPageCache, (String)"updata_cellid_save", (Object)currentMap);
        this.getPageCache().put("updateCellEntityMap", updateCellEntityMap);
        Map customParams = childView.getFormShowParameter().getCustomParams();
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        FormShowParameter param = new FormShowParameter();
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        this.getPageCache().put("declarepageid", param.getPageId());
        param.setCustomParams(customParams);
        this.getView().showForm(param);
    }

    protected Map<String, String> bussinessUpdateMap(Map<String, String> currentMap) {
        return this.getUnifiedDeclareReportEditService().bussinessUpdateMap(currentMap);
    }

    private boolean isDeclared(String rootPageId, String orgId, String startdate, String enddate) {
        DynamicObject declare = this.getDeclareMain(orgId, startdate, enddate);
        IFormView rootView = this.getView().getView(rootPageId);
        IPageCache rootCache = (IPageCache)rootView.getService(IPageCache.class);
        rootCache.put(BILL_STATUS, "A");
        this.getPageCache().remove("templateid");
        if (declare != null) {
            if (StringUtil.isNotEmpty((CharSequence)declare.getString("templateid"))) {
                this.getPageCache().put("templateid", declare.getString("templateid"));
                this.getPageCache().put("templateId", declare.getDynamicObject("templateid").getString("id"));
            }
            String billstatus = declare.getString("billstatus");
            String id = declare.getString("id");
            rootCache.put(BILL_STATUS, billstatus);
            rootCache.put(SBBID, id);
            rootCache.put(BILLNO, declare.getString(BILLNO));
            if (StringUtils.isNotBlank((CharSequence)billstatus) && !"A".equals(billstatus)) {
                DynamicObject org = (DynamicObject)rootView.getModel().getValue(ORG);
                String orgName = null != org ? org.getString("name") : "";
                String taxlimitStr = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)startdate), (Date)DateUtils.stringToDate((String)enddate));
                if (!taxlimitStr.equals("")) {
                    this.getView().sendFormAction(rootView);
                }
                return true;
            }
        }
        return false;
    }

    protected String[] getTaxLimits() {
        return this.getUnifiedDeclareReportEditService().getTaxLimits();
    }

    public Map<String, String> getMainTableParams() {
        String orgid = DynamicObjectUtils.getDynamicObjectStringValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
        String skssqq = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq");
        String skssqz = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz");
        HashMap<String, String> mainTableParams = new HashMap<String, String>(16);
        mainTableParams.put(ORG, orgid);
        mainTableParams.put("skssqq", skssqq);
        mainTableParams.put("skssqz", skssqz);
        Map<String, String> extendParams = this.getMainTableExtendParams();
        if (EmptyCheckUtils.isNotEmpty(extendParams)) {
            mainTableParams.putAll(extendParams);
        }
        return mainTableParams;
    }

    private Map<String, String> getMainTableExtendParams() {
        return this.getUnifiedDeclareReportEditService().getMainTableExtendParams();
    }

    public void openDeclarePage(String orgid, String skssqq, String skssqz, boolean refresh, String customEvent) {
        Boolean isopenbyworkflow;
        if (!this.beforeOpenDeclarePage()) {
            return;
        }
        String templateType = this.getTemplateType();
        DynamicObject dyo = this.getDeclareMain(orgid, skssqq, skssqz);
        if (dyo == null) {
            logger.info("openDeclarePage add");
            customEvent = "add";
            this.showInnerPage(orgid, skssqq, skssqz, true, "edit", customEvent);
            return;
        }
        if (this.getModel().getDataEntity().containsProperty("checkisopenbyworkflow") && (isopenbyworkflow = (Boolean)this.getModel().getValue("checkisopenbyworkflow")) != null && isopenbyworkflow.booleanValue()) {
            this.showInnerPage(orgid, skssqq, skssqz, false, VIEW, customEvent);
            return;
        }
        this.getPageCache().put("datatype", dyo.getString("datatype"));
        if (StringUtils.equals((CharSequence)"2", (CharSequence)dyo.getString("datatype"))) {
            if (StringUtils.equals((CharSequence)"A", (CharSequence)dyo.getString("billstatus")) && this.viewDialog()) {
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                String taxLimitTips = DateUtils.getTaxLimitTips((Date)DateUtils.stringToDate((String)skssqq), (Date)DateUtils.stringToDate((String)skssqz));
                String orgname = this.getModel().getValue(ORG) == null ? "" : ((DynamicObject)this.getModel().getValue(ORG)).getString("name");
                String msg = ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u5b58\u5728\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u53ef\u9009\u62e9\u4ee5\u4e0b\u64cd\u4f5c", (String)"UnifiedDeclareReportEditPlugin_29", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if ("yhs".equals(templateType)) {
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"UnifiedDeclareReportEditPlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"UnifiedDeclareReportEditPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e", (String)"UnifiedDeclareReportEditPlugin_32", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener(CALLBACKID_MODIFY, (IFormPlugin)this), btnNameMaps);
                } else {
                    btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u9875\u9762", (String)"UnifiedDeclareReportEditPlugin_30", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e", (String)"UnifiedDeclareReportEditPlugin_31", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7a0e", (String)"UnifiedDeclareReportEditPlugin_33", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    this.getView().showConfirm(String.format(msg, orgname, taxLimitTips), ResManager.loadKDString((String)"\u4fee\u6539\u6570\u636e\uff1a\u624b\u52a8\u4fee\u6539\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\n\u91cd\u65b0\u8ba1\u7a0e\uff1a\u6e05\u7a7a\u5f15\u5165\u7684\u7533\u62a5\u6570\u636e\uff0c\u5e76\u4f7f\u7528\u81ea\u52a8\u8ba1\u7a0e", (String)"UnifiedDeclareReportEditPlugin_34", (String)"taxc-bdtaxr", (Object[])new Object[0]), MessageBoxOptions.YesNoCancel, ConfirmTypes.Delete, new ConfirmCallBackListener(CALLBACKID_MOD, (IFormPlugin)this), btnNameMaps);
                }
            } else {
                this.showInnerPage(orgid, skssqq, skssqz, refresh, VIEW, customEvent);
            }
        } else if ("A".equals(dyo.getString("billstatus"))) {
            this.showInnerPage(orgid, skssqq, skssqz, refresh, refresh ? "edit" : VIEW, customEvent);
        } else {
            this.showInnerPage(orgid, skssqq, skssqz, false, VIEW, customEvent);
        }
    }

    private boolean beforeOpenDeclarePage() {
        return this.fireBeforeOpenDeclarePage();
    }

    public boolean checkOrgTaxConfig(String orgid, String skssqq, String skssqz) {
        return this.getUnifiedDeclareReportEditService().checkOrgTaxConfig(orgid, skssqq, skssqz);
    }

    private void showInnerPage(String orgid, String startDate, String endDate, boolean refresh, String operationStatus, String customEvent) {
        String appid = this.getView().getFormShowParameter().getFormConfig().getAppId();
        HashMap<String, Object> customParams = new HashMap<String, Object>(16);
        customParams.put("rootPageId", this.getView().getPageId());
        String taxLimit = DateUtils.getTaxLimit((Date)DateUtils.stringToDate((String)startDate), (Date)DateUtils.stringToDate((String)endDate));
        customParams.put("taxlimit", taxLimit);
        customParams.put("templatetype", this.getTemplateType());
        customParams.put("ParentCache", "true");
        if ("zzsybnsr_ybfz".equals(customParams.get("templatetype"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u88ab\u6c47\u603b\u7ec4\u7ec7\u65e0\u987b\u7533\u62a5", (String)"UnifiedDeclareReportEditPlugin_35", (String)"taxc-bdtaxr", (Object[])new Object[0]), null);
            return;
        }
        if ("zzsybnsr_fzjg".equals(customParams.get("templatetype")) || "zzsybnsr_zjg".equals(customParams.get("templatetype"))) {
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6c47\u603b\u822a\u7a7a\u6682\u4e0d\u652f\u6301\u7eb3\u7a0e\u7533\u62a5", (String)"UnifiedDeclareReportEditPlugin_36", (String)"taxc-bdtaxr", (Object[])new Object[0]), null);
            return;
        }
        boolean readonly = false;
        boolean isDeclare = this.isDeclared(this.getView().getPageId(), orgid, startDate, endDate);
        if (isDeclare) {
            readonly = true;
        }
        customParams.put("readonly", readonly);
        customParams.put("templateid", this.getPageCache().get("templateid"));
        Map<String, String> businessParams = this.getMainTableExtendParams();
        String templateType = (String)customParams.get("templatetype");
        this.declareReportService = DeclareReportFactory.createHandler((String)templateType);
        String billNo = this.getPageCache().get(BILLNO);
        if (StringUtil.isBlank((CharSequence)billNo)) {
            billNo = this.declareReportService.getBillNumber(DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), orgid, businessParams);
        }
        this.getPageCache().put(BILLNO, billNo);
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.getBusinessMap().putAll(businessParams);
        requestModel.setModelId(this.declareReportService.getModleId());
        requestModel.setId(this.getSbbid(null, orgid, startDate, endDate));
        requestModel.setBillNo(billNo);
        requestModel.setOrgId(Long.valueOf(Long.parseLong(orgid)));
        requestModel.setTemplateType(templateType);
        requestModel.setOperation(operationStatus);
        requestModel.setCustomEvent(customEvent);
        requestModel.setSkssqq(startDate);
        requestModel.setSkssqz(endDate);
        requestModel.setRefresh(Boolean.valueOf(refresh));
        requestModel.setUniKey(this.getUniKey());
        this.setRequestModel(requestModel);
        customParams.put("declareRequestData", SerializationUtils.toJsonString((Object)requestModel));
        FormShowParameter param = new FormShowParameter();
        param.setFormId(this.getDeclareFormId());
        param.getOpenStyle().setShowType(ShowType.InContainer);
        param.getOpenStyle().setTargetKey(CONTENT_TAB);
        String pageid = param.getPageId();
        this.getPageCache().put("declarepageid", pageid);
        param.setCustomParams(customParams);
        this.getView().showForm(param);
        this.getView().updateView(CONTENT_TAB);
        this.setBtnStatus(orgid, startDate, endDate, operationStatus);
    }

    protected String getUniKey() {
        String templateType = this.getTemplateType();
        this.declareReportService = DeclareReportFactory.createHandler((String)templateType);
        return this.declareReportService.getUniKey(this.getMainTableParams());
    }

    protected void rangeCalc() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        IPageCache childPageCache = (IPageCache)childView.getService(IPageCache.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("DeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                String orgId = DynamicObjectUtils.getDynamicObjectStringValue((DynamicObject)this.getModel().getDataEntity(), (String)ORG);
                String startDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqq");
                String endDate = DynamicObjectUtils.getDateStringValue((DynamicObject)this.getModel().getDataEntity(), (String)"skssqz");
                Map<String, String> businessParams = this.getMainTableExtendParams();
                String templateType = this.getTemplateType();
                this.declareReportService = DeclareReportFactory.createHandler((String)templateType);
                String billNo = this.getPageCache().get(BILLNO);
                if (StringUtil.isBlank((CharSequence)billNo)) {
                    billNo = this.declareReportService.getBillNumber(DateUtils.stringToDate((String)startDate), DateUtils.stringToDate((String)endDate), orgId, businessParams);
                }
                DeclareRequestModel requestModel = new DeclareRequestModel();
                requestModel.getBusinessMap().putAll(businessParams);
                requestModel.setModelId(this.getModelId());
                requestModel.setId(this.getSbbid(null, orgId, startDate, endDate));
                requestModel.setBillNo(billNo);
                requestModel.setOrgId(Long.valueOf(Long.parseLong(orgId)));
                requestModel.setTemplateType(this.getTemplateType());
                requestModel.setOperation("edit");
                requestModel.setCustomEvent(RECALC_KEY);
                requestModel.setSkssqq(startDate);
                requestModel.setSkssqz(endDate);
                requestModel.setRefresh(Boolean.valueOf(true));
                requestModel.setUniKey(this.getUniKey());
                this.setRequestModel(requestModel);
                Method rangeCalc = pluginClass.getMethod("rangeCalc", IPageCache.class, DeclareRequestModel.class);
                rangeCalc.invoke(taxDeclarePlugin, childPageCache, requestModel);
            }
            catch (Exception e) {
                logger.error("\u91cd\u65b0\u8ba1\u7b97\u5931\u8d25", (Throwable)e);
                String msg = ResManager.loadKDString((String)"\u91cd\u65b0\u8ba1\u7b97\u5931\u8d25", (String)"UnifiedDeclareReportEditPlugin_37", (String)"taxc-bdtaxr", (Object[])new Object[0]);
                if (e instanceof InvocationTargetException && ((InvocationTargetException)e).getTargetException() instanceof KDBizException) {
                    Throwable targetException = ((InvocationTargetException)e).getTargetException();
                    this.getView().showErrorNotification(msg + COMMA + targetException.getMessage());
                }
                this.getView().showErrorNotification(msg);
            }
        }
    }

    public String getDeclareFormId() {
        return this.getUnifiedDeclareReportEditService().getDeclareFormId();
    }

    private void setBtnStatus(String orgid, String startDate, String endDate, String operationStatus) {
        this.getModel().setValue("operationStatus", (Object)operationStatus);
        DynamicObject dyo = this.getDeclareMain(orgid, startDate, endDate);
        if (dyo != null && VIEW.equals(operationStatus)) {
            Object checkisopenbyworkflow;
            String billstatus = dyo.getString("billstatus");
            if ("A".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"edit", VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{AUDIT_KEY, SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{SUBMIT_KEY});
            }
            if ("B".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, SUBMIT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{SUBMIT_KEY});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{AUDIT_KEY});
            }
            if ("C".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{AUDIT_KEY, VIEW_DRAFT_KEY, CLOSE_KEY});
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", SAVE_KEY, CANCEL_KEY, RECALC_KEY, REGETDATA_KEY, SUBMIT_KEY, ONE_KEY_GENERATE});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{AUDIT_KEY});
            }
            if (Objects.equals(checkisopenbyworkflow = this.getView().getFormShowParameter().getCustomParam("checkisopenbyworkflow"), true) || Objects.equals(checkisopenbyworkflow, "true") || Objects.equals(checkisopenbyworkflow, Boolean.TRUE)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{TOOL_BAR_DECLARE});
            }
            this.setExtendsControlsByBillstatus(billstatus);
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"edit", CLOSE_KEY, SUBMIT_KEY, AUDIT_KEY});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{VIEW_DRAFT_KEY, RECALC_KEY, REGETDATA_KEY, SAVE_KEY, CANCEL_KEY, ONE_KEY_GENERATE});
            if (dyo != null && StringUtils.equals((CharSequence)"2", (CharSequence)this.getPageCache().get("datatype"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{RECALC_KEY, REGETDATA_KEY});
            }
            this.setExtendsControlsByBillstatus("new");
        }
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        this.getUnifiedDeclareReportEditService().setExtendsControlsByBillstatus(billstatus);
        this.getModel().setValue("billstatus", (Object)billstatus);
    }

    private Long getSbbid(OperationStatus operationStatus, String orgid, String startDate, String endDate) {
        DynamicObject declareMain = this.getDeclareMain(orgid, startDate, endDate);
        if (declareMain != null) {
            return declareMain.getLong("id");
        }
        return null;
    }

    public DynamicObject getDeclareMain(String orgid, String skssqq, String skssqz) {
        if (StringUtil.isBlank((CharSequence)orgid) || StringUtil.isBlank((CharSequence)skssqq) || StringUtil.isBlank((CharSequence)skssqz)) {
            return null;
        }
        String templateType = this.getTemplateType();
        QFilter extendQfilter = this.getDeclareMainQueryParams();
        return YbnsrService.queryMultiDeclareMain((String)this.getMainTable(), (long)Long.parseLong(orgid), (String)templateType, (String)skssqq, (String)skssqz, (QFilter)extendQfilter);
    }

    public String getMainTable() {
        return MultiTableEnum.getMultiTableByModelNumber((String)this.getModelNumber()).getDeclareMainTable();
    }

    protected String getEntity(String templateType) {
        return TemplateEnum.getEnumByDeclareType((String)templateType).getDeclarePage();
    }

    public void beforeInit() {
        this.getUnifiedDeclareReportEditService().beforeInit();
    }

    public void init() {
        this.getUnifiedDeclareReportEditService().init();
    }

    public String getTaxType() {
        return this.getUnifiedDeclareReportEditService().getTaxType();
    }

    public String getTemplateType() {
        return this.getUnifiedDeclareReportEditService().getTemplateType();
    }

    public void clientCallBack(ClientCallBackEvent e) {
        Map dataMap = JsonUtils.strToMap((String)this.getPageCache().get("resultData"));
        this.clientCallBackMethod(dataMap, e.getName());
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
        this.getUnifiedDeclareReportEditService().clientCallBackMethod(dataMap, sheetid);
    }

    public void initPeriod(String orgId, Map<String, Object> customParams) {
        this.getUnifiedDeclareReportEditService().initPeriod(orgId, customParams);
    }

    protected Long getModelId() {
        String templateType = this.getTemplateType();
        this.declareReportService = DeclareReportFactory.createHandler((String)templateType);
        return this.declareReportService.getModleId();
    }

    protected String getModelNumber() {
        Long modelId = this.getModelId();
        if (modelId != null && modelId != 0L) {
            return MultiTableEnum.getModelNumberById((String)String.valueOf(modelId));
        }
        return null;
    }

    protected boolean isDraftType() {
        DeclareTable declareTable = MultiTableEnum.getDeclareTable((Long)this.getModelId());
        return declareTable != null ? declareTable.isDraftModel() : Boolean.FALSE.booleanValue();
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        return this.getUnifiedDeclareReportEditService().setRequestModel(requestModel);
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        return this.getUnifiedDeclareReportEditService().paraCustomParams(customParams);
    }

    public QFilter getDeclareMainQueryParams() {
        String templateType = this.getTemplateType();
        this.declareReportService = DeclareReportFactory.createHandler((String)templateType);
        HashMap<String, String> params = new HashMap<String, String>(16);
        Map<String, String> mainTableParams = this.getMainTableParams();
        if (EmptyCheckUtils.isNotEmpty(mainTableParams)) {
            params.putAll(mainTableParams);
        }
        return this.declareReportService.getDeclareMainQueryExtendFilter(params);
    }

    public void pageRelease(EventObject e) {
        String sbbid = this.getPageCache().get(SBBID);
        if (StringUtils.isNotBlank((CharSequence)sbbid)) {
            MutexServiceImpl.releaseMutexLock(sbbid, "edit", RequestContext.get().getCurrUserId());
        }
    }

    public UnifiedDeclareReportEditService getUnifiedDeclareReportEditService() {
        return UnifiedDeclareReportEditFactory.getInstance(this.getView());
    }

    protected boolean viewDialog() {
        return this.getUnifiedDeclareReportEditService().viewDialog();
    }

    protected void loadFromOtherPage(Map<String, Object> customParams) {
        this.getUnifiedDeclareReportEditService().loadFromOtherPage(customParams);
    }

    public boolean checkIsDynCell(String cellKey) {
        String[] splits = cellKey.split("#");
        if (splits.length == 3) {
            try {
                Integer.parseInt(splits[1]);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    protected FormViewPluginProxy getPluginProxy() {
        return (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
    }

    public boolean fireBeforeSave() {
        List plugins = this.getPluginProxy().getPlugIns();
        for (int i = 0; i < plugins.size(); ++i) {
            IFormPlugin plugin = (IFormPlugin)plugins.get(i);
            if (!(plugin instanceof UnifiedDeclareReportEditAdapter) || ((UnifiedDeclareReportEditAdapter)plugin).beforeSave()) continue;
            return false;
        }
        return true;
    }

    public void fireDoAfterSuccessSave() {
        List plugins = this.getPluginProxy().getPlugIns();
        for (int i = 0; i < plugins.size(); ++i) {
            IFormPlugin plugin = (IFormPlugin)plugins.get(i);
            if (!(plugin instanceof UnifiedDeclareReportEditAdapter)) continue;
            ((UnifiedDeclareReportEditAdapter)plugin).doAfterSuccessSave();
        }
    }

    public boolean fireBeforeOpenDeclarePage() {
        List plugins = this.getPluginProxy().getPlugIns();
        for (int i = 0; i < plugins.size(); ++i) {
            IFormPlugin plugin = (IFormPlugin)plugins.get(i);
            if (!(plugin instanceof UnifiedDeclareReportEditAdapter) || ((UnifiedDeclareReportEditAdapter)plugin).beforeOpenDeclarePage()) continue;
            return false;
        }
        return true;
    }
}

