/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.draft;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.enums.DraftTypeEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class DraftNeedAuditPlugin
extends AbstractFormPlugin {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("submit".equals(operateKey) && !operate.getOption().containsVariable("callBack")) {
            DynamicObject[] drafts;
            if (this.getView() instanceof ListView) {
                Object[] pkIds = args.getListSelectedData().getPrimaryKeyValues();
                String entityId = ((ListView)this.getView()).getBillFormId();
                drafts = BusinessDataServiceHelper.load((Object[])pkIds, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityId));
            } else {
                DynamicObject draft = BusinessDataServiceHelper.newDynamicObject((String)"tctb_draft_main");
                draft.set("org", this.getModel().getValue("org"));
                draft.set("startdate", this.getModel().getValue("skssqq"));
                draft.set("enddate", this.getModel().getValue("skssqz"));
                draft.set("billno", this.getModel().getValue("draftnumber"));
                String draftId = this.getPageCache().get("draftId");
                if (StringUtils.isBlank((CharSequence)draftId)) {
                    return;
                }
                DynamicObject[] one = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"templatetype,billstatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(draftId))});
                if (one != null) {
                    draft.set("templatetype", (Object)one.getString("templatetype"));
                    draft.set("billstatus", (Object)one.getString("billstatus"));
                }
                drafts = new DynamicObject[]{draft};
            }
            String appId = this.getView().getFormShowParameter().getAppId();
            StringBuilder message = new StringBuilder();
            for (DynamicObject draft : drafts) {
                boolean draftneedaudit;
                DynamicObject org = draft.getDynamicObject("org");
                String templatetype = draft.getString("templatetype");
                if ("tam".equals(appId)) {
                    appId = Arrays.stream(DraftTypeEnum.values()).filter(e -> Arrays.asList(e.getTemplates()).contains(templatetype) && !"tam".equals(e.getAppId())).map(DraftTypeEnum::getAppId).findFirst().orElse(appId);
                }
                if (!(draftneedaudit = SystemParamUtil.getZeroDeclareParameter((String)appId, (String)"draftneedaudit", (long)org.getLong("id"))) || !"A".equals(draft.getString("billstatus"))) continue;
                TemplateEnum templateEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
                DynamicObject sbb = YbnsrServiceHelper.queryYbnsrWithEx((String)org.getString("id"), (String)templateEnum.getDeclareType(), (String)DateUtils.format((Date)draft.getDate("startdate")), (String)DateUtils.format((Date)draft.getDate("enddate")), Collections.emptyMap());
                if (sbb == null || !"A".equals(sbb.getString("billstatus"))) continue;
                message.append(String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u6682\u5b58\u7684\u7533\u62a5\u8868\uff0c\u91cd\u65b0\u63d0\u4ea4\u5c06\u540c\u6b65\u5237\u65b0\u7533\u62a5\u8868", (String)"DraftNeedAuditPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), draft.getString("billno"))).append(SEPARATOR);
            }
            if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                args.setCancel(true);
                this.getView().showConfirm(message.toString(), "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        MessageBoxResult result = evt.getResult();
        if ("submit".equals(callBackId) && result == MessageBoxResult.Yes) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("callBack", "yes");
            this.getView().invokeOperation("submit", option);
        }
    }
}

