/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.taxdeclare.draft;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeFilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.list.BillList;
import kd.bos.list.DecimalListColumn;
import kd.bos.list.ListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.list.plugin.ListViewPluginProxy;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.draft.DraftService;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.draft.DraftMQSender;
import kd.taxc.bdtaxr.common.taxdeclare.enums.DraftTypeEnum;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.MetadataUtil;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.showpage.PageShowCommon;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class DraftQueryListPlugin
extends AbstractListPlugin {
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";
    public static final String ITP_PROVISTON_TAXES = "itp_proviston_taxes";
    private BeforeCreateListColumnsArgs beforeCreateListColumnsArgs;
    private boolean isFirst = true;
    private static Log LOGGER = LogFactory.getLog(DraftQueryListPlugin.class);
    private static final Map<String, String> TAX_TYPE_MAP = new HashMap<String, String>(){
        {
            this.put("tcvat", "zzs");
            this.put("tccit", "qysds");
            this.put("tcret", "ccxws");
        }
    };
    private static final Set<String> OPERATEKEYS_TO_MQ = Sets.newHashSet((Object[])new String[]{DeclareMQEvent.DELETE.name().toLowerCase(), DeclareMQEvent.AUDIT.name().toLowerCase(), DeclareMQEvent.UNSUBMIT.name().toLowerCase(), DeclareMQEvent.UNAUDIT.name().toLowerCase(), DeclareMQEvent.SUBMIT.name().toLowerCase()});
    private static final Set<String> FORMID_TO_MQ = Sets.newHashSet((Object[])new String[]{"tcvat_query_ybnsr", "tccit_seasonal_dg_bill", "tccit_year_dg_bill"});

    public void filterContainerInit(FilterContainerInitArgs args) {
        CommonFilterColumn typeColumn;
        String templatetype = (String)this.getView().getFormShowParameter().getCustomParam("templatetype");
        List filterColumnList = args.getCommonFilterColumns();
        List schemeColumnList = args.getSchemeFilterColumns();
        List<String> templates = this.getTemplateTypeList();
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>(templates.size());
        for (String template : templates) {
            ComboItem item = new ComboItem();
            item.setValue(template);
            item.setCaption(new LocaleString((String)TemplateTypeConstant.getNsrtypemap().get(template)));
            combos.add(item);
        }
        for (FilterColumn column : filterColumnList) {
            if ("templatetype".equals(column.getFieldName())) {
                typeColumn = (CommonFilterColumn)column;
                String querytype = StringUtils.isNotBlank((CharSequence)templatetype) && templates.contains(templatetype) ? templatetype : ("qysdsjb".equals(templatetype) ? "draft_qysdsjb" : templates.get(0));
                if (!StringUtils.isEmpty((CharSequence)querytype)) {
                    typeColumn.setMustInput(true);
                    typeColumn.setDefaultValue(querytype);
                    this.getPageCache().put("templatetype", querytype);
                }
                typeColumn.setComboItems(combos);
                continue;
            }
            if ("org.id".equals(column.getFieldName())) {
                Map customParams = this.getView().getFormShowParameter().getCustomParams();
                List orgFilter = (List)customParams.get(ORGID_KEY);
                if (orgFilter == null || !this.isFirst) continue;
                column.setDefaultValues(orgFilter.toArray());
                continue;
            }
            if (!"startdate".equals(column.getFieldName())) continue;
            Object startdate = this.getView().getFormShowParameter().getCustomParam("startdate");
            Object enddate = this.getView().getFormShowParameter().getCustomParam("enddate");
            if (startdate == null || enddate == null || !this.isFirst) continue;
            column.setDefaultValues(new Object[]{startdate, enddate});
        }
        for (FilterColumn column : schemeColumnList) {
            if (!"templatetype".equals(column.getFieldName())) continue;
            typeColumn = (SchemeFilterColumn)column;
            typeColumn.setComboItems(combos);
            break;
        }
        QFilter typeFilter = new QFilter("templatetype", "in", templates);
        BillList billlist = (BillList)this.getControl("billlistap");
        billlist.getFilterParameter().setFilter(typeFilter);
        this.isFirst = false;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("qysdsjb".equals(customParams.get("drafttype"))) {
            boolean isSjjt = "sjjt".equals(customParams.get("draftpurpose"));
            this.getView().setVisible(Boolean.valueOf(isSjjt), new String[]{"newjtd"});
            this.getView().setVisible(Boolean.valueOf(!isSjjt), new String[]{"createsbb"});
        }
    }

    public void setFilter(SetFilterEvent evt) {
        super.setFilter(evt);
        boolean hasTemplatetype = evt.getQFilters().stream().anyMatch(e -> "templatetype".equals(e.getProperty()));
        if (!hasTemplatetype) {
            QFilter qFilter = new QFilter("templatetype", "in", this.getTemplateTypeList());
            evt.addCustomQFilter(qFilter);
        }
        BillList source = (BillList)evt.getSource();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("tccit_seasonal_dg_bill".equals(source.getBillFormId())) {
            if ("sjjt".equals(customParams.get("draftpurpose"))) {
                evt.getQFilters().add(new QFilter("draftpurpose", "=", (Object)"sjjt"));
                if (null != customParams.get("number")) {
                    evt.getQFilters().add(new QFilter("billno", "in", customParams.get("number")));
                }
            } else if ("nssb".equals(customParams.get("draftpurpose"))) {
                evt.getQFilters().add(new QFilter("draftpurpose", "=", (Object)"nssb"));
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Object source = args.getSource();
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"checkjtd", (CharSequence)((Donothing)args.getSource()).getOperateKey()) && ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"DraftQueryListPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String appId = this.getView().getFormShowParameter().getAppId();
        String taxtype = appId != null ? TAX_TYPE_MAP.get(appId.toLowerCase()) : "";
        BillList billlist = (BillList)this.getControl("billlistap");
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        this.sendDraftMQ(afterDoOperationEventArgs.getOperationResult(), afterDoOperationEventArgs.getOperateKey());
        if ("tblnew".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            Map customParams;
            String draftpurpose;
            FormShowParameter param = new FormShowParameter();
            if ("tccit".equals(appId) && "sjjt".equals(draftpurpose = (customParams = this.getView().getFormShowParameter().getCustomParams()).getOrDefault("draftpurpose", "nssb"))) {
                param.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"DraftQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            this.showDraftPage(this.getPageCache().get("templatetype"), param, this.getView().getFormShowParameter().getCustomParams());
        } else if ("createsbb".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            ListSelectedRowCollection list = billlist.getSelectedRows();
            if (list == null || list.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"DraftQueryListPlugin_2", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            } else if (list.size() > 1) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\uff0c\u60a8\u5f53\u524d\u9009\u62e9\u4e86[%d]\u884c\u3002", (String)"DraftQueryListPlugin_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), list.size()), Integer.valueOf(3000));
            } else if (!((Boolean)TaxcMainDataServiceHelper.isTaxcMainByOrgId((Long)list.get(0).getMainOrgId()).getData()).booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u52a1\u7ec4\u7ec7\u672a\u5ba1\u6838\u6216\u4e0d\u53ef\u7528\uff0c\u65e0\u6cd5\u6267\u884c\u5f53\u524d\u64cd\u4f5c\u3002", (String)"DraftQueryListPlugin_4", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            } else {
                this.openDraftPageOrDeclarePage(billlist, false);
            }
        } else if ("newjtd".equals(afterDoOperationEventArgs.getOperateKey()) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String entityId = ((Donothing)afterDoOperationEventArgs.getSource()).getEntityId();
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            List isHz = operationResult.getValidateResult().getValidateErrors("isHz");
            if (!isHz.isEmpty()) {
                this.getView().showTipNotification(((ValidateResult)isHz.get(0)).getMessage());
            }
            StringBuilder successMessage = new StringBuilder();
            StringBuilder failMessage = new StringBuilder();
            this.getLogResultMessage(operationResult, successMessage, failMessage);
            String operateName = ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"DraftQueryListPlugin_5", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            StringBuilder resultMessage = new StringBuilder();
            if (failMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s\u751f\u6210\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"DraftQueryListPlugin_6", (String)"taxc-bdtaxr", (Object[])new Object[0]), failMessage));
            }
            if (successMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801: %s\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"DraftQueryListPlugin_7", (String)"taxc-bdtaxr", (Object[])new Object[0]), successMessage));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd") && operationResult.getBillCount() == operationResult.getSuccessPkIds().size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"DraftQueryListPlugin_8", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            OperatorDialogUtils.operateDialog((String)taxtype, (String)entityId, (String)operateName, (String)resultMessage.toString());
            billlist.refresh();
        } else if ("deletejtd".equals(operateKey) && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            String entityId = ((Donothing)afterDoOperationEventArgs.getSource()).getEntityId();
            String operateName = ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"DraftQueryListPlugin_9", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            StringBuilder successMessage = new StringBuilder();
            StringBuilder failMessage = new StringBuilder();
            this.getLogResultMessage(operationResult, successMessage, failMessage);
            StringBuilder resultMessage = new StringBuilder();
            if (failMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801\uff1a%s\u5220\u9664\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"DraftQueryListPlugin_10", (String)"taxc-bdtaxr", (Object[])new Object[0]), failMessage));
            }
            if (successMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u7801: %s\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"DraftQueryListPlugin_11", (String)"taxc-bdtaxr", (Object[])new Object[0]), successMessage));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd") && operationResult.getBillCount() == operationResult.getSuccessPkIds().size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"DraftQueryListPlugin_12", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            }
            OperatorDialogUtils.operateDialog((String)taxtype, (String)entityId, (String)operateName, (String)resultMessage.toString());
            billlist.refresh();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"checkjtd")) {
            String entityId = ((Donothing)afterDoOperationEventArgs.getSource()).getEntityId();
            Map billNosMap = afterDoOperationEventArgs.getOperationResult().getBillNos();
            Collection billNos = billNosMap.values();
            ArrayList resultbillNos = new ArrayList(billNos);
            List ids = afterDoOperationEventArgs.getOperationResult().getSuccessPkIds();
            String operateName = ResManager.loadKDString((String)"\u67e5\u770b\u8ba1\u63d0\u5355", (String)"DraftQueryListPlugin_13", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            if (ObjectUtils.isNotEmpty((Object)ids)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityId, (String)"billno,org.id ,taxsystem.id,templatetype");
                this.openProvistonBillPage(dynamicObject.getString("org.id"), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("billno"));
                String billEntity = dynamicObject.getDataEntityType().getName();
                if (resultbillNos.size() > 0) {
                    String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"DraftQueryListPlugin_14", (String)"taxc-bdtaxr", (Object[])new Object[0]), resultbillNos.get(0));
                    OperatorDialogUtils.operateDialog((String)taxtype, (String)billEntity, (String)operateName, (String)operateDescription);
                }
            } else if (resultbillNos.size() > 0) {
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u7801:%s\u67e5\u770b\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"DraftQueryListPlugin_15", (String)"taxc-bdtaxr", (Object[])new Object[0]), resultbillNos.get(0));
                OperatorDialogUtils.operateDialog((String)this.getTemplateTypeList().get(0), (String)entityId, (String)operateName, (String)operateDescription);
            }
        }
    }

    private void sendDraftMQ(OperationResult operationResult, String operateKey) {
        List successPkIds;
        String billFormId = ((ListShowParameter)this.getView().getFormShowParameter()).getBillFormId();
        if (operationResult != null && OPERATEKEYS_TO_MQ.contains(operateKey) && FORMID_TO_MQ.contains(billFormId) && EmptyCheckUtils.isNotEmpty((Object)(successPkIds = operationResult.getSuccessPkIds()))) {
            DynamicObject[] load = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(new Object[successPkIds.size()]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"tctb_draft_main"));
            DraftMQSender.sendMQ(Arrays.stream(load).collect(Collectors.toList()), (String)DeclareMQType.DRAFT.name(), (String)operateKey);
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("templatetype");
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                String templatetype = valueList.get(0).toString();
                this.getPageCache().put("templatetype", templatetype);
                FilterContainer control = (FilterContainer)this.getControl("filtercontainerap");
                control.getContext().setEntryEntity("entryentity");
                if ("draft_zzsxgmnsr".equals(templatetype) || "draft_zzsxgmnsr_sjjt".equals(templatetype)) {
                    control.getContext().setEntryEntity("xgmnsrentryentity");
                }
                if (!"draft_zzsybnsr_ybhz".equals(templatetype) && !"draft_zzsybnsr_hz_zjg".equals(templatetype) && !"draft_zzsybnsr_yz_zjg".equals(templatetype) && !"draft_zzsybnsr_yz_fzjg".equals(templatetype) && !"draft_zzsybnsr_ybhz_sjjt".equals(templatetype) && !"draft_zzsybnsr_hz_zjg_sjjt".equals(templatetype) && !"draft_zzsybnsr_yz_zjg_sjjt".equals(templatetype) && !"draft_zzsybnsr_yz_fzjg_Sjjt".equals(templatetype)) continue;
                control.getContext().setEntryEntity("ybhzentryentity");
            }
        }
        super.filterContainerSearchClick(args);
        if (this.beforeCreateListColumnsArgs != null) {
            ListViewPluginProxy formViewPluginProxy = (ListViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            formViewPluginProxy.fireBeforeCreateListColumns(this.beforeCreateListColumnsArgs);
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        String appId = this.getView().getFormShowParameter().getAppId();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String draftpurpose = customParams.getOrDefault("draftpurpose", "nssb");
        this.beforeCreateListColumnsArgs = args;
        List<Object> list = args.getListColumns().subList(0, 7);
        String templateType = this.getPageCache().get("templatetype");
        List<Object> fieldList = new ArrayList();
        switch (templateType) {
            case "draft_zzsxgmnsr": 
            case "draft_zzsxgmnsr_sjjt": {
                fieldList = MetadataUtil.getEntityById((String)"tcvat_dg_xgmnsr").getFieldList();
                fieldList = fieldList.stream().filter(f -> f.getFieldId().startsWith("xgmnsr")).collect(Collectors.toList());
                break;
            }
            case "draft_zzsybnsr": 
            case "draft_zzsybnsr_sjjt": {
                fieldList = MetadataUtil.getEntityById((String)"tcvat_dg_ybnsr").getFieldList();
                fieldList = fieldList.stream().filter(f -> f.getFieldType().equals("Decimal") && !f.getFieldId().equals("jyffynse")).collect(Collectors.toList());
                break;
            }
            case "draft_zzsybnsr_ybhz": 
            case "draft_zzsybnsr_ybhz_sjjt": 
            case "draft_zzsybnsr_hz_zjg": 
            case "draft_zzsybnsr_hz_zjg_sjjt": 
            case "draft_zzsybnsr_yz_zjg": 
            case "draft_zzsybnsr_yz_zjg_sjjt": 
            case "draft_zzsybnsr_yz_fzjg": 
            case "draft_zzsybnsr_yz_fzjg_Sjjt": {
                fieldList = MetadataUtil.getEntityById((String)"tcvat_dg_ybnsr_ybhz").getFieldList();
                fieldList = fieldList.stream().filter(f -> f.getFieldId().startsWith("ybhz") && !f.getFieldId().equals("ybhzjyffynse")).collect(Collectors.toList());
                break;
            }
            case "draft_qysdsjb": {
                if (!"nssb".equals(draftpurpose)) break;
                list.removeIf(s -> s.getListFieldKey().equals("businessdocno"));
            }
        }
        if (fieldList.size() > 0) {
            for (int i = 0; i < fieldList.size(); ++i) {
                list.add(this.createListColumn(((EntityField)fieldList.get(i)).getFieldId(), ((EntityField)fieldList.get(i)).getFieldName(), i + 1));
            }
            if ("tcvat".equals(appId)) {
                List<String> keys = Arrays.asList("deadline", "riskcontent");
                for (String key : keys) {
                    if (args.getListColumn(key) == null) continue;
                    list.add(args.getListColumn(key));
                }
            }
            list.add(args.getListColumn("modifier.name"));
            list.add(args.getListColumn("modifytime"));
            list.add(args.getListColumn("ismodified"));
            if ("tcvat".equals(appId) && "sjjt".equals(draftpurpose)) {
                list.add(args.getListColumn("generatebusinessdoc"));
            }
            args.setListColumns(list);
        }
    }

    private ListColumn createListColumn(String key, String caption, int colIndex) {
        DecimalListColumn col = new DecimalListColumn();
        col.setZeroShow(true);
        col.setCaption(new LocaleString(caption));
        col.setKey(key);
        col.setListFieldKey(key);
        col.setFieldName(key);
        col.setSeq(colIndex);
        col.setVisible(11);
        return col;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
        String entityId = list.getEntityId();
        String fieldName = args.getFieldName();
        if ("tccit_sjjt_list".equals(entityId) && "businessdocno".equals(fieldName)) {
            this.openJtProvistonPage(list);
        } else if (("tccit_sjjt_list".equals(entityId) || "tcvat_sjjt_draft_query".equals(entityId)) && "billno".equals(fieldName)) {
            this.openAccrualPage(list);
        } else if ("riskcontent".equals(args.getFieldName())) {
            ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
            DraftService.showRiskDialog((String)currentSelectedRowInfo.getPrimaryKeyValue().toString(), (String)entityId, (IFormView)this.getView());
        } else {
            this.openDraftPageOrDeclarePage(list, true);
        }
    }

    private void openJtProvistonPage(BillList list) {
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tpo_declare_main_tsd");
        String jtnumber = object.getString("businessdocno");
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)ITP_PROVISTON_TAXES, (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)jtnumber)});
        if (dynamicObject == null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u91d1\u8ba1\u63d0\u5355\u4e0d\u5b58\u5728\u6216\u5df2\u7ecf\u5220\u9664\u3002", (String)"DraftQueryListPlugin_16", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        Long pkId = dynamicObject.getLong("id");
        PageShowCommon.showBill((ShowType)ShowType.MainNewTabPage, (String)ITP_PROVISTON_TAXES, (Object)pkId, (IFormView)this.getView(), (Map)this.getView().getFormShowParameter().getCustomParams(), (BillOperationStatus)BillOperationStatus.EDIT);
    }

    private void openAccrualPage(BillList list) {
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tpo_declare_main_tsd");
        String templatetype = object.getString("templatetype_id");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
        customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
        LOGGER.info("openAccrualPage templatetype:{},name:{}", (Object)templatetype, (Object)object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        customParams.put("templatetype", templatetype);
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("draftpurpose", object.getString("draftpurpose"));
        customParams.put("mainPkId", object.getLong("id"));
        TemplateEnum draftEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
        FormShowParameter param = new FormShowParameter();
        param.setStatus(OperationStatus.EDIT);
        param.setFormId(draftEnum.getDraftPage());
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        param.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"DraftQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        this.getView().showForm(param);
    }

    private void openDraftPageOrDeclarePage(BillList list, boolean openDraftPage) {
        ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)currentSelectedRowInfo.getPrimaryKeyValue(), (String)"tctb_draft_main");
        String templatetype = object.getString("templatetype");
        HashMap<String, String> customParams = new HashMap<String, String>(4);
        customParams.put(ORGID_KEY, object.getDynamicObject("org").getString("id"));
        customParams.put(ORGNAME_KEY, object.getDynamicObject("org").getString("name"));
        Date skssqq = object.getDate("startdate");
        Date skssqz = object.getDate("enddate");
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("draftpurpose", object.getString("draftpurpose"));
        TemplateEnum draftEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
        FormShowParameter param = new FormShowParameter();
        if (openDraftPage) {
            param.setFormId(draftEnum.getDraftPage());
        } else {
            customParams.put("refresh", "true");
            param.setFormId(draftEnum.getDeclarePage());
        }
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("sjjt".equals(object.getString("draftpurpose"))) {
            param.setCaption(ResManager.loadKDString((String)"\u8ba1\u63d0\u5e95\u7a3f\u7f16\u5236", (String)"DraftQueryListPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
        }
        this.getView().showForm(param);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("templatetype".equals(columnDesc.getKey())) {
            String templatetype = data.getString("templatetype");
            e.setFormatValue((Object)TemplateTypeConstant.getNsrtypemap().getOrDefault(templatetype, ""));
        } else if ("riskcontent".equals(columnDesc.getKey())) {
            if ("normal".equals(e.getFormatValue())) {
                e.getNoLinkKey().add("riskcontent");
            }
        } else if ("startdate".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("startdate"), (Date)data.getDate("enddate"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        } else if ("skssqq".equals(columnDesc.getKey())) {
            String date = DateUtils.getStartToEndDate((Date)data.getDate("skssqq"), (Date)data.getDate("skssqz"), (String)InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId()));
            e.setFormatValue((Object)date);
        }
    }

    private List<String> getTemplateTypeList() {
        String draftType;
        DraftTypeEnum taxTypeEnum;
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appId = (String)this.getView().getFormShowParameter().getCustomParam("appid");
        LOGGER.info("DraftQueryListPlugin --- system_appid: {}", (Object)appId);
        if (EmptyCheckUtils.isEmpty((Object)appId)) {
            appId = formShowParameter.getAppId();
            LOGGER.info("DraftQueryListPlugin --- custom_appid: {}", (Object)appId);
        }
        if ((taxTypeEnum = DraftTypeEnum.valueOfAppId((String)appId, (String)(draftType = (String)formShowParameter.getCustomParam("drafttype")))) != null) {
            return Stream.of(taxTypeEnum.getTemplates()).collect(Collectors.toList());
        }
        if ("itp".equals(appId) && "qysdsjb".equals(draftType)) {
            return Stream.of(DraftTypeEnum.valueOfAppId((String)"tccit", (String)"qysdsjb").getTemplates()).collect(Collectors.toList());
        }
        if ("tcvat".equals(appId)) {
            String draftpurpose = formShowParameter.getCustomParams().getOrDefault("draftpurpose", "nssb");
            return Stream.of(DraftTypeEnum.valueOfAppId((String)appId, (String)draftpurpose).getTemplates()).collect(Collectors.toList());
        }
        return new ArrayList<String>(TemplateTypeConstant.getNsrtypemap().keySet());
    }

    private void showDraftPage(String type, FormShowParameter param, Map<String, Object> customParams) {
        if (StringUtil.isEmpty((CharSequence)type)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7eb3\u7a0e\u4eba\u7c7b\u578b\u3002", (String)"DraftQueryListPlugin_17", (String)"taxc-bdtaxr", (Object[])new Object[0]));
            return;
        }
        TemplateEnum draftEnum = TemplateEnum.getEnumByDraftType((String)type);
        param.setFormId(draftEnum.getDraftPage());
        param.setCustomParams(customParams);
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(param);
    }

    private void getLogResultMessage(OperationResult operationResult, StringBuilder successMessage, StringBuilder failMessage) {
        List successPkIds = operationResult.getSuccessPkIds();
        Map billNos = operationResult.getBillNos();
        Set entries = billNos.entrySet();
        for (Map.Entry entry : entries) {
            if (successPkIds.contains(Long.valueOf(entry.getKey().toString()))) {
                if (successMessage.length() > 0) {
                    successMessage.append(" ");
                }
                successMessage.append((String)entry.getValue());
                continue;
            }
            if (failMessage.length() > 0) {
                failMessage.append(" ");
            }
            failMessage.append((String)entry.getValue());
        }
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String draftBillNo) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String appid = formShowParameter.getAppId();
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId(ITP_PROVISTON_TAXES);
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        hashMap.put("appid", appid);
        hashMap.put("taxtype.number", formShowParameter.getCustomParams().get("taxtype.number"));
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

