/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.template;

import java.util.EventObject;
import java.util.HashMap;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.taxc.bdtaxr.common.enums.DynamicRowCheckTypeEnum;

public class DynamicRowCheckTypePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    public static final String ENTRY_ENTITY = "entryentity";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok"});
        EntryGrid grid = (EntryGrid)this.getControl(ENTRY_ENTITY);
        grid.addRowClickListener((RowClickEventListener)this);
    }

    public void afterCreateNewData(EventObject arg0) {
        IDataModel model = this.getModel();
        int row = 0;
        for (DynamicRowCheckTypeEnum type : DynamicRowCheckTypeEnum.values()) {
            model.batchCreateNewEntryRow(ENTRY_ENTITY, 1);
            model.setValue("ruletype", (Object)type.getId(), row);
            model.setValue("name", (Object)type.getName().loadKDString(), row);
            model.setValue("desc", (Object)type.getDesc().loadKDString(), row);
            ++row;
        }
    }

    public void click(EventObject evt) {
        String key = ((Control)evt.getSource()).getKey();
        if (key.equalsIgnoreCase("btnok")) {
            this.returnData();
        }
    }

    private void returnData() {
        AbstractGrid grid = (AbstractGrid)this.getView().getControl(ENTRY_ENTITY);
        int rowKey = grid.getEntryState().getFocusRow();
        if (rowKey >= 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            IDataModel model = this.getModel();
            map.put("ruletype", model.getValue("ruletype", rowKey));
            map.put("name", model.getValue("name", rowKey));
            this.getView().returnDataToParent(map);
            this.getView().close();
        }
    }

    public void entryRowClick(RowClickEvent arg0) {
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        if (ENTRY_ENTITY.equalsIgnoreCase(((Control)evt.getSource()).getKey())) {
            this.returnData();
        }
    }
}

