/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateRelationService;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.tree.TreeUtils;

public class TemplateRelationPlugin
extends AbstractFormPlugin {
    private static final String TEMPLATE_ID = "templateid";
    private static final String RE_TEMPLATE_ID = "re_templateid";
    private static final String TEMPLATE_NUM = "templatenum";
    private static final String RE_TEMPLATE_NUM = "re_templatenum";
    private static final String TEMPLATE_RELATION_ENTITY = "bdtaxr_tmp_relation";
    private static final String TEMPLATE_ENTITY_NAME = "bdtaxr_template";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"save"});
    }

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String templateId = (String)customParams.get(TEMPLATE_ID);
        String templateNum = (String)customParams.get(TEMPLATE_NUM);
        this.createCombo(TEMPLATE_ID, null);
        if (StringUtils.isNotBlank((CharSequence)templateId)) {
            Map map = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"templateList", Map.class);
            this.getModel().setValue(TEMPLATE_NUM, map.get(templateId));
            this.getModel().setValue(TEMPLATE_ID, (Object)templateId);
            this.getView().setEnable(Boolean.FALSE, new String[]{TEMPLATE_ID});
        }
        this.createCombo(RE_TEMPLATE_ID, templateId);
    }

    private void createCombo(String key, String excludeValue) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(key);
        QFilter qFilter1 = new QFilter("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)TEMPLATE_ENTITY_NAME, (String)"id,number", (QFilter[])new QFilter[]{qFilter1});
        if (EmptyCheckUtils.isNotEmpty((Object)dynamicObjects)) {
            ArrayList comboItemList = new ArrayList();
            HashMap map = new HashMap();
            Arrays.stream(dynamicObjects).forEach(v -> {
                String templateNum = v.getString("number");
                String templateId = v.getString("id");
                if (StringUtils.isBlank((CharSequence)excludeValue) || !excludeValue.equals(templateId)) {
                    comboItemList.add(new ComboItem(new LocaleString(templateNum), templateId));
                }
                map.put(templateId, templateNum);
            });
            TreeUtils.putCache((IPageCache)this.getPageCache(), (String)"templateList", map);
            comboEdit.setComboItems(comboItemList);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("save".equals(key)) {
            String templateId = (String)this.getModel().getValue(TEMPLATE_ID);
            String templateNum = (String)this.getModel().getValue(TEMPLATE_NUM);
            String reTemplateId = (String)this.getModel().getValue(RE_TEMPLATE_ID);
            String reTemplateNum = (String)this.getModel().getValue(RE_TEMPLATE_NUM);
            if (StringUtils.isBlank((CharSequence)templateId) || StringUtils.isBlank((CharSequence)reTemplateId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6709\u5fc5\u586b\u5b57\u6bb5\u672a\u5f55\u5165\uff0c\u8bf7\u8865\u5145\u5b8c\u6574!", (String)"TemplateRelationPlugin_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                return;
            }
            this.saveTempateRelation(templateId, reTemplateId, templateNum, reTemplateNum);
        }
    }

    private void saveTempateRelation(String templateId, String reTemplateId, String templateNum, String reTemplateNum) {
        DynamicObject dObj = TemplateRelationService.findTmpRelation((String)templateId, (String)reTemplateId);
        if (dObj == null) {
            dObj = BusinessDataServiceHelper.newDynamicObject((String)TEMPLATE_RELATION_ENTITY);
        }
        dObj.set(TEMPLATE_ID, (Object)templateId);
        dObj.set(TEMPLATE_NUM, (Object)templateNum);
        dObj.set(RE_TEMPLATE_ID, (Object)reTemplateId);
        dObj.set(RE_TEMPLATE_NUM, (Object)reTemplateNum);
        Object[] ids = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dObj});
        this.getModel().setDataChanged(false);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f", (String)"TemplateRelationPlugin_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), Integer.valueOf(3000));
        this.getView().close();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if (RE_TEMPLATE_ID.equals(name)) {
            Map map = (Map)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)"templateList", Map.class);
            String reTemplateId = (String)this.getModel().getValue(RE_TEMPLATE_ID);
            this.getModel().setValue(RE_TEMPLATE_NUM, map.get(reTemplateId));
        }
    }
}

