/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.upgradeservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.PayDateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;

public class PayRecordPayDateUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_UPDATE_DATA = "select fid,fnsrtype,fssbbid from t_bdtaxr_pay_record where fdeadline is null";
    private static final String UPDATE_PAY_RECORD = "update t_bdtaxr_pay_record set fdeadline = ? where fid  = ?;";
    private static final Log LOGGER = LogFactory.getLog(PayRecordPayDateUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u7f34\u6b3e\u622a\u6b62\u65e5\u671f\u5386\u53f2\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"PayRecordPayDateUpgradeService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        try {
            this.update();
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        Date paydate = null;
        List payList = DBUtils.query((String)QUERY_UPDATE_DATA);
        if (CollectionUtils.isEmpty((Collection)payList)) {
            return;
        }
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(payList.size());
        for (Map payMap : payList) {
            DynamicObject nsrxx;
            DynamicObject taxauthority;
            Long nsrxxid;
            boolean exists;
            String fssbbid = (String)payMap.get("FSSBBID");
            if (fssbbid.isEmpty() || "null".equals(fssbbid) || !(exists = QueryServiceHelper.exists((String)"tcvat_nsrxx", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)(nsrxxid = Long.valueOf(Long.parseLong(fssbbid))))})) || null == (taxauthority = (nsrxx = BusinessDataServiceHelper.loadSingle((String)"tcvat_nsrxx", (String)"taxauthority,declaredate,skssqz", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)nsrxxid)})).getDynamicObject("taxauthority"))) continue;
            Long taxauthorityId = taxauthority.getLong("id");
            Date declaredate = nsrxx.getDate("declaredate");
            String sbbtype = (String)payMap.get("FNSRTYPE");
            Date skssqz = nsrxx.getDate("skssqz");
            paydate = PayDateUtils.getPayDate((Date)declaredate, (Long)taxauthorityId, (String)sbbtype, (Date)skssqz);
            long id = Long.parseLong(String.valueOf(payMap.get("FID")));
            paramsList.add(new Object[]{paydate, id});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_PAY_RECORD, paramsList);
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

