/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.formplugin.upgradeservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.upgrade.AbstractUpgradeFormPlugin;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.declare.PayRecordQueryListPlugin;

public class PayRecordUpgradeService
extends AbstractUpgradeFormPlugin {
    private static final String QUERY_UPDATE_DATA = "select fid,fssbbid,ftaxtype,fsbbentryid from t_bdtaxr_pay_record where forgid = 0 or forgid is null;";
    private static final String UPDATE_PAY_RECORD = "update t_bdtaxr_pay_record set forgid = ?,fskssqq = ?,fskssqz = ?,fsssq = ?,fnsrtype = ?,fbillstatus = ?,ftaxauthority = ? where fid  = ?;";
    private static final Log LOGGER = LogFactory.getLog(PayRecordUpgradeService.class);

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String log;
        UpgradeResult result = new UpgradeResult();
        boolean success = true;
        String info = log = ResManager.loadKDString((String)"\u7f34\u6b3e\u8bb0\u5f55\u6570\u636e\u5347\u7ea7\u6210\u529f", (String)"PayRecordUpgradeService_0", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        try {
            boolean exit = DB.exitsTable((DBRoute)DBRoute.of((String)"taxc"), (String)"t_bdtaxr_pay_record");
            if (exit) {
                this.update();
            } else {
                info = log = ResManager.loadKDString((String)"\u65e0\u9700\u5347\u7ea7\u7f34\u6b3e\u8bb0\u5f55\u6570\u636e", (String)"PayRecordUpgradeService_1", (String)"taxc-bdtaxr", (Object[])new Object[0]);
            }
        }
        catch (Exception var9) {
            success = false;
            log = this.currentData + '\n' + ERROR_INFO + '\n';
            info = this.currentData + '\n' + this.getStackTraceMessage(var9);
            LOGGER.error(ERROR_INFO, (Throwable)var9);
        }
        result.setLog(log);
        result.setSuccess(success);
        result.setEl("");
        result.setErrorInfo(info);
        return result;
    }

    public void update() {
        List payList = DBUtils.query((String)QUERY_UPDATE_DATA);
        if (CollectionUtils.isEmpty((Collection)payList)) {
            return;
        }
        QFilter idFilter = new QFilter("id", "in", payList.stream().map(p -> this.parseLong(String.valueOf(p.get("FSSBBID")))).collect(Collectors.toList()));
        QFilter nxxNsrsbhFilter = new QFilter("nsrsbh", "!=", (Object)"").and(new QFilter("nsrsbh", "!=", (Object)" ")).and(QFilter.isNotNull((String)"nsrsbh"));
        DynamicObject[] nsrArray = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)"id,org,skssqq,skssqz,type,nsrsbh", (QFilter[])new QFilter[]{idFilter, nxxNsrsbhFilter});
        DynamicObjectCollection nsrCollect = new DynamicObjectCollection();
        Collections.addAll(nsrCollect, nsrArray);
        if (CollectionUtils.isEmpty((Collection)nsrCollect)) {
            return;
        }
        QFilter nsrsbhFilter = new QFilter("taxorg.unifiedsocialcode", "in", nsrCollect.stream().map(nsr -> nsr.get("nsrsbh")).collect(Collectors.toList()));
        DynamicObject[] taxofficeCollect = BusinessDataServiceHelper.load((String)"tctb_tax_main", (String)"id,taxorg.unifiedsocialcode,taxoffice", (QFilter[])new QFilter[]{nsrsbhFilter});
        Map<String, Object> nsrsbhMap = Arrays.asList(taxofficeCollect).stream().filter(t -> StringUtil.isNotBlank((CharSequence)t.getString("taxorg.unifiedsocialcode"))).collect(Collectors.groupingBy(t -> t.getString("taxorg.unifiedsocialcode"), Collectors.reducing(null, (m, n) -> n)));
        QFilter entryIdFilter = new QFilter("id", "in", payList.stream().filter(p -> !String.valueOf(p.get("FTAXTYPE")).equals("szys") && this.parseLong(String.valueOf(p.get("FSBBENTRYID"))) != 0L && PayRecordQueryListPlugin.TCRET_TAXTYPE.contains(String.valueOf(p.get("FTAXTYPE")))).map(p -> p.get("fsbbentryid")).collect(Collectors.toList()));
        DynamicObjectCollection zbCollect = QueryServiceHelper.query((String)"tcret_ccxws_zb_hb", (String)"id,sbbid,taxtype,startdate,enddate", (QFilter[])new QFilter[]{entryIdFilter});
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(payList.size());
        for (Map payMap : payList) {
            Optional<DynamicObject> zbOptional;
            long fsbbid = this.parseLong(String.valueOf(payMap.get("FSSBBID")));
            long fsbbentryid = this.parseLong(String.valueOf(payMap.get("FSBBENTRYID")));
            String ftaxtype = String.valueOf(payMap.get("FTAXTYPE"));
            Optional<DynamicObject> optional = nsrCollect.stream().filter(n -> fsbbid == n.getLong("id")).findFirst();
            if (!optional.isPresent()) continue;
            DynamicObject nsr2 = optional.get();
            Date skssqq = nsr2.getDate("skssqq");
            Date skssqz = nsr2.getDate("skssqz");
            if (!ftaxtype.equals("szys") && fsbbentryid != 0L && PayRecordQueryListPlugin.TCRET_TAXTYPE.contains(ftaxtype) && (zbOptional = zbCollect.stream().filter(n -> fsbbentryid == n.getLong("id")).findFirst()).isPresent()) {
                DynamicObject zbObj = zbOptional.get();
                skssqq = zbObj.getDate("startdate");
                skssqz = zbObj.getDate("enddate");
            }
            String skssqqStr = DateUtils.format((Date)skssqq, (String)DateUtils.YYYYMMDD_CHINESE);
            String skssqzStr = DateUtils.format((Date)skssqz, (String)DateUtils.YYYYMMDD_CHINESE);
            DynamicObject org = nsr2.getDynamicObject("org");
            DynamicObject taxMain = nsrsbhMap.get(nsr2.getString("nsrsbh"));
            if (org == null || taxMain == null || taxMain.getDynamicObject("taxoffice") == null) continue;
            paramsList.add(new Object[]{org.getLong("id"), skssqq, skssqz, skssqqStr.concat("-").concat(skssqzStr), nsr2.get("type"), "C", taxMain.getDynamicObject("taxoffice").getLong("id"), payMap.get("FID")});
        }
        if (CollectionUtils.isEmpty(paramsList)) {
            return;
        }
        DBUtils.executeBatch((String)UPDATE_PAY_RECORD, paramsList);
    }

    private long parseLong(Object id) {
        try {
            return Long.parseLong(String.valueOf(id));
        }
        catch (Exception e) {
            LOGGER.error("PayRecordUpgradeService parse id:{0} error", id);
            LOGGER.error((Throwable)e);
            return 0L;
        }
    }

    protected IUpgradeService getService() {
        return this;
    }

    protected Log getLogger() {
        return LOGGER;
    }
}

