/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declare;

import java.util.Arrays;
import java.util.Date;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;

public class DraftNeedAuditDeclareOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("skssqq");
        e.getFieldKeys().add("skssqz");
        e.getFieldKeys().add("type");
        e.getFieldKeys().add("datatype");
        e.getFieldKeys().add("billstatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey = this.getOperateKey();
                if ("submit".equals(operateKey)) {
                    OperateOption option = this.getOption();
                    if (option.containsVariable("sbbid")) {
                        DynamicObject sbb = YbnsrServiceHelper.queryYbnsrWithId((String)option.getVariableValue("sbbid"));
                        long orgId = sbb.getLong("org");
                        String type = sbb.getString("type");
                        String appId = this.getAppId(type);
                        boolean draftneedaudit = SystemParamUtil.getZeroDeclareParameter((String)appId, (String)"draftneedaudit", (long)orgId);
                        if ("A".equals(sbb.getString("billstatus")) && draftneedaudit) {
                            this.checkDraftStatus(this.dataEntities[0], orgId, sbb.getDate("skssqq"), sbb.getDate("skssqz"), type, sbb.getString("datatype"));
                        }
                    } else {
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            DynamicObject dynamicObject = dataEntity.getDataEntity();
                            DynamicObject org = dynamicObject.getDynamicObject("org");
                            String declaretype = dynamicObject.getString("type");
                            String appId = this.getAppId(declaretype);
                            boolean draftneedaudit = SystemParamUtil.getZeroDeclareParameter((String)appId, (String)"draftneedaudit", (long)org.getLong("id"));
                            if (!"A".equals(dynamicObject.getString("billstatus")) || !draftneedaudit) continue;
                            this.checkDraftStatus(dataEntity, org.getLong("id"), dynamicObject.getDate("skssqq"), dynamicObject.getDate("skssqz"), declaretype, dynamicObject.getString("datatype"));
                        }
                    }
                }
            }

            private String getAppId(String declareType) {
                String appId = DraftNeedAuditDeclareOp.this.billEntityType.getAppId();
                if ("tam".equals(appId) && (appId = Arrays.stream(TaxTypeEnum.values()).filter(e -> Arrays.asList(e.getTemplates()).contains(declareType) && !"tam".equals(e.getAppId()) && !"tsate".equals(e.getAppId())).map(TaxTypeEnum::getAppId).findFirst().orElse(appId)).contains("_")) {
                    appId = appId.substring(0, appId.indexOf("_"));
                }
                return appId;
            }

            private void checkDraftStatus(ExtendedDataEntity dataEntity, Long orgId, Date skssqq, Date skssqz, String declaretype, String datatype) {
                TemplateEnum templateEnum = TemplateEnum.getEnumByDeclareType((String)declaretype);
                DynamicObject draft = QueryServiceHelper.queryOne((String)"tctb_draft_main", (String)"billstatus", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("startdate", "=", (Object)skssqq), new QFilter("enddate", "=", (Object)skssqz), new QFilter("templatetype", "=", (Object)templateEnum.getDraftType())});
                if (draft != null && !"C".equals(draft.getString("billstatus"))) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5e95\u7a3f\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u63d0\u4ea4\u7533\u62a5\u8868", (String)"DraftNeedAuditDeclareOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                } else if (draft == null && "1".equals(datatype)) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u65b0\u589e\u7533\u62a5\u5e95\u7a3f\u5e76\u5b8c\u6210\u5ba1\u6838\uff0c\u518d\u63d0\u4ea4\u7533\u62a5\u8868", (String)"DraftNeedAuditDeclareOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                }
            }
        });
    }
}

