/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declare;

import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.business.multidideclare.DeclareReportHelpService;
import kd.taxc.bdtaxr.business.service.taxdeclare.DeclareRequestService;
import kd.taxc.bdtaxr.business.service.taxdeclare.SavetaxDeclareService;
import kd.taxc.bdtaxr.business.service.taxdeclare.TaxDeclareDataService;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.DeclareRequestServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.SavetaxDeclareServiceImpl;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.common.declare.helper.TemplateFormulaServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.refactor.template.TemplateUtils;
import kd.taxc.bdtaxr.common.taxdeclare.enums.DraftTypeEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.util.param.SystemParamUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;

public class DraftNeedAuditOp
extends AbstractOperationServicePlugIn {
    private DeclareRequestService declareRequestService = new DeclareRequestServiceImpl();
    private static TaxDeclareDataService taxDeclareDataService = new TaxDeclareDataServiceImpl();
    private static SavetaxDeclareService savetaxDeclareService = new SavetaxDeclareServiceImpl();

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("startdate");
        e.getFieldKeys().add("enddate");
        e.getFieldKeys().add("templatetype");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                block3: {
                    String operateKey;
                    block2: {
                        operateKey = this.getOperateKey();
                        if (!"submit".equals(operateKey)) break block2;
                        for (ExtendedDataEntity dataEntity : this.dataEntities) {
                            DynamicObject dynamicObject = dataEntity.getDataEntity();
                            DynamicObject org = dynamicObject.getDynamicObject("org");
                            String templatetype = dynamicObject.getString("templatetype");
                            String appId = DraftNeedAuditOp.this.getAppId(templatetype);
                            boolean draftneedaudit = SystemParamUtil.getZeroDeclareParameter((String)appId, (String)"draftneedaudit", (long)org.getLong("id"));
                            if (!draftneedaudit) continue;
                            TemplateEnum templateEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
                            DynamicObject sbb = YbnsrServiceHelper.queryYbnsrWithEx((String)org.getString("id"), (String)templateEnum.getDeclareType(), (String)DateUtils.format((Date)dynamicObject.getDate("startdate")), (String)DateUtils.format((Date)dynamicObject.getDate("enddate")), Collections.emptyMap());
                            if (sbb == null || "A".equals(sbb.getString("billstatus"))) continue;
                            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u63d0\u4ea4/\u5df2\u5ba1\u6838\uff0c\u4e0d\u5f97\u4fee\u6539\u5e95\u7a3f\u6570\u636e", (String)"DraftNeedAuditOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                        }
                        break block3;
                    }
                    if (!"unaudit".equals(operateKey)) break block3;
                    for (ExtendedDataEntity dataEntity : this.dataEntities) {
                        DynamicObject dynamicObject = dataEntity.getDataEntity();
                        DynamicObject org = dynamicObject.getDynamicObject("org");
                        String templatetype = dynamicObject.getString("templatetype");
                        String appId = DraftNeedAuditOp.this.getAppId(templatetype);
                        boolean draftneedaudit = SystemParamUtil.getZeroDeclareParameter((String)appId, (String)"draftneedaudit", (long)org.getLong("id"));
                        if (!draftneedaudit) continue;
                        TemplateEnum templateEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
                        DynamicObject sbb = YbnsrServiceHelper.queryYbnsrWithEx((String)org.getString("id"), (String)templateEnum.getDeclareType(), (String)DateUtils.format((Date)dynamicObject.getDate("startdate")), (String)DateUtils.format((Date)dynamicObject.getDate("enddate")), Collections.emptyMap());
                        if (sbb == null || "A".equals(sbb.getString("billstatus"))) continue;
                        this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7533\u62a5\u8868\u5df2\u63d0\u4ea4/\u5df2\u5ba1\u6838\uff0c\u5e95\u7a3f\u4e0d\u5f97\u53cd\u5ba1\u6838", (String)"DraftNeedAuditOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public String getAppId(String templatetype) {
        String appId = this.billEntityType.getAppId();
        if ("tam".equals(appId)) {
            appId = Arrays.stream(DraftTypeEnum.values()).filter(e -> Arrays.asList(e.getTemplates()).contains(templatetype) && !"tam".equals(e.getAppId())).map(DraftTypeEnum::getAppId).findFirst().orElse(appId);
        }
        return appId;
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        if ("submit".equals(operationKey)) {
            HashMap<Long, String> templateIdNumberMap = new HashMap<Long, String>();
            for (DynamicObject dynamicObject : args.getDataEntities()) {
                DynamicObject template;
                String templateNumber;
                DynamicObject org = dynamicObject.getDynamicObject("org");
                String templatetype = dynamicObject.getString("templatetype");
                String appId = this.getAppId(templatetype);
                boolean draftneedaudit = SystemParamUtil.getZeroDeclareParameter((String)appId, (String)"draftneedaudit", (long)org.getLong("id"));
                if (!draftneedaudit) continue;
                TemplateEnum templateEnum = TemplateEnum.getEnumByDraftType((String)templatetype);
                String startdate = DateUtils.format((Date)dynamicObject.getDate("startdate"));
                String enddate = DateUtils.format((Date)dynamicObject.getDate("enddate"));
                DynamicObject sbb = YbnsrServiceHelper.queryYbnsrWithEx((String)org.getString("id"), (String)templateEnum.getDeclareType(), (String)startdate, (String)enddate, Collections.emptyMap());
                if (sbb == null || !"A".equals(sbb.getString("billstatus"))) continue;
                DeclareRequestModel requestModel = new DeclareRequestModel();
                requestModel.setBillNo(sbb.getString("billno"));
                requestModel.setId(Long.valueOf(sbb.getLong("id")));
                requestModel.setOrgId(Long.valueOf(org.getLong("id")));
                requestModel.setTemplateType(sbb.getString("type"));
                requestModel.setOperation("edit");
                requestModel.setSkssqq(startdate);
                requestModel.setSkssqz(enddate);
                requestModel.setRefresh(Boolean.TRUE);
                long templateid = sbb.getLong("templateid");
                if (templateid == 0L) {
                    TemplateVo templateVo = TaxDeclarePluginService.getTemplateVo(requestModel, Boolean.FALSE);
                    templateid = templateVo.getTemplateId();
                    templateNumber = templateVo.getTemplateNumber();
                    templateIdNumberMap.put(templateid, templateNumber);
                }
                requestModel.setTemplateId(Long.valueOf(templateid));
                templateNumber = (String)templateIdNumberMap.get(templateid);
                if (StringUtils.isBlank((CharSequence)templateNumber) && templateid > 0L && (template = TemplateUtils.getTemplateObjectById((String)String.valueOf(templateid))) != null) {
                    templateNumber = template.getString("number");
                    templateIdNumberMap.put(templateid, templateNumber);
                }
                requestModel.setTemplateNumber(templateNumber);
                requestModel.getBusinessMap().put("taxPayerType", templateEnum.getDeclareType());
                requestModel = this.declareRequestService.build(SerializationUtils.toJsonString((Object)requestModel));
                Map metaMap = TemplateFormulaServiceHelper.getMetaDataListByTmpId((Long)templateid);
                requestModel.setMetaDataMap(metaMap);
                Map<String, EntityField> typeMap = DeclareReportHelpService.getEntityFieldsByMetadata(requestModel, null);
                DeclareResponseModel responseModel = taxDeclareDataService.refreshData(requestModel, typeMap);
                savetaxDeclareService.saveTaxDeclare(sbb.getString("id"), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), requestModel, responseModel, responseModel.getData());
            }
        }
    }
}

