/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declarelist;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.TemplateEnum;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.taxdeclare.constant.TaxTypeEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.OrgUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class DeclareListApplyOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("apply".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            StringBuilder fzybhzMessage = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tcvat_nsrxx", (String)DeclareConstant.ENTITY_MAIN_ALL_FIELD_STRING, (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                for (DynamicObject declare : declares) {
                    QFilter sbbidFilter;
                    QFilter ewblxh;
                    DynamicObject taxObj;
                    DynamicObject org = declare.getDynamicObject("org");
                    String type = declare.getString("type");
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String billStatus = declare.getString("billstatus");
                    OrgUtils.getfzybqyMessage((String)type, (String)org.getString("id"), (String)DateUtils.format((Date)declare.getDate("skssqq")), (String)DateUtils.format((Date)declare.getDate("skssqz")), (StringBuilder)fzybhzMessage);
                    boolean zerodeclare = declare.getBoolean("zerodeclare");
                    if (!zerodeclare && "zzsybnsr".equals(type)) {
                        long orgId = org.getLong("id");
                        Date skssqqDate = declare.getDate("skssqq");
                        Date skssqzDate = declare.getDate("skssqz");
                        DynamicObject orgDeclarePlan = OrgUtils.getOrgDeclarePlan((Long)orgId, (Date)skssqqDate, (Date)skssqzDate);
                        if (orgDeclarePlan != null && "2".equals(orgDeclarePlan.getString("summaryway"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e3a\u589e\u503c\u7a0e\u6c47\u603b\u7533\u62a5\u5206\u914d\u6a21\u5f0f\u4e0b\u7684\u5206\u652f\u673a\u6784\uff0c\u7cfb\u7edf\u6839\u636e\u603b\u673a\u6784\u5206\u914d\u8868\u81ea\u52a8\u751f\u6210\u7a0e\u91d1\u7f34\u7eb3\u5355: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareListApplyOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                            continue;
                        }
                    }
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7533\u62a5\u8868\u624d\u80fd\u63d0\u4ea4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareListApplyOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"editing".equals(declare.getString("declarestatus")) && !"declarefailed".equals(declare.getString("declarestatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7533\u62a5\u72b6\u6001\u672a\u7533\u62a5\u6216\u7533\u62a5\u5931\u8d25\u72b6\u6001\u53ef\u786e\u8ba4\u7533\u62a5: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"DeclareListApplyOp_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    BigDecimal bqybtse = declare.getBigDecimal("bqybtse");
                    if (("szys_a".equals(type) || "szys_b".equals(type)) && (taxObj = QueryServiceHelper.queryOne((String)"tcwat_declare_a_tax", (String)"bqybtse", (QFilter[])new QFilter[]{ewblxh = new QFilter("ewblxh", "=", (Object)"sum"), sbbidFilter = new QFilter("sbbid", "=", (Object)declare.getString("id"))})) != null) {
                        bqybtse = taxObj.getBigDecimal("bqybtse");
                    }
                    this.setPayStatus(bqybtse, declare, this.billEntityType.getAppId());
                    declare.set("declarestatus", (Object)"declared");
                    declare.set("modifytime", (Object)new Date());
                    declare.set("modifier", (Object)RequestContext.get().getUserId());
                    declare.set("declaretype", (Object)"0");
                    declare.set("sbrq", (Object)new Date());
                    declare.set("declarer", (Object)RequestContext.get().getUserId());
                    modifyDynamicObjects.add(declare);
                    String billno = declare.getString("billno");
                    String nsrtype = declare.getString("type");
                    if (!StringUtils.trimToEmpty((String)nsrtype).startsWith("qysds")) continue;
                    OperatorDialogUtils.operateDialog((String)"qysds", (String)TemplateEnum.getEnumByDeclareType((String)nsrtype).getDeclarePage(), (String)ResManager.loadKDString((String)"\u786e\u8ba4\u7533\u62a5", (String)"DeclareListApplyOp_3", (String)"taxc-bdtaxr", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%s\u7684\u7533\u62a5\u8868\u786e\u8ba4\u7533\u62a5\u6210\u529f\u3002", (String)"DeclareListApplyOp_4", (String)"taxc-bdtaxr", (Object[])new Object[0]), billno));
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)message.toString())) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                if (StringUtils.isNotBlank((CharSequence)fzybhzMessage.toString())) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(String.valueOf(fzybhzMessage.insert(0, "fzybhz:")));
                    this.operationResult.setShowMessage(false);
                    return;
                }
                String appId = this.billEntityType.getAppId();
                if (!CollectionUtils.isEmpty(modifyDynamicObjects)) {
                    List sbbIds = modifyDynamicObjects.stream().filter(d -> !"nopay".equals(d.getString("paystatus"))).map(d -> d.getLong("id")).collect(Collectors.toList());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"DeferPayApplyService", (String)"manualDeclare", (Object[])new Object[]{sbbIds});
                    SaveServiceHelper.save((DynamicObject[])modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]));
                    for (DynamicObject modifyob : modifyDynamicObjects) {
                        DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)DeclareListApplyOp.getPayDate(modifyob), (String)DeclareMQType.PAY.name(), (String)operateKey);
                    }
                    this.doSaveZzsPrePayBill(modifyDynamicObjects);
                    this.operationResult.setSuccess(true);
                }
            }
        }
    }

    private void doSaveZzsPrePayBill(List<DynamicObject> modifyDynamicObjects) {
        List yjList = modifyDynamicObjects.stream().filter(m -> "zzsyjskb".equals(m.getString("type"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(yjList)) {
            DynamicObject[] yjObjs;
            for (DynamicObject yjObj : yjObjs = BusinessDataServiceHelper.load((String)"tcvat_prepay_declare_bill", (String)"id,declarer,sbrq,modifier,modifytime,declarestatus", (QFilter[])new QFilter[]{new QFilter("id", "in", yjList.stream().map(y -> y.getLong("id")).collect(Collectors.toList()))})) {
                yjObj.set("modifytime", (Object)new Date());
                yjObj.set("modifier", (Object)RequestContext.get().getUserId());
                yjObj.set("sbrq", (Object)new Date());
                yjObj.set("declarer", (Object)RequestContext.get().getUserId());
                yjObj.set("declarestatus", (Object)"declared");
            }
            SaveServiceHelper.save((DynamicObject[])yjObjs);
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }

    private void setPayStatus(BigDecimal bqybtse, DynamicObject declare, String appId) {
        String type = declare.getString("type");
        String declareAppId = this.getAppId(type, appId);
        if ("tcvat".equals(declareAppId) || "tccit".equals(declareAppId) || "szys_a".equals(type) || "szys_b".equals(type)) {
            if (BigDecimal.ONE.compareTo(bqybtse) >= 0) {
                declare.set("paystatus", (Object)"nopay");
            }
        } else if ("tcret".equals(declareAppId)) {
            DynamicObjectCollection entryentity = declare.getDynamicObjectCollection("entryentity");
            Map<String, List<DynamicObject>> taxtypeMap = entryentity.stream().collect(Collectors.groupingBy(o -> o.getString("taxtype")));
            boolean allLessOne = true;
            for (List<DynamicObject> datums : taxtypeMap.values()) {
                BigDecimal ybse = datums.stream().map(o -> o.getBigDecimal("ybse")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                allLessOne = allLessOne && BigDecimal.ONE.compareTo(ybse) >= 0;
            }
            if (allLessOne) {
                declare.set("paystatus", (Object)"nopay");
            }
        } else if (BigDecimal.ZERO.compareTo(bqybtse) >= 0) {
            declare.set("paystatus", (Object)"nopay");
        }
    }

    private String getAppId(String declareType, String appId) {
        if ("tam".equals(appId) && (appId = Arrays.stream(TaxTypeEnum.values()).filter(e -> Arrays.asList(e.getTemplates()).contains(declareType) && !"tam".equals(e.getAppId()) && !"tsate".equals(e.getAppId())).map(TaxTypeEnum::getAppId).findFirst().orElse(appId)).contains("_")) {
            appId = appId.substring(0, appId.indexOf("_"));
        }
        return appId;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])dataEntities, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)e.getOperationKey()));
    }
}

