/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declarelist;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.serviceImpl.taxdeclare.TaxDeclareDataServiceImpl;
import kd.taxc.bdtaxr.common.declare.helper.TaxBureauServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.ServiceInvokeUtils;

public class DeclareListRectifyOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(DeclareListRectifyOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("rectify".equals(operateKey)) {
            OperationResult unauditResult;
            String opreateType = "";
            try {
                opreateType = this.getOption().getVariableValue("msgInput");
            }
            catch (Exception exception) {
                // empty catch block
            }
            DynamicObject[] dataEntities = args.getDataEntities();
            Object pkValue = dataEntities[0].getPkValue();
            DynamicObject declares = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)"tcvat_nsrxx");
            String checkZfInfo = this.checkGzInfo(declares);
            if (checkZfInfo != null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(checkZfInfo);
                this.operationResult.setShowMessage(false);
                return;
            }
            String nsrtype = declares.getString("type");
            this.saveHisSbbInfo(declares, opreateType, nsrtype);
            declares.set("versiontype", (Object)"gzsb");
            if (!"ccxws".equals(nsrtype)) {
                declares.set("datatype", (Object)"1");
            }
            declares.set("declarestatus", (Object)"editing");
            declares.set("paystatus", (Object)"unpaid");
            declares.set("payer", (Object)0L);
            declares.set("paydate", null);
            declares.set("declarer", (Object)0L);
            declares.set("sbrq", null);
            declares.set("declaretype", null);
            declares.set("paytype", null);
            SaveServiceHelper.update((DynamicObject)declares);
            String entryentityId = dataEntities[0].getDataEntityType().getName();
            if ("ccxws".equals(nsrtype)) {
                unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)"tcret_query_report", (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
                ServiceInvokeUtils.invokeTaxcTcretService((String)"DraftWriteBackService", (String)"writeBackDeclareReportByField", (Object[])new Object[]{Collections.singletonList(pkValue)});
            } else {
                unauditResult = OperationServiceHelper.executeOperate((String)"unaudit", (String)entryentityId, (Object[])new Object[]{pkValue}, (OperateOption)OperateOption.create());
            }
            logger.info("DeclareListRectifyOp\u4e2dunaudit\u6267\u884c\u7ed3\u679c\u4e3a{}", (Object)SerializationUtils.toJsonString((Object)unauditResult));
            if (!unauditResult.isSuccess()) {
                throw new KDBizException(StringUtil.isBlank((CharSequence)unauditResult.getMessage()) ? ResManager.loadKDString((String)"\u66f4\u6b63\u7533\u62a5\u64cd\u4f5c\u5931\u8d25\uff0c\u64a4\u9500\u672a\u6210\u529f", (String)"DeclareListRectifyOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]) : unauditResult.getMessage());
            }
            QFilter voucherFilter = new QFilter("isvoucher", "=", (Object)"0");
            QFilter sbbidfilter = new QFilter("sbbid", "=", (Object)String.valueOf(pkValue));
            QFilter paystatusfilter = new QFilter("paystatus", "=", (Object)"2");
            DeleteServiceHelper.delete((String)"bdtaxr_pay_record", (QFilter[])new QFilter[]{sbbidfilter, voucherFilter, paystatusfilter});
        }
    }

    private String checkGzInfo(DynamicObject declares) {
        String declarestatus = declares.getString("declarestatus");
        if (!"declared".equals(declarestatus)) {
            return ResManager.loadKDString((String)"\u53ea\u6709\u201c\u7533\u62a5\u6210\u529f\u201d\u7684\u6570\u636e\uff0c\u624d\u80fd\u66f4\u6b63\u7533\u62a5", (String)"DeclareListRectifyOp_3", (String)"taxc-bdtaxr", (Object[])new Object[0]);
        }
        return null;
    }

    private void saveHisSbbInfo(DynamicObject declares, String opreateType, String nsrtype) {
        long orgid = ((DynamicObject)declares.get("org")).getLong("id");
        DeclareRequestModel requestModel = new DeclareRequestModel();
        requestModel.setOrgId(Long.valueOf(orgid));
        requestModel.setTemplateType(nsrtype);
        requestModel.setSkssqq(DateUtils.format((Date)declares.getDate("skssqq")));
        requestModel.setSkssqz(DateUtils.format((Date)declares.getDate("skssqz")));
        requestModel.setId(Long.valueOf(declares.getLong("id")));
        HashMap<String, Object> extendParams = new HashMap<String, Object>();
        extendParams.put("versiontype", declares.get("versiontype"));
        extendParams.put("causedesc", opreateType);
        requestModel.setExtendParams(extendParams);
        TaxDeclareDataServiceImpl taxDeclareDataService = new TaxDeclareDataServiceImpl();
        DeclareResponseModel responseModel = taxDeclareDataService.queryData(requestModel);
        Map olddata = responseModel.getData();
        String declaredata = JsonUtil.toJson((Object)olddata);
        TaxBureauServiceHelper.saveData((DynamicObject)declares, (String)"bdtaxr_history_sbb", (DeclareRequestModel)requestModel, (String)declaredata);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        DeclareMainServiceHelper.fireModel2DeclareMainChangeEvent((DynamicObject[])dataEntities, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)e.getOperationKey()));
    }
}

