/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.declarelist;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.taxc.bdtaxr.common.util.DeclareUtils;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class DeclareListSubmitOp
extends AbstractOperationServicePlugIn {
    private static Log LOGGER = LogFactory.getLog(DeclareListSubmitOp.class);

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        String operateKey = args.getOperationKey();
        if ("submit".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey)) {
            LOGGER.info("input submitop");
            DynamicObject[] dataEntities = args.getDataEntities();
            List keyList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            boolean isForm = keyList.stream().allMatch(Objects::isNull);
            if (isForm) {
                return;
            }
            ValidDataResultVo submit = DeclareUtils.submit(keyList, (String)operateKey, (String)"tcvat_nsrxx", (boolean)true, (String)this.billEntityType.getName());
            if (submit.getSuccess()) {
                this.operationResult.setSuccess(true);
                List<Object> ids = Arrays.stream(dataEntities).map(e -> String.valueOf(e.getPkValue())).collect(Collectors.toList());
                this.operationResult.getValidateResult().getValidateErrors().clear();
                this.syncMbksData(operateKey, ids);
            } else if (submit.getData() == null) {
                this.operationResult.setSuccess(false);
                this.operationResult.setMessage(submit.getMessage());
                this.operationResult.getSuccessPkIds().clear();
                ValidationErrorInfo e2 = new ValidationErrorInfo();
                e2.setMessage(submit.getMessage());
                e2.setLevel(ErrorLevel.FatalError);
                this.operationResult.getAllErrorInfo().add(e2);
            } else {
                OperationResult result = (OperationResult)submit.getData();
                List errorInfo = result.getAllErrorOrValidateInfo();
                if (errorInfo.size() > 1) {
                    this.operationResult.setMessage(((IOperateInfo)errorInfo.get(1)).getMessage());
                } else if (errorInfo.size() > 0) {
                    this.operationResult.setMessage(((IOperateInfo)errorInfo.get(0)).getMessage());
                } else {
                    this.operationResult.setMessage(result.getMessage());
                }
                for (IOperateInfo info : errorInfo) {
                    ValidationErrorInfo e3 = new ValidationErrorInfo();
                    e3.setPkValue(info.getPkValue());
                    e3.setMessage(info.getMessage());
                    e3.setLevel(ErrorLevel.FatalError);
                    this.operationResult.getAllErrorInfo().add(e3);
                    this.operationResult.getSuccessPkIds().removeIf(o -> o.equals(info.getPkValue()));
                }
                this.operationResult.setSuccess(false);
            }
        }
    }

    private void syncMbksData(String operateKey, List<Object> keyList) {
        if (StringUtils.equals((CharSequence)"audit", (CharSequence)operateKey)) {
            DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tccit", (String)"MbksTaxbookSyncService", (String)"syncData", (Object[])new Object[]{keyList});
        }
    }
}

