/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.multideclarelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.OperateCodeEnum;
import kd.taxc.bdtaxr.common.mq.accrual.AccrualMQSender;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.RiskControlUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.multideclarelist.MultiDeclareUtils;
import kd.taxc.bdtaxr.common.vo.ValidDataResultVo;

public class DeclareListSubmitOp
extends AbstractOperationServicePlugIn {
    public static final String AUDIT = "audit";
    public static final String SUBMIT = "submit";
    public static final String UNAUDIT = "unaudit";
    public static final String UNSUBMIT = "unsubmit";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("org", "taxsystem", "taxtype", "taxareagroup", "accountsettype", "skssqq", "skssqz"));
    }

    public void onAddValidators(final AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        MainEntityType billEntityType = this.billEntityType;
        String billEntity = this.billEntityType.getName();
        String tableName = billEntityType.getAlias();
        billEntity = tableName.substring(2);
        final String entityName = billEntityType.getName();
        if (!("itp_draft_query_list".equals(entityName) || "itp_accrualdec_than_list".equals(entityName) || "rdesd_yhmxb_query_list".equals(entityName) || "rdesd_fzz_gx_query_list".equals(entityName) || "rdesd_gxqyyhmxb_list".equals(entityName))) {
            return;
        }
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                Object[] dataEntities = this.getDataEntities();
                if (ObjectUtils.isEmpty((Object[])dataEntities)) {
                    return;
                }
                String tableName = dataEntities[0].getDataEntity().getDataEntityType().getAlias();
                String billEntity = tableName.substring(2);
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billEntity);
                ArrayList<Object> pklist = new ArrayList<Object>(12);
                for (Object object : dataEntities) {
                    pklist.add(object.getDataEntity().get("id"));
                }
                String operationKey = !ObjectUtils.isEmpty((Object)e.getValidators()) && !ObjectUtils.isEmpty(e.getValidators().get(0)) ? ((AbstractValidator)e.getValidators().get(0)).getOperateKey() : "";
                Object[] loadResult = BusinessDataServiceHelper.load((Object[])pklist.toArray(), (DynamicObjectType)mainEntityType);
                HashMap dataMap = new HashMap(16);
                if (!ObjectUtils.isEmpty((Object[])loadResult)) {
                    for (Object obj : loadResult) {
                        String nsrmc;
                        String billno;
                        HashMap<String, String> errorInfoMap;
                        String msg;
                        DynamicObject jtysbbd;
                        String billstatus = obj.getString("billstatus");
                        String datatype = obj.getString("datatype");
                        String templatetype = obj.getString("templatetype.number");
                        boolean adjuest = false;
                        if (("jtysbbd_bd".equals(templatetype) || "jtysbbd_jt".equals(templatetype)) && !ObjectUtils.isEmpty((Object)(jtysbbd = BusinessDataServiceHelper.loadSingle((String)"itp_accrualdec_than_list", (String)"id,taxsystem,accountsettype,billno,billstatus,org,skssqq,skssqz,templatetype,remarks,entryentity.isadjuest,entryentity,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)obj.getLong("id"))}))) && !ObjectUtils.isEmpty((Object)jtysbbd.getDynamicObjectCollection("entryentity"))) {
                            String isadjuest = ((DynamicObject)jtysbbd.getDynamicObjectCollection("entryentity").get(0)).getString("isadjuest");
                            if ("C".equals(billstatus) && StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && "yes".equals(isadjuest)) {
                                adjuest = true;
                            }
                        }
                        if (MultiDeclareUtils.operateCondition((String)billEntity, (String)billstatus, (String)operationKey, (DynamicObject)obj)) {
                            DynamicObject object;
                            QFilter checkFilter;
                            boolean checkResult = true;
                            if (billEntity.equals("tpo_declare_main_tsd") && StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && "sdbd".equals(obj.getString("comparisontype")) && QueryServiceHelper.exists((String)billEntity, (QFilter[])new QFilter[]{checkFilter = new QFilter("org", "=", (Object)obj.getLong("org.id")).and("taxsystem", "=", (Object)obj.getLong("taxsystem.id")).and("accountsettype", "=", (Object)obj.getString("accountsettype")).and("skssqq", "=", (Object)obj.getDate("skssqq")).and("skssqz", "=", (Object)obj.getDate("skssqz")).and("templatetype", "=", (Object)templatetype).and("comparisontype", "=", (Object)"hjbd")})) {
                                msg = String.format(ResManager.loadKDString((String)"%1$s:\u8ba1\u63d0\u4e0e\u5ba1\u5b9a\u6570\u3001\u6c47\u7f34\u6570\u6bd4\u5bf9\u53c2\u6570\u8bbe\u7f6e\u5206\u5f00\u6bd4\u5bf9\u65f6\uff0c\u8bf7\u5148\u5220\u9664\u6c47\u7f34\u6bd4\u5bf9\u7c7b\u578b\u6bd4\u5bf9\u8868\u3002", (String)"MultiDeclareUtils_5", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), obj.getString("billno"));
                                errorInfoMap = new HashMap(2);
                                errorInfoMap.put("errorMsg", msg);
                                dataMap.put(obj.getString("id"), errorInfoMap);
                                OperatorDialogUtils.operateDialog((String)templatetype, (String)entityName, (String)OperateCodeEnum.getByCode((String)operationKey), (String)msg);
                                checkResult = false;
                            }
                            if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && ("USA_CIT".equals(templatetype) || "Overseas_CIT".equals(templatetype) || "Overseas_VAT".equals(templatetype)) && null != (object = BusinessDataServiceHelper.loadSingle((String)"gtcp_normal_draft_list", (String)"id,billno,taxsystem,entryentity.declarestatus,entryentity", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)obj.getLong("id"))})) && !ObjectUtils.isEmpty((Object)object.getDynamicObjectCollection("entryentity"))) {
                                String declarestatus = ((DynamicObject)object.getDynamicObjectCollection("entryentity").get(0)).getString("declarestatus");
                                if ("C".equals(billstatus) && StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && "declared".equals(declarestatus)) {
                                    String msg2 = String.format(ResManager.loadKDString((String)"\u4ec5\u7533\u62a5\u72b6\u6001\u4e3a\u672a\u7533\u62a5\u7684\u6570\u636e\u53ef\u53cd\u5ba1\u6838\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a%1$s", (String)"MultiDeclareUtils_25", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), obj.getString("billno"));
                                    HashMap<String, String> errorInfoMap2 = new HashMap<String, String>(2);
                                    errorInfoMap2.put("errorMsg", msg2);
                                    dataMap.put(obj.getString("id"), errorInfoMap2);
                                    OperatorDialogUtils.operateDialog((String)templatetype, (String)entityName, (String)OperateCodeEnum.getByCode((String)operationKey), (String)msg2);
                                    checkResult = false;
                                }
                            }
                            if (("jtysbbd_bd".equals(templatetype) || "jtysbbd_jt".equals(templatetype)) && adjuest) {
                                String nsrmc2 = obj.getDynamicObject("org").getString("name");
                                Date skssqq = obj.getDate("skssqq");
                                String msg2 = String.format(ResManager.loadKDString((String)"%1$s\u7ec4\u7ec7%2$s\u5c5e\u671f:\u5355\u636e\u5df2\u6821\u51c6\u5e95\u7a3f\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_15", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc2, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
                                HashMap<String, String> errorInfoMap2 = new HashMap<String, String>(2);
                                errorInfoMap2.put("errorMsg", msg2);
                                dataMap.put(obj.getString("id"), errorInfoMap2);
                                OperatorDialogUtils.operateDialog((String)templatetype, (String)entityName, (String)OperateCodeEnum.getByCode((String)operationKey), (String)msg2);
                                checkResult = false;
                            }
                            if (!checkResult) continue;
                            billno = obj.getString("billno");
                            if (billEntity.equals("tpo_declare_main_tsd")) {
                                OperatorDialogUtils.operateDialog((String)templatetype, (String)entityName, (String)OperateCodeEnum.getByCode((String)operationKey), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u5e95\u7a3f%2$s\u6210\u529f\u3002", (String)"MultiDeclareUtils_17", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode((String)operationKey)));
                                continue;
                            }
                            OperatorDialogUtils.operateDialog((String)templatetype, (String)entityName, (String)OperateCodeEnum.getByCode((String)operationKey), (String)String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a%1$s\u7684\u7533\u62a5\u8868%2$s\u6210\u529f\u3002", (String)"MultiDeclareUtils_7", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), billno, OperateCodeEnum.getByCode((String)operationKey)));
                            continue;
                        }
                        if ("tpo_declare_main_tsc".equals(billEntity)) {
                            nsrmc = obj.getDynamicObject("org").getString("name");
                            billno = obj.getString("billno");
                            String declareStatus = obj.getString("declarestatus");
                            String skssqq = DateUtils.format((Date)obj.getDate("skssqq"), (String)"yyyy-MM");
                            String msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                            if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && ("declared".equals(declareStatus) || "declaring".equals(declareStatus) || "submitted".equals(declareStatus) || "importing".equals(declareStatus))) {
                                msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u7533\u62a5\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_9", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                            } else if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
                                msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                            } else if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && "3".equals(datatype)) {
                                msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\uff1a\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                            } else if (StringUtils.equals((CharSequence)DeclareListSubmitOp.AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
                                msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                            } else if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
                                msg3 = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"MultiDeclareUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, skssqq);
                            }
                            HashMap<String, String> errorInfoMap3 = new HashMap<String, String>(2);
                            errorInfoMap3.put("errorMsg", msg3);
                            dataMap.put(obj.getString("id"), errorInfoMap3);
                            continue;
                        }
                        nsrmc = obj.getDynamicObject("org").getString("name");
                        Date skssqq = obj.getDate("skssqq");
                        msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u7533\u62a5\u8868\u5df2\u63d0\u4ea4\u5ba1\u6279\uff0c\u8bf7\u52ff\u91cd\u590d\u64cd\u4f5c\u3002", (String)"MultiDeclareUtils_8", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
                        if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && ("B".equals(billstatus) || "A".equals(billstatus))) {
                            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\u8bf7\u5148\u63d0\u4ea4\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_10", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
                        } else if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && "3".equals(datatype)) {
                            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f\uff1a\u7a0e\u5c40\u4e0b\u8f7d\u7684\u7533\u62a5\u8868\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_11", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
                        } else if (StringUtils.equals((CharSequence)DeclareListSubmitOp.AUDIT, (CharSequence)operationKey) && "A".equals(billstatus)) {
                            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_12", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
                        } else if (StringUtils.equals((CharSequence)DeclareListSubmitOp.UNSUBMIT, (CharSequence)operationKey) && !"B".equals(billstatus)) {
                            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u72b6\u6001\u5fc5\u987b\u4e3a\u5df2\u63d0\u4ea4\u624d\u80fd\u64a4\u9500\u3002", (String)"MultiDeclareUtils_13", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
                        } else if (billEntity.equals("tpo_declare_main_tsd") && "C".equals(billstatus) && StringUtils.equals((CharSequence)DeclareListSubmitOp.UNAUDIT, (CharSequence)operationKey) && Boolean.TRUE.equals(obj.getBoolean("generatebusinessdoc"))) {
                            msg = String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u7ec4\u7ec7\u201c%2$s\u201d\u5c5e\u671f:\u5355\u636e\u5df2\u751f\u6210\u8ba1\u63d0\u5355\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"MultiDeclareUtils_14", (String)"taxc-bdtaxr-common", (Object[])new Object[0]), nsrmc, DateUtils.format((Date)skssqq, (String)"yyyy-MM"));
                        }
                        errorInfoMap = new HashMap<String, String>(2);
                        errorInfoMap.put("errorMsg", msg);
                        dataMap.put(obj.getString("id"), errorInfoMap);
                    }
                    TaxResult taxResult = RiskControlUtils.checkRiskControlResultForValidator(Arrays.stream(loadResult).collect(Collectors.toList()), (String)operationKey, (String)entityName);
                    if (!taxResult.isSuccess()) {
                        Map errorMap = (Map)taxResult.getData();
                        for (Map.Entry entry : errorMap.entrySet()) {
                            HashMap errorInfoMap = new HashMap(2);
                            errorInfoMap.put("errorMsg", entry.getValue());
                            errorInfoMap.put("errorLevel", ErrorLevel.FatalError);
                            dataMap.put((String)entry.getKey(), errorInfoMap);
                        }
                    }
                }
                for (Object dataEntity : dataEntities) {
                    String id = dataEntity.getDataEntity().getString("id");
                    if (!dataMap.containsKey(id)) continue;
                    if (ErrorLevel.FatalError.equals(((Map)dataMap.get(id)).get("errorLevel"))) {
                        this.addFatalErrorMessage((ExtendedDataEntity)dataEntity, ((Map)dataMap.get(id)).get("errorMsg").toString());
                        continue;
                    }
                    this.addErrorMessage((ExtendedDataEntity)dataEntity, ((Map)dataMap.get(id)).get("errorMsg").toString());
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs args) {
        DynamicObject[] dataEntities;
        String appId = this.billEntityType.getAppId();
        String operateKey = args.getOperationKey();
        if (SUBMIT.equals(operateKey) || UNSUBMIT.equals(operateKey) || AUDIT.equals(operateKey) || UNAUDIT.equals(operateKey)) {
            dataEntities = args.getDataEntities();
            List keyList = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            MainEntityType billEntityType = this.billEntityType;
            String billEntity = ((BillEntityType)this.billEntityType).getName();
            String tableName = ((BillEntityType)billEntityType).getAlias();
            billEntity = tableName.substring(2);
            if ("itp".equals(appId) || "rdesd".equals(appId)) {
                OperationResult result = MultiDeclareUtils.submit(keyList, (String)operateKey, (String)billEntity, (String)billEntityType.getName());
                if (!ObjectUtils.isEmpty((Object)result) && !result.isSuccess()) {
                    List validateErrors = result.getValidateResult().getValidateErrors();
                    ArrayList<OperateErrorInfo> errorInfoList = new ArrayList<OperateErrorInfo>(12);
                    if (!ObjectUtils.isEmpty((Object)validateErrors)) {
                        for (ValidateResult validateResult : validateErrors) {
                            List allErrorInfo = validateResult.getAllErrorInfo();
                            if (ObjectUtils.isEmpty((Object)allErrorInfo)) continue;
                            for (OperateErrorInfo info : allErrorInfo) {
                                errorInfoList.add(info);
                            }
                        }
                    }
                    if (!ObjectUtils.isEmpty(errorInfoList)) {
                        for (OperateErrorInfo operateErrorInfo : errorInfoList) {
                            this.operationResult.setSuccess(false);
                            this.operationResult.addErrorInfo((OperateErrorInfo)this.buildErrMessage(operateErrorInfo));
                            this.operationResult.setShowMessage(false);
                        }
                    }
                }
            } else {
                ArrayList errorIds = new ArrayList(2);
                ValidDataResultVo submit = MultiDeclareUtils.submit(keyList, (String)operateKey, (String)billEntity, errorIds, (boolean)true, (String)billEntityType.getName());
                this.operationResult.getValidateResult().setErrorPkIds(new HashSet(errorIds));
                this.operationResult.setSuccessPkIds(new ArrayList());
                if (submit.getSuccess()) {
                    this.operationResult.setSuccess(true);
                    if (!ObjectUtils.isEmpty((Object)this.operationResult.getSuccessPkIds()) && !ObjectUtils.isEmpty(errorIds)) {
                        this.operationResult.getSuccessPkIds().removeAll(errorIds);
                    }
                } else if (submit.getData() == null) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(submit.getMessage());
                    this.operationResult.setShowMessage(false);
                } else {
                    OperationResult result = (OperationResult)submit.getData();
                    List errorInfo = result.getAllErrorOrValidateInfo();
                    if (errorInfo.size() > 1) {
                        this.operationResult.setMessage(((IOperateInfo)errorInfo.get(1)).getMessage());
                    } else if (errorInfo.size() > 0) {
                        this.operationResult.setMessage(((IOperateInfo)errorInfo.get(0)).getMessage());
                    } else {
                        this.operationResult.setMessage(result.getMessage());
                    }
                    this.operationResult.setShowMessage(false);
                    this.operationResult.setSuccess(false);
                }
            }
        }
        for (DynamicObject dataEntity : dataEntities = args.getDataEntities()) {
            AccrualMQSender.sendMQ((DynamicObject)dataEntity);
        }
    }

    private ValidationErrorInfo buildErrMessage(OperateErrorInfo operateErrorInfo) {
        int dataIndex = 0;
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo info = new ValidationErrorInfo("", operateErrorInfo.getPkValue(), dataIndex, rowIndex, "500", "", operateErrorInfo.getMessage(), errorLevel);
        return info;
    }
}

