/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.opplugin.multideclarelist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.constant.TaxDeclareConstant;
import kd.taxc.bdtaxr.common.constant.TemplateTypeConstant;
import kd.taxc.bdtaxr.common.enums.tpo.DeclareOperationEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.DeclareMQSender;
import kd.taxc.bdtaxr.common.mq.DeclareMQType;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.collections.CollectionUtils;

public class MultiDeclareListUnPayOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("cancelpay".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"tpo_declare_main_tsc", (String)TaxDeclareConstant.MAIN_DECLARE_ALL_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                ArrayList<DynamicObject> modifyDynamicObjects = new ArrayList<DynamicObject>(declares.length);
                for (DynamicObject declare : declares) {
                    DynamicObject org = declare.getDynamicObject("org");
                    DynamicObject templatetype = (DynamicObject)declare.get("templatetype");
                    String type = templatetype.getString("number");
                    String typeName = (String)TemplateTypeConstant.getNsrtypemap().get(type);
                    String payType = declare.getString("paytype");
                    String skssqq = DateUtils.format((Date)declare.getDate("skssqq"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String skssqz = DateUtils.format((Date)declare.getDate("skssqz"), (String)DateUtils.YYYYMMDD_CHINESE);
                    String billStatus = declare.getString("billstatus");
                    if (!"C".equals(billStatus)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u7f34\u6b3e\u8868\u624d\u80fd\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnPayOp_0", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"paid".equals(declare.getString("paystatus"))) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u72b6\u6001\u4e3a\u7f34\u6b3e\u6210\u529f\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnPayOp_1", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    if (!"0".equals(payType)) {
                        message.append(String.format(ResManager.loadKDString((String)"\u53ea\u6709\u7f34\u6b3e\u65b9\u5f0f\u4e3a\u624b\u5de5\u7f34\u6b3e\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7f34\u6b3e: %1$s %2$s \u81f3 %3$s %4$s\u4e0d\u7b26\u5408\u6761\u4ef6", (String)"MultiDeclareListUnPayOp_2", (String)"taxc-bdtaxr", (Object[])new Object[0]), org.getString("name"), skssqq, skssqz, typeName)).append(SEPARATOR);
                        continue;
                    }
                    declare.set("paystatus", (Object)"unpaid");
                    declare.set("modifytime", (Object)new Date());
                    declare.set("modifier", (Object)RequestContext.get().getUserId());
                    declare.set("paytype", (Object)"");
                    declare.set("paydate", null);
                    declare.set("payer", (Object)0L);
                    modifyDynamicObjects.add(declare);
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                if (CollectionUtils.isNotEmpty(modifyDynamicObjects)) {
                    List sbbIds = modifyDynamicObjects.stream().map(d -> d.getLong("id")).collect(Collectors.toList());
                    DispatchServiceHelper.invokeBizService((String)"taxc", (String)"bdtaxr", (String)"MultiDeclarePayApplyService", (String)"cancelPay", (Object[])new Object[]{sbbIds});
                    DynamicObject[] saveObjects = modifyDynamicObjects.toArray(new DynamicObject[modifyDynamicObjects.size()]);
                    SaveServiceHelper.save((DynamicObject[])saveObjects);
                    for (DynamicObject modifyob : modifyDynamicObjects) {
                        DeclareMQSender.sendMQ((DynamicObject)modifyob, (Date)MultiDeclareListUnPayOp.getPayDate(modifyob), (String)DeclareMQType.PAY.name(), (String)operateKey);
                    }
                    MultiDeclareMQSender.sendMQ((DynamicObject[])saveObjects, (String)operateKey);
                    DeclareMainServiceHelper.fireModel3DeclareMainChangeEvent((DynamicObject[])saveObjects, (DeclareOperationEnum)DeclareOperationEnum.getEnumByKey((String)operateKey));
                    this.operationResult.setSuccess(true);
                }
            }
        }
    }

    private static Date getPayDate(DynamicObject modifyob) {
        DynamicObject obj = QueryServiceHelper.queryOne((String)"bdtaxr_pay_record", (String)"paydate", (QFilter[])new QFilter[]{new QFilter("sbbid", "=", (Object)modifyob.getString("id"))});
        return null == obj ? null : obj.getDate("paydate");
    }
}

