/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.bdtaxr.validator.provision;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;

public class DeleteProvisionValidator
extends AbstractValidator {
    public void validate() {
        List entityNumberList = Arrays.stream(this.getDataEntities()).map(ExtendedDataEntity::getBillNo).collect(Collectors.toList());
        QFilter billNoQ = new QFilter("entitynumber", "in", entityNumberList);
        DynamicObjectCollection jtdCollection = QueryServiceHelper.query((String)"itp_proviston_taxes", (String)"billno,billstatus,entitynumber", (QFilter[])new QFilter[]{billNoQ});
        Map<String, List<DynamicObject>> map = jtdCollection.stream().collect(Collectors.groupingBy(d -> d.getString("entitynumber")));
        block0: for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            String billno = dataEntity.getBillNo();
            if (EmptyCheckUtils.isEmpty(map.get(billno))) {
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u672a\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"DeleteProvisionValidator_0", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                continue;
            }
            List<DynamicObject> jtdList = map.get(billno);
            for (DynamicObject object : jtdList) {
                if ("A".equals(object.getString("billstatus"))) continue;
                this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u6682\u5b58\u7684\u5168\u90e8\u8ba1\u63d0\u5355\u53ef\u4ee5\u5220\u9664\u3002", (String)"DeleteProvisionValidator_1", (String)"taxc-bdtaxr", (Object[])new Object[0]));
                continue block0;
            }
        }
    }
}

