/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.draft;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.YbnsrServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.taxcyear.GtcpTaxcYearDataBussiness;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpDraftBussiness {
    public static String getTemplateTypeByTaxtype(String taxType) {
        if ("ZZS".equals(taxType)) {
            return "Overseas_VAT";
        }
        if ("SDS".equals(taxType)) {
            return "Overseas_CIT";
        }
        if ("USA_CIT".equals(taxType)) {
            return "USA_CIT";
        }
        return "";
    }

    public static DynamicObject queryDraftMainDataByDraftId(Long orgId, Long taxSystemId, Long taxcategory, Long taxareagroup, String draftpurpose, Long draftId) {
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("taxsystem", "=", (Object)taxSystemId)).and(new QFilter("taxtype", "=", (Object)taxcategory)).and(new QFilter("taxareagroup", "=", (Object)taxareagroup)).and(new QFilter("id", "=", (Object)draftId)).and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
        return QueryServiceHelper.queryOne((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,billno,skssqq,skssqz", (QFilter[])new QFilter[]{declareMainFilter});
    }

    public static DynamicObject[] queryDraftMainDataByDraftId(String draftpurpose, List<Long> draftIds) {
        QFilter declareMainFilter = new QFilter("id", "in", draftIds).and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
        return BusinessDataServiceHelper.load((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,billno,org,taxsystem,taxtype,taxareagroup,skssqq,skssqz", (QFilter[])new QFilter[]{declareMainFilter});
    }

    public static DynamicObject[] queryDraftMainDataByDraftId(List<Long> draftIds) {
        QFilter declareMainFilter = new QFilter("id", "in", draftIds);
        return BusinessDataServiceHelper.load((String)"gtcp_normal_draft_list", (String)"id,billno,org,taxsystem,taxtype,taxareagroup,skssqq,skssqz,entryentity.payrefundstatus,entryentity.payrefunddate,entryentity", (QFilter[])new QFilter[]{declareMainFilter});
    }

    public static DynamicObject[] queryRangeDraftMainDataByOrgsAndTaxType(List<Long> orgList, List<Long> taxTypeList, List<String> templateTypeList, String draftpurpose, Date skssqq, Date skssqz) {
        QFilter declareMainFilter = new QFilter("org", "in", orgList).and(new QFilter("taxtype", "in", taxTypeList)).and(new QFilter("draftpurpose", "=", (Object)draftpurpose)).and(new QFilter("templatetype", "in", templateTypeList)).and(new QFilter("skssqq", ">=", (Object)skssqq)).and(new QFilter("skssqz", "<=", (Object)skssqz));
        return BusinessDataServiceHelper.load((String)"gtcp_normal_draft_list", (String)"id,billno,billstatus,org,taxsystem,taxtype,taxareagroup,skssqq,skssqz,entryentity,entryentity.bqybtse,entryentity.declarestatus,entryentity.payrefundstatus", (QFilter[])new QFilter[]{declareMainFilter});
    }

    public static String getSbbId(String templateType, Long orgId, Date startDate, Date endDate, Long taxSystemId, Long taxcategory, Long taxareagroup, String draftpurpose) {
        DynamicObject preMain;
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("templatetype", "=", (Object)templateType)).and(new QFilter("skssqz", "=", (Object)endDate)).and(new QFilter("taxsystem", "=", (Object)taxSystemId)).and(new QFilter("taxtype", "=", (Object)taxcategory)).and(new QFilter("taxareagroup", "=", (Object)taxareagroup));
        if (startDate != null) {
            declareMainFilter.and(new QFilter("skssqq", "=", (Object)startDate));
        }
        if (draftpurpose != null) {
            declareMainFilter.and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
        }
        return (preMain = QueryServiceHelper.queryOne((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{declareMainFilter})) == null ? "0" : preMain.getString("id");
    }

    public static String getSbbIdWithOffset(String templateType, Long orgId, Date startDate, Date endDate, Long taxSystemId, Long taxcategory, Long taxareagroup, String draftpurpose) {
        DynamicObject preMain;
        Date taxYearStartDate = GtcpTaxcYearDataBussiness.queryTaxcyearByTaxationsysId(Collections.singletonList(orgId), taxSystemId);
        ImmutablePair<Date, Date> dateDateImmutablePair = GtcpDraftBussiness.calDate(taxYearStartDate, startDate, endDate);
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId);
        if (dateDateImmutablePair == null) {
            return "";
        }
        declareMainFilter.and(new QFilter("templatetype", "=", (Object)templateType)).and(new QFilter("skssqz", "=", dateDateImmutablePair.right)).and(new QFilter("taxsystem", "=", (Object)taxSystemId)).and(new QFilter("taxtype", "=", (Object)taxcategory)).and(new QFilter("taxareagroup", "=", (Object)taxareagroup));
        if (startDate != null) {
            declareMainFilter.and(new QFilter("skssqq", "=", dateDateImmutablePair.left));
        }
        if (draftpurpose != null) {
            declareMainFilter.and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
        }
        return (preMain = QueryServiceHelper.queryOne((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{declareMainFilter})) == null ? "0" : preMain.getString("id");
    }

    public static List<String> getSbbIdListByPeriod(String templateType, Long orgId, Date startDate, Date endDate, Long taxSystemId, Long taxcategory, Long taxareagroup, String draftpurpose, String period) {
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("templatetype", "=", (Object)templateType)).and(new QFilter("skssqz", "<=", (Object)endDate)).and(new QFilter("taxsystem", "=", (Object)taxSystemId)).and(new QFilter("taxtype", "=", (Object)taxcategory)).and(new QFilter("taxareagroup", "=", (Object)taxareagroup));
        if (startDate != null) {
            declareMainFilter.and(new QFilter("skssqq", ">=", (Object)startDate));
        }
        if (draftpurpose != null) {
            declareMainFilter.and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
        }
        ArrayList<String> resultList = new ArrayList<String>();
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id,skssqq,skssqz", (QFilter[])new QFilter[]{declareMainFilter});
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            dynamicObjects.stream().forEach(dynamicObject -> {
                if (DateUtils.validDateRange((String)period, (Date)dynamicObject.getDate("skssqq"), (Date)dynamicObject.getDate("skssqz"))) {
                    resultList.add(dynamicObject.getString("id"));
                }
            });
        }
        return resultList;
    }

    public static List<String> getSbbIdListByPeriodWithOffset(String templateType, Long orgId, Date startDate, Date endDate, Long taxSystemId, Long taxcategory, Long taxareagroup, String draftpurpose) {
        DynamicObjectCollection dynamicObjects;
        Date taxYearStartDate = GtcpTaxcYearDataBussiness.queryTaxcyearByTaxationsysId(Collections.singletonList(orgId), taxSystemId);
        ImmutablePair<Date, Date> dateDateImmutablePair = GtcpDraftBussiness.calDate(taxYearStartDate, startDate, endDate);
        if (dateDateImmutablePair == null) {
            return new ArrayList<String>();
        }
        QFilter declareMainFilter = new QFilter("org", "=", (Object)orgId).and(new QFilter("templatetype", "=", (Object)templateType)).and(new QFilter("skssqz", "=", dateDateImmutablePair.right)).and(new QFilter("taxsystem", "=", (Object)taxSystemId)).and(new QFilter("taxtype", "=", (Object)taxcategory)).and(new QFilter("taxareagroup", "=", (Object)taxareagroup));
        if (startDate != null) {
            declareMainFilter.and(new QFilter("skssqq", ">=", dateDateImmutablePair.left));
        }
        if (draftpurpose != null) {
            declareMainFilter.and(new QFilter("draftpurpose", "<=", (Object)draftpurpose));
        }
        if (ObjectUtils.isNotEmpty((Object)(dynamicObjects = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{declareMainFilter})))) {
            return dynamicObjects.stream().map(o -> o.getString("id")).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public static Map<String, Map<String, Map<String, String>>> queryCellValue(Long entryid, String dynrownopre, String bbxmEndNumber, String amountEndNumber) {
        HashMap<String, Map<String, Map<String, String>>> resultMap = new HashMap<String, Map<String, Map<String, String>>>(8);
        QFilter entryidQ = new QFilter("entryid", "=", (Object)entryid);
        QFilter dynRowNoQ = new QFilter("dynrowno", "=", (Object)dynrownopre);
        DataSet rowsData = QueryServiceHelper.queryDataSet((String)"batchQueryCellValue", (String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"index,cellnumber,value,dynrowno", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ}, null);
        DataSet dynrownoDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + bbxmEndNumber)).toString());
        DataSet valueDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + amountEndNumber)).toString());
        JoinDataSet join = dynrownoDataSet.join(valueDataSet, JoinType.INNER);
        DataSet rows = join.on("dynrowno", "dynrowno").on("index", "index").select(new String[]{"dynrowno", "cellnumber bbcellnumber", "value bbId"}, new String[]{"cellnumber", "value"}).finish();
        while (rows.hasNext()) {
            Row row = rows.next();
            String bbId = row.getString("bbId");
            String dynrowno = row.getString("dynrowno");
            String value = row.getString("value");
            if (!resultMap.containsKey(dynrowno)) {
                HashMap mapList = new HashMap(8);
                resultMap.put(dynrowno, mapList);
            }
            if (!resultMap.containsKey(dynrowno)) continue;
            if (((Map)resultMap.get(dynrowno)).containsKey(bbId)) {
                ((Map)((Map)resultMap.get(dynrowno)).get(bbId)).put(bbxmEndNumber, bbId);
                ((Map)((Map)resultMap.get(dynrowno)).get(bbId)).put(amountEndNumber, value);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(bbxmEndNumber, bbId);
            map.put(amountEndNumber, value);
            ((Map)resultMap.get(dynrowno)).put(bbId, map);
        }
        rowsData.close();
        dynrownoDataSet.close();
        valueDataSet.close();
        rows.close();
        return resultMap;
    }

    public static Map<String, Map<String, Map<String, String>>> batchQueryCellValue(Long entryid, List<String> dynrownoList, String bbxmEndNumber, String amountEndNumber) {
        HashMap<String, Map<String, Map<String, String>>> resultMap = new HashMap<String, Map<String, Map<String, String>>>(8);
        QFilter entryidQ = new QFilter("entryid", "=", (Object)entryid);
        QFilter dynRowNoQ = new QFilter("dynrowno", "in", dynrownoList);
        DataSet rowsData = QueryServiceHelper.queryDataSet((String)"batchQueryCellValue", (String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"index,cellnumber,value,dynrowno", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ}, null);
        DataSet dynrownoDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + bbxmEndNumber)).toString());
        DataSet valueDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + amountEndNumber)).toString());
        JoinDataSet join = dynrownoDataSet.join(valueDataSet, JoinType.INNER);
        DataSet rows = join.on("dynrowno", "dynrowno").on("index", "index").select(new String[]{"dynrowno", "cellnumber bbcellnumber", "value bbId"}, new String[]{"cellnumber", "value"}).finish();
        while (rows.hasNext()) {
            Row row = rows.next();
            String bbId = row.getString("bbId");
            String dynrowno = row.getString("dynrowno");
            String value = row.getString("value");
            if (!resultMap.containsKey(dynrowno)) {
                HashMap mapList = new HashMap(8);
                resultMap.put(dynrowno, mapList);
            }
            if (!resultMap.containsKey(dynrowno)) continue;
            if (((Map)resultMap.get(dynrowno)).containsKey(bbId)) {
                ((Map)((Map)resultMap.get(dynrowno)).get(bbId)).put(bbxmEndNumber, bbId);
                ((Map)((Map)resultMap.get(dynrowno)).get(bbId)).put(amountEndNumber, value);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(bbxmEndNumber, bbId);
            map.put(amountEndNumber, value);
            ((Map)resultMap.get(dynrowno)).put(bbId, map);
        }
        rowsData.close();
        dynrownoDataSet.close();
        valueDataSet.close();
        rows.close();
        return resultMap;
    }

    public static Map<String, Map<String, Map<String, String>>> batchQueryCellValueWithSum(List<Long> entryid, List<String> dynrownoList, String bbxmEndNumber, String amountEndNumber) {
        HashMap<String, Map<String, Map<String, String>>> resultMap = new HashMap<String, Map<String, Map<String, String>>>(8);
        QFilter entryidQ = new QFilter("entryid", "in", entryid);
        QFilter dynRowNoQ = new QFilter("dynrowno", "in", dynrownoList);
        DataSet rowsData = QueryServiceHelper.queryDataSet((String)"batchQueryCellValue", (String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"index,cellnumber,value,dynrowno,entryid", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ}, null);
        DataSet dynrownoDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + bbxmEndNumber)).toString());
        DataSet valueDataSet = rowsData.copy().filter(new QFilter("cellnumber", "like", (Object)("%" + amountEndNumber)).toString());
        JoinDataSet join = dynrownoDataSet.join(valueDataSet, JoinType.INNER);
        DataSet rows = join.on("dynrowno", "dynrowno").on("index", "index").on("entryid", "entryid").select(new String[]{"dynrowno", "cellnumber bbcellnumber", "value bbId"}, new String[]{"cellnumber", "value"}).finish();
        while (rows.hasNext()) {
            Row row = rows.next();
            String bbId = row.getString("bbId");
            String dynrowno = row.getString("dynrowno");
            String value = row.getString("value");
            if (!resultMap.containsKey(dynrowno)) {
                HashMap mapList = new HashMap(8);
                resultMap.put(dynrowno, mapList);
            }
            if (!resultMap.containsKey(dynrowno)) continue;
            if (((Map)resultMap.get(dynrowno)).containsKey(bbId)) {
                if (((Map)((Map)resultMap.get(dynrowno)).get(bbId)).containsKey(amountEndNumber)) {
                    String oldValue = (String)((Map)((Map)resultMap.get(dynrowno)).get(bbId)).get(amountEndNumber);
                    value = new BigDecimal(oldValue).add(new BigDecimal(value)).toString();
                }
                ((Map)((Map)resultMap.get(dynrowno)).get(bbId)).put(amountEndNumber, value);
                ((Map)((Map)resultMap.get(dynrowno)).get(bbId)).put(bbxmEndNumber, bbId);
                continue;
            }
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(amountEndNumber, value);
            map.put(bbxmEndNumber, bbId);
            ((Map)resultMap.get(dynrowno)).put(bbId, map);
        }
        rowsData.close();
        dynrownoDataSet.close();
        valueDataSet.close();
        rows.close();
        return resultMap;
    }

    public static Map<Long, Map<String, String>> batchFixCellValue(Map<Long, List<String>> draftCellKeyMap) {
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(8);
        Set<Long> entryid = draftCellKeyMap.keySet();
        HashSet cellkeyList = new HashSet();
        draftCellKeyMap.keySet().stream().forEach(key -> ((List)draftCellKeyMap.get(key)).stream().forEach(cell -> cellkeyList.add(cell)));
        QFilter entryidQ = new QFilter("entryid", "in", entryid);
        QFilter dynRowNoQ = new QFilter("cellnumber", "in", cellkeyList);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"id,entryid,index,cellnumber,value", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ}, null);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                Long draftId = dynamicObject.getLong("entryid");
                List<String> cellNumberList = draftCellKeyMap.get(draftId);
                String cellNumber = dynamicObject.getString("cellnumber");
                if (null == cellNumberList || !cellNumberList.contains(cellNumber)) continue;
                if (resultMap.containsKey(draftId)) {
                    ((Map)resultMap.get(draftId)).put(dynamicObject.getString("cellnumber"), dynamicObject.getString("value"));
                    continue;
                }
                HashMap<String, String> valueMap = new HashMap<String, String>();
                valueMap.put(dynamicObject.getString("cellnumber"), dynamicObject.getString("value"));
                resultMap.put(draftId, valueMap);
            }
        }
        return resultMap;
    }

    public static Map<String, String> queryFixCellValue(Long entryid, List<String> cellkeyList) {
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        QFilter entryidQ = new QFilter("entryid", "=", (Object)entryid);
        QFilter dynRowNoQ = new QFilter("cellnumber", "in", cellkeyList);
        DynamicObjectCollection dynamicObjects = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"index,cellnumber,value", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ}, null);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                resultMap.put(dynamicObject.getString("cellnumber"), dynamicObject.getString("value"));
            }
        }
        return resultMap;
    }

    public static ImmutablePair<Date, Date> calDate(Date taxYearStartDate, Date modelStartDate, Date modelEndDate) {
        if (taxYearStartDate == null || modelStartDate == null || modelEndDate == null) {
            return null;
        }
        int monthInt = 1 - DateUtils.getMonthOfDate((Date)taxYearStartDate);
        int dataInt = 1 - DateUtils.getDayOfDate((Date)taxYearStartDate);
        Date offSetStartDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)modelStartDate, (int)monthInt), (int)dataInt);
        Integer monthBetweenInOneYear = GtcpDraftBussiness.getMonthBetweenInOneYear(modelStartDate, modelEndDate);
        if (monthBetweenInOneYear != null) {
            Date offSetEndDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)offSetStartDate, (int)monthBetweenInOneYear), (int)-1);
            return ImmutablePair.of((Object)offSetStartDate, (Object)offSetEndDate);
        }
        return null;
    }

    public static Integer getMonthBetweenInOneYear(Date minDate, Date maxDate) {
        int result;
        if (minDate == null || maxDate == null || maxDate.compareTo(minDate) <= 0) {
            return null;
        }
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        max.setTime(maxDate);
        for (result = 0; min.before(max) && result < 12; ++result) {
            min.add(2, 1);
        }
        min.add(5, -1);
        if (result <= 12 && min.equals(max)) {
            return result;
        }
        return null;
    }

    public static String comparePeroid(String sbPeriod, String jtPeriod, String thanmethod) {
        if (jtPeriod.equalsIgnoreCase(thanmethod)) {
            return "sb";
        }
        if (sbPeriod.equalsIgnoreCase(thanmethod)) {
            return "jt";
        }
        return "";
    }

    public static ImmutablePair<Date, Date> getLastPeriod(Date start, Date end, String plan) {
        if ("month".equalsIgnoreCase(plan)) {
            Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.getFirstDateOfMonth((Date)end)), (String)"yyyy-MM-dd"));
            Date lastDateOfMonth = DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)end)), (String)"yyyy-MM-dd");
            return ImmutablePair.of((Object)firstDateOfMonth, (Object)lastDateOfMonth);
        }
        if ("season".equalsIgnoreCase(plan)) {
            Date parseDate = DateUtils.addMonth((Date)end, (int)-2);
            Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)DateUtils.format((Date)parseDate), (String)"yyyy-MM-dd"));
            Date lastDateOfMonth = DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)end)), (String)"yyyy-MM-dd");
            return ImmutablePair.of((Object)firstDateOfMonth, (Object)lastDateOfMonth);
        }
        if ("halfyear".equalsIgnoreCase(plan)) {
            Date parseDate = DateUtils.addMonth((Date)end, (int)-5);
            Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)DateUtils.stringToDate((String)DateUtils.format((Date)parseDate), (String)"yyyy-MM-dd"));
            Date lastDateOfMonth = DateUtils.stringToDate((String)DateUtils.format((Date)DateUtils.getLastDateOfMonth((Date)end)), (String)"yyyy-MM-dd");
            return ImmutablePair.of((Object)firstDateOfMonth, (Object)lastDateOfMonth);
        }
        return null;
    }

    public static List<String> getDateIntersectionDraftNumber(Long orgId, String type, String startDate, String endDate, QFilter extendFilter) {
        ArrayList<String> list = new ArrayList<String>();
        List collection = YbnsrServiceHelper.queryMultiDeclareMainList((String)MultiTableEnum.TSD001.getDeclareMainTable(), (Long)orgId, (String)type, null, null, (QFilter)extendFilter);
        if (null != collection) {
            DynamicObject currentData = YbnsrServiceHelper.queryMultiDeclareMain((String)MultiTableEnum.TSD001.getDeclareMainTable(), (Long)orgId, (String)type, (String)startDate, (String)endDate, (QFilter)extendFilter);
            long currentDataId = null != currentData ? currentData.getLong("id") : 0L;
            for (DynamicObject row : collection) {
                Date[] date = DateUtils.getIntersectionDate((Date)DateUtils.stringToDate2((String)startDate), (Date)DateUtils.stringToDate2((String)endDate), (Date)row.getDate("skssqq"), (Date)row.getDate("skssqz"));
                if (0L != currentDataId && row.getLong("id") == currentDataId || null == date) continue;
                Date oldDate = row.getDate("skssqq");
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(oldDate);
                int oldDay = calendar.get(5);
                Calendar skssqqCalendar = Calendar.getInstance();
                skssqqCalendar.setTime(DateUtils.stringToDate2((String)startDate));
                int skssqqDay = skssqqCalendar.get(5);
                if (oldDay == skssqqDay) continue;
                list.add(row.getString("billno"));
            }
        }
        return list;
    }

    public static Long queryBeforeLastDraftId(Long orgId, String type, String startDate, String endDate, QFilter extendFilter, String taxLimit) {
        Long draftId = null;
        List collection = YbnsrServiceHelper.queryMultiDeclareMainList((String)MultiTableEnum.TSD001.getDeclareMainTable(), (Long)orgId, (String)type, null, null, (QFilter)extendFilter);
        if (null != collection) {
            DynamicObject currentData = YbnsrServiceHelper.queryMultiDeclareMain((String)MultiTableEnum.TSD001.getDeclareMainTable(), (Long)orgId, (String)type, (String)startDate, (String)endDate, (QFilter)extendFilter);
            long currentDataId = null != currentData ? currentData.getLong("id") : 0L;
            collection.removeIf(row -> 0L != currentDataId && row.getLong("id") == currentDataId || !StringUtil.equalsIgnoreCase((CharSequence)DateUtils.getTaxLimit((Date)row.getDate("skssqq"), (Date)row.getDate("skssqz")), (CharSequence)taxLimit) || DateUtils.getYearOfDate((Date)row.getDate("skssqq")) > DateUtils.getYearOfDate((Date)DateUtils.stringToDate2((String)startDate)));
            collection = collection.stream().sorted((a, b) -> b.getDate("skssqq").compareTo(a.getDate("skssqq"))).collect(Collectors.toList());
            if (ObjectUtils.isNotEmpty(collection)) {
                DynamicObject dynamicObject = (DynamicObject)collection.get(0);
                return dynamicObject.getLong("id");
            }
        }
        return draftId;
    }

    public static Map<String, Map<String, Map<String, String>>> batchQueryCellValue(Long entryid, List<String> dynrownoList) {
        HashMap<String, Map<String, Map<String, String>>> resultMap = new HashMap<String, Map<String, Map<String, String>>>(16);
        QFilter entryidQ = new QFilter("entryid", "=", (Object)entryid);
        QFilter dynRowNoQ = new QFilter("dynrowno", "in", dynrownoList);
        try (DataSet rowsData = QueryServiceHelper.queryDataSet((String)"batchQueryCellValue", (String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"dynrowno,index,cellnumber,value", (QFilter[])new QFilter[]{entryidQ, dynRowNoQ}, (String)"index");){
            while (rowsData.hasNext()) {
                HashMap<String, String> celValueMap;
                Map indexMap;
                Row row = rowsData.next();
                String dynrowno = row.getString("dynrowno");
                String index = row.getString("index");
                String value = row.getString("value");
                String cellnumber = row.getString("cellnumber");
                if (resultMap.containsKey(dynrowno)) {
                    indexMap = (Map)resultMap.get(dynrowno);
                    if (indexMap.containsKey(index)) {
                        ((Map)indexMap.get(index)).put(cellnumber, value);
                        continue;
                    }
                    celValueMap = new HashMap();
                    celValueMap.put(cellnumber, value);
                    indexMap.put(index, celValueMap);
                    continue;
                }
                indexMap = new HashMap();
                celValueMap = new HashMap<String, String>();
                celValueMap.put(cellnumber, value);
                indexMap.put(index, celValueMap);
                resultMap.put(dynrowno, indexMap);
            }
        }
        return resultMap;
    }
}

