/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.draft;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.MultiDiTemplateHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.business.fetchitem.FetchItemBusiness;
import kd.taxc.gtcp.business.rule.GtcpDraftCalculateBusiness;
import kd.taxc.gtcp.business.sharefactor.UsaShareFactorBusiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.business.tctb.TaxPeriodBusiness;
import kd.taxc.gtcp.common.constant.GtcpConstant;
import kd.taxc.gtcp.common.enums.FixedCellFetchTransFormProjectEnum;
import kd.taxc.gtcp.common.enums.GtcpBizTypeEnum;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupColumnEnum;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class GtcpFetchDataBussiness {
    public static Map<String, String> getBizParams(String templateType, Long orgId, Long taxSysId, Long taxTypeId, Date skssqq, String draftpurpose) {
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        paramsMap.put("ttctag", "taxarea");
        if ("USA_CIT".equalsIgnoreCase(templateType)) {
            List<Long> taxCategories = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxSysId);
            List<Long> taxAreaIds = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxSysId, taxTypeId);
            if (taxCategories.contains(1682650334692126720L)) {
                taxAreaIds.add(1681071243350195200L);
            }
            taxAreaIds = taxAreaIds.stream().distinct().collect(Collectors.toList());
            paramsMap.put("USA_CIT_TAX_AREA_LIST", SerializationUtils.toJsonString(taxAreaIds));
            for (Map.Entry<String, String> entry : UsaTaxAreaGroupColumnEnum.getformulaMap().entrySet()) {
                if (ObjectUtils.isNotEmpty(taxAreaIds)) {
                    paramsMap.put(entry.getValue(), taxAreaIds.contains(Long.valueOf(entry.getKey())) ? entry.getValue() : "0");
                    continue;
                }
                paramsMap.put(entry.getValue(), "0");
            }
        }
        if (kd.taxc.bdtaxr.common.util.string.StringUtil.equalsIgnoreCase((CharSequence)"nssb", (CharSequence)draftpurpose)) {
            Date firstDateOfTaxYear = TaxPeriodBusiness.getTaxPeriodStartMonthAndDay(orgId, taxSysId, taxTypeId, skssqq);
            paramsMap.put("firstDateOfTaxYear", DateUtils.format((Date)firstDateOfTaxYear));
            paramsMap.put("lastDateOfTaxYear", ObjectUtils.isEmpty((Object)firstDateOfTaxYear) ? "" : DateUtils.format((Date)DateUtils.addMonth((Date)DateUtils.addDay((Date)firstDateOfTaxYear, (int)-1), (int)12)));
        } else if (kd.taxc.bdtaxr.common.util.string.StringUtil.equalsIgnoreCase((CharSequence)"sjjt", (CharSequence)draftpurpose)) {
            paramsMap.put("firstDateOfTaxYear", ObjectUtils.isEmpty((Object)skssqq) ? "" : DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)skssqq)));
            paramsMap.put("lastDateOfTaxYear", ObjectUtils.isEmpty((Object)skssqq) ? "" : DateUtils.format((Date)DateUtils.getLastDateOfYear((Date)skssqq)));
        }
        return paramsMap;
    }

    public static Map<String, String> getSbFetchConfigParams(DeclareRequestModel requestModel, Long taxSysId, Long taxTypeId, Long taxareagroup, RuleEngineParamDto engineParamDto) {
        Object usaCitOrgIncludeUsaFt;
        Object draftpurpose = requestModel.getExtendParams().get("draftpurpose");
        HashMap<String, String> businessMap = new HashMap<String, String>();
        if (ObjectUtils.isEmpty(draftpurpose)) {
            return businessMap;
        }
        Map preData = requestModel.getPreData();
        if (kd.taxc.bdtaxr.common.util.string.StringUtil.equals((CharSequence)"regetdata", (CharSequence)requestModel.getCustomEvent())) {
            businessMap.putAll(preData);
        }
        if ("USA_CIT".equalsIgnoreCase(requestModel.getTemplateType())) {
            List<Long> taxCategories = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(requestModel.getOrgId(), requestModel.getTaxationsys());
            requestModel.getExtendParams().put("usaCitOrgIncludeUsaFt", String.valueOf(taxCategories.contains(1682650334692126720L)));
            ArrayList<Long> areaList = new ArrayList();
            String areaJsonStr = (String)requestModel.getExtendParams().get("USA_CIT_TAX_AREA_LIST");
            if (StringUtils.isNotEmpty((CharSequence)areaJsonStr)) {
                areaList = (List)SerializationUtils.fromJsonString((String)areaJsonStr, List.class);
            }
            Long taxationsysId = taxSysId;
            Long taxcategoryId = taxTypeId;
            Date newStartDate = TaxPeriodBusiness.getTaxPeriodStartMonthAndDay(requestModel.getOrgId(), taxationsysId, taxcategoryId, DateUtils.stringToDate((String)requestModel.getSkssqz()));
            businessMap.putAll(UsaShareFactorBusiness.queryUsaShareFactorBySole(requestModel.getOrgId(), DateUtils.format((Date)newStartDate), requestModel.getSkssqz(), (String)draftpurpose, areaList));
        }
        if ((usaCitOrgIncludeUsaFt = requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt")) instanceof String && kd.taxc.bdtaxr.common.util.string.StringUtil.equalsIgnoreCase((CharSequence)((String)usaCitOrgIncludeUsaFt), (CharSequence)"true")) {
            GtcpDraftCalculateBusiness gtcpCalculateService = new GtcpDraftCalculateBusiness();
            List list = gtcpCalculateService.calculateRuleAccess(engineParamDto);
            list.stream().forEach(row -> row.getRuleFetchCellSummaryList().forEach(cell -> {
                if (kd.taxc.bdtaxr.common.util.string.StringUtil.isNotEmpty((CharSequence)cell.getReportItem())) {
                    businessMap.put(cell.getReportItem(), String.valueOf(cell.getAmount()));
                }
            }));
        }
        return businessMap;
    }

    public static RuleEngineParamDto getSbRuleEngineParamDto(DeclareRequestModel requestModel, Long taxSysId, Long taxTypeId, Long taxareagroup) {
        List<Long> fetchItemListById;
        DynamicObject templateObject = MultiDiTemplateHelper.getTemplateByConfig((Long)requestModel.getModelId(), (String)requestModel.getTemplateType(), (String)String.valueOf(requestModel.getOrgId()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqq()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqz()));
        Long templateId = templateObject.getLong("id");
        Long taxationsysId = taxSysId;
        Long taxCategoryId = taxTypeId;
        QFilter taxationSysQ = new QFilter("taxationsys", "=", (Object)taxationsysId);
        QFilter taxcategoryQ = new QFilter("taxcategory.number", "=", (Object)"USA-FT");
        QFilter taxAreaGroupNumberQ = new QFilter("taxareagroup.id", "=", (Object)1681071243350195200L);
        QFilter bizTypeFilter = new QFilter("biztype.number", "in", Arrays.asList(GtcpBizTypeEnum.WP_00023.getNumber(), GtcpBizTypeEnum.WP_00024.getNumber(), GtcpBizTypeEnum.WP_00025.getNumber(), GtcpBizTypeEnum.WP_00026.getNumber(), GtcpBizTypeEnum.WP_00028.getNumber(), GtcpBizTypeEnum.WP_00029.getNumber(), GtcpBizTypeEnum.WP_00030.getNumber(), GtcpBizTypeEnum.WP_00033.getNumber())).and(taxationSysQ).and(taxcategoryQ).and(taxAreaGroupNumberQ);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)"gtcp_fetchitem", (Long)requestModel.getOrgId(), (QFilter)bizTypeFilter, (String)"id");
        List projectIdList = collection.stream().map(o -> o.getLong("id")).collect(Collectors.toList());
        if (1641488655174373376L == taxCategoryId && ObjectUtils.isNotEmpty(fetchItemListById = FetchItemBusiness.getFetchItemListById(Arrays.asList(1858840376929123328L, 1858837696810934272L, 1858839989257993216L)))) {
            projectIdList.addAll(fetchItemListById);
        }
        String draftpurpose = (String)requestModel.getExtendParams().get("draftpurpose");
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId).and(new QFilter("accessproject", "in", projectIdList)).and(new QFilter("rulepurpose", "like", (Object)("%" + draftpurpose + "%")));
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId).and(new QFilter("ruleentity.rule.rulepurpose", "like", (Object)("%" + draftpurpose + "%"))).and(new QFilter("ruleentity.rule.accessproject", "in", projectIdList));
        HashMap<String, String> extendParams = new HashMap<String, String>();
        extendParams.put("usaCitOrgIncludeUsaFt", ObjectUtils.isEmpty(requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt")) ? "false" : requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt"));
        extendParams.put("customEvent", requestModel.getCustomEvent());
        return new RuleEngineParamDto(requestModel.getOrgId(), DateUtils.stringToDate((String)requestModel.getSkssqq()), DateUtils.stringToDate((String)requestModel.getSkssqz()), taxationsysId, taxCategoryId, taxareagroup, templateId, draftpurpose, accessWhereFilter, sharingPlanWhereFilter, extendParams);
    }

    public static void dealWithSbRuleEngineParamDto(DeclareRequestModel requestModel, RuleEngineParamDto paramDto, String taxcategoryNumber, Long orgId, Long taxationsysId, Long taxcategoryId, String draftpourse, boolean flag) {
        if ("nssb".equals(draftpourse) && (GtcpConstant.SDS.contains(taxcategoryNumber) || flag)) {
            Date startDate = TaxPeriodBusiness.getTaxPeriodStartMonthAndDay(orgId, taxationsysId, taxcategoryId, paramDto.getSkssqq());
            paramDto.setSkssqq(startDate);
            paramDto.getExtendParams().put("originalSkssqq", DateUtils.stringToDate((String)requestModel.getSkssqq()));
            paramDto.getExtendParams().put("customEvent", requestModel.getCustomEvent());
        }
    }

    public static Map<String, String> getJtFetchConfigParams(DeclareRequestModel requestModel, Long taxSysId, Long taxTypeId, Long taxareagroup, String taxcategoryNumber, boolean flag) {
        Object draftpurpose = requestModel.getExtendParams().get("draftpurpose");
        if (ObjectUtils.isEmpty(draftpurpose)) {
            return null;
        }
        HashMap<String, String> businessMap = new HashMap<String, String>();
        if ("USA_CIT".equalsIgnoreCase(requestModel.getTemplateType())) {
            List<Long> taxCategories = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(requestModel.getOrgId(), requestModel.getTaxationsys());
            requestModel.getExtendParams().put("usaCitOrgIncludeUsaFt", String.valueOf(taxCategories.contains(1682650334692126720L)));
            ArrayList<Long> areaList = new ArrayList();
            String areaJsonStr = (String)requestModel.getExtendParams().get("USA_CIT_TAX_AREA_LIST");
            if (StringUtils.isNotEmpty((CharSequence)areaJsonStr)) {
                areaList = (List)SerializationUtils.fromJsonString((String)areaJsonStr, List.class);
            }
            businessMap.putAll(UsaShareFactorBusiness.queryUsaShareFactorBySole(requestModel.getOrgId(), DateUtils.format((Date)DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)requestModel.getSkssqq()))), requestModel.getSkssqz(), (String)draftpurpose, areaList));
        }
        Object usaCitOrgIncludeUsaFt = requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt");
        GtcpDraftCalculateBusiness gtcpCalculateService = new GtcpDraftCalculateBusiness();
        List list = gtcpCalculateService.calculateRuleAccess(GtcpFetchDataBussiness.getJtRuleEngineParamDto(requestModel, taxSysId, taxTypeId, taxareagroup, usaCitOrgIncludeUsaFt, taxcategoryNumber, flag));
        list.stream().forEach(row -> row.getRuleFetchCellSummaryList().forEach(cell -> {
            if (StringUtil.isNotEmpty((CharSequence)cell.getReportItem())) {
                businessMap.put(cell.getReportItem(), String.valueOf(cell.getAmount()));
            }
        }));
        return businessMap;
    }

    public static RuleEngineParamDto getJtRuleEngineParamDto(DeclareRequestModel requestModel, Long taxSysId, Long taxTypeId, Long taxareagroup, Object usaCitOrgIncludeUsaFt, String taxcategoryNumber, boolean flag) {
        DynamicObject templateObject = MultiDiTemplateHelper.getTemplateByConfig((Long)requestModel.getModelId(), (String)requestModel.getTemplateType(), (String)String.valueOf(requestModel.getOrgId()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqq()), (Date)DateUtils.stringToDate((String)requestModel.getSkssqz()));
        Long templateId = templateObject.getLong("id");
        String draftpurpose = (String)requestModel.getExtendParams().get("draftpurpose");
        List usaAreaList = new ArrayList();
        String areaJsonStr = (String)requestModel.getExtendParams().get("USA_CIT_TAX_AREA_LIST");
        if (StringUtils.isNotEmpty((CharSequence)areaJsonStr)) {
            usaAreaList = (List)SerializationUtils.fromJsonString((String)areaJsonStr, List.class);
        }
        ArrayList projectIdAllList = new ArrayList();
        Long taxationsysId = taxSysId;
        Long taxcategoryId = taxTypeId;
        Long taxareagroupId = taxareagroup;
        QFilter taxationSysQ = new QFilter("taxationsys", "=", (Object)taxationsysId);
        QFilter taxcategoryQ = new QFilter("taxcategory", "=", (Object)taxcategoryId);
        if (TaxationsysMappingEnum.DEU.getId().equals(taxationsysId)) {
            taxcategoryQ = new QFilter("taxcategory", "in", Arrays.asList(taxcategoryId, FixedCellFetchTransFormProjectEnum.DEU_SS_amount_accrued.getTaxcategory(), FixedCellFetchTransFormProjectEnum.DEU_TT_amount_accrued.getTaxcategory()));
        } else if (TaxationsysMappingEnum.JAP.getId().equals(taxationsysId)) {
            taxcategoryQ = new QFilter("taxcategory", "in", Arrays.asList(taxcategoryId, FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_ET.getTaxcategory(), FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_IT1.getTaxcategory(), FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_IT2.getTaxcategory(), FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_LCIT.getTaxcategory(), FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_SET.getTaxcategory()));
        }
        QFilter taxareagroupQ = TaxationsysMappingEnum.USA.getId().equals(taxationsysId) ? new QFilter("taxareagroup", "in", usaAreaList) : new QFilter("taxareagroup", "=", (Object)taxareagroupId);
        QFilter bizTypeFilterQ = new QFilter("biztype.number", "in", Arrays.asList(GtcpBizTypeEnum.WP_00031.getNumber(), GtcpBizTypeEnum.WP_00033.getNumber())).and(taxationSysQ).and(taxcategoryQ).and(taxareagroupQ);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)"gtcp_fetchitem", (Long)requestModel.getOrgId(), (QFilter)bizTypeFilterQ, (String)"id");
        collection.stream().forEach(o -> projectIdAllList.add(o.getLong("id")));
        if (usaCitOrgIncludeUsaFt instanceof String && StringUtil.equalsIgnoreCase((CharSequence)((String)usaCitOrgIncludeUsaFt), (CharSequence)"true")) {
            QFilter taxcategoryQU = new QFilter("taxcategory.number", "=", (Object)"USA-FT");
            QFilter taxAreaGroupNumberQU = new QFilter("taxareagroup.id", "=", (Object)1681071243350195200L);
            QFilter bizTypeFilter = new QFilter("biztype.number", "in", Arrays.asList(GtcpBizTypeEnum.WP_00023.getNumber(), GtcpBizTypeEnum.WP_00024.getNumber(), GtcpBizTypeEnum.WP_00025.getNumber(), GtcpBizTypeEnum.WP_00026.getNumber(), GtcpBizTypeEnum.WP_00028.getNumber(), GtcpBizTypeEnum.WP_00029.getNumber(), GtcpBizTypeEnum.WP_00030.getNumber(), GtcpBizTypeEnum.WP_00031.getNumber())).and(taxationSysQ).and(taxcategoryQU).and(taxAreaGroupNumberQU);
            DynamicObjectCollection collectionU = BaseDataServiceHelper.queryBaseData((String)"gtcp_fetchitem", (Long)requestModel.getOrgId(), (QFilter)bizTypeFilter, (String)"id");
            collectionU.stream().forEach(o -> projectIdAllList.add(o.getLong("id")));
        }
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId).and(new QFilter("accessproject", "in", projectIdAllList)).and(new QFilter("rulepurpose", "like", (Object)("%" + draftpurpose + "%")));
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxationsysId).and(new QFilter("ruleentity.rule.rulepurpose", "like", (Object)("%" + draftpurpose + "%"))).and(new QFilter("ruleentity.rule.accessproject", "in", projectIdAllList));
        if (GtcpConstant.SDS.contains(taxcategoryNumber) || flag) {
            return new RuleEngineParamDto(requestModel.getOrgId(), DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate((String)requestModel.getSkssqq())), DateUtils.stringToDate((String)requestModel.getSkssqz()), taxationsysId, taxcategoryId, taxareagroupId, templateId, draftpurpose, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)DateUtils.stringToDate((String)requestModel.getSkssqq()), (Object)"usaCitOrgIncludeUsaFt", (Object)(ObjectUtils.isEmpty(requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt")) ? "false" : requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt")), (Object)"customEvent", (Object)requestModel.getCustomEvent()));
        }
        return new RuleEngineParamDto(requestModel.getOrgId(), DateUtils.stringToDate((String)requestModel.getSkssqq()), DateUtils.stringToDate((String)requestModel.getSkssqz()), taxationsysId, taxcategoryId, taxareagroupId, templateId, draftpurpose, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"usaCitOrgIncludeUsaFt", (Object)(ObjectUtils.isEmpty(requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt")) ? "false" : requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt")), (Object)"customEvent", (Object)requestModel.getCustomEvent()));
    }

    public static String declareMapTaxablePaystatus(DynamicObject obj) {
        if (ObjectUtils.isEmpty((Object)obj)) {
            return "unpaid";
        }
        return GtcpFetchDataBussiness.declareMapTaxablePaystatus(obj.getString("payrefundstatus"));
    }

    public static String declareMapTaxablePaystatus(String paystatus) {
        if (ObjectUtils.isEmpty((Object)paystatus) || "unpayrefund".equals(paystatus)) {
            return "unpaid";
        }
        if ("partpayrefund".equals(paystatus)) {
            return "paying";
        }
        if ("payrefund".equals(paystatus)) {
            return "paid";
        }
        if ("nopayrefund".equals(paystatus)) {
            return "nopay";
        }
        return "unpaid";
    }
}

