/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.fetchitem;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import org.apache.commons.lang3.ObjectUtils;

public class FetchItemBusiness {
    public static DynamicObjectCollection getFetchItems(Long orgId, Long taxSystemId, Long taxcategoryId, Long taxareagroupId, Collection<String> biztypeList) {
        QFilter taxSysFilter = new QFilter("taxationsys", "=", (Object)taxSystemId);
        QFilter taxCategoryFilter = new QFilter("taxcategory", "=", (Object)taxcategoryId);
        QFilter taxAreagroupFilter = new QFilter("taxareagroup", "=", (Object)taxareagroupId);
        QFilter fetchItemsFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("biztype.number", "in", biztypeList)).and(taxSysFilter).and(taxCategoryFilter).and(taxAreagroupFilter);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)"gtcp_fetchitem", (Long)orgId, (QFilter)fetchItemsFilter, (String)"id,org,number,name,taxationsys,biztype.number,ctrlstrategy,taxareagroup.number,taxareagroup.id,taxcategory.number,taxcategory.id");
        Collections.sort(collection, (o1, o2) -> o1.getString("number").compareToIgnoreCase(o2.getString("number")));
        return collection;
    }

    public static DynamicObjectCollection getFetchItems(Long orgId, Long taxSystemId, Long taxcategoryId, List taxAreaGroupIdList, Collection<String> biztypeList) {
        QFilter taxSysFilter = new QFilter("taxationsys", "=", (Object)taxSystemId);
        QFilter taxCategoryFilter = new QFilter("taxcategory", "=", (Object)taxcategoryId);
        QFilter taxAreagroupFilter = new QFilter("taxareagroup", "in", (Object)taxAreaGroupIdList);
        QFilter fetchItemsFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("biztype.number", "in", biztypeList)).and(taxSysFilter).and(taxCategoryFilter).and(taxAreagroupFilter);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)"gtcp_fetchitem", (Long)orgId, (QFilter)fetchItemsFilter, (String)"id,org,number,name,taxationsys,biztype.number,ctrlstrategy,taxareagroup.number,taxareagroup.id,taxcategory.number,taxcategory.id");
        Collections.sort(collection, (o1, o2) -> o1.getString("number").compareToIgnoreCase(o2.getString("number")));
        return collection;
    }

    public static DynamicObjectCollection getFetchItems(Long orgId, Long taxSystemId, List taxcategoryId, Long taxareagroupId, Collection<String> biztypeList) {
        QFilter taxSysFilter = new QFilter("taxationsys", "=", (Object)taxSystemId);
        QFilter taxCategoryFilter = new QFilter("taxcategory", "in", (Object)taxcategoryId);
        QFilter taxAreagroupFilter = new QFilter("taxareagroup", "=", (Object)taxareagroupId);
        QFilter fetchItemsFilter = new QFilter("isleaf", "=", (Object)Boolean.TRUE).and(new QFilter("enable", "=", (Object)"1")).and(new QFilter("biztype.number", "in", biztypeList)).and(taxSysFilter).and(taxCategoryFilter).and(taxAreagroupFilter);
        DynamicObjectCollection collection = BaseDataServiceHelper.queryBaseData((String)"gtcp_fetchitem", (Long)orgId, (QFilter)fetchItemsFilter, (String)"id,org,number,name,taxationsys,biztype.number,ctrlstrategy,taxareagroup.number,taxareagroup.id,taxcategory.number,taxcategory.id");
        Collections.sort(collection, (o1, o2) -> o1.getString("number").compareToIgnoreCase(o2.getString("number")));
        return collection;
    }

    public static Map<String, List<Long>> getFetchItemIdWithOrder(List<Long> idList) {
        HashMap<String, List<Long>> resultMap = new HashMap<String, List<Long>>(16);
        QFilter idFilter = new QFilter("id", "in", idList);
        DynamicObject[] dynamicObjectCollection = BusinessDataServiceHelper.load((String)"gtcp_fetchitem", (String)"id,org,number,name,taxationsys,biztype.number,ctrlstrategy,taxareagroup.number,taxareagroup.id,taxcategory.number,taxcategory.id", (QFilter[])new QFilter[]{idFilter}, (String)"number");
        List list = Arrays.stream(dynamicObjectCollection).collect(Collectors.toList());
        Collections.sort(list, (o1, o2) -> o1.getString("number").compareToIgnoreCase(o2.getString("number")));
        if (ObjectUtils.isNotEmpty(list)) {
            for (DynamicObject dynamicObject : list) {
                String biztype = dynamicObject.getString("biztype.number");
                long fid = dynamicObject.getLong("id");
                if (resultMap.containsKey(biztype)) {
                    ((List)resultMap.get(biztype)).add(fid);
                    continue;
                }
                ArrayList<Long> fetchIdList = new ArrayList<Long>(12);
                fetchIdList.add(fid);
                resultMap.put(biztype, fetchIdList);
            }
        }
        return resultMap;
    }

    public static List<Long> getFetchItemListById(List<Long> idList) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        QFilter idFilter = new QFilter("id", "in", idList).and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjectCollection = BusinessDataServiceHelper.load((String)"gtcp_fetchitem", (String)"id,org,number,name,taxationsys,biztype.number,ctrlstrategy,taxareagroup.number,taxareagroup.id,taxcategory.number,taxcategory.id", (QFilter[])new QFilter[]{idFilter}, (String)"number");
        if (ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
            for (DynamicObject dyn : dynamicObjectCollection) {
                resultList.add(dyn.getLong("id"));
            }
        }
        return resultList;
    }
}

