/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.provision;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.helper.TaxOrgTakeRelationServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.draft.UsaCitBussiness;
import kd.taxc.gtcp.common.enums.GtcpCitThanTaxAreaGroupProvisionEnum;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupProvisionEnum;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupThanTaxesEnum;
import org.apache.commons.lang3.ObjectUtils;

public interface GenerateProvisionBillService {
    public Map<Boolean, Map<Long, String>> generateProvisionBill(List<Long> var1);

    public static enum TemplateProvisionItemEnum {
        OVERSEAS_CIT_01("OVERSEAS-CIT-01", new String[]{ProvisionItemEnum.JTSX_YS_AUS_CIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_DEU_CIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_GBR_CIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_HKG_CIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_CIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_SGP_CIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_1022.getProvisionItemNumber(), ProvisionItemEnum.JTSX_1023.getProvisionItemNumber(), ProvisionItemEnum.JTSX_1024.getProvisionItemNumber(), ProvisionItemEnum.JTSX_1025.getProvisionItemNumber(), ProvisionItemEnum.JTSX_1026.getProvisionItemNumber(), ProvisionItemEnum.JTSX_1027.getProvisionItemNumber(), ProvisionItemEnum.JTSX_1028.getProvisionItemNumber()}),
        USA_CIT_01("USA-CIT-01", new String[]{ProvisionItemEnum.JTSX_YS_USA_CIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_USA_FT_0001.getProvisionItemNumber()}),
        OVERSEAS_CIT_RTA_01("OVERSEAS-CIT-RTA-01", new String[]{ProvisionItemEnum.JTSX_YS_HKG_CIT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_SGP_CIT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_DEU_CIT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_DEU_TT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_DEU_SS_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_AUS_CIT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_CIT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_SET_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_ET_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_IT_2_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_IT_1_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_LCIT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_GBR_CIT_0002.getProvisionItemNumber()}),
        OVERSEAS_VAT_RTA_01("OVERSEAS-VAT-RTA-01", new String[]{ProvisionItemEnum.JTSX_YS_AUS_VAT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_AUS_VAT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_DEU_VAT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_DEU_VAT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_GBR_VAT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_GBR_VAT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_VAT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_JAP_VAT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_SGP_VAT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_SGP_VAT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_USA_VAT_0001.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_USA_VAT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_USA_VAT_0003.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_USA_VAT_0004.getProvisionItemNumber()}),
        USA_CIT_RAT_01("USA-CIT-RAT-01", new String[]{ProvisionItemEnum.JTSX_YS_USA_CIT_0002.getProvisionItemNumber(), ProvisionItemEnum.JTSX_YS_USA_FT_0002.getProvisionItemNumber()});

        private String template;
        private String[] provisionItems;

        private TemplateProvisionItemEnum(String template, String[] provisionItems) {
            this.template = template;
            this.provisionItems = provisionItems;
        }

        public String getTemplate() {
            return this.template;
        }

        public String[] getProvisionItems() {
            return this.provisionItems;
        }

        public static TemplateProvisionItemEnum getEnumByTemplate(String template) {
            for (TemplateProvisionItemEnum templateProvisionItemEnum : TemplateProvisionItemEnum.values()) {
                if (!templateProvisionItemEnum.getTemplate().equals(template)) continue;
                return templateProvisionItemEnum;
            }
            return null;
        }
    }

    public static enum ProvisionItemEnum {
        JTSX_YS_AUS_CIT_0001("JTSX-YS-AUS-CIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#generalincome_amount");
            }
        }
        ,
        JTSX_YS_DEU_CIT_0001("JTSX-YS-DEU-CIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#generalincome_amount");
            }
        }
        ,
        JTSX_1022("JTSX-1022"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#solidarity_surcharge_amount");
            }
        }
        ,
        JTSX_1023("JTSX-1023"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#trade_tax_amount");
            }
        }
        ,
        JTSX_YS_GBR_CIT_0001("JTSX-YS-GBR-CIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#generalincome_amount");
            }
        }
        ,
        JTSX_YS_HKG_CIT_0001("JTSX-YS-HKG-CIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#generalincome_amount");
            }
        }
        ,
        JTSX_YS_JAP_CIT_0001("JTSX-YS-JAP-CIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#generalincome_amount");
            }
        }
        ,
        JTSX_1024("JTSX-1024"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#local_income_tax_amount");
            }
        }
        ,
        JTSX_1025("JTSX-1025"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#inhabitants_taxprop_amount");
            }
        }
        ,
        JTSX_1026("JTSX-1026"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#inhabitants_taxnorm_amount");
            }
        }
        ,
        JTSX_1027("JTSX-1027"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#enterprise_tax_amount");
            }
        }
        ,
        JTSX_1028("JTSX-1028"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#special_enter_tax_amount");
            }
        }
        ,
        JTSX_YS_SGP_CIT_0001("JTSX-YS-SGP-CIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("generalincome_amount_tobe_accrued#generalincome_amount");
            }
        }
        ,
        JTSX_YS_USA_CIT_0001("JTSX-YS-USA-CIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, "");
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                List<String> usaCitDraftTabList = UsaCitBussiness.queryUsaCitDraftTabByDraftId(draftDynmicObject.getLong("id"));
                usaCitDraftTabList.add(UsaTaxAreaGroupProvisionEnum.Federation.getTaxAreaGroupName());
                return UsaTaxAreaGroupProvisionEnum.getAllReportItemList(usaCitDraftTabList);
            }

            @Override
            public Map<String, Map<String, Object>> createTotalResult(Map<String, BigDecimal> decimalMap, String taxAreaGroupId) {
                Iterator<Map.Entry<String, BigDecimal>> iterator = decimalMap.entrySet().iterator();
                HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(12);
                while (iterator.hasNext()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    Map.Entry<String, BigDecimal> next = iterator.next();
                    String reportItemkey = next.getKey();
                    BigDecimal value = next.getValue();
                    map.put(reportItemkey, value);
                    map.put("taxAreaGroupId", UsaTaxAreaGroupProvisionEnum.getTaxAreaGroupIdByReportItem(reportItemkey));
                    resultMap.put(reportItemkey, map);
                }
                return resultMap;
            }
        }
        ,
        JTSX_YS_USA_FT_0001("JTSX-YS-USA-FT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject));
                return this.createTotalResult(decimalMap, "1681071243350195200");
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("Amount_to_be_accrued#Amount_Texas_FT");
            }
        }
        ,
        JTSX_YS_HKG_CIT_0002("JTSX-YS-HKG-CIT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            protected Map<String, BigDecimal> getCellValue(Long draftId, List<String> cellNumberList) {
                HashMap<String, BigDecimal> decimalMap = new HashMap<String, BigDecimal>(2);
                QFilter idQ = new QFilter("id", "=", (Object)draftId);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"gtcp_jt_declare_than_list", (String)"entryentity.difference as difference", (QFilter[])new QFilter[]{idQ});
                BigDecimal lastAmount = BigDecimal.ZERO;
                for (DynamicObject coll : collection) {
                    lastAmount = lastAmount.add(null == coll.getBigDecimal("difference") ? BigDecimal.ZERO : coll.getBigDecimal("difference"));
                }
                decimalMap.put(cellNumberList.get(0), lastAmount);
                return decimalMap;
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("declaretax_taxaccrual_difference");
            }
        }
        ,
        JTSX_YS_SGP_CIT_0002("JTSX-YS-SGP-CIT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_HKG_CIT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_HKG_CIT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_DEU_CIT_0002("JTSX-YS-DEU-CIT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_HKG_CIT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_HKG_CIT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_DEU_TT_0001("JTSX-YS-DEU-TT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> resultList = new ArrayList<String>(2);
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Trade_tax.getAccrualItemList());
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Trade_tax.getReportItemList());
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), resultList);
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"), GtcpCitThanTaxAreaGroupProvisionEnum.Trade_tax.getAccrualItemList().get(0), GtcpCitThanTaxAreaGroupProvisionEnum.Trade_tax.getReportItemList().get(0));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("total");
            }
        }
        ,
        JTSX_YS_DEU_SS_0001("JTSX-YS-DEU-SS-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> resultList = new ArrayList<String>(2);
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Solidarity_surcharge.getAccrualItemList());
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Solidarity_surcharge.getReportItemList());
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), resultList);
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"), GtcpCitThanTaxAreaGroupProvisionEnum.Solidarity_surcharge.getAccrualItemList().get(0), GtcpCitThanTaxAreaGroupProvisionEnum.Solidarity_surcharge.getReportItemList().get(0));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_DEU_TT_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_AUS_CIT_0002("JTSX-YS-AUS-CIT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_HKG_CIT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_HKG_CIT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_JAP_CIT_0002("JTSX-YS-JAP-CIT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_HKG_CIT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_HKG_CIT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_JAP_SET_0001("JTSX-YS-JAP-SET-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> resultList = new ArrayList<String>(2);
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Special_enterprise_tax.getAccrualItemList());
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Special_enterprise_tax.getReportItemList());
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), resultList);
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"), GtcpCitThanTaxAreaGroupProvisionEnum.Special_enterprise_tax.getAccrualItemList().get(0), GtcpCitThanTaxAreaGroupProvisionEnum.Special_enterprise_tax.getReportItemList().get(0));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("total");
            }
        }
        ,
        JTSX_YS_JAP_ET_0001("JTSX-YS-JAP-ET-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> resultList = new ArrayList<String>(2);
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Enterprise_tax.getAccrualItemList());
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Enterprise_tax.getReportItemList());
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), resultList);
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"), GtcpCitThanTaxAreaGroupProvisionEnum.Enterprise_tax.getAccrualItemList().get(0), GtcpCitThanTaxAreaGroupProvisionEnum.Enterprise_tax.getReportItemList().get(0));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_JAP_SET_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_JAP_IT_2_0001("JTSX-YS-JAP-IT-2-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> resultList = new ArrayList<String>(2);
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_normquota.getAccrualItemList());
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_normquota.getReportItemList());
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), resultList);
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"), GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_normquota.getAccrualItemList().get(0), GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_normquota.getReportItemList().get(0));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_JAP_SET_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_JAP_IT_1_0001("JTSX-YS-JAP-IT-1-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> resultList = new ArrayList<String>(2);
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_proportional.getAccrualItemList());
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_proportional.getReportItemList());
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), resultList);
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"), GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_proportional.getAccrualItemList().get(0), GtcpCitThanTaxAreaGroupProvisionEnum.Inhabitants_tax_proportional.getReportItemList().get(0));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_JAP_SET_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_JAP_LCIT_0001("JTSX-YS-JAP-LCIT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> resultList = new ArrayList<String>(2);
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Local_income_tax.getAccrualItemList());
                resultList.addAll(GtcpCitThanTaxAreaGroupProvisionEnum.Local_income_tax.getReportItemList());
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), resultList);
                return this.createTotalResult(decimalMap, draftDynamicObject.getString("taxareagroup.id"), GtcpCitThanTaxAreaGroupProvisionEnum.Local_income_tax.getAccrualItemList().get(0), GtcpCitThanTaxAreaGroupProvisionEnum.Local_income_tax.getReportItemList().get(0));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_JAP_SET_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_GBR_CIT_0002("JTSX-YS-GBR-CIT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_HKG_CIT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_HKG_CIT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_USA_CIT_0002("JTSX-YS-USA-CIT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                ArrayList<String> list = new ArrayList<String>();
                List<String> usaCitDraftTabList = this.getUsaCitDraftTabList(draftDynamicObject);
                List<String> accrualItemList = UsaTaxAreaGroupThanTaxesEnum.getAccrualItemListByTaxAreaGroupId(usaCitDraftTabList);
                list.addAll(accrualItemList);
                list.addAll(UsaTaxAreaGroupThanTaxesEnum.getReportingItemListByTaxAreaGroupId(usaCitDraftTabList));
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), list);
                HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
                for (String accrualItem : accrualItemList) {
                    List reportingItemList;
                    if (map.containsKey(accrualItem) || null == (reportingItemList = UsaTaxAreaGroupThanTaxesEnum.getReportItemListByAccrualItem(accrualItem)) || reportingItemList.size() <= 0) continue;
                    BigDecimal reportingAmount = decimalMap.get(reportingItemList.get(0)) == null ? BigDecimal.ZERO : decimalMap.get(reportingItemList.get(0));
                    BigDecimal accrualAmount = decimalMap.get(accrualItem) == null ? BigDecimal.ZERO : decimalMap.get(accrualItem);
                    map.put(accrualItem, reportingAmount.subtract(accrualAmount).setScale(2, 4));
                }
                return this.createTotalResult(map, "");
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynamicObject) {
                return UsaTaxAreaGroupThanTaxesEnum.getAccrualItemListByTaxAreaGroupId(this.getUsaCitDraftTabList(draftDynamicObject));
            }

            @Override
            public Map<String, Map<String, Object>> createTotalResult(Map<String, BigDecimal> decimalMap, String taxAreaGroupId) {
                Iterator<Map.Entry<String, BigDecimal>> iterator = decimalMap.entrySet().iterator();
                HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(12);
                while (iterator.hasNext()) {
                    HashMap<String, Object> map = new HashMap<String, Object>(2);
                    Map.Entry<String, BigDecimal> next = iterator.next();
                    String reportItemkey = next.getKey();
                    BigDecimal value = next.getValue();
                    map.put(reportItemkey, value);
                    map.put("taxAreaGroupId", UsaTaxAreaGroupThanTaxesEnum.getTaxAreaGroupIdByAccrualItem(reportItemkey));
                    resultMap.put(reportItemkey, map);
                }
                return resultMap;
            }

            private List<String> getUsaCitDraftTabList(DynamicObject draftDynamicObject) {
                List<String> usaCitDraftTabList = UsaCitBussiness.queryUsaCitDraftThanTabByDraftId(draftDynamicObject.getLong("id"));
                usaCitDraftTabList.add(UsaTaxAreaGroupThanTaxesEnum.Federation.getTaxAreaGroupName());
                return usaCitDraftTabList;
            }
        }
        ,
        JTSX_YS_USA_FT_0002("JTSX-YS-USA-FT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                Map<String, BigDecimal> decimalMap = this.getCellValue(draftDynamicObject.getLong("id"), Lists.newArrayList((Object[])new String[]{"Total_amount_due_and_payable#RTA_Texas_FT_Reporting", "Amount_to_be_accrued#RTA_Texas_FT_Accrual"}));
                BigDecimal reportingAmount = decimalMap.get("Total_amount_due_and_payable#RTA_Texas_FT_Reporting") == null ? BigDecimal.ZERO : decimalMap.get("Total_amount_due_and_payable#RTA_Texas_FT_Reporting");
                BigDecimal accrualAmount = decimalMap.get("Amount_to_be_accrued#RTA_Texas_FT_Accrual") == null ? BigDecimal.ZERO : decimalMap.get("Amount_to_be_accrued#RTA_Texas_FT_Accrual");
                HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
                map.put(this.getReportItemKeys(draftDynamicObject).get(0), reportingAmount.subtract(accrualAmount).setScale(2, 4));
                return this.createTotalResult(map, "1681071243350195200");
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("reporting_accrual_difference");
            }
        }
        ,
        JTSX_YS_AUS_VAT_0001("JTSX-YS-AUS-VAT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("vat_Gtc_Purchases#vat_rta_differences");
            }
        }
        ,
        JTSX_YS_DEU_VAT_0001("JTSX-YS-DEU-VAT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0001.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_GBR_VAT_0001("JTSX-YS-GBR-VAT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0001.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_JAP_VAT_0001("JTSX-YS-JAP-VAT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0001.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_SGP_VAT_0001("JTSX-YS-SGP-VAT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0001.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_USA_VAT_0001("JTSX-YS-USA-VAT-0001"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0001.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_USA_VAT_0003("JTSX-YS-USA-VAT-0003"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0001.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0001.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_AUS_VAT_0002("JTSX-YS-AUS-VAT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return this.createTotalResult(this.getCellValue(draftDynamicObject.getLong("id"), this.getReportItemKeys(draftDynamicObject)), draftDynamicObject.getString("taxareagroup.id"));
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return Collections.singletonList("vat_Gtc_Sales#vat_rta_differences");
            }
        }
        ,
        JTSX_YS_DEU_VAT_0002("JTSX-YS-DEU-VAT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_GBR_VAT_0002("JTSX-YS-GBR-VAT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_JAP_VAT_0002("JTSX-YS-JAP-VAT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_SGP_VAT_0002("JTSX-YS-SGP-VAT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_USA_VAT_0002("JTSX-YS-USA-VAT-0002"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0002.getReportItemKeys(draftDynmicObject);
            }
        }
        ,
        JTSX_YS_USA_VAT_0004("JTSX-YS-USA-VAT-0004"){

            @Override
            public Map<String, Map<String, Object>> getTotal(DynamicObject draftDynamicObject) {
                return JTSX_YS_AUS_VAT_0002.getTotal(draftDynamicObject);
            }

            @Override
            public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
                return JTSX_YS_AUS_VAT_0002.getReportItemKeys(draftDynmicObject);
            }
        };

        private String provisionItemNumber;

        public Date getEntryDate(DynamicObject draftDynamicObject) {
            return draftDynamicObject.getDate("skssqz");
        }

        public Long getAccountOrg(DynamicObject draftDynamicObject) {
            Long taxorgId = draftDynamicObject.getLong("org.id");
            List orgTakeRelation = TaxOrgTakeRelationServiceHelper.getOrgTakeRelation(Collections.singletonList(taxorgId), (Date)draftDynamicObject.getDate("skssqq"), (Date)draftDynamicObject.getDate("skssqz"));
            if (ObjectUtils.isNotEmpty((Object)orgTakeRelation)) {
                HashSet set = new HashSet(orgTakeRelation);
                if (set.size() == 1 && !((Long)set.stream().findFirst().get()).equals(0L)) {
                    return (Long)set.stream().findFirst().get();
                }
                if (set.size() == 2 && set.contains(taxorgId)) {
                    Long org = 0L;
                    for (Long id : set) {
                        if (id.equals(taxorgId)) continue;
                        org = id;
                        break;
                    }
                    return org;
                }
                if (set.size() > 2 && set.contains(taxorgId)) {
                    return taxorgId;
                }
                return (Long)orgTakeRelation.get(0);
            }
            return null;
        }

        public Long getAccountOrgBasecurrrency(Long accountOrg) {
            Map baseAccountingInfo = BaseDataServiceHelper.getBaseAccountingInfo((Long)accountOrg);
            if (ObjectUtils.isNotEmpty((Object)baseAccountingInfo)) {
                return (Long)baseAccountingInfo.get("baseCurrencyID");
            }
            return -1L;
        }

        public abstract Map<String, Map<String, Object>> getTotal(DynamicObject var1);

        public Map<String, Map<String, Object>> createTotalResult(Map<String, BigDecimal> decimalMap, String taxAreaGroupId) {
            Iterator<Map.Entry<String, BigDecimal>> iterator = decimalMap.entrySet().iterator();
            HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(12);
            while (iterator.hasNext()) {
                HashMap<String, Object> map = new HashMap<String, Object>(2);
                Map.Entry<String, BigDecimal> next = iterator.next();
                String reportItemkey = next.getKey();
                BigDecimal value = next.getValue();
                map.put(reportItemkey, value);
                map.put("taxAreaGroupId", taxAreaGroupId);
                resultMap.put(reportItemkey, map);
            }
            return resultMap;
        }

        public Map<String, Map<String, Object>> createTotalResult(Map<String, BigDecimal> decimalMap, String taxAreaGroupId, String accrualKey, String reportingKey) {
            HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(12);
            BigDecimal accrual = decimalMap.containsKey(accrualKey) ? decimalMap.get(accrualKey) : BigDecimal.ZERO;
            BigDecimal reporting = decimalMap.containsKey(reportingKey) ? decimalMap.get(reportingKey) : BigDecimal.ZERO;
            HashMap<String, Object> map = new HashMap<String, Object>(2);
            map.put("total", reporting.subtract(accrual));
            map.put("taxAreaGroupId", taxAreaGroupId);
            resultMap.put("total", map);
            return resultMap;
        }

        public List<String> getReportItemKeys(DynamicObject draftDynmicObject) {
            return new ArrayList<String>();
        }

        protected Map<String, BigDecimal> getCellValue(Long draftId, List<String> cellNumberList) {
            HashMap<String, BigDecimal> resultMap = new HashMap<String, BigDecimal>(2);
            if (ObjectUtils.isEmpty(cellNumberList)) {
                return resultMap;
            }
            QFilter entryidQ = new QFilter("entryid", "=", (Object)draftId);
            QFilter cellnumberQ = new QFilter("cellnumber", "in", cellNumberList);
            DynamicObjectCollection collection = QueryServiceHelper.query((String)MultiTableEnum.TSD001.getDeclareDetailTabled(), (String)"value,cellnumber", (QFilter[])new QFilter[]{entryidQ, cellnumberQ});
            collection.stream().forEach(coll -> resultMap.put(coll.getString("cellnumber"), StringUtil.isNotEmpty((CharSequence)coll.getString("value")) ? coll.getBigDecimal("value") : BigDecimal.ZERO));
            return resultMap;
        }

        private ProvisionItemEnum(String provisionItemNumber) {
            this.provisionItemNumber = provisionItemNumber;
        }

        public String getProvisionItemNumber() {
            return this.provisionItemNumber;
        }

        public static ProvisionItemEnum getEnumByProvisionItem(String provisionItem) {
            for (ProvisionItemEnum provisionItemEnum : ProvisionItemEnum.values()) {
                if (!provisionItemEnum.getProvisionItemNumber().equals(provisionItem)) continue;
                return provisionItemEnum;
            }
            return null;
        }
    }
}

