/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.provision;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.provision.ProvisionSharePlanDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpProvisionPlanBusiness {
    public static String queryMinProvisionPlan(Long orgId, Long taxationsysId, Long categoryId, Long taxareaId, Date skssqq, Date skssqz) {
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)categoryId) || ObjectUtils.isEmpty((Object)taxareaId) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return "";
        }
        List<String> planList = GtcpProvisionPlanBusiness.queryAllJtPlanBySharePlan(orgId, taxationsysId, categoryId, taxareaId, skssqq, skssqz);
        if (ObjectUtils.isNotEmpty(planList)) {
            if (planList.contains("month")) {
                return "month";
            }
            if (planList.contains("season")) {
                return "season";
            }
            if (planList.contains("year")) {
                return "year";
            }
        }
        return "";
    }

    public static Map<String, Set<Long>> querySharePlanByOrgIds(List<Long> orgList, Long taxationsysId, Long categoryId, Long taxareaId, Date skssqq, Date skssqz) {
        HashMap<String, Set<Long>> planMap = new HashMap<String, Set<Long>>(12);
        if (ObjectUtils.isEmpty(orgList) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)categoryId) || ObjectUtils.isEmpty((Object)taxareaId) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return planMap;
        }
        TaxResult dynamicObjectCollectionTaxResult = ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIdsAndCategoryId(orgList, (Long)categoryId, (Long)taxationsysId, (Date)skssqq, (Date)skssqz);
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollectionTaxResult) || !dynamicObjectCollectionTaxResult.isSuccess()) {
            return planMap;
        }
        DynamicObjectCollection sharePlans = (DynamicObjectCollection)dynamicObjectCollectionTaxResult.getData();
        for (DynamicObject sharePlan : sharePlans) {
            DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
            ArrayList<Long> orgs = new ArrayList<Long>(8);
            for (DynamicObject org : orgentity) {
                if (!orgList.contains(org.getDynamicObject("org").getLong("id"))) continue;
                orgs.add(org.getDynamicObject("org").getLong("id"));
            }
            DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
            for (DynamicObject rule : ruleentity) {
                DynamicObject plan = rule.getDynamicObject("rule");
                String taxsystem = plan.getString("taxsystem.id");
                String taxarea = plan.getString("taxarea.id");
                String taxtype = plan.getString("taxtype.id");
                String cycle = plan.getString("cycle");
                String planMapKey = String.format("%s-%s-%s-%s", taxsystem, taxarea, taxtype, cycle);
                Set planOrgs = planMap.computeIfAbsent(planMapKey, d -> new HashSet());
                planOrgs.addAll(orgs);
            }
        }
        return planMap;
    }

    public static Map<String, Set<Long>> querySharePlanByOrgIds(List<Long> orgList) {
        HashMap<String, Set<Long>> planMap = new HashMap<String, Set<Long>>(12);
        if (ObjectUtils.isEmpty(orgList)) {
            return planMap;
        }
        List sharePlans = (List)ProvisionSharePlanDataServiceHelper.queryProvisionSharePlanByOrgIds(orgList).getData();
        for (DynamicObject sharePlan : sharePlans) {
            DynamicObjectCollection orgentity = sharePlan.getDynamicObjectCollection("orgentity");
            ArrayList<Long> orgs = new ArrayList<Long>(8);
            for (DynamicObject org : orgentity) {
                if (!orgList.contains(org.getDynamicObject("org").getLong("id"))) continue;
                orgs.add(org.getDynamicObject("org").getLong("id"));
            }
            DynamicObjectCollection ruleentity = sharePlan.getDynamicObjectCollection("ruleentity");
            for (DynamicObject rule : ruleentity) {
                DynamicObject plan = rule.getDynamicObject("rule");
                String taxsystem = plan.getString("taxsystem.id");
                String taxtype = plan.getString("taxtype.id");
                String taxarea = plan.getString("taxarea.id");
                String beginTime = ObjectUtils.isNotEmpty((Object)plan.getDate("startdate")) ? kd.taxc.bdtaxr.common.utils.date.DateUtils.format((Date)plan.getDate("startdate"), (String)"yyyy-MM-dd") : null;
                String endTime = ObjectUtils.isNotEmpty((Object)plan.getDate("enddate")) ? kd.taxc.bdtaxr.common.utils.date.DateUtils.format((Date)plan.getDate("enddate"), (String)"yyyy-MM-dd") : null;
                String cycle = plan.getString("cycle");
                String planMapKey = String.format("%s_%s_%s_%s_%s_%s", taxsystem, taxtype, taxarea, beginTime, endTime, cycle);
                Set planOrgs = planMap.computeIfAbsent(planMapKey, d -> new HashSet());
                planOrgs.addAll(orgs);
            }
        }
        return planMap;
    }

    public static List<String> queryAllJtPlanBySharePlan(Long orgId, Long taxationsysId, Long categoryId, Long taxareaId, Date skssqq, Date skssqz) {
        ArrayList<String> jtPlanList = new ArrayList<String>(3);
        if (ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsysId) || ObjectUtils.isEmpty((Object)categoryId) || ObjectUtils.isEmpty((Object)taxareaId) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return jtPlanList;
        }
        Map<String, Set<Long>> planByOrgIds = GtcpProvisionPlanBusiness.querySharePlanByOrgIds(Collections.singletonList(orgId), taxationsysId, categoryId, taxareaId, skssqq, skssqz);
        Set<Map.Entry<String, Set<Long>>> entries = planByOrgIds.entrySet();
        for (Map.Entry<String, Set<Long>> next : entries) {
            Set<Long> longSet = next.getValue();
            if (!longSet.contains(orgId)) continue;
            String nextKey = next.getKey();
            String[] split = nextKey.split("-");
            jtPlanList.add(split[3]);
        }
        return jtPlanList;
    }

    public static ImmutablePair<Date, Date> provisionPeriod(Date now, String provisionPlan) {
        Date endDate;
        Date startDate;
        if ("season".equals(provisionPlan)) {
            Date date = DateUtils.addMonth((Date)now, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            endDate = DateUtils.getLastDateOfSeason((Date)date);
        } else if ("year".equals(provisionPlan)) {
            Date date = DateUtils.addYear((Date)now, (int)-1);
            startDate = DateUtils.getFirstDateOfYear((Date)date);
            endDate = DateUtils.getLastDateOfYear((Date)date);
        } else if ("month".equals(provisionPlan)) {
            Date date = DateUtils.addMonth((Date)now, (int)-1);
            startDate = DateUtils.getFirstDateOfMonth((Date)date);
            endDate = DateUtils.getLastDateOfMonth((Date)date);
        } else {
            return null;
        }
        return ImmutablePair.of((Object)startDate, (Object)endDate);
    }
}

