/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.provision.impl;

import com.google.common.collect.ImmutableBiMap;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.result.BaseResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.gtcp.business.provision.GenerateProvisionBillService;
import kd.taxc.gtcp.business.provision.handle.CreateProvisionFactory;
import kd.taxc.gtcp.business.provision.handle.CreateProvisionService;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpGenerateProvisionBillServiceBusiness
implements GenerateProvisionBillService {
    @Override
    public Map<Boolean, Map<Long, String>> generateProvisionBill(List<Long> draftIdList) {
        String responseList;
        BaseResult data;
        ArrayList<Map<String, Object>> requestParamList = new ArrayList<Map<String, Object>>(12);
        HashMap<Boolean, Map<Long, String>> responseMap = new HashMap<Boolean, Map<Long, String>>();
        HashMap successMap = new HashMap();
        HashMap<Long, String> failMap = new HashMap<Long, String>();
        responseMap.put(Boolean.TRUE, successMap);
        responseMap.put(Boolean.FALSE, failMap);
        if (ObjectUtils.isEmpty(draftIdList)) {
            return responseMap;
        }
        HashMap<String, Long> draftMap = new HashMap<String, Long>(12);
        DynamicObject[] draftObjects = BusinessDataServiceHelper.load((Object[])draftIdList.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)MultiTableEnum.TSD001.getDeclareMainTable()));
        List taxSystemList = Arrays.stream(draftObjects).map(o -> o.getLong("taxsystem.id")).distinct().collect(Collectors.toList());
        List taxTypeList = Arrays.stream(draftObjects).map(o -> o.getLong("taxtype.id")).distinct().collect(Collectors.toList());
        HashSet provisionItemSet = new HashSet();
        Arrays.stream(draftObjects).forEach(row -> {
            GenerateProvisionBillService.TemplateProvisionItemEnum itemEnum = GenerateProvisionBillService.TemplateProvisionItemEnum.getEnumByTemplate(row.getString("templateid.number"));
            if (null != itemEnum) {
                Arrays.stream(itemEnum.getProvisionItems()).forEach(o -> provisionItemSet.add(o));
            }
        });
        QFilter enableQ = new QFilter("enable", "=", (Object)Boolean.TRUE);
        QFilter taxSystemQ = new QFilter("taxsystem", "in", taxSystemList);
        QFilter numberQ = new QFilter("number", "in", provisionItemSet);
        DynamicObjectCollection provisionItemCol = QueryServiceHelper.query((String)"itp_proviston_item", (String)"id,number,taxtype,taxsystem", (QFilter[])new QFilter[]{enableQ, numberQ, taxSystemQ});
        HashMap waitGenerateProvisionMap = new HashMap();
        provisionItemCol.stream().forEach(row -> {
            String taxSystem = row.getString("taxsystem");
            String number = row.getString("number");
            Long id = row.getLong("id");
            Long taxType = row.getLong("taxtype");
            if (waitGenerateProvisionMap.containsKey(taxSystem)) {
                ((Map)waitGenerateProvisionMap.get(taxSystem)).put(number, new Long[]{id, taxType});
            } else {
                HashMap<String, Long[]> map = new HashMap<String, Long[]>();
                map.put(number, new Long[]{id, taxType});
                waitGenerateProvisionMap.put(taxSystem, map);
            }
        });
        provisionItemCol.stream().collect(Collectors.toMap(a -> a.getString("taxsystem"), b -> ImmutableBiMap.of((Object)b.getString("number"), (Object)new Long[]{b.getLong("id"), b.getLong("taxtype")}), (m, n) -> n));
        for (DynamicObject draftRow : draftObjects) {
            Long draftId = draftRow.getLong("id");
            String draftBillNo = draftRow.getString("billno");
            draftMap.put(draftBillNo, draftId);
            String taxSystem = draftRow.getString("taxsystem.id");
            String templateNumber = draftRow.getString("templateid.number");
            if (waitGenerateProvisionMap.containsKey(taxSystem)) {
                Map waitProvisionItemMap = (Map)waitGenerateProvisionMap.get(taxSystem);
                GenerateProvisionBillService.TemplateProvisionItemEnum itemEnum = GenerateProvisionBillService.TemplateProvisionItemEnum.getEnumByTemplate(templateNumber);
                if (null != itemEnum) {
                    GenerateProvisionBillService.ProvisionItemEnum provisionItemEnum;
                    String[] tempProvisionItems = itemEnum.getProvisionItems();
                    List<String> provisionItems = new ArrayList<String>(2);
                    for (String tempProvisionItem : tempProvisionItems) {
                        if (!((Map)waitGenerateProvisionMap.get(taxSystem)).containsKey(tempProvisionItem)) continue;
                        provisionItems.add(tempProvisionItem);
                    }
                    CreateProvisionService createProvisionService = CreateProvisionFactory.createHandler(templateNumber);
                    if (ObjectUtils.isNotEmpty((Object)createProvisionService)) {
                        provisionItems = createProvisionService.handleProvisionItems(draftRow, provisionItems);
                    }
                    boolean noAppear = true;
                    boolean notFindAccoutOrg = false;
                    boolean notBasecuurrency = false;
                    for (String provisionItem : provisionItems) {
                        if (!waitProvisionItemMap.containsKey(provisionItem)) continue;
                        provisionItemEnum = GenerateProvisionBillService.ProvisionItemEnum.getEnumByProvisionItem(provisionItem);
                        Long accountorg = provisionItemEnum.getAccountOrg(draftRow);
                        if (null != accountorg) {
                            Long basecuurrency = provisionItemEnum.getAccountOrgBasecurrrency(accountorg);
                            if (basecuurrency == -1L) {
                                notBasecuurrency = true;
                                break;
                            }
                            noAppear = false;
                            continue;
                        }
                        notFindAccoutOrg = true;
                        noAppear = false;
                        break;
                    }
                    if (!(notFindAccoutOrg || noAppear || notBasecuurrency)) {
                        for (String provisionItem : provisionItems) {
                            if (!waitProvisionItemMap.containsKey(provisionItem)) continue;
                            provisionItemEnum = GenerateProvisionBillService.ProvisionItemEnum.getEnumByProvisionItem(provisionItem);
                            List<Map<String, Object>> list = this.createParamsMap((Long[])waitProvisionItemMap.get(provisionItem), provisionItemEnum, draftRow);
                            if (ObjectUtils.isEmpty(list)) {
                                failMap.put(draftId, String.format(ResManager.loadKDString((String)"%s\uff1a\u7a0e\u91d1\u4e3a0\uff0c\u4e0d\u7528\u751f\u6210\u7a0e\u91d1\u8ba1\u63d0\u5355\u3002", (String)"GtcpGenerateProvisionBillServiceBusiness_5", (String)"taxc-gtcp", (Object[])new Object[0]), draftBillNo));
                                continue;
                            }
                            requestParamList.addAll(list);
                        }
                    }
                    if (notFindAccoutOrg) {
                        failMap.put(draftId, String.format(ResManager.loadKDString((String)"%s\uff1a\u627e\u4e0d\u5230\u6216\u5b58\u5728\u591a\u4e2a\u59d4\u6258\u7684\u6838\u7b97\u7ec4\u7ec7\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GtcpGenerateProvisionBillServiceBusiness_0", (String)"taxc-gtcp", (Object[])new Object[0]), draftBillNo));
                    }
                    if (noAppear) {
                        failMap.put(draftId, String.format(ResManager.loadKDString((String)"\u4ec5\u8bbe\u7f6e\u4e86\u53ef\u7528\u8ba1\u63d0\u4e8b\u9879\u7684\u5e95\u7a3f\u53ef\u751f\u6210\u8ba1\u63d0\u5355\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a%s\u3002", (String)"GtcpGenerateProvisionBillServiceBusiness_1", (String)"taxc-gtcp", (Object[])new Object[0]), draftBillNo));
                    }
                    if (!notBasecuurrency) continue;
                    failMap.put(draftId, String.format(ResManager.loadKDString((String)"\u59d4\u6258\u7684\u6838\u7b97\u7ec4\u7ec7\u672a\u7ef4\u62a4\u672c\u4f4d\u5e01\u4fe1\u606f\uff1a%s\u3002", (String)"GtcpGenerateProvisionBillServiceBusiness_2", (String)"taxc-gtcp", (Object[])new Object[0]), draftBillNo));
                    continue;
                }
                failMap.put(draftId, String.format(ResManager.loadKDString((String)"%1$s\uff1a \u5e95\u7a3f\u7684\u6a21\u677f\u7f16\u53f7%2$s\u6682\u4e0d\u652f\u6301\u751f\u6210\u8ba1\u63d0\u5355\u3002", (String)"GtcpGenerateProvisionBillServiceBusiness_3", (String)"taxc-gtcp", (Object[])new Object[0]), draftBillNo, templateNumber));
                continue;
            }
            failMap.put(draftId, String.format(ResManager.loadKDString((String)"%s\uff1a \u7a0e\u6536\u5236\u5ea6\u4e0d\u652f\u6301\u6216\u627e\u4e0d\u5230\u53ef\u7528\u7684\u7cfb\u7edf\u9884\u7f6e\u7684\u8ba1\u63d0\u4e8b\u9879\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"GtcpGenerateProvisionBillServiceBusiness_4", (String)"taxc-gtcp", (Object[])new Object[0]), draftBillNo));
        }
        if (ObjectUtils.isNotEmpty(requestParamList) && (data = (BaseResult)SerializationUtils.fromJsonString((String)(responseList = (String)DispatchServiceHelper.invokeBizService((String)"taxc", (String)"tctb", (String)"TaxprovisionService", (String)"createTaxprovision", (Object[])new Object[]{SerializationUtils.toJsonString(requestParamList)})), BaseResult.class)).getCode().equals(BaseResult.OK)) {
            List responses = (List)data.getData();
            responses.stream().forEach(rowMap -> {
                for (Map.Entry entry : rowMap.entrySet()) {
                    String draftBillNo = (String)entry.getKey();
                    successMap.put(draftMap.get(draftBillNo), "");
                }
            });
        }
        return responseMap;
    }

    private List<Map<String, Object>> createParamsMap(Long[] provisionItemArray, GenerateProvisionBillService.ProvisionItemEnum provisionItemEnum, DynamicObject draftDynmicObject) {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(2);
        List<String> reportItemKeys = provisionItemEnum.getReportItemKeys(draftDynmicObject);
        Map<String, Map<String, Object>> totals = provisionItemEnum.getTotal(draftDynmicObject);
        Long accountOrgBasecurrrency = provisionItemEnum.getAccountOrgBasecurrrency(provisionItemEnum.getAccountOrg(draftDynmicObject));
        for (String reportItemKey : reportItemKeys) {
            Map<String, Object> totalMap;
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            if (!totals.containsKey(reportItemKey) || (totalMap = totals.get(reportItemKey)).get(reportItemKey) instanceof BigDecimal && BigDecimal.ZERO.compareTo((BigDecimal)totalMap.get(reportItemKey)) == 0) continue;
            map.put("coins", accountOrgBasecurrrency);
            map.put("provistonitem", provisionItemArray[0]);
            map.put("taxorg", draftDynmicObject.getLong("org.id"));
            map.put("taxsystem", draftDynmicObject.getLong("taxsystem.id"));
            map.put("taxtype", provisionItemArray[1]);
            map.put("taxarea", ObjectUtils.isNotEmpty((Object)totalMap.get("taxAreaGroupId")) ? Long.parseLong(totalMap.get("taxAreaGroupId").toString()) : 0L);
            map.put("startdate", draftDynmicObject.get("skssqq"));
            map.put("enddate", draftDynmicObject.get("skssqz"));
            map.put("entitynumber", draftDynmicObject.getString("billno"));
            map.put("sourcedrafttype", draftDynmicObject.getString("templatetype.name"));
            map.put("entitytype", MultiTableEnum.TSD001.getDeclareMainTable());
            map.put("accountorg", provisionItemEnum.getAccountOrg(draftDynmicObject));
            map.put("entrydate", provisionItemEnum.getEntryDate(draftDynmicObject));
            map.put("total", totalMap.get(reportItemKey));
            map.put("creator", RequestContext.get().getCurrUserId());
            map.put("modifier", RequestContext.get().getCurrUserId());
            resultList.add(map);
        }
        return resultList;
    }
}

