/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.rule;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.rule.RuleAccessConfigService;
import kd.taxc.bdtaxr.business.rule.impl.AbstractRuleEngineService;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleAccessDetailDto;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.gtcp.business.rule.GtcpDraftAccessConfigBusiness;
import kd.taxc.gtcp.common.enums.FixedCellFetchTransFormProjectEnum;

public class GtcpDraftEngineBusiness
extends AbstractRuleEngineService {
    private static Log logger = LogFactory.getLog(GtcpDraftEngineBusiness.class);

    public GtcpDraftEngineBusiness() {
        this.accessConfigEntityName = "gtcp_accessconfig";
    }

    public static RuleAccessConfigService getRuleFetchBusiness() {
        return RuleAccessConfigServiceInner.ruleFetchBusiness;
    }

    protected RuleAccessConfigService registerRuleAccessConfigService() {
        return GtcpDraftEngineBusiness.getRuleFetchBusiness();
    }

    protected void saveOrDelDraftData(RuleFetchMainDto fetchSummaryDtoList) {
    }

    protected RuleFetchMainDto handleBuildRuleFetchMainDto(RuleEngineParamDto engineParamDto, List<Map<Long, List<Map<String, List<RuleAccessDetailDto>>>>> allOrgAccessResult) {
        RuleFetchMainDto ruleFetchMainDto = super.handleBuildRuleFetchMainDto(engineParamDto, allOrgAccessResult);
        Date originalSkssqq = (Date)engineParamDto.getExtendParams().get("originalSkssqq");
        if (null != originalSkssqq) {
            ruleFetchMainDto.setSkssqq(originalSkssqq);
        }
        if (null != engineParamDto.getDraftPurpose()) {
            ruleFetchMainDto.setPurpose(engineParamDto.getDraftPurpose());
        }
        ruleFetchMainDto.setCustomEvent(engineParamDto.getExtendParams().getOrDefault("customEvent", "").toString());
        return ruleFetchMainDto;
    }

    protected Map<String, String> getReportItemAccessProjectMap(RuleEngineParamDto engineParamDto, Set<String> accessProjectIdList) {
        accessProjectIdList.addAll(FixedCellFetchTransFormProjectEnum.getReportItemList(engineParamDto.getTaxationSys(), engineParamDto.getTaxType()));
        HashMap<String, String> newReportItemAccessProjectMap = new HashMap<String, String>();
        Map reportItemAccessProjectMap = super.getReportItemAccessProjectMap(engineParamDto, accessProjectIdList);
        for (Map.Entry entry : reportItemAccessProjectMap.entrySet()) {
            String projectId = FixedCellFetchTransFormProjectEnum.getProjectId((String)entry.getKey(), engineParamDto.getTaxationSys(), engineParamDto.getTaxType());
            if (null != projectId) {
                newReportItemAccessProjectMap.put(projectId, (String)entry.getKey());
                continue;
            }
            newReportItemAccessProjectMap.put((String)entry.getKey(), (String)entry.getValue());
        }
        return newReportItemAccessProjectMap;
    }

    private static class RuleAccessConfigServiceInner {
        private static final RuleAccessConfigService ruleFetchBusiness = new GtcpDraftAccessConfigBusiness();

        private RuleAccessConfigServiceInner() {
        }
    }
}

