/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.sharefactor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupColumnEnum;
import org.apache.commons.lang3.ObjectUtils;

public class UsaShareFactorBusiness {
    public static final Long usaCitId = 1641488655174373376L;

    public static List<DynamicObject> queryTaxcMainUSA(String appId, String entityNum, String permItemId) {
        List<DynamicObject> list = GtcpTaxOrgCommonBusiness.queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHwsWithPerm(RequestContext.get().getCurrUserId(), appId, entityNum, permItemId, TaxationsysMappingEnum.USA.getId(), usaCitId);
        for (DynamicObject mainObject : list) {
            DynamicObjectCollection hwCollection = mainObject.getDynamicObjectCollection("hwsentryentity");
            hwCollection.removeIf(row -> !usaCitId.equals(row.getLong("hwstaxtype.id")));
            hwCollection.removeIf(row -> !row.getBoolean("hwsenable"));
        }
        return list;
    }

    public static Map<String, List<String>> getOrgTaxAreaGroupUSA(String appId, String entityNum, String permItemId) {
        HashMap<String, List<String>> taxOrgAreaMap = new HashMap<String, List<String>>(16);
        List<DynamicObject> allMeetList = UsaShareFactorBusiness.queryTaxcMainUSA(appId, entityNum, permItemId);
        for (DynamicObject mainObject : allMeetList) {
            DynamicObjectCollection subCollection = mainObject.getDynamicObjectCollection("hwsentryentity");
            ArrayList<String> taxArea = new ArrayList<String>();
            for (DynamicObject subRow : subCollection) {
                taxArea.add(subRow.getString("hwstaxarea.number"));
            }
            taxOrgAreaMap.put(mainObject.getString("taxorg.org.number"), taxArea);
        }
        return taxOrgAreaMap;
    }

    public static List<Long> queryBastaxTaxOrgIdUSA(String appId, String entityNum, String permItemId) {
        return GtcpTaxOrgCommonBusiness.queryTaxcMainOrgIdsByIsTaxpayerForHwsWithPerm(RequestContext.get().getCurrUserId(), appId, entityNum, permItemId, TaxationsysMappingEnum.USA.getId(), usaCitId);
    }

    public static List<Long> queryOrgTaxAreaGroupByOrgId(Long orgId, String appId, String entityNum, String permItemId) {
        ArrayList<Long> list = new ArrayList<Long>();
        List<Object> permList = new ArrayList();
        permList = null == orgId ? UsaShareFactorBusiness.queryTaxcMainUSAListUse(appId, entityNum, permItemId) : UsaShareFactorBusiness.queryTaxcMainUSA(appId, entityNum, permItemId);
        if (ObjectUtils.isNotEmpty(permList)) {
            for (DynamicObject dynamicObject : permList) {
                DynamicObjectCollection subCollection = dynamicObject.getDynamicObjectCollection("hwsentryentity");
                if (null != orgId && (null == orgId || !orgId.equals(dynamicObject.getLong("taxorg.org.id")))) continue;
                for (DynamicObject subRow : subCollection) {
                    list.add(subRow.getLong("hwstaxarea.id"));
                }
            }
        }
        list.removeIf(row -> Long.valueOf(UsaTaxAreaGroupColumnEnum.Federation.getTaxAreaGroupId()).equals(row));
        return list;
    }

    public static Map<String, String> queryTaxcMainUSAMap(String appId, String entityNum, String permItemId) {
        List<DynamicObject> list = UsaShareFactorBusiness.queryTaxcMainUSA(appId, entityNum, permItemId);
        return list.stream().collect(Collectors.toMap(o -> o.getString("taxorg.org.id"), o -> o.getString("taxorg.org.name"), (k1, k2) -> k1));
    }

    public static Map<String, String> queryUsaShareFactorBySole(Long orgId, String skssqq, String skssqz, String draftPurpose, List<Long> taxAreaGroupList) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        HashMap tempMap = new HashMap();
        QFilter orgQ = new QFilter("org", "=", (Object)orgId).and("enable", "=", (Object)Boolean.TRUE).and("status", "=", (Object)"C").and("skssqq", "=", (Object)DateUtils.stringToDate((String)skssqq)).and("skssqz", "=", (Object)DateUtils.stringToDate((String)skssqz)).and("datapurpose", "=", (Object)draftPurpose).and("taxareagroup", "in", taxAreaGroupList);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gtcp_usasharefactor", (String)"taxareagroup,sharefactor", (QFilter[])new QFilter[]{orgQ});
        collection.stream().forEach(row -> {
            UsaTaxAreaGroupColumnEnum columnEnum = UsaTaxAreaGroupColumnEnum.getEnumByTaxAreaGroupId(row.getString("taxareagroup"));
            if (null != columnEnum) {
                tempMap.put(columnEnum.getAmountColumn(), row.getString("sharefactor"));
            }
        });
        Arrays.stream(UsaTaxAreaGroupColumnEnum.values()).forEach(rowEnum -> {
            if (tempMap.containsKey(rowEnum.getAmountColumn())) {
                resultMap.put("Apportionment_factor#" + rowEnum.getAmountColumn(), (String)tempMap.get(rowEnum.getAmountColumn()));
            } else {
                resultMap.put("Apportionment_factor#" + rowEnum.getAmountColumn(), "0");
            }
        });
        return resultMap;
    }

    public static List<DynamicObject> queryTaxcMainUSAListUse(String appId, String entityNum, String permItemId) {
        List<DynamicObject> list = GtcpTaxOrgCommonBusiness.queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHwsWithPerm(RequestContext.get().getCurrUserId(), appId, entityNum, permItemId, TaxationsysMappingEnum.USA.getId(), null);
        for (DynamicObject mainObject : list) {
            DynamicObjectCollection hwCollection = mainObject.getDynamicObjectCollection("hwsentryentity");
            hwCollection.removeIf(row -> !usaCitId.equals(row.getLong("hwstaxtype.id")));
            hwCollection.removeIf(row -> !row.getBoolean("hwsenable"));
        }
        return list;
    }

    public static Map<String, String> queryTaxcMainUSAMapListUse(String appId, String entityNum, String permItemId) {
        List<DynamicObject> list = UsaShareFactorBusiness.queryTaxcMainUSAListUse(appId, entityNum, permItemId);
        return list.stream().collect(Collectors.toMap(o -> o.getString("taxorg.org.id"), o -> o.getString("taxorg.org.name"), (k1, k2) -> k1));
    }

    public static Map<String, String> queryOrgTaxAreaGroupMapListUse(String appId, String entityNum, String permItemId) {
        HashMap<String, String> map = new HashMap<String, String>();
        List<DynamicObject> permList = UsaShareFactorBusiness.queryTaxcMainUSAListUse(appId, entityNum, permItemId);
        if (null == permList) {
            return map;
        }
        for (DynamicObject row : permList) {
            DynamicObjectCollection subCollection = row.getDynamicObjectCollection("hwsentryentity");
            subCollection.stream().filter(o -> StringUtil.isNotBlank((CharSequence)o.getString("hwstaxarea.id"))).forEach(subRow -> map.put(subRow.getString("hwstaxarea.id"), subRow.getString("hwstaxarea.name")));
        }
        return map;
    }
}

