/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.taxorg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.form.IFormView;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import org.apache.commons.collections4.CollectionUtils;

public class GtcpCombineBusiness {
    public static List<Long> getAllTaxOrgs(IFormView getView) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)getView);
        return GtcpCombineBusiness.getTaxOrgByPerm(hasPermOrgResult);
    }

    public static List<Long> getAllTaxOrgs(String entityId) {
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgsByUserId((String)"gtcp", (String)entityId, (String)"47156aff000000ac", (Long)RequestContext.get().getCurrUserId());
        return GtcpCombineBusiness.getTaxOrgByPerm(hasPermOrgResult);
    }

    private static List<Long> getTaxOrgByPerm(HasPermOrgResult hasPermOrgResult) {
        List<Long> taxOrgs = EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs()) ? GtcpTaxOrgCommonBusiness.queryTaxcOrgByOrgIdAndIsTaxpayer(hasPermOrgResult.getHasPermOrgs()) : GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayer();
        return GtcpCombineBusiness.getAudited(taxOrgs);
    }

    private static List<Long> getAudited(List<Long> taxOrgs) {
        QFilter billstatusFilter = new QFilter("billstatus", "=", (Object)"C");
        DynamicObjectCollection results = QueryServiceHelper.query((String)"tctb_tax_main", (String)"orgid.id as id,orgid.name as name", (QFilter[])new QFilter[]{billstatusFilter});
        Set id = results.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        return CollectionUtils.isEmpty(taxOrgs) ? new ArrayList<Long>() : taxOrgs.parallelStream().filter(id::contains).collect(Collectors.toList());
    }

    public static QFilter getTaxAreaGroupFilter(long countryId) {
        Date now = DateUtils.getDayFirst((Date)new Date());
        QFilter groupFilter = GtcpCombineBusiness.buildTaxAreaFilter(countryId, now);
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"bastax_taxarea", (String)"group", (QFilter[])new QFilter[]{groupFilter});
        Set groupIds = groups.stream().map(m -> m.getLong("group")).collect(Collectors.toSet());
        return new QFilter("id", "in", groupIds);
    }

    public static Long getDefaultTaxAreaGroupFilter(long countryId) {
        if (countryId == 0L) {
            return null;
        }
        Date now = DateUtils.getDayFirst((Date)new Date());
        QFilter groupFilter = GtcpCombineBusiness.buildTaxAreaFilter(countryId, now);
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"bastax_taxarea", (String)"id,group", (QFilter[])new QFilter[]{groupFilter}, (String)"id desc");
        if (CollectionUtils.isEmpty((Collection)groups)) {
            return null;
        }
        return ((DynamicObject)groups.get(0)).getLong("id");
    }

    public static void saveDialog(String appid, String entityName, String operateName, String operateDescription) {
        AppLogInfo appLogInfo = new AppLogInfo();
        appLogInfo.setBizAppID(appid);
        appLogInfo.setBizObjID(entityName);
        ILogService service = (ILogService)ServiceFactory.getService(ILogService.class);
        appLogInfo.setOpName(operateName);
        appLogInfo.setOpDescription(operateDescription);
        service.addLog(appLogInfo);
    }

    private static QFilter buildTaxAreaFilter(long countryId, Date now) {
        QFilter endDateFilter = new QFilter("enddate", "is null", null).or("enddate", ">=", (Object)now);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)now).and(endDateFilter);
        return new QFilter("country", "=", (Object)countryId).and("enable", "=", (Object)"1").and(dateFilter);
    }
}

