/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.taxorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.errorcode.TaxcErrorCode;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.TaxcCombineDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxcorg.TaxcOrgDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.tctb.taxcmain.TaxcMainDataServiceHelper;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;

public class GtcpTaxOrgCommonBusiness {
    public static List<DynamicObject> queryValidTaxOrg(Long taxationSysId) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)taxationSysId);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            List taxResultData = (List)taxResult.getData();
            return taxResultData;
        }
        return resultList;
    }

    public static List<DynamicObject> queryBastaxTaxOrgByTaxType(Long taxationSysId, Long applyTaxType) {
        DynamicObjectCollection subCollection;
        List<DynamicObject> resultList = GtcpTaxOrgCommonBusiness.queryValidTaxOrg(taxationSysId);
        for (DynamicObject mainObject : resultList) {
            subCollection = mainObject.getDynamicObjectCollection("entryentity");
            if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)subCollection)) continue;
            Iterator iterator = subCollection.iterator();
            while (iterator.hasNext()) {
                DynamicObject subRow = (DynamicObject)iterator.next();
                DynamicObjectCollection applyTaxTypeCol = subRow.getDynamicObjectCollection("entry_applytaxtype");
                List applyTaxTypeList = applyTaxTypeCol.stream().filter(a -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)a.get("fbasedataid.id"))).map(b -> b.getLong("fbasedataid.id")).collect(Collectors.toList());
                if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty(applyTaxTypeList) || applyTaxTypeList.contains(applyTaxType)) continue;
                iterator.remove();
            }
        }
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(resultList)) {
            Iterator<DynamicObject> iterator = resultList.iterator();
            while (iterator.hasNext()) {
                DynamicObject mainObject;
                mainObject = iterator.next();
                subCollection = mainObject.getDynamicObjectCollection("entryentity");
                if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)subCollection)) continue;
                iterator.remove();
            }
        }
        return resultList;
    }

    public static List<Long> queryTaxOrgIdByTaxType(Long taxationSysId, Long applyTaxType) {
        List<Long> list = new ArrayList<Long>();
        List<DynamicObject> resultList = GtcpTaxOrgCommonBusiness.queryBastaxTaxOrgByTaxType(taxationSysId, applyTaxType);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(resultList)) {
            list = resultList.stream().map(row -> row.getLong("org.id")).collect(Collectors.toList());
        }
        return list;
    }

    public static List<Long> queryValidTaxOrg() {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)1L, (boolean)false);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static String queryDefaultTaxPeriod(Long orgId, Long taxationsysId, Long categoryId) {
        if (orgId == null || taxationsysId == null || categoryId == null) {
            return null;
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryTaxcMainCategoryByOrgId((Long)orgId, (Long)taxationsysId, (Long)categoryId);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            String data = (String)taxResult.getData();
            if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)data)) {
                return null;
            }
            if (data.contains("month")) {
                return "month";
            }
            if (data.contains("season")) {
                return "season";
            }
            if (data.contains("halfyear")) {
                return "halfyear";
            }
            if (data.contains("year")) {
                return "year";
            }
        }
        return null;
    }

    public static List<String> queryHwsTaxlimit(Long orgId, Long taxationsysId, Long categoryId, Long taxAreaId) {
        ArrayList<String> resultList = new ArrayList<String>(4);
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryHwsTaxlimitByOrgId((Long)orgId, (Long)taxationsysId, (Long)categoryId, (Long)taxAreaId, (boolean)true);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)listTaxResult.getData())) {
            String[] splits = ((String)((List)listTaxResult.getData()).get(0)).split(",");
            Arrays.stream(splits).forEach(s -> {
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)s)) {
                    resultList.add((String)s);
                }
            });
        }
        return resultList;
    }

    public static String queryMinHwsTaxlimitByOrgId(Long orgId, Long taxationsysId, Long categoryId, Long taxAreaId) {
        List<String> taxlimitList = GtcpTaxOrgCommonBusiness.queryHwsTaxlimit(orgId, taxationsysId, categoryId, taxAreaId);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(taxlimitList)) {
            if (taxlimitList.contains("month")) {
                return "month";
            }
            if (taxlimitList.contains("season")) {
                return "season";
            }
            if (taxlimitList.contains("halfyear")) {
                return "halfyear";
            }
            if (taxlimitList.contains("year")) {
                return "year";
            }
        }
        return null;
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayerWithPerm() {
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcOrgIdByIsTaxpayerWithPerm((Long)RequestContext.get().getCurrUserId(), (Long)1L, (boolean)false);
        if (!ObjectUtils.isEmpty((Object)taxResult) && taxResult.isSuccess() && !ObjectUtils.isEmpty((Object)taxResult.getData())) {
            return (List)taxResult.getData();
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryTaxcMainByOrgIds(Long orgIds, Long taxationsysId, boolean isIncludeTaxationsys) {
        ArrayList<Long> resultList = new ArrayList<Long>(12);
        TaxResult listTaxResult = TaxcCombineBusinessDataServiceHelper.queryTaxcMaintaxationsysIdsByOrgIds(Collections.singletonList(orgIds));
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            List sysIds = (List)listTaxResult.getData();
            if (!isIncludeTaxationsys) {
                sysIds.remove(taxationsysId);
            }
            return sysIds;
        }
        return resultList;
    }

    public static Map<String, Map<String, Map<String, Map<String, List<String>>>>> queryTaxcMainByOrgIds(List<Long> orgIds, Long taxationsysId) {
        List dynamicObjectList;
        HashMap<String, Map<String, Map<String, Map<String, List<String>>>>> resultMap = new HashMap<String, Map<String, Map<String, Map<String, List<String>>>>>(12);
        TaxResult listTaxResult = TaxcMainDataServiceHelper.queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHws(orgIds, (Long)taxationsysId, null);
        if (!org.apache.commons.lang3.ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !org.apache.commons.lang3.ObjectUtils.isEmpty((Object)listTaxResult.getData()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(dynamicObjectList = (List)listTaxResult.getData()))) {
            for (DynamicObject dynamicObject : dynamicObjectList) {
                DynamicObjectCollection hwsentryentity;
                String taxsysId = dynamicObject.getString("taxationsys.id");
                if ("1".equals(taxsysId)) continue;
                String orgId = dynamicObject.getString("orgid.id");
                if (!resultMap.containsKey(orgId)) {
                    resultMap.put(orgId, new HashMap(12));
                }
                if (!((Map)resultMap.get(orgId)).containsKey(taxsysId)) {
                    ((Map)resultMap.get(orgId)).put(taxsysId, new HashMap(12));
                }
                if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(hwsentryentity = dynamicObject.getDynamicObjectCollection("hwsentryentity")))) continue;
                for (DynamicObject obj : hwsentryentity) {
                    String hwsdeadline;
                    if (!obj.getBoolean("hwsenable")) continue;
                    String hwstaxtypeId = obj.getString("hwstaxtype.id");
                    if (!((Map)((Map)resultMap.get(orgId)).get(taxsysId)).containsKey(hwstaxtypeId)) {
                        ((Map)((Map)resultMap.get(orgId)).get(taxsysId)).put(hwstaxtypeId, new HashMap(2));
                    }
                    String hwstaxareaId = obj.getString("hwstaxarea.id");
                    if (!((Map)((Map)((Map)resultMap.get(orgId)).get(taxsysId)).get(hwstaxtypeId)).containsKey(hwstaxareaId)) {
                        ((Map)((Map)((Map)resultMap.get(orgId)).get(taxsysId)).get(hwstaxtypeId)).put(hwstaxareaId, new ArrayList(2));
                    }
                    if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(hwsdeadline = obj.getString("hwsdeadline")))) continue;
                    String[] split = hwsdeadline.split(",");
                    ArrayList<String> list = new ArrayList<String>(4);
                    for (String s : split) {
                        if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)s)) continue;
                        list.add(s);
                    }
                    ((List)((Map)((Map)((Map)resultMap.get(orgId)).get(taxsysId)).get(hwstaxtypeId)).get(hwstaxareaId)).addAll(list);
                }
            }
        }
        return resultMap;
    }

    public static List<DynamicObject> queryTaxcOrgByOrgIds(List<Long> orgIds) {
        TaxResult listTaxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIds(orgIds);
        if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
            return (List)listTaxResult.getData();
        }
        return new ArrayList<DynamicObject>();
    }

    public static List<Long> queryHwsCategoryByOrgId(Long orgId, Long taxationsysId) {
        if (orgId == null || orgId == 0L || taxationsysId == null || taxationsysId == 0L) {
            return new ArrayList<Long>();
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryHwsCategoryByOrgId((Long)orgId, (Long)taxationsysId);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObject tctbTaxMain = (DynamicObject)taxResult.getData();
            DynamicObjectCollection hwsentryentity = tctbTaxMain.getDynamicObjectCollection("hwsentryentity");
            Set collect = hwsentryentity.stream().filter(o -> o.getBoolean("hwsenable")).map(o -> o.getLong("hwstaxtype.id")).collect(Collectors.toSet());
            return new ArrayList<Long>(collect);
        }
        return new ArrayList<Long>();
    }

    public static List<Long> queryHwsTaxAreaByOrgId(Long orgId, Long taxationsysId, Long taxTypeId) {
        if (orgId == null || orgId == 0L || taxationsysId == null || taxationsysId == 0L || taxTypeId == null || taxTypeId == 0L) {
            return new ArrayList<Long>();
        }
        TaxResult taxResult = TaxcMainDataServiceHelper.queryHwsCategoryByOrgId((Long)orgId, (Long)taxationsysId);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            DynamicObject tctbTaxMain = (DynamicObject)taxResult.getData();
            HashSet<Long> ids = new HashSet<Long>();
            DynamicObjectCollection hwsentryentity = tctbTaxMain.getDynamicObjectCollection("hwsentryentity");
            for (DynamicObject entity : hwsentryentity) {
                String status = entity.getString("hwsenable");
                Long value = entity.getLong("hwstaxarea.id");
                Long hwsTaxTypeId = entity.getLong("hwstaxtype.id");
                if (!"1".equals(status) || hwsTaxTypeId.compareTo(taxTypeId) != 0) continue;
                ids.add(value);
            }
            return new ArrayList<Long>(ids);
        }
        return new ArrayList<Long>();
    }

    public static List<DynamicObject> queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHwsWithPerm(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId, Long categoryId) {
        ArrayList<DynamicObject> resultList = new ArrayList<DynamicObject>();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainCategoryByOrgIdsAndIsTaxpayerForHwsWithPerm((Long)userId, (String)appId, (String)entityNum, (String)permItemId, (Long)taxationsysId, (Long)categoryId);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            List taxResultData = (List)taxResult.getData();
            return taxResultData;
        }
        return resultList;
    }

    public static List<Long> queryTaxcMainOrgIdsByIsTaxpayerForHwsWithPerm(Long userId, String appId, String entityNum, String permItemId, Long taxationsysId, Long categoryId) {
        ArrayList<Long> resultList = new ArrayList<Long>();
        TaxResult taxResult = TaxcCombineDataServiceHelper.queryTaxcMainOrgIdsByIsTaxpayerForHwsWithPerm((Long)userId, (String)appId, (String)entityNum, (String)permItemId, (Long)taxationsysId, (Long)categoryId);
        if (StringUtil.equalsIgnoreCase((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            List taxResultData = (List)taxResult.getData();
            return taxResultData;
        }
        return resultList;
    }

    public static List<Long> queryTaxcOrgIdByIsTaxpayer() {
        List<Long> list = new ArrayList<Long>();
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgIdByIsTaxpayer(null);
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            list = (List)taxResult.getData();
        }
        return list;
    }

    public static List<Long> queryTaxcOrgByOrgIdAndIsTaxpayer(List<Long> orgIds) {
        List<Long> list = new ArrayList<Long>(orgIds.size());
        TaxResult taxResult = TaxcOrgDataServiceHelper.queryTaxcOrgByOrgIdsAndIsTaxpayerForHws(orgIds);
        if (EmptyCheckUtils.isNotEmpty((Object)taxResult) && StringUtils.equals((CharSequence)TaxcErrorCode.TAXC_SUCCESS_CODE.getCode(), (CharSequence)taxResult.getCode())) {
            list = ((List)taxResult.getData()).stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        }
        return list;
    }
}

