/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.taxpayrefund.strategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import org.apache.commons.lang3.ObjectUtils;

public class AbstractGtcpTaxPayRefundStrategy {
    public boolean checkNoCommonTaxtype(Map<String, Object> customParams) {
        if (ObjectUtils.isNotEmpty(customParams)) {
            Object taxationsys = customParams.get("taxationsys");
            Object taxcategory = customParams.get("taxcategory");
            Object taxestype = customParams.get("taxestype");
            Object datasouce = customParams.get("datasouce");
            Object taxareagroup = customParams.get("taxareagroup");
            if (ObjectUtils.isNotEmpty((Object)taxationsys) && ObjectUtils.isNotEmpty((Object)taxcategory) && ObjectUtils.isNotEmpty((Object)datasouce) && ObjectUtils.isNotEmpty((Object)taxestype) && ObjectUtils.isNotEmpty((Object)taxareagroup)) {
                return this.checkNoCommonTaxtype((Long)taxationsys, (Long)taxcategory, (Long)taxareagroup, datasouce.toString(), taxestype.toString());
            }
        }
        return false;
    }

    public boolean checkNoCommonTaxtype(DynamicObject dynamicObject) {
        return this.checkNoCommonTaxtype(dynamicObject.getLong("taxationsys.id"), dynamicObject.getLong("taxcategory.id"), dynamicObject.getLong("taxareagroup.id"), dynamicObject.getString("datasouce"), dynamicObject.getString("taxestype"));
    }

    public boolean checkNoCommonTaxtype(Long taxationsysId, Long taxcategoryId, Long taxareagroup, String datasouce, String taxestype) {
        return false;
    }

    public void verifyTaxRefundRelationSbDraftStatus(DynamicObject dynamicObject, Map<String, List<DynamicObject>> draftIdsMap, Map<String, Map<String, Object>> updateMap) {
        DynamicObjectCollection collection;
        String draftId = dynamicObject.getString("id");
        Map<Object, Object> dataMap = updateMap.containsKey(draftId) ? updateMap.get(draftId) : new HashMap();
        Long fid = dataMap.containsKey("id") ? (Long)dataMap.get("id") : 0L;
        Object payrefstatus = dataMap.get("payrefstatus");
        Object payrefunddate = dataMap.get("payrefunddate");
        List<String> checkDataList = payrefstatus.equals("pay") || payrefstatus.equals("noneedpay") ? Collections.singletonList("pay") : Collections.singletonList("refund");
        List<DynamicObject> dynamicObjectList = draftIdsMap.get(draftId);
        HashMap<String, String> statisticMap = new HashMap<String, String>(12);
        Date updateDate = ObjectUtils.isNotEmpty((Object)payrefunddate) ? (Date)payrefunddate : null;
        int payedCount = 0;
        if ("pay".equals(payrefstatus) || "refund".equals(payrefstatus)) {
            ++payedCount;
        }
        if (ObjectUtils.isNotEmpty(dynamicObjectList)) {
            for (DynamicObject obj : dynamicObjectList) {
                long id = obj.getLong("id");
                if (fid == id) continue;
                String pstatus = obj.getString("payrefstatus");
                Date pdate = obj.getDate("payrefunddate");
                if (checkDataList.contains(pstatus)) {
                    ++payedCount;
                }
                if (!statisticMap.containsKey("updateStatus")) {
                    List<String> paylist;
                    String updateStatus = "";
                    List<String> list = paylist = payrefstatus.equals("pay") || payrefstatus.equals("noneedpay") ? Collections.singletonList("nopay") : Collections.singletonList("norefund");
                    if (paylist.contains(pstatus) && (payrefstatus.equals("pay") || payrefstatus.equals("noneedpay"))) {
                        updateStatus = "partpay";
                    } else if (paylist.contains(pstatus) && (payrefstatus.equals("refund") || payrefstatus.equals("noneedrefund"))) {
                        updateStatus = "partrefund";
                    }
                    if (ObjectUtils.isNotEmpty((Object)updateStatus)) {
                        statisticMap.put("updateStatus", updateStatus);
                    }
                }
                if (!pstatus.equals("pay") && !pstatus.equals("refund") || !checkDataList.contains(pstatus) || updateDate != null && !pdate.after(updateDate)) continue;
                updateDate = pdate;
            }
            if (payedCount == 0) {
                statisticMap.put("updateStatus", "unpayrefund");
            }
        } else {
            statisticMap.put("updateStatus", "payrefund");
            Date date = updateDate = ObjectUtils.isNotEmpty((Object)payrefunddate) ? (Date)payrefunddate : null;
        }
        if (null != (collection = dynamicObject.getDynamicObjectCollection("entryentity"))) {
            String status = ObjectUtils.isNotEmpty(statisticMap.get("updateStatus")) ? statisticMap.get("updateStatus").toString() : "payrefund";
            for (DynamicObject row : collection) {
                row.set("payrefundstatus", (Object)("payrefund".equalsIgnoreCase(status) || "unpayrefund".equals(status) ? status : "partpayrefund"));
                row.set("payrefunddate", (Object)updateDate);
            }
        }
    }

    public void cancelTaxRefundRelationSbDraftStatus(DynamicObject dynamicObject, Map<String, List<DynamicObject>> draftNumbersMap, List<Long> ids, Map<String, Map<String, Object>> backWriteMap) {
        String draftId = dynamicObject.getString("draftid.id");
        if (backWriteMap.containsKey(draftId)) {
            return;
        }
        String taxestype = dynamicObject.getString("taxestype");
        Long taxationsys = dynamicObject.getLong("taxationsys.id");
        Long taxcategory = dynamicObject.getLong("taxcategory.id");
        String updateStatus = "unpayrefund";
        Date updateDate = null;
        List<DynamicObject> dynamicObjectList = draftNumbersMap.get(draftId);
        if (ObjectUtils.isNotEmpty(dynamicObjectList)) {
            for (DynamicObject obj : dynamicObjectList) {
                if (ids.contains(obj.getLong("id"))) continue;
                String pstatus = obj.getString("payrefstatus");
                Date payrefunddate = obj.getDate("payrefunddate");
                String type = "pay".equalsIgnoreCase(taxestype) ? "pay" : "refund";
                if (!type.equals(pstatus) || !ObjectUtils.isNotEmpty((Object)payrefunddate) || !ObjectUtils.isEmpty(updateDate) && !payrefunddate.after(updateDate)) continue;
                updateDate = payrefunddate;
                updateStatus = "partpayrefund";
            }
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("updateStatus", updateStatus);
            map.put("updateDate", updateDate);
            map.put("taxationsys", taxationsys);
            map.put("taxcategory", taxcategory);
            backWriteMap.put(draftId, map);
        } else {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("updateStatus", "unpayrefund");
            map.put("updateDate", updateDate);
            map.put("taxationsys", taxationsys);
            map.put("taxcategory", taxcategory);
            backWriteMap.put(draftId, map);
        }
    }

    public String setPayStatus(String payStatus, String draftId, GtcpDeclarePayRefundEnum gtcpDeclarePayRefundEnum) {
        if (!StringUtil.equalsIgnoreCase((CharSequence)payStatus, (CharSequence)"nopayrefund")) {
            return payStatus;
        }
        if (null == gtcpDeclarePayRefundEnum) {
            return payStatus;
        }
        if (!StringUtil.equalsIgnoreCase((CharSequence)payStatus, (CharSequence)"nopayrefund") || !this.isAllTabZeroAmount(Long.parseLong(draftId), gtcpDeclarePayRefundEnum)) {
            return "unpayrefund";
        }
        return payStatus;
    }

    public boolean isAllTabZeroAmount(Long draftId, GtcpDeclarePayRefundEnum gtcpDeclarePayRefundEnum) {
        boolean isAllZero = true;
        Map<String, String> map = GtcpDraftBussiness.queryFixCellValue(draftId, gtcpDeclarePayRefundEnum.getRowColumn());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            BigDecimal bigDecimal = StringUtil.isNotBlank((CharSequence)entry.getValue()) ? new BigDecimal(entry.getValue()) : BigDecimal.ZERO;
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            isAllZero = false;
            break;
        }
        return isAllZero;
    }

    public List<DynamicObject> buildTaxPayRefunds(DynamicObject draftObject, String payrefunddate, String remark) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        GtcpDeclarePayRefundEnum payEnum = GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)draftObject.getString("templatetype.id"), (String)draftObject.getString("taxsystem.id"), (String)draftObject.getString("taxtype.id"));
        if (null == payEnum) {
            return list;
        }
        Map<String, String> map = GtcpDraftBussiness.queryFixCellValue(draftObject.getLong("id"), payEnum.getRowColumn());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            BigDecimal bigDecimal = StringUtil.isNotBlank((CharSequence)entry.getValue()) ? new BigDecimal(entry.getValue()) : BigDecimal.ZERO;
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            list.add(this.generateTaxPayRefunds(draftObject, payrefunddate, remark, bigDecimal, draftObject.getDynamicObject("taxtype"), draftObject.getDynamicObject("taxareagroup")));
        }
        return list;
    }

    protected DynamicObject generateTaxPayRefunds(DynamicObject draftObject, String payrefunddate, String remark, BigDecimal amount, DynamicObject taxcategory, DynamicObject taxareagroup) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_taxpay_refund_bill");
        dynamicObject.set("org", draftObject.get("org"));
        dynamicObject.set("taxationsys", draftObject.get("taxsystem"));
        dynamicObject.set("taxcategory", (Object)taxcategory);
        dynamicObject.set("taxareagroup", (Object)taxareagroup);
        dynamicObject.set("skssqq", draftObject.get("skssqq"));
        dynamicObject.set("skssqz", draftObject.get("skssqz"));
        dynamicObject.set("taxestype", (Object)(amount.compareTo(BigDecimal.ZERO) > 0 ? "pay" : "refund"));
        dynamicObject.set("payrefstatus", (Object)(amount.compareTo(BigDecimal.ZERO) > 0 ? "pay" : "refund"));
        dynamicObject.set("payrefunddate", null == payrefunddate ? null : DateUtils.stringToDate2((String)payrefunddate, (String)"yyyy-MM-dd HH:mm:ss"));
        dynamicObject.set("coin", (Object)draftObject.getDynamicObject("taxsystem").getDynamicObject("currency"));
        dynamicObject.set("amount", (Object)amount.abs());
        dynamicObject.set("datasouce", (Object)"1");
        dynamicObject.set("remark", (Object)remark);
        dynamicObject.set("draftid", draftObject.get("id"));
        dynamicObject.set("draftnumber", (Object)draftObject.getString("billno"));
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        dynamicObject.set("billno", (Object)codeRuleService.readNumber("gtcp_taxpay_refund_bill", dynamicObject, null));
        dynamicObject.set("creator", (Object)RequestContext.get().getCurrUserId());
        return dynamicObject;
    }
}

