/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.taxpayrefund.strategy;

import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpDeuCitTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpJpaCitTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpUsaCitTaxPayRefundStrategy;

public class GtcpTaxPayRefundStrategyFactory {
    public static AbstractGtcpTaxPayRefundStrategy getGtcpTaxPayRefundStrategyEnumByType(String taxationSysNumber, String taxCategoryNumber) {
        GtcpTaxPayRefundStrategyEnum[] values;
        for (GtcpTaxPayRefundStrategyEnum value : values = GtcpTaxPayRefundStrategyEnum.values()) {
            if (!value.type.equals(taxationSysNumber + "_" + taxCategoryNumber)) continue;
            return value.abstractGtcpTaxPayRefundStrategy;
        }
        return null;
    }

    static enum GtcpTaxPayRefundStrategyEnum {
        USA_USA_CIT("USA_USA-CIT", new GtcpUsaCitTaxPayRefundStrategy()),
        USA_USA_FT("USA_USA-FT", new GtcpUsaCitTaxPayRefundStrategy()),
        USA_DEU_CIT("DEU_DEU-CIT", new GtcpDeuCitTaxPayRefundStrategy()),
        DEU_DEU_SS("DEU_DEU-SS", new GtcpDeuCitTaxPayRefundStrategy()),
        DEU_DEU_TT("DEU_DEU-TT", new GtcpDeuCitTaxPayRefundStrategy()),
        JAP_JAP_CIT("JAP_JAP-CIT", new GtcpJpaCitTaxPayRefundStrategy()),
        JAP_JAP_LCIT("JAP_JAP-LCIT", new GtcpJpaCitTaxPayRefundStrategy()),
        JAP_JAP_IT_1("JAP_JAP-IT-1", new GtcpJpaCitTaxPayRefundStrategy()),
        JAP_JAP_IT_2("JAP_JAP-IT-2", new GtcpJpaCitTaxPayRefundStrategy()),
        JAP_JAP_SET("JAP_JAP-SET", new GtcpJpaCitTaxPayRefundStrategy()),
        JAP_JAP_ET("JAP_JAP-ET", new GtcpJpaCitTaxPayRefundStrategy());

        private String type;
        private AbstractGtcpTaxPayRefundStrategy abstractGtcpTaxPayRefundStrategy;

        private GtcpTaxPayRefundStrategyEnum(String type, AbstractGtcpTaxPayRefundStrategy abstractGtcpTaxPayRefundStrategy) {
            this.type = type;
            this.abstractGtcpTaxPayRefundStrategy = abstractGtcpTaxPayRefundStrategy;
        }
    }
}

