/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.taxpayrefund.strategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.helper.bd.taxcategory.TaxCategoryDataServiceHelper;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;

public class GtcpUsaCitTaxPayRefundStrategy
extends AbstractGtcpTaxPayRefundStrategy {
    @Override
    public boolean checkNoCommonTaxtype(Long taxationsysId, Long taxcategoryId, Long taxareagroup, String datasouce, String taxestype) {
        return taxationsysId.equals(TaxationsysMappingEnum.USA.getId()) && (taxcategoryId.equals(1641488655174373376L) || taxcategoryId.equals(1682650334692126720L)) && "1".equals(datasouce);
    }

    @Override
    public List<DynamicObject> buildTaxPayRefunds(DynamicObject draftObject, String payrefunddate, String remark) {
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>();
        if (!this.checkNoCommonTaxtype(draftObject.getLong("taxsystem.id"), draftObject.getLong("taxtype.id"), draftObject.getLong("taxareagroup.id"), "1", null)) {
            return super.buildTaxPayRefunds(draftObject, payrefunddate, remark);
        }
        GtcpDeclarePayRefundEnum payEnum = GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)draftObject.getString("templatetype.id"), (String)draftObject.getString("taxsystem.id"), (String)draftObject.getString("taxtype.id"));
        if (null == payEnum) {
            return list;
        }
        Map<String, String> map = GtcpDraftBussiness.queryFixCellValue(draftObject.getLong("id"), payEnum.getRowColumn());
        ArrayList taxTaxAreaGroupIds = new ArrayList();
        HashMap cellTaxAreaGroupMap = new HashMap();
        GtcpDeclarePayRefundEnum.getUsaTabTaxAreaGroupMap().entrySet().stream().forEach(o -> {
            taxTaxAreaGroupIds.add(Long.valueOf((String)o.getValue()));
            cellTaxAreaGroupMap.put(GtcpDeclarePayRefundEnum.getUsaTaxAmountRowColumnMap().get(o.getKey()), o.getValue());
        });
        DynamicObject[] taxTaxAreaList = BusinessDataServiceHelper.load((Object[])taxTaxAreaGroupIds.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"bastax_taxareagroup"));
        for (Map.Entry<String, String> entry : map.entrySet()) {
            BigDecimal bigDecimal = StringUtil.isNotBlank((CharSequence)entry.getValue()) ? new BigDecimal(entry.getValue()) : BigDecimal.ZERO;
            if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
            DynamicObject taxtype = draftObject.getDynamicObject("taxtype");
            String cell = entry.getKey();
            if (StringUtil.equalsIgnoreCase((CharSequence)cell, (CharSequence)"Total_amount_due_and_payable#Amount_Texas_FT")) {
                taxtype = (DynamicObject)TaxCategoryDataServiceHelper.querySingleTaxCategoryById((Long)1682650334692126720L).getData();
            }
            String taxTaxAreaGroupId = (String)cellTaxAreaGroupMap.get(cell);
            DynamicObject dynamicObject = draftObject.getDynamicObject("taxareagroup");
            if (StringUtil.isNotEmpty((CharSequence)taxTaxAreaGroupId)) {
                for (DynamicObject row : taxTaxAreaList) {
                    if (!StringUtil.equalsIgnoreCase((CharSequence)row.getString("id"), (CharSequence)taxTaxAreaGroupId)) continue;
                    dynamicObject = row;
                    break;
                }
            }
            list.add(this.generateTaxPayRefunds(draftObject, payrefunddate, remark, bigDecimal, taxtype, dynamicObject));
        }
        return list;
    }
}

