/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.business.tctb;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.tctb.taxcyear.TaxcYearDataServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class TaxPeriodBusiness {
    public static Date getTaxPeriodStartDate(Long orgId, Long taxSysId, Long taxTypeId) {
        Map rowMap;
        List resultList;
        Date newStartDate = null;
        if (orgId == 0L || taxSysId == null || taxSysId == 0L) {
            return newStartDate;
        }
        ArrayList list = new ArrayList();
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("key_orgId", orgId);
        map.put("key_taxationsysId", taxSysId);
        map.put("key_taxcategoryId", taxTypeId);
        list.add(map);
        TaxResult taxResult = TaxcYearDataServiceHelper.queryTaxcyearsByPriority(list);
        if (taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)(resultList = (List)taxResult.getData())) && ObjectUtils.isNotEmpty((Object)(rowMap = (Map)resultList.get(0))) && ObjectUtils.isNotEmpty(rowMap.get("key_taxyear"))) {
            newStartDate = ((DynamicObject)rowMap.get("key_taxyear")).getDate("startdate");
        }
        return newStartDate;
    }

    public static Date getTaxPeriodStartMonthAndDay(Long orgId, Long taxSysId, Long taxcategoryId, Date skssqq) {
        if (orgId == 0L || taxSysId == null || taxSysId == 0L || skssqq == null) {
            return null;
        }
        Date startMonthAndDay = TaxPeriodBusiness.getTaxPeriodStartDate(orgId, taxSysId, taxcategoryId);
        if (null == startMonthAndDay) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int skssqqYear = DateUtils.getYearOfDate((Date)skssqq);
        int skssqqMonth = DateUtils.getMonthOfDate((Date)skssqq);
        int skssqqDay = DateUtils.getDayOfDate((Date)skssqq);
        int newStartMonth = DateUtils.getMonthOfDate((Date)startMonthAndDay);
        int newStartDay = DateUtils.getDayOfDate((Date)startMonthAndDay);
        if (skssqqMonth == newStartMonth) {
            if (skssqqDay >= newStartDay) {
                calendar.setTime(startMonthAndDay);
                calendar.set(1, skssqqYear);
            } else {
                calendar.setTime(skssqq);
                calendar.set(1, skssqqYear - 1);
            }
            return calendar.getTime();
        }
        if (skssqqMonth > newStartMonth) {
            calendar.setTime(startMonthAndDay);
            calendar.set(1, skssqqYear);
            return calendar.getTime();
        }
        if (skssqqMonth < newStartMonth) {
            calendar.setTime(startMonthAndDay);
            calendar.set(1, skssqqYear - 1);
            return calendar.getTime();
        }
        return startMonthAndDay;
    }

    public static Map<String, Date> getOrgTaxPeriodStartDateMap(List<Map<String, Object>> paramsList) {
        List list;
        HashMap<String, Date> result = new HashMap<String, Date>(12);
        if (ObjectUtils.isEmpty(paramsList)) {
            return result;
        }
        TaxResult taxResult = TaxcYearDataServiceHelper.queryTaxcyearsByPriority(paramsList);
        if (taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)(list = (List)taxResult.getData()))) {
            for (Map map : list) {
                DynamicObject row = (DynamicObject)map.get("key_taxyear");
                if (!ObjectUtils.isNotEmpty((Object)row)) continue;
                Date startDate = row.getDate("startdate");
                String key = String.valueOf(map.get("key_orgId")) + "_" + String.valueOf(map.get("key_taxationsysId")) + "_" + String.valueOf(map.get("key_taxcategoryId"));
                result.put(key, startDate);
            }
        }
        return result;
    }

    public static Date getTaxPeriodStartDateByCondition(Long orgId, Long taxationsysId, Long taxcategoryId, Map<String, Date> taxPeriodMap) {
        if (ObjectUtils.isEmpty(taxPeriodMap)) {
            return null;
        }
        String key = String.valueOf(orgId) + "_" + String.valueOf(taxationsysId) + "_" + String.valueOf(taxcategoryId);
        return taxPeriodMap.get(key);
    }

    public static ImmutablePair<Date, Date> calDate(Date taxYearStartDate, Date modelStartDate, Date modelEndDate) {
        if (taxYearStartDate == null || modelStartDate == null || modelEndDate == null) {
            return null;
        }
        int monthInt = 1 - DateUtils.getMonthOfDate((Date)taxYearStartDate);
        int dataInt = 1 - DateUtils.getDayOfDate((Date)taxYearStartDate);
        Date offSetStartDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)modelStartDate, (int)monthInt), (int)dataInt);
        Integer monthBetweenInOneYear = TaxPeriodBusiness.getMonthBetweenInOneYear(modelStartDate, modelEndDate);
        if (monthBetweenInOneYear != null) {
            Date offSetEndDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)offSetStartDate, (int)monthBetweenInOneYear), (int)-1);
            return ImmutablePair.of((Object)offSetStartDate, (Object)offSetEndDate);
        }
        return null;
    }

    public static Integer getMonthBetweenInOneYear(Date minDate, Date maxDate) {
        int result;
        if (minDate == null || maxDate == null || maxDate.compareTo(minDate) <= 0) {
            return null;
        }
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        max.setTime(maxDate);
        for (result = 0; min.before(max) && result < 12; ++result) {
            min.add(2, 1);
        }
        min.add(5, -1);
        if (result <= 12 && min.equals(max)) {
            return result;
        }
        return null;
    }

    public static ImmutablePair<Date, Date> preTaxPeriod(String provisionPeriod, Date taxYearStartDate) {
        int adj;
        Date startDate;
        Date now = new Date();
        int monthInt = DateUtils.getMonthOfDate((Date)taxYearStartDate) - 1;
        int dateInt = DateUtils.getDayOfDate((Date)taxYearStartDate) - 1;
        if ("season".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            adj = 3;
        } else if ("year".equals(provisionPeriod)) {
            startDate = DateUtils.getFirstDateOfYear((Date)now);
            adj = 12;
        } else if ("month".equals(provisionPeriod)) {
            Date xtqDate = DateUtils.addMonth((Date)now, (int)-1);
            startDate = DateUtils.getFirstDateOfMonth((Date)xtqDate);
            adj = 1;
        } else if ("halfyear".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-6);
            startDate = DateUtils.getFirstDateOfHalfYear((Date)date);
            adj = 6;
        } else {
            return null;
        }
        startDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)monthInt), (int)dateInt);
        Date endDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)adj), (int)-1);
        return TaxPeriodBusiness.getLast(startDate, endDate, adj);
    }

    public static ImmutablePair<Date, Date> preTaxPeriod(String provisionPeriod, Date taxYearStartDate, Date nowDate) {
        int adj;
        Date startDate;
        if (ObjectUtils.isEmpty((Object)nowDate) || ObjectUtils.isEmpty((Object)taxYearStartDate)) {
            return null;
        }
        Date now = nowDate;
        int monthInt = DateUtils.getMonthOfDate((Date)taxYearStartDate) - 1;
        int dateInt = DateUtils.getDayOfDate((Date)taxYearStartDate) - 1;
        if ("season".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            adj = 3;
        } else if ("year".equals(provisionPeriod)) {
            startDate = DateUtils.getFirstDateOfYear((Date)now);
            adj = 12;
        } else if ("month".equals(provisionPeriod)) {
            Date xtqDate = DateUtils.addMonth((Date)now, (int)-1);
            startDate = DateUtils.getFirstDateOfMonth((Date)xtqDate);
            adj = 1;
        } else if ("halfyear".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-6);
            startDate = DateUtils.getFirstDateOfHalfYear((Date)date);
            adj = 6;
        } else {
            return null;
        }
        startDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)monthInt), (int)dateInt);
        Date endDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)adj), (int)-1);
        return TaxPeriodBusiness.getLast(startDate, endDate, adj, nowDate);
    }

    public static ImmutablePair<Date, Date> getLast(Date startDate, Date endDate, int month) {
        if (endDate.compareTo(DateUtils.getDayFirst((Date)new Date())) < 0) {
            return ImmutablePair.of((Object)startDate, (Object)endDate);
        }
        startDate = DateUtils.addMonth((Date)startDate, (int)(-month));
        endDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)month), (int)-1);
        return TaxPeriodBusiness.getLast(startDate, endDate, month);
    }

    public static ImmutablePair<Date, Date> getLast(Date startDate, Date endDate, int month, Date nowDate) {
        if (endDate.compareTo(DateUtils.getDayFirst((Date)nowDate)) < 0) {
            return ImmutablePair.of((Object)startDate, (Object)endDate);
        }
        startDate = DateUtils.addMonth((Date)startDate, (int)(-month));
        endDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)month), (int)-1);
        return TaxPeriodBusiness.getLast(startDate, endDate, month, nowDate);
    }
}

