/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.common.dto;

import java.util.Date;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.bdtaxr.common.vo.DraftRequest;
import kd.taxc.gtcp.business.draft.UsaCitBussiness;

public class DraftRequestVo {
    private String category;
    private String dataType;
    private String orgId;
    private Date executeTime;
    private Date skssqq;
    private Date skssqz;
    private Long taxationsys;
    private Long taxareagroup;
    private Long taxcatetory;
    private String requestType;

    public DraftRequestVo(DraftRequest draftRequest) {
        this.requestType = "nssb";
        this.category = draftRequest.getCategory();
        this.orgId = draftRequest.getOrgId();
        this.taxationsys = draftRequest.getTaxationsys();
        this.taxcatetory = draftRequest.getTaxcatetory();
        this.taxareagroup = draftRequest.getTaxareagroup();
        this.skssqq = draftRequest.getStartDate();
        this.skssqz = draftRequest.getEndDate();
        this.executeTime = draftRequest.getExecuteTime();
        this.dataType = draftRequest.getDataType();
    }

    public DraftRequestVo(AccrualRequest accrualRequest) {
        this.requestType = "sjjt";
        this.category = accrualRequest.getCategory();
        this.orgId = accrualRequest.getOrgId();
        this.taxationsys = accrualRequest.getTaxsystem();
        this.taxcatetory = accrualRequest.getTaxcatetory();
        this.taxareagroup = accrualRequest.getTaxareagroup();
        this.skssqq = accrualRequest.getSkssqq();
        this.skssqz = accrualRequest.getSkssqz();
        this.executeTime = accrualRequest.getAccrualDate();
        this.dataType = "";
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getOrgId() {
        return this.orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public Date getExecuteTime() {
        return this.executeTime;
    }

    public void setExecuteTime(Date executeTime) {
        this.executeTime = executeTime;
    }

    public Date getSkssqq() {
        return this.skssqq;
    }

    public void setSkssqq(Date skssqq) {
        this.skssqq = skssqq;
    }

    public Date getSkssqz() {
        return this.skssqz;
    }

    public void setSkssqz(Date skssqz) {
        this.skssqz = skssqz;
    }

    public Long getTaxationsys() {
        return this.taxationsys;
    }

    public void setTaxationsys(Long taxationsys) {
        this.taxationsys = taxationsys;
    }

    public Long getTaxareagroup() {
        return this.taxareagroup;
    }

    public void setTaxareagroup(Long taxareagroup) {
        this.taxareagroup = taxareagroup;
    }

    public Long getTaxcatetory() {
        return this.taxcatetory;
    }

    public void setTaxcatetory(Long taxcatetory) {
        this.taxcatetory = taxcatetory;
    }

    public String getRequestType() {
        return this.requestType;
    }

    public void setRequestType(String requestType) {
        this.requestType = requestType;
    }

    public String getTemplateType() {
        if (DraftCateGory.HW_ZZS.getCategory().equals(this.getCategory())) {
            return "Overseas_VAT";
        }
        if (DraftCateGory.HW_QYSDS.getCategory().equals(this.getCategory()) && UsaCitBussiness.checkIsUsaSds(this.taxationsys.toString(), this.taxcatetory.toString(), this.taxareagroup.toString())) {
            return "USA_CIT";
        }
        return "Overseas_CIT";
    }

    public String getTemplateId() {
        String templateType = this.getTemplateType();
        if ("Overseas_VAT".equals(templateType)) {
            return "1657311429247904768";
        }
        if ("USA_CIT".equals(templateType)) {
            return "1686895520800370688";
        }
        if ("Overseas_CIT".equals(templateType)) {
            return "1657982743440669696";
        }
        return null;
    }

    public boolean isSds() {
        return "GtcpConstant.CIT_TEMPLATE_TEMPLATE_TYPE".equals(this.getTemplateType());
    }
}

