/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.common.enums;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupThanTaxesEnum;
import org.apache.commons.lang3.ObjectUtils;

public enum GtcpCitThanTaxAreaGroupProvisionEnum {
    General_income_tax("", "General_income tax", Collections.singletonList("generalincome_amount_tobe_accrued#generalincome_rta_accrual"), Collections.singletonList("generalincome_amount_due_overp#generalincome_rta_reporting")),
    Solidarity_surcharge("", "Solidarity surcharge", Collections.singletonList("generalincome_amount_tobe_accrued#solidarity_surcharge_rta_accrual"), Collections.singletonList("generalincome_amount_due_overp#solidarity_surcharge_rta_reporting")),
    Trade_tax("", "Trade tax", Collections.singletonList("generalincome_amount_tobe_accrued#trade_tax_rta_accrual"), Collections.singletonList("generalincome_amount_due_overp#trade_tax_rta_reporting")),
    Local_income_tax("", "Local income tax", Collections.singletonList("generalincome_amount_tobe_accrued#Local_income_tax_rta_accrual"), Collections.singletonList("generalincome_amount_due_overp#Local_income_tax_rta_reporting")),
    Inhabitants_tax_proportional("", "Inhabitants tax proportional", Collections.singletonList("generalincome_amount_tobe_accrued#Inhabitants_tax_propo_rta_accrual"), Collections.singletonList("generalincome_amount_due_overp#Inhabitants_tax_propo_rta_reporting")),
    Inhabitants_tax_normquota("", "Inhabitants tax normquota", Collections.singletonList("generalincome_amount_tobe_accrued#Inhabitants_tax_norm_accrual"), Collections.singletonList("generalincome_amount_due_overp#Inhabitants_tax_norm_reporting")),
    Enterprise_tax("", "Enterprise tax", Collections.singletonList("generalincome_amount_tobe_accrued#enterprise_tax_rta_accrual"), Collections.singletonList("generalincome_amount_due_overp#enterprise_tax_rta_reporting")),
    Special_enterprise_tax("", "Special enterprise tax", Collections.singletonList("generalincome_amount_tobe_accrued#special_enterprise_tax_rta_accrual"), Collections.singletonList("generalincome_amount_due_overp#special_enterprise_tax_rta_reporting"));

    private String taxAreaGroupId;
    private String taxAreaGroupName;
    private List<String> AccrualItemList;
    private List<String> ReportItemList;

    private GtcpCitThanTaxAreaGroupProvisionEnum(String taxAreaGroupId, String taxAreaGroupName, List<String> accrualItemList, List<String> reportItemList) {
        this.taxAreaGroupId = taxAreaGroupId;
        this.taxAreaGroupName = taxAreaGroupName;
        this.AccrualItemList = accrualItemList;
        this.ReportItemList = reportItemList;
    }

    public String getTaxAreaGroupId() {
        return this.taxAreaGroupId;
    }

    public void setTaxAreaGroupId(String taxAreaGroupId) {
        this.taxAreaGroupId = taxAreaGroupId;
    }

    public String getTaxAreaGroupName() {
        return this.taxAreaGroupName;
    }

    public List<String> getAccrualItemList() {
        return this.AccrualItemList;
    }

    public List<String> getReportItemList() {
        return this.ReportItemList;
    }

    public static List<String> getAccrualItemListByTaxAreaGroupId(List<String> taxAreaGroupIdList) {
        UsaTaxAreaGroupThanTaxesEnum[] values;
        ArrayList<String> resultList = new ArrayList<String>(12);
        for (UsaTaxAreaGroupThanTaxesEnum taxesEnum : values = UsaTaxAreaGroupThanTaxesEnum.values()) {
            if (!taxAreaGroupIdList.contains(taxesEnum.getTaxAreaGroupName())) continue;
            resultList.addAll(taxesEnum.getAccrualItemList());
        }
        return resultList;
    }

    public static List<String> getReportingItemListByTaxAreaGroupId(List<String> taxAreaGroupIdList) {
        UsaTaxAreaGroupThanTaxesEnum[] values;
        ArrayList<String> resultList = new ArrayList<String>(12);
        for (UsaTaxAreaGroupThanTaxesEnum taxesEnum : values = UsaTaxAreaGroupThanTaxesEnum.values()) {
            if (!taxAreaGroupIdList.contains(taxesEnum.getTaxAreaGroupName())) continue;
            resultList.addAll(taxesEnum.getReportItemList());
        }
        return resultList;
    }

    public static String getTaxAreaGroupIdByAccrualItem(String reportItem) {
        for (GtcpCitThanTaxAreaGroupProvisionEnum usaTaxAreaGroupThanTaxesEnum : GtcpCitThanTaxAreaGroupProvisionEnum.values()) {
            List<String> reportItemList = usaTaxAreaGroupThanTaxesEnum.getAccrualItemList();
            if (!ObjectUtils.isNotEmpty(reportItemList) || !reportItemList.contains(reportItem)) continue;
            return usaTaxAreaGroupThanTaxesEnum.getTaxAreaGroupId();
        }
        return "0";
    }

    public static List<String> getReportItemListByAccrualItem(String accrualItem) {
        for (GtcpCitThanTaxAreaGroupProvisionEnum usaTaxAreaGroupThanTaxesEnum : GtcpCitThanTaxAreaGroupProvisionEnum.values()) {
            List<String> reportItemList = usaTaxAreaGroupThanTaxesEnum.getAccrualItemList();
            if (!ObjectUtils.isNotEmpty(reportItemList) || !reportItemList.contains(accrualItem)) continue;
            return usaTaxAreaGroupThanTaxesEnum.getReportItemList();
        }
        return null;
    }
}

