/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.accessconfig;

import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.Donothing;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.taxc.bdtaxr.common.constant.RuleTypeEnum;
import kd.taxc.bdtaxr.common.enums.RuleCodeEnum;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AdvanceConfDto;
import kd.taxc.bdtaxr.common.taxdeclare.ruleconfig.RuleTemplateService;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.taxorg.GtcpCombineBusiness;
import kd.taxc.gtcp.common.constant.GtcpConstant;
import kd.taxc.gtcp.common.enums.GtcpBizTypeEnum;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AccessConfigPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String ENTRY_ENTITY_1 = "entryentity1";
    private static final String KEY_FILTERCONDITION_1 = "filtercondition1";
    private static final String KEY_CONDITIONJSON_1 = "conditionjson1";
    private static final String NUMBER = "number";
    private static final String TABLE = "table";
    private static final String ACCESS_PROJECT = "accessproject";
    private static final String ORG = "org";
    private static final String TBL_SHARE = "tblshare";
    private static final String TBL_PRIUSE = "tblpriuse";
    private static final String RULE_TYPE = "ruletype";
    private static final String ONE = "1";

    public void registerListener(EventObject e) {
        BasedataEdit org = (BasedataEdit)this.getControl(ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationsys = (BasedataEdit)this.getControl("taxationsys");
        taxationsys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxcategory = (BasedataEdit)this.getControl("taxcategory");
        taxcategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxareagroup = (BasedataEdit)this.getControl("taxareagroup");
        taxareagroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit accessproject = (BasedataEdit)this.getControl(ACCESS_PROJECT);
        accessproject.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxrate = (BasedataEdit)this.getControl("taxrate");
        taxrate.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit table = (BasedataEdit)this.getControl(TABLE);
        table.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit tableTax = (BasedataEdit)this.getControl("table1");
        tableTax.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"tbmain"});
        BasedataEdit amountfield = (BasedataEdit)this.getControl("amountfield1");
        amountfield.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof Donothing) {
            String key = ((Donothing)args.getSource()).getOperateKey();
            if (!"setting1".equals(key) && !"setadvancedconf1".equals(key)) {
                return;
            }
            EntryGrid entryentity = (EntryGrid)this.getControl(ENTRY_ENTITY_1);
            int focusRow = entryentity.getEntryState().getFocusRow();
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table1", focusRow);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"AccessConfigPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Long tableEntityId = tabletype.getLong("id");
            if ("setting1".equals(key)) {
                String ischild = tabletype.getString("ischild");
                String entityNumber = tabletype.getString("name");
                if ("false".equals(ischild) && StringUtil.isNotBlank((CharSequence)tabletype.getString("subname"))) {
                    entityNumber = tabletype.getString("subname");
                }
                this.openSettingPage(focusRow, tabletype.getLong("id"), entityNumber);
            }
            if ("setadvancedconf1".equals(key)) {
                DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield1", focusRow);
                String advancedconfjson = (String)this.getModel().getValue("advancedconfjson1", focusRow);
                String datatype = (String)this.getModel().getValue("datatype1", focusRow);
                BigDecimal vatrate = BigDecimal.ZERO;
                BigDecimal jsbl = BigDecimal.ONE;
                BigDecimal yzvatrate = BigDecimal.ZERO;
                if ("jsflqs".equals(datatype) || "cysldsqs".equals(datatype) || "sehshsj".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate1", focusRow);
                } else if ("gjqs".equals(datatype)) {
                    jsbl = (BigDecimal)this.getModel().getValue("jsbl1", focusRow);
                } else if ("yjjsflqs".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate1", focusRow);
                    yzvatrate = (BigDecimal)this.getModel().getValue("yzvatrate1", focusRow);
                } else if ("hsjhsse".equals(datatype) || "bhsjhsse".equals(datatype)) {
                    vatrate = (BigDecimal)this.getModel().getValue("vatrate1", focusRow);
                }
                AdvanceConfDto advanceConfDto = new AdvanceConfDto(advancedconfjson, datatype, vatrate, jsbl, yzvatrate);
                if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson")) {
                    String exratejson = (String)this.getModel().getValue("exratejson1", focusRow);
                    advanceConfDto.setConvertExrateJson(exratejson);
                }
                RuleTemplateService.operationConfigClick((AdvanceConfDto)advanceConfDto, (BeforeDoOperationEventArgs)args, (EntryGrid)entryentity, (DynamicObject)amountfield, (Long)tableEntityId, (IFormView)this.getView(), (int)focusRow, (String)ENTRY_ENTITY_1, (IFormPlugin)this);
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject taxCategory;
        long id;
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        List<Long> allTaxOrgs = GtcpCombineBusiness.getAllTaxOrgs(this.getView());
        if (org != null && !allTaxOrgs.contains(id = org.getLong("id"))) {
            if (CollectionUtils.isEmpty(allTaxOrgs)) {
                this.getModel().setValue(ORG, null);
            } else {
                this.getModel().setValue(ORG, (Object)allTaxOrgs.get(0));
            }
        }
        String taxCategoryNumber = (taxCategory = this.getModel().getDataEntity().getDynamicObject("taxcategory")) == null ? null : taxCategory.getString(NUMBER);
        this.getView().setVisible(Boolean.valueOf(GtcpConstant.ZZS.contains(taxCategoryNumber)), new String[]{"taxrate", "advconap1"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("taxationsys".equals(name)) {
            DynamicObject newValue = (DynamicObject)e.getChangeSet()[0].getNewValue();
            this.getModel().setValue("taxcategory", null);
            this.getModel().setValue("taxareagroup", null);
            this.getModel().setValue("taxrate", null);
        } else if ("taxcategory".equals(name) || "taxareagroup".equals(name)) {
            if ("taxcategory".equals(name)) {
                DynamicObjectCollection collection;
                DynamicObject taxCategory = this.getModel().getDataEntity().getDynamicObject("taxcategory");
                String taxCategoryNumber = taxCategory == null ? null : taxCategory.getString(NUMBER);
                this.getView().setVisible(Boolean.valueOf(GtcpConstant.ZZS.contains(taxCategoryNumber)), new String[]{"taxrate", "advconap1"});
                if (!GtcpConstant.ZZS.contains(taxCategoryNumber)) {
                    this.getModel().deleteEntryData(ENTRY_ENTITY_1);
                }
                DynamicObjectCollection dynamicObjectCollection = collection = taxCategory == null ? null : taxCategory.getDynamicObjectCollection("taxarea");
                if (null != collection && ObjectUtils.isNotEmpty((Object)collection)) {
                    Optional optional = collection.stream().findFirst();
                    this.getModel().setValue("taxareagroup", optional.isPresent() ? Long.valueOf(((DynamicObject)optional.get()).getLong("fbasedataid.id")) : null);
                } else {
                    this.getModel().setValue("taxareagroup", null);
                }
                this.getModel().deleteEntryData("entryentity");
                this.hideZzsSomeBizType();
            }
            this.getModel().setValue(ACCESS_PROJECT, null);
            this.getModel().setValue("taxrate", null);
        } else if ("table1".equals(e.getProperty().getName())) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_1);
            this.getModel().setValue("amountfield1", null, rowIndex);
            this.getModel().setValue(KEY_FILTERCONDITION_1, null, rowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON_1, null, rowIndex);
            this.getModel().setValue("absolute1", (Object)Boolean.FALSE, rowIndex);
        } else if ("amountfield1".equals(name)) {
            DynamicObject changeAmount = (DynamicObject)e.getChangeSet()[0].getNewValue();
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_1);
            if (changeAmount == null) {
                return;
            }
            String amountValue = changeAmount.getString("fieldname");
            String table = changeAmount.getString("fieldsubname");
            BiPredicate<String, String> tdmBalance = AccessConfigPlugin.predicate("tdm_balance_new", Lists.newArrayList((Object[])new String[]{"closinglocalcurrency", "openinglocalcurrency"}));
            BiPredicate<String, String> glBalance = AccessConfigPlugin.predicate("gl_balance", Lists.newArrayList((Object[])new String[]{"beginlocal", "endlocal"}));
            if (tdmBalance.test(table, amountValue) || glBalance.test(table, amountValue)) {
                this.getModel().setValue("absolute1", (Object)Boolean.TRUE, rowIndex);
            } else {
                this.getModel().setValue("absolute1", (Object)Boolean.FALSE, rowIndex);
            }
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table1", rowIndex);
            DynamicObject amountfield = (DynamicObject)this.getModel().getValue("amountfield1", rowIndex);
            RuleTemplateService.setAdvanceConfDefaultValue((IDataModel)this.getModel(), (int)rowIndex, (DynamicObject)tabletype, (DynamicObject)amountfield, (String)"advancedconf1", (String)"advancedconfjson1");
        } else if ("datatype1".equals(name)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_1);
            BigDecimal vatrate = BigDecimal.ZERO;
            String datatype = (String)e.getChangeSet()[0].getNewValue();
            if (!("jsflqs".equals(datatype) || "cysldsqs".equals(datatype) || "sehshsj".equals(datatype))) {
                this.getModel().setValue("vatrate1", (Object)vatrate, rowIndex);
            }
        } else if (ACCESS_PROJECT.equalsIgnoreCase(name)) {
            this.hideZzsSomeBizType();
        } else if (ORG.equalsIgnoreCase(name)) {
            this.getModel().setValue(ACCESS_PROJECT, null);
            this.getModel().setValue("taxrate", null);
        }
    }

    public void afterBindData(EventObject e) {
        DynamicObject taxCategory;
        if (StringUtils.equalsIgnoreCase((CharSequence)((String)this.getView().getFormShowParameter().getCustomParams().get(TBL_SHARE)), (CharSequence)ONE)) {
            this.getModel().setValue(RULE_TYPE, (Object)"public");
            this.getView().getParentView().getPageCache().remove(TBL_SHARE);
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)((String)this.getView().getFormShowParameter().getCustomParams().get(TBL_PRIUSE)), (CharSequence)ONE)) {
            this.getModel().setValue(RULE_TYPE, (Object)"private");
            this.getView().getParentView().getPageCache().remove(TBL_PRIUSE);
        }
        String taxCategoryNumber = (taxCategory = this.getModel().getDataEntity().getDynamicObject("taxcategory")) == null ? null : taxCategory.getString(NUMBER);
        this.getView().setVisible(Boolean.valueOf(GtcpConstant.ZZS.contains(taxCategoryNumber)), new String[]{"taxrate", "advconap1"});
        this.hideZzsSomeBizType();
        this.getModel().setDataChanged(false);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)ORG)) {
            List<Long> allTaxOrgs = GtcpCombineBusiness.getAllTaxOrgs(this.getView());
            QFilter idFilter = CollectionUtils.isEmpty(allTaxOrgs) ? new QFilter("id", "is null", null) : new QFilter("id", "in", allTaxOrgs);
            evt.addCustomQFilter(idFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxcategory")) {
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            if (taxationsys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AccessConfigPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("taxationsysid", "=", taxationsys.get("id"));
            evt.addCustomQFilter(qFilter);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxareagroup")) {
            DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
            if (null == taxCategory) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"AccessConfigPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObjectCollection collection = null == taxCategory ? null : taxCategory.getDynamicObjectCollection("taxarea");
            List<Object> groupIds = new ArrayList(16);
            if (null != collection && ObjectUtils.isNotEmpty((Object)collection)) {
                groupIds = collection.stream().map(row -> row.getLong("fbasedataid.id")).collect(Collectors.toList());
            }
            evt.addCustomQFilter(new QFilter("id", "in", groupIds));
        } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)TABLE) || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"table1")) {
            String formId;
            String ruleType;
            DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
            if (taxationsys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AccessConfigPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
            if (taxCategory == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"AccessConfigPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            String number = taxCategory.getString(NUMBER);
            if (!(GtcpConstant.ZZS.contains(number) || GtcpConstant.SDS.contains(number) || GtcpConstant.USA_OTHER.contains(number))) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u8be5\u7a0e\u79cd\u3002", (String)"AccessConfigPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
            if (org != null) {
                formShowParameter.setUseOrgId(org.getLong("id"));
            }
            if (StringUtil.isNotBlank((CharSequence)(ruleType = RuleCodeEnum.getRuleType((String)(formId = this.getView().getFormShowParameter().getFormId()))))) {
                QFilter filter = new QFilter("basedataid.billno", "=", (Object)ruleType);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"tctb_datasource_pkrules", (String)"id", (QFilter[])new QFilter[]{filter});
                formShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", collection.stream().map(e -> e.getLong("id")).collect(Collectors.toList())));
            }
            String billNo = GtcpConstant.ZZS.contains(number) ? "RULE-GLOBALTAX-VAT-WP" : "RULE-GLOBALTAX-CIT-WP";
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tctb_datasource_peek_rule", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)billNo)});
            Long id = dynamicObject == null ? 0L : dynamicObject.getLong("id");
            QFilter ruleFilter = new QFilter("peekrule.fbasedataid", "=", (Object)id);
            evt.addCustomQFilter(ruleFilter);
        } else if (ACCESS_PROJECT.equalsIgnoreCase(name)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject(ORG);
            DynamicObject taxationsys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
            DynamicObject taxcategory = this.getModel().getDataEntity().getDynamicObject("taxcategory");
            DynamicObject taxareagroup = this.getModel().getDataEntity().getDynamicObject("taxareagroup");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AccessConfigPlugin_8", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (taxationsys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AccessConfigPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (taxcategory == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"AccessConfigPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (taxareagroup == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u8f96\u533a\u3002", (String)"AccessConfigPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter orgQ = BaseDataServiceHelper.getBaseDataFilter((String)"gtcp_fetchitem", (Long)org.getLong("id"));
            Long taxareagroupid = taxareagroup.getLong("id");
            QFilter filter = new QFilter("taxationsys", "=", (Object)taxationsys.getLong("id")).and(new QFilter("taxcategory", "=", (Object)taxcategory.getLong("id"))).and(new QFilter("isleaf", "=", (Object)Boolean.TRUE)).and(new QFilter("enable", "=", (Object)ONE)).and(new QFilter("taxareagroup", "=", (Object)taxareagroupid)).and(orgQ);
            evt.addCustomQFilter(filter);
        } else if ("taxrate".equals(name)) {
            DynamicObject org = this.getModel().getDataEntity().getDynamicObject(ORG);
            DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
            DynamicObject taxAreagroup = this.getModel().getDataEntity().getDynamicObject("taxareagroup");
            if (taxCategory == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"AccessConfigPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AccessConfigPlugin_8", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter baseDataQ = BaseDataServiceHelper.getBaseDataFilter((String)"bd_taxrate", (Long)org.getLong("id"));
            if (null != taxAreagroup && StringUtil.equalsIgnoreCase((CharSequence)taxAreagroup.getString(NUMBER), (CharSequence)"EU")) {
                QFilter groupQ = new QFilter("group.number", "=", (Object)"EU");
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxarea", (String)"country", (QFilter[])new QFilter[]{groupQ});
                if (ObjectUtils.isNotEmpty((Object)collection)) {
                    Set countrySet = collection.stream().map(row -> row.getLong("country")).collect(Collectors.toSet());
                    baseDataQ.and(new QFilter("country", "in", countrySet));
                }
            } else {
                baseDataQ.and("taxcategoryid", "=", (Object)taxCategory.getLong("id"));
                baseDataQ.and("taxarea", "=", (Object)(null == taxAreagroup ? 0L : taxAreagroup.getLong("id")));
            }
            evt.addCustomQFilter(baseDataQ);
        } else if ("amountfield1".equals(name)) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_1);
            DynamicObject tabletype = (DynamicObject)this.getModel().getValue("table1", rowIndex);
            if (tabletype == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6570\u636e\u6e90\u3002", (String)"AccessConfigPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            QFilter id = new QFilter("tableid", "=", tabletype.get("id"));
            ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
            formShowParameter.getListFilterParameter().setFilter(id);
            String entityName = ((BasedataEdit)evt.getSource()).getView().getFormShowParameter().getFormId();
            if (RuleTypeEnum.REDUCE.getEntry().equals(entityName) && "tdm_balance_new".equals(tabletype.get("name"))) {
                QFilter fieldFilter = new QFilter("fieldname", "=", (Object)"debitlocalcurrency").or(new QFilter("fieldname", "=", (Object)"creditlocalcurrency"));
                formShowParameter.getListFilterParameter().setFilter(fieldFilter);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        int currentRowIndex;
        Map filterData;
        super.closedCallBack(evt);
        if ("setting1".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_1);
            this.getModel().setValue(KEY_FILTERCONDITION_1, filterData.get("filterdescription"), currentRowIndex);
            this.getModel().setValue(KEY_CONDITIONJSON_1, filterData.get("filtervalue"), currentRowIndex);
        }
        if ("setadvancedconf1".equals(evt.getActionId()) && (filterData = (Map)evt.getReturnData()) != null) {
            Object datatype;
            currentRowIndex = this.getModel().getEntryCurrentRowIndex(ENTRY_ENTITY_1);
            this.getModel().setValue("advancedconf1", filterData.get("advancedconf"), currentRowIndex);
            this.getModel().setValue("advancedconfjson1", filterData.get("advancedconfjson"), currentRowIndex);
            if (this.getModel().getDataEntityType().getAllFields().containsKey("exratejson1")) {
                this.getModel().setValue("exratejson1", filterData.get("convert_rate_json"), currentRowIndex);
            }
            if ("jsflqs".equals(datatype = this.getModel().getValue("datatype1", currentRowIndex)) || "cysldsqs".equals(datatype) || "sehshsj".equals(datatype)) {
                this.getModel().setValue("vatrate1", filterData.get("vatrate"), currentRowIndex);
            } else if ("gjqs".equals(datatype)) {
                this.getModel().setValue("jsbl1", filterData.get("jsbl"), currentRowIndex);
            } else if ("yjjsflqs".equals(datatype)) {
                this.getModel().setValue("vatrate1", filterData.get("vatrate"), currentRowIndex);
                this.getModel().setValue("yzvatrate1", filterData.get("yzvatrate"), currentRowIndex);
            } else if ("hsjhsse".equals(datatype) || "bhsjhsse".equals(datatype)) {
                this.getModel().setValue("vatrate1", filterData.get("vatrate"), currentRowIndex);
            }
        }
    }

    public static BiPredicate<String, String> predicate(String table, List<String> columns) {
        return (table1, amountValue1) -> table.equals(table1) && columns.contains(amountValue1);
    }

    protected void openSettingPage(int rowIndex, long entityId, String entityNumber) {
        DynamicObject selectedRow = this.getModel().getEntryRowEntity(ENTRY_ENTITY_1, rowIndex);
        FormShowParameter formshowParameter = new FormShowParameter();
        formshowParameter.setFormId("bdtaxr_filtercondition");
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "setting1");
        formshowParameter.setCloseCallBack(closeCallBack);
        formshowParameter.setCustomParam("entityId", (Object)entityId);
        formshowParameter.setCustomParam("entityNumber", (Object)entityNumber);
        formshowParameter.setCustomParam("filterJson", selectedRow.get(KEY_CONDITIONJSON_1));
        formshowParameter.setCustomParam("description", selectedRow.get(KEY_FILTERCONDITION_1));
        DynamicObject org = (DynamicObject)this.getModel().getValue(ORG);
        Object ruleType = this.getView().getFormShowParameter().getCustomParams().get(RULE_TYPE);
        if (null != ruleType) {
            formshowParameter.setCustomParam(RULE_TYPE, ruleType);
        }
        if (org != null) {
            formshowParameter.setCustomParam("orgid", (Object)org.getString("id"));
        }
        formshowParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(formshowParameter);
    }

    private void hideZzsSomeBizType() {
        String taxCategoryNumber;
        String bizTypeNumber = this.getModel().getDataEntity().getString("accessproject.biztype.number");
        DynamicObject taxCategory = this.getModel().getDataEntity().getDynamicObject("taxcategory");
        String string = taxCategoryNumber = taxCategory == null ? null : taxCategory.getString(NUMBER);
        if (GtcpConstant.ZZS.contains(taxCategoryNumber)) {
            if (GtcpConstant.ZZS_HIDE_BIZTYPE.contains(bizTypeNumber)) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"taxrate", "advconap"});
                this.getModel().deleteEntryData("entryentity");
                this.getModel().setValue("taxrate", null);
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"taxrate", "advconap"});
            }
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advconap"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"taxrate"});
        }
        List<String> NSSB_BIZTYPE = Arrays.asList(GtcpBizTypeEnum.WP_00019.getNumber(), GtcpBizTypeEnum.WP_00028.getNumber(), GtcpBizTypeEnum.WP_00029.getNumber(), GtcpBizTypeEnum.WP_00030.getNumber());
        if (StringUtil.equalsIgnoreCase((CharSequence)bizTypeNumber, (CharSequence)GtcpBizTypeEnum.WP_00031.getNumber())) {
            this.getModel().setValue("rulepurpose", (Object)"sjjt");
            this.getView().setEnable(Boolean.FALSE, new String[]{"rulepurpose"});
        } else if (NSSB_BIZTYPE.contains(bizTypeNumber)) {
            this.getModel().setValue("rulepurpose", (Object)"nssb");
            this.getView().setEnable(Boolean.FALSE, new String[]{"rulepurpose"});
        } else {
            this.getView().setEnable(Boolean.TRUE, new String[]{"rulepurpose"});
        }
    }
}

