/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.accessconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.taxorg.GtcpCombineBusiness;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class AccessconfigListPlugin
extends AbstractListPlugin {
    private static final String BASTAX_TAXORG = "bastax_taxorg";
    private static final String TBL_SHARE = "tblshare";
    private static final String TBL_PRIUSE = "tblpriuse";
    private static final String TBL_COPY = "tblcopy";
    private static final String SPECIFIEDSHARING = "specifiedsharing";
    private static final String TBLENABLE = "tblenable";
    private static final String SPECIFIED_SHARING = "specified_sharing";
    private static final String ID = "id";
    private static final String RULE_ID = "rule.id";
    private static final String RULE_NUMBER = "rule.number";
    private static final String RULE_TYPE = "ruletype";
    private static final String ENABLE = "enable";
    private static final String SEPARATOR = System.getProperty("line.separator");
    private static final String GTCP_INCOME_SHARDINGPLAN = "gtcp_shardingplan";
    private static final String ACCESS_CONFIG_NAME = "gtcp_accessconfig";
    private static final String PUBLIC = "public";
    private static final String NEW_TYPE = "newtype";
    private static final String ONE = "1";

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        String newtype = this.getPageCache().get(NEW_TYPE);
        String oid = null;
        if (newtype != null) {
            if (TBL_SHARE.equalsIgnoreCase(newtype) || TBL_PRIUSE.equalsIgnoreCase(newtype)) {
                e.getParameter().setCustomParam(newtype, (Object)ONE);
                List orgid = this.getControlFilters().getFilter("org.id");
                oid = orgid != null && orgid.size() == 1 && !"".equalsIgnoreCase(orgid.get(0).toString()) ? String.valueOf(orgid.get(0)) : null;
            } else if (TBL_COPY.equalsIgnoreCase(newtype)) {
                oid = this.getPageCache().get(TBL_COPY);
            }
            if (oid != null) {
                DynamicObject[] load = BusinessDataServiceHelper.load((String)BASTAX_TAXORG, (String)ID, (QFilter[])new QFilter[]{new QFilter("istaxpayer", "=", (Object)ONE).and("status", "=", (Object)ONE).and(ID, "=", (Object)Long.valueOf(oid))});
                if (load == null || load.length == 0) {
                    oid = null;
                    e.getParameter().setCustomParam("setnull", (Object)Boolean.TRUE);
                } else {
                    HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"gtcp", (String)ACCESS_CONFIG_NAME, (String)"47156aff000000ac", (Long)RequestContext.get().getCurrUserId());
                    if (!allPermOrgsByUserId.hasAllOrgPerm() && !allPermOrgsByUserId.getHasPermOrgs().contains(load[0].getLong(ID))) {
                        oid = null;
                        e.getParameter().setCustomParam("setnull", (Object)Boolean.TRUE);
                    }
                }
            }
            e.getParameter().setCustomParam("orgid", (Object)oid);
            this.getPageCache().put(NEW_TYPE, null);
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_SHARE) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_PRIUSE) || StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_COPY)) {
            this.getPageCache().put(NEW_TYPE, itemKey);
            if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBL_COPY) && this.getSelectRowsDetail() != null && this.getSelectRowsDetail().length == 1) {
                this.getPageCache().put(TBL_COPY, String.valueOf(this.getSelectRowsDetail()[0].get("org.id")));
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)SPECIFIEDSHARING)) {
            this.checkSpecifiedSharing(evt);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)TBLENABLE)) {
            this.checkDuplicateWhenClickEnable(evt);
        }
    }

    private void checkSpecifiedSharing(BeforeItemClickEvent evt) {
        if (this.getSelectedRows().isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"AccessconfigListPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
            evt.setCancel(true);
        } else {
            ArrayList<String> errorMsgList = new ArrayList<String>(3);
            DynamicObject[] dynamicObjects = this.getSelectRowsDetail();
            ListSelectedRowCollection accessConfigRows = this.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ListSelectedRow accessConfigRow : accessConfigRows) {
                Long primaryKeyValue = (Long)accessConfigRow.getPrimaryKeyValue();
                ids.add(primaryKeyValue);
            }
            DynamicObjectCollection accessConfigList = QueryServiceHelper.query((String)ACCESS_CONFIG_NAME, (String)"id,taxationsys.id,taxcategory.id,taxareagroup.id,org.id", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
            Set taxationsysCollect = accessConfigList.stream().map(m -> m.getLong("taxationsys.id")).collect(Collectors.toSet());
            Set taxcategoryCollect = accessConfigList.stream().map(m -> m.getLong("taxcategory.id")).collect(Collectors.toSet());
            Set taxareagroupCollect = accessConfigList.stream().map(m -> m.getLong("taxareagroup.id")).collect(Collectors.toSet());
            Set orgCollect = accessConfigList.stream().map(m -> m.getLong("org.id")).collect(Collectors.toSet());
            if (taxationsysCollect.size() != 1) {
                errorMsgList.add(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u540c\u65e0\u6cd5\u6279\u91cf\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u3002", (String)"AccessconfigListPlugin_11", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            if (taxcategoryCollect.size() != 1) {
                errorMsgList.add(ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u540c\u65e0\u6cd5\u6279\u91cf\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u3002", (String)"AccessconfigListPlugin_12", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            if (taxareagroupCollect.size() != 1) {
                errorMsgList.add(ResManager.loadKDString((String)"\u7a0e\u6536\u8f96\u533a\u4e0d\u540c\u65e0\u6cd5\u6279\u91cf\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u3002", (String)"AccessconfigListPlugin_13", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            if (orgCollect.size() != 1) {
                errorMsgList.add(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u540c\u65e0\u6cd5\u6279\u91cf\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccessconfigListPlugin_20", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            for (DynamicObject row : dynamicObjects) {
                String format;
                if (!StringUtils.equalsIgnoreCase((CharSequence)row.getString(ENABLE), (CharSequence)ONE)) {
                    format = String.format(ResManager.loadKDString((String)"%1$s: \u53ea\u6709\u53ef\u7528\u7684\u6570\u636e\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 ", (String)"AccessconfigListPlugin_14", (String)"taxc-gtcp", (Object[])new Object[0]), row.getString("number"));
                    errorMsgList.add(format);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)row.getString(RULE_TYPE), (CharSequence)PUBLIC)) continue;
                format = String.format(ResManager.loadKDString((String)"%1$s: \u53ea\u6709\u53ef\u5206\u914d\u89c4\u5219\u624d\u80fd\u6307\u5b9a\u5171\u4eab\u65b9\u6848\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002 ", (String)"AccessconfigListPlugin_15", (String)"taxc-gtcp", (Object[])new Object[0]), row.getString("number"));
                errorMsgList.add(format);
            }
            if (!errorMsgList.isEmpty()) {
                if (errorMsgList.size() == 1) {
                    this.getView().showErrorNotification((String)errorMsgList.get(0));
                } else {
                    String joinErrorMsg = String.join((CharSequence)SEPARATOR, errorMsgList);
                    this.getView().getFormShowParameter().getOpenStyle().setShowType(ShowType.Modal);
                    OperationResult operationResult = new OperationResult();
                    operationResult.setSuccess(false);
                    operationResult.setMessage(joinErrorMsg);
                    this.getView().showOperationResult(operationResult);
                }
                evt.setCancel(true);
            }
        }
    }

    private void checkDuplicateWhenClickEnable(BeforeItemClickEvent evt) {
        DynamicObject[] selectedRows = this.getSelectRowsDetail();
        HashSet<Long> privateSet = new HashSet<Long>();
        HashSet<Long> orgSet = new HashSet<Long>();
        HashSet<Long> accessProjectSet = new HashSet<Long>();
        HashSet rulepurposeSet = new HashSet();
        for (DynamicObject selectedRow : selectedRows) {
            if (!StringUtil.equalsIgnoreCase((CharSequence)selectedRow.getString(RULE_TYPE), (CharSequence)"private")) continue;
            privateSet.add(selectedRow.getLong(ID));
            orgSet.add(selectedRow.getLong("org.id"));
            accessProjectSet.add(selectedRow.getLong("accessproject.id"));
            String rulepurposes = selectedRow.getString("rulepurpose");
            Arrays.stream(rulepurposes.split(",")).forEach(row -> rulepurposeSet.add(row));
        }
        if (!privateSet.isEmpty()) {
            Arrays.stream(selectedRows).forEach(o -> {
                privateSet.add(o.getLong(ID));
                orgSet.add(o.getLong("org.id"));
                accessProjectSet.add(o.getLong("accessproject.id"));
            });
            QFilter status = new QFilter(ENABLE, "=", (Object)Boolean.TRUE);
            QFilter ruletype = new QFilter(RULE_TYPE, "=", (Object)"private");
            QFilter noInid = new QFilter(ID, "not in", (Object)privateSet.toArray());
            QFilter org = new QFilter("org", "in", (Object)orgSet.toArray());
            QFilter accessproject = new QFilter("accessproject", "in", (Object)accessProjectSet.toArray());
            QFilter rulepurpose = QFilter.ftlikeMultiValue((String[])rulepurposeSet.toArray(new String[0]), (String[])new String[]{"rulepurpose"});
            QFilter inIdQ = new QFilter(ID, "in", (Object)privateSet.toArray());
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"accessconfigList", (String)ACCESS_CONFIG_NAME, (String)"org.id org,accessproject.id accessproject,rulepurpose", (QFilter[])new QFilter[]{inIdQ, ruletype, rulepurpose}, null);){
                DataType[] dataTypes = new DataType[]{DataType.StringType, DataType.StringType, DataType.StringType};
                RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])new String[]{"org", "accessproject", "rulepurpose"}, (DataType[])dataTypes);
                ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
                while (dataSet.hasNext()) {
                    Row row2 = dataSet.next();
                    String tempRulePurpose = row2.getString("rulepurpose");
                    String[] tempRulePurposes = tempRulePurpose.split(",");
                    if (!ObjectUtils.isNotEmpty((Object)tempRulePurposes)) continue;
                    for (String ruleConfig : tempRulePurposes) {
                        if (!StringUtil.isNotEmpty((CharSequence)ruleConfig)) continue;
                        Object[] value = new Object[]{row2.getString("org"), row2.getString("accessproject"), ruleConfig};
                        coll.add(value);
                    }
                }
                CollectionInput inputs = new CollectionInput(rowMeta, coll);
                DataSet newDataSet = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSet(new Input[]{inputs});
                DataSet smartGroupByDataSet = newDataSet.groupBy(new String[]{"org", "accessproject", "rulepurpose"}).count("total").finish();
                Object object = null;
                try {
                    while (true) {
                        if (smartGroupByDataSet.hasNext()) {
                            Row row3 = smartGroupByDataSet.next();
                            if (row3.getInteger("total") <= 1) continue;
                            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u548c\u53d6\u6570\u9879\u76ee\u548c\u89c4\u5219\u7528\u9014\u76f8\u540c\u65f6\uff0c\u81ea\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccessconfigListPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                            evt.setCancel(true);
                            return;
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    if (smartGroupByDataSet != null) {
                        if (object != null) {
                            try {
                                smartGroupByDataSet.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                        } else {
                            smartGroupByDataSet.close();
                        }
                    }
                }
            }
            if (QueryServiceHelper.exists((String)ACCESS_CONFIG_NAME, (QFilter[])new QFilter[]{status, ruletype, noInid, org, accessproject, rulepurpose})) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u548c\u53d6\u6570\u9879\u76ee\u548c\u89c4\u5219\u7528\u9014\u76f8\u540c\u65f6\uff0c\u81ea\u7528\u89c4\u5219\u4e0d\u5141\u8bb8\u540c\u65f6\u542f\u7528\u591a\u6761\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AccessconfigListPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        if (SPECIFIED_SHARING.equalsIgnoreCase(evt.getOperateKey()) && evt.getOperationResult().isSuccess()) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)GTCP_INCOME_SHARDINGPLAN, (boolean)true);
            ListSelectedRowCollection accessConfigRows = this.getSelectedRows();
            ArrayList<Long> ids = new ArrayList<Long>();
            for (ListSelectedRow accessConfigRow : accessConfigRows) {
                Long primaryKeyValue = (Long)accessConfigRow.getPrimaryKeyValue();
                ids.add(primaryKeyValue);
            }
            DynamicObject dyo = QueryServiceHelper.queryOne((String)ACCESS_CONFIG_NAME, (String)"id,taxationsys.id,taxcategory.id,taxareagroup.id", (QFilter[])new QFilter[]{new QFilter(ID, "in", ids)});
            QFilter filter = new QFilter("taxationsys", "=", (Object)dyo.getLong("taxationsys.id"));
            filter.and("taxcategory", "=", (Object)dyo.getLong("taxcategory.id"));
            long taxareagroupId = dyo.getLong("taxareagroup.id");
            if (taxareagroupId != 0L) {
                filter.and("taxareagroup", "=", (Object)dyo.getLong("taxareagroup.id"));
            }
            listShowParameter.getListFilterParameter().setFilter(filter);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SPECIFIEDSHARING));
            ArrayList accessconfigList = new ArrayList(evt.getOperationResult().getBillNos().values());
            this.getView().getPageCache().put("accessconfigno", String.join((CharSequence)",", accessconfigList));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)SPECIFIEDSHARING)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData instanceof ListSelectedRowCollection) {
                StringBuilder message = new StringBuilder();
                ListSelectedRowCollection returnDataRows = (ListSelectedRowCollection)returnData;
                ListSelectedRowCollection accessConfigRows = this.getSelectedRows();
                DynamicObject[] shardingPlans = BusinessDataServiceHelper.load((Object[])returnDataRows.stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)GTCP_INCOME_SHARDINGPLAN));
                Arrays.stream(shardingPlans).forEach(shardingPlan -> {
                    DynamicObject[] selRules;
                    DynamicObjectCollection ruleCollection = shardingPlan.getDynamicObjectCollection("ruleentity");
                    List rules = ruleCollection.stream().map(o -> o.getLong(RULE_ID)).collect(Collectors.toList());
                    Map<String, String> ruleNumberNameMap = ruleCollection.stream().collect(Collectors.toMap(o -> o.getString("rule.accessproject.number"), o -> o.getString("rule.accessproject.name"), (k1, k2) -> k1));
                    HashMap projectRulePurposeMap = new HashMap();
                    for (DynamicObject row : ruleCollection) {
                        List<Object> rulePurposeList = new ArrayList(16);
                        if (StringUtil.isNotBlank((CharSequence)row.getString("rule.rulepurpose"))) {
                            rulePurposeList = Arrays.asList(row.getString("rule.rulepurpose").split(",")).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList());
                        }
                        if (projectRulePurposeMap.containsKey(row.getString("rule.accessproject.number"))) {
                            ((List)projectRulePurposeMap.get(row.getString("rule.accessproject.number"))).addAll(rulePurposeList);
                            projectRulePurposeMap.put(row.getString("rule.accessproject.number"), projectRulePurposeMap.get(row.getString("rule.accessproject.number")));
                            continue;
                        }
                        projectRulePurposeMap.put(row.getString("rule.accessproject.number"), rulePurposeList);
                    }
                    List seletRules = accessConfigRows.stream().map(o -> (Long)o.getPrimaryKeyValue()).collect(Collectors.toList());
                    List existsRules = (List)CollectionUtils.intersection(rules, seletRules);
                    for (DynamicObject row : selRules = BusinessDataServiceHelper.load((Object[])seletRules.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ACCESS_CONFIG_NAME))) {
                        List rulePurpose;
                        Long id = row.getLong(ID);
                        if (rules.contains(id)) continue;
                        if (!projectRulePurposeMap.containsKey(row.getString("accessproject.number"))) {
                            DynamicObject dynamicObject = ruleCollection.addNew();
                            dynamicObject.set("rule", (Object)id);
                            continue;
                        }
                        List list = (List)projectRulePurposeMap.get(row.getString("accessproject.number"));
                        List existsRulePurposeList = (List)CollectionUtils.intersection((Iterable)list, rulePurpose = Arrays.asList(row.getString("rulepurpose").split(",")).stream().filter(s -> StringUtils.isNotBlank((CharSequence)s)).collect(Collectors.toList()));
                        if (ObjectUtils.isEmpty((Object)existsRulePurposeList)) {
                            DynamicObject dynamicObject = ruleCollection.addNew();
                            dynamicObject.set("rule", (Object)id);
                            continue;
                        }
                        String format = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848:%1$s \u5b58\u5728\u76f8\u540c\u7684\u53d6\u6570\u9879\u76ee:%2$s\u3002", (String)"AccessconfigListPlugin_18", (String)"taxc-gtcp", (Object[])new Object[0]), shardingPlan.getString("name"), ruleNumberNameMap.get(row.getString("accessproject.number")));
                        message.append(format);
                        message.append("\r\n");
                    }
                    if (!existsRules.isEmpty()) {
                        ArrayList messages = new ArrayList(8);
                        ruleCollection.forEach(o -> {
                            if (existsRules.contains(o.getLong(RULE_ID))) {
                                messages.add(o.getString(RULE_NUMBER));
                            }
                        });
                        String format = String.format(ResManager.loadKDString((String)"\u5171\u4eab\u65b9\u6848:%1$s \u5df2\u914d\u7f6e\u89c4\u5219:%2$s\u3002", (String)"AccessconfigListPlugin_19", (String)"taxc-gtcp", (Object[])new Object[0]), shardingPlan.getString("name"), String.join((CharSequence)", ", messages));
                        message.append(format);
                        message.append("\r\n");
                    }
                });
                SaveServiceHelper.save((DynamicObject[])shardingPlans);
                if (StringUtils.isNotBlank((CharSequence)message)) {
                    this.getView().showTipNotification(message.toString());
                    GtcpCombineBusiness.saveDialog("19KIWPPM7UT=", ACCESS_CONFIG_NAME, ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848", (String)"AccessconfigListPlugin_17", (String)"taxc-gtcp", (Object[])new Object[0]), message.toString());
                } else {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"AccessconfigListPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]));
                    String number = this.getView().getPageCache().get("accessconfigno");
                    GtcpCombineBusiness.saveDialog("19KIWPPM7UT=", ACCESS_CONFIG_NAME, ResManager.loadKDString((String)"\u6307\u5b9a\u5171\u4eab\u65b9\u6848", (String)"AccessconfigListPlugin_17", (String)"taxc-gtcp", (Object[])new Object[0]), String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s \u6307\u5b9a\u5171\u4eab\u65b9\u6848\u6210\u529f\u3002", (String)"AccessconfigListPlugin_16", (String)"taxc-gtcp", (Object[])new Object[0]), number));
                }
            }
            this.getView().getPageCache().remove("accessconfigno");
        }
    }

    private DynamicObject[] getSelectRowsDetail() {
        return BusinessDataServiceHelper.load((Object[])this.getSelectedRows().stream().map(ListSelectedRow::getPrimaryKeyValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)ACCESS_CONFIG_NAME));
    }
}

