/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.basedeclare;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.business.multidideclare.MultiDiTemplateHelper;
import kd.taxc.bdtaxr.business.taxcode.TaxCodeResultBussiness;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.refactor.template.domain.Sheet;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiPlugin;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.business.tctb.TaxPeriodBusiness;
import kd.taxc.gtcp.common.constant.GtcpConstant;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGtcpDeclareReportMultiPlugin
extends AbstractDeclareReportMultiPlugin {
    private static Log LOGGER = LogFactory.getLog(AbstractGtcpDeclareReportMultiPlugin.class);
    public static final Map<String, String> cycleMap = new HashMap<String, String>(4);

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isNotEmpty((Object)customParams) && ObjectUtils.isNotEmpty(customParams.get("taxcategory.number"))) {
            this.getView().getPageCache().put("taxcategory.number", customParams.get("taxcategory.number").toString());
        }
        super.afterCreateNewData(e);
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"usacitsolve"});
    }

    protected void setExtendControllsStatus(String operationType) {
        if ("USA_CIT".equalsIgnoreCase(this.getTemplateType())) {
            if ("edit".equals(operationType)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"usacitsolve"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"usacitsolve"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"usacitsolve"});
        }
        if ("edit".equals(operationType)) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"remarks"});
        } else {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"remarks"});
        }
    }

    protected void setExtendsControlsByBillstatus(String billstatus) {
        super.setExtendsControlsByBillstatus(billstatus);
        if ("USA_CIT".equalsIgnoreCase(this.getTemplateType())) {
            if ("new".equals(billstatus)) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"usacitsolve"});
            } else {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"usacitsolve"});
            }
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"usacitsolve"});
        }
        if ("A".equals(billstatus) || "B".equals(billstatus) || "C".equals(billstatus)) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"remarks"});
        } else {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"remarks"});
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key = evt.getItemKey();
        if ("USA_CIT".equalsIgnoreCase(this.getTemplateType())) {
            switch (key) {
                case "usacitsolve": {
                    this.calUSTax();
                    this.reloadPageAndRecoverCache();
                    return;
                }
            }
        }
        super.itemClick(evt);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        String key = afterDoOperationEventArgs.getOperateKey();
        if ("USA_CIT".equalsIgnoreCase(this.getTemplateType())) {
            switch (key) {
                case "save": {
                    Map currentMap = (Map)TreeUtils.getCache((IPageCache)this.getChildPageCache(), (String)"showData", Map.class);
                    if (!ObjectUtils.isNotEmpty((Object)currentMap)) break;
                    double Total_Tax = Double.parseDouble((String)currentMap.get("Total#Total_Tax"));
                    double State_income_tax_Amount = Double.parseDouble((String)currentMap.get("State_income_tax#Amount"));
                    if (!(BigDecimal.valueOf(Total_Tax).add(BigDecimal.valueOf(State_income_tax_Amount)).abs().doubleValue() >= 1.0E-6)) break;
                    HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                    btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"AbstractGtcpDeclareReportMultiPlugin_18", (String)"taxc-gtcp", (Object[])new Object[0]));
                    btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"AbstractGtcpDeclareReportMultiPlugin_19", (String)"taxc-gtcp", (Object[])new Object[0]));
                    this.getView().showConfirm(ResManager.loadKDString((String)"State income tax overview\u9875\u7b7e\u4e0bTotal#Accumulated total tax for the year\u5355\u5143\u683c\u503c-Federation\u9875\u7b7e\u4e0bState income tax#Accumulated amount for the year \u5355\u5143\u683c\u503c >=0.000001\uff0c\u6570\u636e\u5c1a\u672a\u6821\u51c6\u81f3\u7279\u5b9a\u7cbe\u5ea6\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4fdd\u5b58\uff1f", (String)"AbstractGtcpDeclareReportMultiPlugin_20", (String)"taxc-gtcp", (Object[])new Object[0]), "", MessageBoxOptions.YesNo, ConfirmTypes.Save, new ConfirmCallBackListener("usacitsolve", (IFormPlugin)this), btnNameMaps);
                    return;
                }
            }
        }
        super.afterDoOperation(afterDoOperationEventArgs);
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        String callBackId;
        super.confirmCallBack(e);
        switch (callBackId = e.getCallBackId()) {
            case "usacitsolve": {
                if (e.getResult() != MessageBoxResult.Yes) break;
                LocaleString saveMsg = new LocaleString(ResManager.loadKDString((String)"\u6570\u636e\u4fdd\u5b58\u4e2d\uff0c\u8bf7\u7a0d\u7b49\uff083S\uff09\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_21", (String)"taxc-gtcp", (Object[])new Object[0]));
                this.getView().showLoading(saveMsg, 3000);
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e1) {
                    LOGGER.error(e1.getMessage());
                }
                this.save();
            }
        }
    }

    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    public void init() {
    }

    public String getTaxType() {
        return null;
    }

    public String getTemplateType() {
        String taxCategoryNumber;
        DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
        String string = taxCategoryNumber = taxCategory == null ? null : taxCategory.getString("number");
        if (ObjectUtils.isEmpty((Object)taxCategoryNumber) && ObjectUtils.isNotEmpty((Object)this.getView().getPageCache().get("taxcategory.number"))) {
            taxCategoryNumber = this.getView().getPageCache().get("taxcategory.number");
        }
        if (GtcpConstant.ZZS.contains(taxCategoryNumber)) {
            return "Overseas_VAT";
        }
        if (GtcpConstant.SDS.contains(taxCategoryNumber)) {
            if (StringUtil.equalsIgnoreCase((CharSequence)taxCategoryNumber, (CharSequence)"USA-CIT")) {
                return "USA_CIT";
            }
            return "Overseas_CIT";
        }
        return "";
    }

    protected boolean isDefaultOrg() {
        return Boolean.FALSE;
    }

    protected Long getCustomOrg(Map<String, Object> customParams) {
        if (customParams.get("org.id") != null) {
            return Long.parseLong(customParams.get("org.id").toString());
        }
        List<Long> suitableOrgIds = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
        if (CollectionUtils.isEmpty(suitableOrgIds)) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        if (suitableOrgIds.contains(orgId)) {
            return orgId;
        }
        return suitableOrgIds.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPeriod(IDataModel model, IPageCache pageCache, String orgIdStr, Map<String, Object> customParams) {
        try {
            String papersStatus = "A";
            Long orgId = Long.parseLong(orgIdStr);
            this.getModel().setValue("org", (Object)orgId);
            Long taxationSysId = null;
            Long taxTypeId = null;
            Long taxAreaId = null;
            List<Long> taxationSysByBasTaxOrg = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false);
            if (CollectionUtils.isNotEmpty(taxationSysByBasTaxOrg)) {
                List<Long> taxAreaGroupIdList;
                taxationSysId = taxationSysByBasTaxOrg.get(0);
                List<Long> taxTypeIdList = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationSysId);
                if (CollectionUtils.isNotEmpty(taxTypeIdList)) {
                    taxTypeId = taxTypeIdList.get(0);
                }
                if (CollectionUtils.isNotEmpty(taxAreaGroupIdList = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationSysId, taxTypeId))) {
                    taxAreaId = taxAreaGroupIdList.get(0);
                    if (taxationSysId != null && taxTypeId != null && taxationSysId == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupIdList.contains(1616686278185582592L)) {
                        taxAreaId = 1616686278185582592L;
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
                    }
                }
            }
            this.getModel().setValue("taxationsys", (Object)taxationSysId);
            this.getModel().setValue("taxcategory", taxTypeId);
            this.getModel().setValue("taxareagroup", taxAreaId);
            model.setValue("papers_status", (Object)papersStatus);
            pageCache.put("papers_status", papersStatus);
            this.initDate(orgId, taxationSysId, taxTypeId, taxAreaId, customParams);
            this.createBillNumber();
        }
        finally {
            pageCache.put("dateChanged", "false");
            this.getModel().setDataChanged(false);
        }
    }

    protected void initDate(Long orgId, Long taxationSysId, Long taxTypeId, Long taxAreaId, Map<String, Object> customParams) {
    }

    protected void createBillNumber() {
    }

    protected String getDraftpurpose() {
        return "nssb";
    }

    protected boolean checkArgsBeforeOpenInnerPage() {
        Date startDate = this.getModel().getDataEntity().getDate("skssqq");
        Date endDate = this.getModel().getDataEntity().getDate("skssqz");
        return this.isValidDates(startDate, endDate, true);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"org")) {
            List<Long> longs = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
            QFilter qFilter = CollectionUtils.isEmpty(longs) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", longs);
            evt.addCustomQFilter(qFilter);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxationsys") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxcategory") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxareagroup")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long orgId = org.getLong("id");
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxationsys")) {
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false);
                QFilter qFilter = CollectionUtils.isEmpty(longs) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", longs);
                evt.addCustomQFilter(qFilter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxcategory")) {
                QFilter qFilter;
                DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
                if (taxationsys == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationsys.getLong("id"));
                if (CollectionUtils.isEmpty(longs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]));
                    qFilter = new QFilter("id", "=", (Object)0L);
                } else {
                    qFilter = new QFilter("id", "in", longs);
                }
                evt.addCustomQFilter(qFilter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxareagroup")) {
                QFilter qFilter;
                long taxCategoryId;
                DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
                DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
                if (taxationsys == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long l = taxCategoryId = taxCategory == null ? 0L : taxCategory.getLong("id");
                if (taxCategoryId == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_8", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationsys.getLong("id"), taxCategoryId);
                if (CollectionUtils.isEmpty(longs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]));
                    qFilter = new QFilter("id", "=", (Object)0L);
                } else {
                    qFilter = new QFilter("id", "in", longs);
                }
                evt.addCustomQFilter(qFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        List<Long> taxCategories;
        List<Long> sysByBasTaxOrg;
        List<Long> suitableOrgIds;
        DynamicObject taxareagroup;
        String appId = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appId == null || changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        Object newValue = changeData[0].getNewValue();
        if (newValue == null && null != changeData[0].getOldValue()) {
            this.getModel().setValue(name, changeData[0].getOldValue());
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"remarks", (CharSequence)name)) {
            return;
        }
        boolean loadData = false;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject taxationSys = (DynamicObject)this.getModel().getValue("taxationsys");
        DynamicObject taxType = (DynamicObject)this.getModel().getValue("taxcategory");
        DynamicObject taxAreaGroup = (DynamicObject)this.getModel().getValue("taxareagroup");
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        if (ObjectUtils.isNotEmpty((Object)startDate) && ObjectUtils.isNotEmpty((Object)endDate)) {
            this.getView().getPageCache().put("skssqq", DateUtils.format((Date)startDate));
            this.getView().getPageCache().put("skssqz", DateUtils.format((Date)endDate));
        }
        long orgId = org == null ? 0L : org.getLong("id");
        long taxationSysId = taxationSys == null ? 0L : taxationSys.getLong("id");
        long taxTypeId = taxType == null ? 0L : taxType.getLong("id");
        long taxAreaGroupId = taxAreaGroup == null ? 0L : taxAreaGroup.getLong("id");
        List<Long> sysTaxAreaIds = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationSysId, taxTypeId);
        if ("org".equalsIgnoreCase(name)) {
            this.getPageCache().put("orgid", String.valueOf(orgId));
            this.getModel().getDataEntity().set("taxationsys", null);
            this.getModel().getDataEntity().set("taxcategory", null);
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("taxationsys");
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxareagroup");
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            taxationSysId = 0L;
            taxTypeId = 0L;
            taxAreaGroupId = 0L;
            startDate = null;
            endDate = null;
        } else if ("taxationsys".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxationsys", String.valueOf(taxationSysId));
            this.getModel().getDataEntity().set("taxcategory", null);
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxareagroup");
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            taxTypeId = 0L;
            taxAreaGroupId = 0L;
            startDate = null;
            endDate = null;
            if (TaxationsysMappingEnum.USA.getId() != taxationSysId) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"usacitsolve"});
            }
        } else if ("taxcategory".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxcategory", Long.toString(taxTypeId));
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("taxareagroup");
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            taxAreaGroupId = 0L;
            startDate = null;
            endDate = null;
        } else if ("taxareagroup".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxareagroup", Long.toString(taxAreaGroupId));
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            startDate = null;
            endDate = null;
        }
        this.createBillNumber();
        if (orgId != 0L && taxationSysId != 0L && taxTypeId != 0L && taxAreaGroupId != 0L && startDate != null && endDate != null) {
            loadData = true;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"taxareagroup"});
        if (taxationSysId == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupId != 1616686278185582592L) {
            loadData = true;
            this.getPageCache().put("taxareagroup", Long.toString(1616686278185582592L));
            taxareagroup = BusinessDataServiceHelper.loadSingle((Object)1616686278185582592L, (String)"bastax_taxareagroup");
            this.getModel().getDataEntity().set("taxareagroup", (Object)taxareagroup);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
            this.getView().updateView("taxareagroup");
            sysTaxAreaIds.add(1616686278185582592L);
        }
        if (taxationSysId == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupId == 1616686278185582592L) {
            loadData = true;
            this.getPageCache().put("taxareagroup", Long.toString(1616686278185582592L));
            taxareagroup = BusinessDataServiceHelper.loadSingle((Object)1616686278185582592L, (String)"bastax_taxareagroup");
            this.getModel().getDataEntity().set("taxareagroup", (Object)taxareagroup);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
            this.getView().updateView("taxareagroup");
            sysTaxAreaIds.add(1616686278185582592L);
        }
        if (orgId != 0L && !(suitableOrgIds = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm()).contains(orgId)) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u4e0d\u53ef\u7528\u6216\u65e0\u6743\u9650\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]), org.getString("number"));
            this.getView().showErrorNotification(msg);
            return;
        }
        if (taxationSysId != 0L && !(sysByBasTaxOrg = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false)).contains(taxationSysId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_11", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        if (taxTypeId != 0L && !(taxCategories = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationSysId)).contains(taxTypeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u79cd\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_12", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        if (taxAreaGroupId != 0L && (CollectionUtils.isEmpty(sysTaxAreaIds) || !sysTaxAreaIds.contains(taxAreaGroupId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u6536\u8f96\u533a\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_13", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        Boolean checkTemplate = this.checkTemplate(false);
        if (!checkTemplate.booleanValue()) {
            return;
        }
        if (loadData) {
            Boolean isNeedRefresh;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)MultiTableEnum.TSD001.getDeclareMainTable(), (String)"id", (QFilter[])new QFilter[]{this.setDefaultQfilter()});
            Boolean bl = isNeedRefresh = dynamicObject == null ? Boolean.TRUE : Boolean.FALSE;
            if (startDate == null || endDate == null) {
                return;
            }
            this.loadData(startDate, endDate, true, isNeedRefresh);
        }
    }

    public void edit(String key) {
        super.edit(key);
        String sbbid = this.getPageCache().get("cache_sbbid");
        if (ObjectUtils.isNotEmpty((Object)sbbid)) {
            TaxCodeResultBussiness.buildCopyData((Long)Long.parseLong(sbbid));
        }
    }

    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String number = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        Long taxTypeId = customParams.get("taxcategory") == null ? null : Long.valueOf(Long.parseLong(customParams.get("taxcategory").toString()));
        Long taxationSys = customParams.get("taxationsys") == null ? null : Long.valueOf(Long.parseLong(customParams.get("taxationsys").toString()));
        Long taxAreaGroupId = customParams.get("taxareagroup") == null ? null : Long.valueOf(Long.parseLong(customParams.get("taxareagroup").toString()));
        String billStatus = customParams.get("papers_status") == null ? null : customParams.get("papers_status").toString();
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue("taxationsys", (Object)taxationSys);
        this.getModel().setValue("taxcategory", (Object)taxTypeId);
        this.getModel().setValue("taxareagroup", (Object)taxAreaGroupId);
        this.getModel().setValue("papers_status", (Object)billStatus);
        this.getModel().setValue("draftpurpose", (Object)this.getDraftpurpose());
        if (taxationSys != null && taxTypeId != null && taxAreaGroupId != null && taxationSys == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupId == 1616686278185582592L) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
        }
        return customParams;
    }

    protected QFilter setDefaultQfilter() {
        QFilter declareMainQueryParams = this.getDeclareMainQueryParams();
        return new QFilter("org", "=", (Object)(this.getView().getPageCache().get("orgid") == null ? Long.valueOf(0L) : Long.valueOf(this.getView().getPageCache().get("orgid")))).and("skssqq", "=", this.getModel().getValue("skssqq") == null ? null : DateUtils.stringToDate((String)DateUtils.format((Date)((Date)this.getModel().getValue("skssqq"))))).and("skssqz", "=", this.getModel().getValue("skssqz") == null ? null : DateUtils.stringToDate((String)DateUtils.format((Date)((Date)this.getModel().getValue("skssqz"))))).and("templatetype", "=", (Object)this.getTemplateType()).and(declareMainQueryParams);
    }

    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    protected Map<String, String> getBizParams() {
        HashMap<String, String> bizParamsMap = new HashMap<String, String>(4);
        DynamicObject dataEntity = this.getModel().getDataEntity(true);
        bizParamsMap.put("billno", this.getView().getPageCache().get("number"));
        bizParamsMap.put("billstatus", this.getView().getPageCache().get("papers_status"));
        bizParamsMap.put("taxsystem", dataEntity.getString("taxationsys.id"));
        bizParamsMap.put("taxationsys", dataEntity.getString("taxationsys.id"));
        bizParamsMap.put("taxcategory", dataEntity.getString("taxcategory.id"));
        bizParamsMap.put("taxtype", dataEntity.getString("taxcategory.id"));
        bizParamsMap.put("taxareagroup", dataEntity.getString("taxareagroup.id"));
        bizParamsMap.put("ttctag", "taxarea");
        bizParamsMap.put("createtime", new Date().toString());
        bizParamsMap.put("draftpurpose", this.getDraftpurpose());
        bizParamsMap.put("templatetype", this.getTemplateType());
        DynamicObject templateObject = MultiDiTemplateHelper.getTemplateByConfig((Long)this.getModelId(), (String)this.getTemplateType(), (String)this.getModel().getDataEntity().getString("org.id"), (Date)this.getModel().getDataEntity().getDate("skssqq"), (Date)this.getModel().getDataEntity().getDate("skssqz"));
        if (templateObject != null) {
            bizParamsMap.put("templateid", templateObject.getString("id"));
        }
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        DynamicObject taxSys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        Long taxSysId = taxSys == null ? null : Long.valueOf(taxSys.getLong("id"));
        Long taxTypeId = taxType == null ? null : Long.valueOf(taxType.getLong("id"));
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        bizParamsMap.putAll(GtcpFetchDataBussiness.getBizParams(this.getTemplateType(), orgId, taxSysId, taxTypeId, skssqq, this.getDraftpurpose()));
        return bizParamsMap;
    }

    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        DynamicObject taxSys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        requestModel.setTaxationsys(taxSys == null ? null : Long.valueOf(taxSys.getLong("id")));
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        if (requestModel.getRefresh().booleanValue()) {
            Map preData = requestModel.getPreData();
            Map<String, String> fetchConfigParams = this.getFetchConfigParams(requestModel);
            if (StringUtil.equals((CharSequence)"regetdata", (CharSequence)requestModel.getCustomEvent())) {
                fetchConfigParams.putAll(preData);
            }
            requestModel.getBusinessMap().putAll(fetchConfigParams);
        }
        return requestModel;
    }

    protected RuleEngineParamDto getRuleEngineParamDto(DeclareRequestModel requestModel) {
        DynamicObject taxSys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        Long taxSysId = taxSys == null ? 0L : taxSys.getLong("id");
        Long taxTypeId = taxType == null ? 0L : taxType.getLong("id");
        Long taxareagroupId = this.getModel().getDataEntity().getLong("taxareagroup.id");
        return GtcpFetchDataBussiness.getSbRuleEngineParamDto(requestModel, taxSysId, taxTypeId, taxareagroupId);
    }

    protected QFilter getDeclareMainQueryParams() {
        Long taxSysId = this.getModel().getValue("taxationsys") == null ? 0L : this.getModel().getDataEntity().getDynamicObject("taxationsys").getLong("id");
        Long taxTypeId = this.getModel().getValue("taxcategory") == null ? 0L : this.getModel().getDataEntity().getDynamicObject("taxcategory").getLong("id");
        Long taxAreaGroupId = this.getModel().getValue("taxareagroup") == null ? 0L : this.getModel().getDataEntity().getDynamicObject("taxareagroup").getLong("id");
        return new QFilter("taxsystem", "=", (Object)taxSysId).and("taxtype", "=", (Object)taxTypeId).and("taxareagroup", "=", (Object)taxAreaGroupId).and("draftpurpose", "=", (Object)this.getDraftpurpose());
    }

    public String getUniKey() {
        String orgId = this.getPageCache().get("orgid");
        String taxSystem = this.getModel().getDataEntity().get("taxationsys") == null ? "0" : this.getModel().getDataEntity().getString("taxationsys.id");
        String taxCategory = this.getModel().getDataEntity().get("taxcategory") == null ? "0" : this.getModel().getDataEntity().getString("taxCategory.id");
        String taxAreaGroup = this.getModel().getDataEntity().get("taxareagroup") == null ? "0" : this.getModel().getDataEntity().getString("taxareagroup.id");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        return String.format("%s_%s_%s_%s_%s_%s_%s_%s", orgId, taxSystem, taxCategory, taxAreaGroup, skssq, skssz, this.getDraftpurpose(), this.getTemplateType());
    }

    protected boolean viewDialog() {
        return Boolean.FALSE;
    }

    protected void doAfterSuccessSave() {
        super.doAfterSuccessSave();
        String templateType = this.getTemplateType();
        if (!"USA_CIT".equalsIgnoreCase(templateType)) {
            return;
        }
        DynamicObject mainTsd = BusinessDataServiceHelper.loadSingle((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])new QFilter[]{this.setDefaultQfilter()});
        if (mainTsd == null) {
            return;
        }
        String key = this.getUniKey() + "_htmlTemplate";
        TemplateVo templateVo = (TemplateVo)TreeUtils.getCache((IPageCache)this.getPageCache(), (String)key, TemplateVo.class);
        if (templateVo == null) {
            return;
        }
        List sheetList = templateVo.getTemplate();
        if (CollectionUtils.isEmpty((Collection)sheetList)) {
            return;
        }
        List tabNameList = sheetList.stream().map(Sheet::getName).distinct().collect(Collectors.toList());
        QFilter filter = new QFilter("id", "is not null", null);
        DynamicObjectCollection taxareagroupList = QueryServiceHelper.query((String)"bastax_taxareagroup", (String)"id,name", (QFilter[])filter.toArray());
        Map<String, Long> map = taxareagroupList.stream().collect(Collectors.toMap(k -> k.getString("name"), v -> v.getLong("id"), (k1, k2) -> k1));
        Long id = mainTsd.getLong("id");
        DeleteServiceHelper.delete((String)"gtcp_draft_tab", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
        List<DynamicObject> tableInfoList = tabNameList.stream().map(tabName -> {
            DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_draft_tab");
            dynamicObject.set("tab", tabName);
            dynamicObject.set("draftid", (Object)id);
            Long taxareagroupId = (Long)map.get(tabName);
            if ("Texas (FT)".equals(tabName)) {
                taxareagroupId = 1681071243350195200L;
            } else if ("State income tax overview".equalsIgnoreCase((String)tabName)) {
                taxareagroupId = 1616686278185582592L;
            } else if ("Federation".equals(tabName)) {
                taxareagroupId = 1681073516923009024L;
            }
            if (taxareagroupId != null) {
                dynamicObject.set("taxareagroup", (Object)taxareagroupId);
            }
            return dynamicObject;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(tableInfoList)) {
            SaveServiceHelper.save((DynamicObject[])tableInfoList.toArray(new DynamicObject[0]));
        }
    }

    protected Map<String, String> getFetchConfigParams(DeclareRequestModel requestModel) {
        Object draftpurpose = requestModel.getExtendParams().get("draftpurpose");
        HashMap<String, String> businessMap = new HashMap<String, String>();
        if (ObjectUtils.isEmpty(draftpurpose)) {
            return businessMap;
        }
        Long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
        Long taxcategoryId = this.getModel().getDataEntity().getLong("taxcategory.id");
        Long taxareagroupId = this.getModel().getDataEntity().getLong("taxareagroup.id");
        businessMap.putAll(GtcpFetchDataBussiness.getSbFetchConfigParams(requestModel, taxationsysId, taxcategoryId, taxareagroupId, GtcpFetchDataBussiness.getSbRuleEngineParamDto(requestModel, taxationsysId, taxcategoryId, taxareagroupId)));
        return businessMap;
    }

    protected Boolean checkTemplate(boolean showNullMsg) {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject taxSystem = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity().getDynamicObject("taxcategory");
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        if (taxSystem == null) {
            if (showNullMsg) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_16", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            return false;
        }
        if (taxType == null) {
            if (showNullMsg) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_17", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            return false;
        }
        String taxSystemName = taxSystem.getString("name");
        String taxCategoryNumber = taxType.getString("number");
        String taxCategoryName = taxType.getString("name");
        if (!GtcpConstant.ZZS.contains(taxCategoryNumber) && !GtcpConstant.SDS.contains(taxCategoryNumber)) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301%1$s - %2$s\u7684\u8ba1\u7a0e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7a0e\u5236\u7a0e\u79cd\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_14", (String)"taxc-gtcp", (Object[])new Object[0]), taxSystemName, taxCategoryName));
            return false;
        }
        if (startDate != null && endDate != null && org != null) {
            DynamicObject templateObject;
            String templateType = this.getTemplateType();
            long orgId = org.getLong("id");
            if (StringUtils.isNotEmpty((CharSequence)templateType) && (templateObject = MultiDiTemplateHelper.getTemplateByConfig((Long)1532683517396254720L, (String)templateType, (String)String.valueOf(orgId), (Date)startDate, (Date)endDate)) == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\u53c2\u6570\u5408\u6cd5\u6027\u3002", (String)"AbstractGtcpDeclareReportMultiPlugin_15", (String)"taxc-gtcp", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    protected Date getTaxYearStartDate(Long orgId, Long taxSysId, Long taxTypeId) {
        return TaxPeriodBusiness.getTaxPeriodStartDate(orgId, taxSysId, taxTypeId);
    }

    private Map<String, String> calUSTax() {
        HashMap<String, String> argsMap1 = new HashMap<String, String>(16);
        boolean flag = true;
        int count = 0;
        String str = "";
        argsMap1.put("State_income_tax#Amount", "0");
        argsMap1.put("State_income_tax_#Arkansas_Amount", "0");
        argsMap1.put("State_income_tax_#Colorado_Amount", "0");
        argsMap1.put("State_income_tax_#Illinois_Amount", "0");
        argsMap1.put("State_income_tax_#Iowa_Amount", "0");
        argsMap1.put("State_income_tax_#Louisiana_Amount", "0");
        argsMap1.put("State_income_tax_#Rhode_Island_Amount", "0");
        argsMap1.put("State_income_tax_#Tennessee_Amount", "0");
        argsMap1.put("State_income_tax_#Georgia_Amount", "0");
        this.changeDataBusiness(argsMap1);
        while (flag && count < 20) {
            Map currentMap = (Map)TreeUtils.getCache((IPageCache)this.getChildPageCache(), (String)"showData", Map.class);
            double Total_Tax = Double.parseDouble((String)currentMap.get("Total#Total_Tax"));
            double State_income_tax_Amount = Double.parseDouble((String)currentMap.get("State_income_tax#Amount"));
            str = str + "Total#Total_Tax=" + Total_Tax + ";State_income_tax#Amount=" + State_income_tax_Amount + "\r\n";
            if (BigDecimal.valueOf(Total_Tax).add(BigDecimal.valueOf(State_income_tax_Amount)).abs().doubleValue() >= 1.0E-6) {
                argsMap1.put("State_income_tax#Amount", -Total_Tax + "");
                argsMap1.put("State_income_tax_#Arkansas_Amount", -(Total_Tax - Double.parseDouble((String)currentMap.get("Total_tax_common#Arkansas_Amount"))) + "");
                argsMap1.put("State_income_tax_#Colorado_Amount", -(Total_Tax - Double.parseDouble((String)currentMap.get("Total_tax_common#Colorado_Amount"))) + "");
                argsMap1.put("State_income_tax_#Illinois_Amount", -(Total_Tax - Double.parseDouble((String)currentMap.get("Total_tax_common#Illinois_Amount"))) + "");
                argsMap1.put("State_income_tax_#Iowa_Amount", -(Total_Tax - Double.parseDouble((String)currentMap.get("Total_tax_common#Iowa_Amount"))) + "");
                argsMap1.put("State_income_tax_#Louisiana_Amount", -(Total_Tax - Double.parseDouble((String)currentMap.get("Total_tax_common#Louisiana_Amount"))) + "");
                argsMap1.put("State_income_tax_#Rhode_Island_Amount", -(Total_Tax - Double.parseDouble((String)currentMap.get("Total_tax_common#Rhode_Island_Amount"))) + "");
                argsMap1.put("State_income_tax_#Tennessee_Amount", -(Total_Tax - Double.parseDouble((String)currentMap.get("Total_tax_common#Tennessee_Amount"))) + "");
                argsMap1.put("State_income_tax_#Georgia_Amount", -Double.parseDouble((String)currentMap.get("Total_tax_common#Georgia_Amount")) + "");
                argsMap1.put("The_states_accrued_income_tax_deduction#Oklahoma_Amount", Double.parseDouble((String)currentMap.get("Tax_based_on_taxable_income#Oklahoma_Amount")) + "");
                this.changeDataBusiness(argsMap1);
                ++count;
                continue;
            }
            flag = false;
        }
        LOGGER.info("====================calUSTax:" + str);
        return argsMap1;
    }

    private void reloadPageAndRecoverCache() {
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        this.getView().sendFormAction(childView);
    }

    private void changeDataBusiness(Map<String, String> changeCellMap) {
        if (ObjectUtils.isEmpty(changeCellMap)) {
            return;
        }
        String pageid = this.getPageCache().get("declarepageid");
        IFormView childView = this.getView().getView(pageid);
        FormViewPluginProxy pluginProxy = (FormViewPluginProxy)childView.getService(FormViewPluginProxy.class);
        List pluginList = pluginProxy.getPlugIns();
        Object taxDeclarePlugin = null;
        for (IFormPlugin plugin : pluginList) {
            String name = plugin.getPluginName();
            if (!name.endsWith("DeclarePlugin")) continue;
            taxDeclarePlugin = plugin;
            break;
        }
        if (taxDeclarePlugin != null) {
            Class<?> pluginClass = taxDeclarePlugin.getClass();
            try {
                Method changeDataBusiness = pluginClass.getDeclaredMethod("changeDataBusiness", Map.class);
                AccessibleObject.setAccessible(new AccessibleObject[]{changeDataBusiness}, true);
                changeDataBusiness.invoke(taxDeclarePlugin, changeCellMap);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
            }
        }
    }

    static {
        cycleMap.put("month", ResManager.loadKDString((String)"\u6708", (String)"AbstractGtcpDeclareReportMultiPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
        cycleMap.put("season", ResManager.loadKDString((String)"\u5b63\u5ea6", (String)"AbstractGtcpDeclareReportMultiPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
        cycleMap.put("halfyear", ResManager.loadKDString((String)"\u534a\u5e74", (String)"AbstractGtcpDeclareReportMultiPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
        cycleMap.put("year", ResManager.loadKDString((String)"\u5e74", (String)"AbstractGtcpDeclareReportMultiPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
    }
}

