/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.basedeclare;

import com.google.common.collect.Maps;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ExportFileEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TaxationSysEnum;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.formplugin.taxdeclare.AbstractDeclareReportMultiQueryListPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public abstract class AbstractGtcpNormalDeclareReportMultiListPlugin
extends AbstractDeclareReportMultiQueryListPlugin {
    private static final String ORG_ID = "org.id";
    private static Log LOGGER = LogFactory.getLog(AbstractGtcpNormalDeclareReportMultiListPlugin.class);

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if (ORG_ID.equalsIgnoreCase(args.getFieldName())) {
            List<Long> taxpayers = AbstractGtcpNormalDeclareReportMultiListPlugin.queryBastaxTaxOrg(this.getView());
            QFilter orgFilter = new QFilter("id", "in", taxpayers);
            args.getQfilters().add(orgFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List filterColumnList = contInitEvent.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            TaxResult result;
            if ("org.name".equals(column.getFieldName())) {
                List<Long> idList = AbstractGtcpNormalDeclareReportMultiListPlugin.queryBastaxTaxOrg(this.getView());
                long orgId = RequestContext.get().getOrgId();
                QFilter authFilter = new QFilter("id", "in", idList);
                DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name", (QFilter[])new QFilter[]{authFilter});
                List comboItems = orgCol.stream().map(dyo -> {
                    ComboItem item = new ComboItem();
                    item.setValue(dyo.getString("id"));
                    item.setCaption(new LocaleString(dyo.getString("name")));
                    return item;
                }).collect(Collectors.toList());
                CommonFilterColumn typeColumn = (CommonFilterColumn)column;
                typeColumn.setComboItems(comboItems);
                if (idList.contains(orgId)) {
                    typeColumn.setDefaultValue(String.valueOf(orgId));
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(idList)) continue;
                typeColumn.setDefaultValue(String.valueOf(idList.get(0)));
                continue;
            }
            if (!"taxsystem.name".equalsIgnoreCase(column.getFieldName()) || (result = TaxAtionsysDataServiceHelper.queryTaxAtionsysByIds(null)) == null || !result.isSuccess()) continue;
            List list = (List)result.getData();
            List comboItems = list.stream().filter(row -> !TaxationSysEnum.CHAIN_MAINLAND.getId().equals(row.getPkValue())).map(dyo -> {
                ComboItem item = new ComboItem();
                item.setValue(dyo.getString("id"));
                item.setCaption(new LocaleString(dyo.getString("name")));
                return item;
            }).collect(Collectors.toList());
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            typeColumn.setComboItems(comboItems);
        }
    }

    public static List<Long> queryBastaxTaxOrg(IFormView view) {
        DynamicObjectCollection taxOrgs;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        QFilter entryEntityFilter = new QFilter("entryentity.entry_taxationsys", "!=", (Object)1L);
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs())) {
            QFilter authFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name,entryentity.entry_taxationsys as taxationsys", (QFilter[])new QFilter[]{authFilter, entryEntityFilter});
        } else {
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name,entryentity.entry_taxationsys as taxationsys", (QFilter[])new QFilter[]{entryEntityFilter});
        }
        return taxOrgs.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
    }

    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
        Long taxTypeId = object.get("taxtype") == null ? 0L : ((DynamicObject)object.get("taxtype")).getLong("id");
        Long taxareagroupId = object.get("taxareagroup") == null ? 0L : ((DynamicObject)object.get("taxareagroup")).getLong("id");
        customParams.put("papers_status", object.get("billstatus"));
        customParams.put("taxationsys", ((DynamicObject)object.get("taxsystem")).getLong("id"));
        customParams.put("taxtype", taxTypeId);
        customParams.put("taxcategory", taxTypeId);
        customParams.put("taxareagroup", taxareagroupId);
        customParams.put("draftPurpose", this.getDraftPurpose());
        customParams.put("remarks", object.getString("remarks"));
    }

    public String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    protected List<String> getTemplateTypeList() {
        return Arrays.asList("Overseas_VAT", "Overseas_CIT", "USA_CIT");
    }

    protected void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object) {
        List orgValues = this.getControlFilters().getFilter(ORG_ID);
        try {
            if (CollectionUtils.isNotEmpty((Collection)orgValues) && orgValues.size() == 1) {
                customParams.put(ORG_ID, Long.parseLong(orgValues.get(0).toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        super.showDeclarePage(type, customParams, declarestatus, object);
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        String draftPurpose = this.getDraftPurpose();
        if (!ObjectUtils.isEmpty((Object)draftPurpose)) {
            e.getQFilters().add(new QFilter("draftpurpose", "=", (Object)draftPurpose));
        }
    }

    public String getDraftPurpose() {
        return null;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"checkjtd", (CharSequence)((Donothing)args.getSource()).getOperateKey()) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
            args.setCancel(true);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"checkjtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            Map billNosMap = evt.getOperationResult().getBillNos();
            Collection billNos = billNosMap.values();
            ArrayList resultbillNos = new ArrayList(billNos);
            List ids = evt.getOperationResult().getSuccessPkIds();
            String operateName = ResManager.loadKDString((String)"\u67e5\u770b\u8ba1\u63d0\u5355", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)ids)) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle(ids.get(0), (String)entityId, (String)"billno,org.id ,taxsystem.id,templatetype,taxtype");
                this.openProvistonBillPage(dynamicObject.getString(ORG_ID), dynamicObject.getString("taxsystem.id"), dynamicObject.getString("taxtype.number"), dynamicObject.getString("billno"));
                String templatetype = dynamicObject.getString("templatetype.number");
                String billEntity = dynamicObject.getDataEntityType().getName();
                if (resultbillNos.size() > 0) {
                    String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7:%s\u67e5\u770b\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]), resultbillNos.get(0));
                    OperatorDialogUtils.operateDialog((String)templatetype, (String)billEntity, (String)operateName, (String)operateDescription);
                }
            } else if (resultbillNos.size() > 0) {
                String operateDescription = String.format(ResManager.loadKDString((String)"\u7f16\u53f7:%s\u67e5\u770b\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]), resultbillNos.get(0));
                OperatorDialogUtils.operateDialog((String)this.getTemplateTypeList().get(0), (String)entityId, (String)operateName, (String)operateDescription);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            OperationResult operationResult = evt.getOperationResult();
            StringBuilder successMessage = new StringBuilder();
            StringBuilder failMessage = new StringBuilder();
            this.getLogResultMessage(operationResult, successMessage, failMessage);
            String operateName = ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]);
            StringBuilder resultMessage = new StringBuilder();
            if (failMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\u751f\u6210\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]), failMessage));
            }
            if (successMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7: %s\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]), successMessage));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"newjtd") && operationResult.getBillCount() == operationResult.getSuccessPkIds().size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u751f\u6210\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            OperatorDialogUtils.operateDialog((String)this.getTemplateTypeList().get(0), (String)entityId, (String)operateName, (String)resultMessage.toString());
            this.getView().invokeOperation("refresh");
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd")) {
            String entityId = ((Donothing)evt.getSource()).getEntityId();
            String operateName = ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_8", (String)"taxc-gtcp", (Object[])new Object[0]);
            OperationResult operationResult = evt.getOperationResult();
            StringBuilder successMessage = new StringBuilder();
            StringBuilder failMessage = new StringBuilder();
            this.getLogResultMessage(operationResult, successMessage, failMessage);
            StringBuilder resultMessage = new StringBuilder();
            if (failMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7\uff1a%s\u5220\u9664\u8ba1\u63d0\u5355\u5931\u8d25\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_9", (String)"taxc-gtcp", (Object[])new Object[0]), failMessage));
            }
            if (successMessage.length() > 0) {
                resultMessage.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7: %s\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]), successMessage));
            }
            if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"deletejtd") && operationResult.getBillCount() == operationResult.getSuccessPkIds().size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u8ba1\u63d0\u5355\u6210\u529f\u3002", (String)"AbstractGtcpNormalDeclareReportMultiListPlugin_11", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            OperatorDialogUtils.operateDialog((String)this.getTemplateTypeList().get(0), (String)entityId, (String)operateName, (String)resultMessage.toString());
            this.getView().invokeOperation("refresh");
        }
    }

    public ImmutablePair<String, String> getListNameOfBillnoAndTime() {
        return null;
    }

    public void afterExportFile(ExportFileEvent e) {
        ImmutablePair<String, String> listNameOfBillnoAndTime = this.getListNameOfBillnoAndTime();
        if (listNameOfBillnoAndTime == null) {
            super.afterExportFile(e);
            return;
        }
        File file = e.getFile();
        String billnoStr = (String)listNameOfBillnoAndTime.left;
        String skssqqStr = (String)listNameOfBillnoAndTime.right;
        if (file != null) {
            ArrayList<String> billnoList = new ArrayList<String>(8);
            int billnoIndex = 0;
            int skssqqIndex = 0;
            try (FileInputStream fis = new FileInputStream(file);){
                Cell cell;
                String cellValue;
                XSSFWorkbook wb = new XSSFWorkbook((InputStream)fis);
                Sheet sheet = wb.getSheetAt(0);
                int lastRowNum = sheet.getLastRowNum();
                Row firstRow = sheet.getRow(0);
                Iterator iterator = firstRow.iterator();
                while (iterator.hasNext() && !billnoStr.equalsIgnoreCase(cellValue = (cell = (Cell)iterator.next()).getStringCellValue())) {
                    ++billnoIndex;
                }
                iterator = firstRow.iterator();
                while (iterator.hasNext() && !skssqqStr.equalsIgnoreCase(cellValue = (cell = (Cell)iterator.next()).getStringCellValue())) {
                    ++skssqqIndex;
                }
                for (int i = 1; i < lastRowNum + 1; ++i) {
                    String billno = sheet.getRow(i).getCell(billnoIndex).getStringCellValue();
                    billnoList.add(billno);
                }
                DynamicObjectCollection dyoList = QueryServiceHelper.query((String)"tpo_declare_main_tsd", (String)"billno,skssqq,skssqz", (QFilter[])new QFilter("billno", "in", billnoList).toArray());
                Map<String, List<DynamicObject>> listMap = dyoList.stream().collect(Collectors.groupingBy(m -> m.getString("billno")));
                for (int i = 1; i < lastRowNum + 1; ++i) {
                    Row row = sheet.getRow(i);
                    String billno = row.getCell(billnoIndex).getStringCellValue();
                    List objects = listMap.getOrDefault(billno, new ArrayList(8));
                    if (objects.size() != 1) continue;
                    DynamicObject data = (DynamicObject)objects.get(0);
                    String dataFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
                    String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)dataFormat);
                    String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)dataFormat);
                    String newCellValue = skssqq + "~" + skssqz;
                    Cell cell2 = row.createCell(skssqqIndex);
                    cell2.setCellValue(newCellValue);
                }
                FileOutputStream out = new FileOutputStream(file);
                wb.write((OutputStream)out);
                wb.close();
                out.close();
            }
            catch (Throwable ex) {
                LOGGER.error("\u5bfc\u51fa\u51fa\u73b0\u5f02\u5e38:" + StringUtil.getStackTraceMessage((Throwable)ex));
                super.afterExportFile(e);
            }
        }
    }

    private void getLogResultMessage(OperationResult operationResult, StringBuilder successMessage, StringBuilder failMessage) {
        List successPkIds = operationResult.getSuccessPkIds();
        Map billNos = operationResult.getBillNos();
        Set entries = billNos.entrySet();
        for (Map.Entry entry : entries) {
            if (successPkIds.contains(Long.valueOf(entry.getKey().toString()))) {
                if (successMessage.length() > 0) {
                    successMessage.append(" ");
                }
                successMessage.append((String)entry.getValue());
                continue;
            }
            if (failMessage.length() > 0) {
                failMessage.append(" ");
            }
            failMessage.append((String)entry.getValue());
        }
    }

    private void openProvistonBillPage(String orgId, String taxsystem, String taxtype, String draftBillNo) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("itp_proviston_taxes");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("entitynumber", draftBillNo);
        hashMap.put("orgId", orgId);
        hashMap.put("taxsystem", taxsystem);
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

