/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.customformula.cit;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.business.tctb.TaxPeriodBusiness;

public abstract class AbstractGtcpCitDynamicCustomFormulaPlugin
extends AbstractDynamicCustomFormulaPlugin {
    public abstract Map<String, String> getDynRowNoTaxableIncomeRowCol();

    public Map<String, FormulaVo> queryByDeclareRequestModel(DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> resultMap = new HashMap<String, FormulaVo>(12);
        Map extendParams = requestModel.getExtendParams();
        if (ObjectUtils.isEmpty((Object)extendParams)) {
            return resultMap;
        }
        if (ObjectUtils.isEmpty(dynList)) {
            return resultMap;
        }
        Long taxSystemId = Long.parseLong((String)extendParams.get("taxationsys"));
        Long taxcategoryId = Long.parseLong((String)extendParams.get("taxcategory"));
        String draftpurpose = (String)extendParams.get("draftpurpose");
        String startDate = requestModel.getSkssqq();
        Date firstDateOfTaxYear = null;
        if (StringUtil.equalsIgnoreCase((CharSequence)"nssb", (CharSequence)draftpurpose)) {
            firstDateOfTaxYear = TaxPeriodBusiness.getTaxPeriodStartMonthAndDay(requestModel.getOrgId(), taxSystemId, taxcategoryId, DateUtils.stringToDate2((String)startDate));
        } else if (StringUtil.equalsIgnoreCase((CharSequence)"sjjt", (CharSequence)draftpurpose)) {
            firstDateOfTaxYear = DateUtils.getFirstDateOfYear((Date)DateUtils.stringToDate2((String)startDate));
        }
        String currentYear = DateUtils.format(firstDateOfTaxYear, (String)"yyyy-MM-dd");
        this.buildFormula(dynList, currentYear, resultMap);
        return resultMap;
    }

    public void buildFormula(List<DynamicRowModel> dynList, String currentYear, Map<String, FormulaVo> resultMap) {
        Map<String, String> dynRowNoTaxableIncomeRowCol = this.getDynRowNoTaxableIncomeRowCol();
        if (ObjectUtils.isEmpty(dynRowNoTaxableIncomeRowCol)) {
            return;
        }
        for (DynamicRowModel dyn : dynList) {
            String dynRowNo = dyn.getDynRowNo();
            for (Map.Entry<String, String> entry : dynRowNoTaxableIncomeRowCol.entrySet()) {
                List rowList;
                String dynRowTaxableIncomeNo = entry.getKey();
                String taxableIncomeRowCol = entry.getValue();
                if (!StringUtil.equalsIgnoreCase((CharSequence)(dynRowTaxableIncomeNo + "#1"), (CharSequence)dynRowNo) || ObjectUtils.isEmpty((Object)(rowList = dyn.getRowList()))) continue;
                for (int i = 0; i < rowList.size(); ++i) {
                    Map row = (Map)rowList.get(i);
                    Optional<String> keyOptional = row.keySet().stream().filter(o -> o.endsWith("#years_losses_incurred")).findFirst();
                    String yearsLossesIncurred = (String)row.get(keyOptional.get());
                    boolean isCurrentYear = false;
                    if (StringUtil.isNotEmpty((CharSequence)yearsLossesIncurred) && StringUtil.isNotEmpty((CharSequence)currentYear) && StringUtil.equalsIgnoreCase((CharSequence)yearsLossesIncurred, (CharSequence)String.valueOf(DateUtils.getYearOfDate((Date)DateUtils.stringToDate2((String)currentYear))))) {
                        isCurrentYear = true;
                    }
                    Set entries = ((Map)rowList.get(i)).entrySet();
                    for (Map.Entry next : entries) {
                        String dynreportItemKey = (String)next.getKey();
                        if (ObjectUtils.isEmpty((Object)dynreportItemKey) || !dynreportItemKey.endsWith("#loss")) continue;
                        String baseFormulavokey = dynRowTaxableIncomeNo + "#" + (i + 1);
                        if (isCurrentYear) {
                            FormulaVo fv = new FormulaVo();
                            fv.setFormulaType("1");
                            String fvokey = baseFormulavokey + "#loss";
                            fv.setFormulaKey(fvokey);
                            String fvo = "if({Q[" + taxableIncomeRowCol + "]} >=0,0,{Q[" + taxableIncomeRowCol + "]})";
                            fv.setFormula(fvo);
                            resultMap.put(fvokey, fv);
                            continue;
                        }
                        FormulaVo vo = new FormulaVo();
                        vo.setFormulaType("1");
                        String formulavokey = baseFormulavokey + "#loss";
                        vo.setFormulaKey(formulavokey);
                        String formulavo = "{P[" + dynRowTaxableIncomeNo + "_" + formulavokey + "]}";
                        vo.setFormula(formulavo);
                        resultMap.put(formulavokey, vo);
                    }
                }
            }
        }
    }
}

