/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.customformula.vat;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicCustomFormulaPlugin;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.rule.GtcpDraftDynEngineBusiness;

public abstract class AbstractGtcpVatDynamicCustomFormulaPlugin
extends AbstractDynamicCustomFormulaPlugin {
    public Map<String, FormulaVo> queryByDeclareRequestModel(DeclareRequestModel requestModel, List<DynamicRowModel> dynList) {
        HashMap<String, FormulaVo> resultMap = new HashMap<String, FormulaVo>(12);
        Map extendParams = requestModel.getExtendParams();
        if (ObjectUtils.isEmpty((Object)extendParams)) {
            return resultMap;
        }
        if (ObjectUtils.isEmpty(dynList)) {
            return resultMap;
        }
        ArrayList<Long> idList = new ArrayList<Long>(12);
        for (DynamicRowModel dyn : dynList) {
            List rowList;
            String dynRowNo = dyn.getDynRowNo();
            if (!dynRowNo.startsWith("vat_Gtc_Sales") && !dynRowNo.startsWith("vat_Gtc_Purchases") && !dynRowNo.startsWith("vat_stc_Sales") || ObjectUtils.isEmpty((Object)(rowList = dyn.getRowList()))) continue;
            block1: for (Map row : rowList) {
                Set entries = row.entrySet();
                for (Map.Entry next : entries) {
                    String nextKey = (String)next.getKey();
                    if (ObjectUtils.isEmpty((Object)nextKey) || !nextKey.endsWith("#vat_Item")) continue;
                    idList.add(Long.parseLong((String)next.getValue()));
                    continue block1;
                }
            }
        }
        List<DynamicObject> dynamicObjects = this.getAllOrgMatchAccessConfigMap(requestModel, idList);
        HashMap<String, String> entryentityMap = new HashMap<String, String>(12);
        HashMap<String, String> entryentity1Map = new HashMap<String, String>(12);
        HashMap<String, String> rateMap = new HashMap<String, String>(12);
        this.dealwithEntrytity(entryentityMap, entryentity1Map, rateMap, dynamicObjects);
        this.buildFormula(dynList, entryentityMap, entryentity1Map, rateMap, resultMap);
        return resultMap;
    }

    public void buildFormula(List<DynamicRowModel> dynList, Map<String, String> entryentityMap, Map<String, String> entryentity1Map, Map<String, String> rateMap, Map<String, FormulaVo> resultMap) {
        String dyndynRowNo = this.getDyndynRowNo();
        if (ObjectUtils.isEmpty((Object)dyndynRowNo)) {
            return;
        }
        for (DynamicRowModel dyn : dynList) {
            List rowList;
            String dynRowNo = dyn.getDynRowNo();
            if (!(dyndynRowNo + "#1").equals(dynRowNo) || ObjectUtils.isEmpty((Object)(rowList = dyn.getRowList()))) continue;
            for (int i = 0; i < rowList.size(); ++i) {
                Set entries = ((Map)rowList.get(i)).entrySet();
                for (Map.Entry next : entries) {
                    String fvo;
                    String fvokey;
                    FormulaVo fv;
                    String formulavo;
                    String formulavokey;
                    FormulaVo vo;
                    String nextKey = (String)next.getKey();
                    if (ObjectUtils.isEmpty((Object)nextKey) || !nextKey.endsWith("#vat_Item")) continue;
                    String nextValue = (String)next.getValue();
                    String baseFormulavokey = dyndynRowNo + "#" + (i + 1);
                    if (!rateMap.containsKey(nextValue) || entryentityMap.containsKey(nextValue) && entryentity1Map.containsKey(nextValue) || !entryentityMap.containsKey(nextValue) && !entryentity1Map.containsKey(nextValue)) {
                        vo = new FormulaVo();
                        vo.setFormulaType("1");
                        formulavokey = baseFormulavokey + "#vat_Amount";
                        vo.setFormulaKey(formulavokey);
                        formulavo = "{P[" + dyndynRowNo + "_" + formulavokey + "]}";
                        vo.setFormula(formulavo);
                        resultMap.put(formulavokey, vo);
                        fv = new FormulaVo();
                        fv.setFormulaType("1");
                        fvokey = baseFormulavokey + "#vat_Tax";
                        fv.setFormulaKey(fvokey);
                        fvo = "{P[" + dyndynRowNo + "_" + fvokey + "]}";
                        fv.setFormula(fvo);
                        resultMap.put(fvokey, fv);
                        continue;
                    }
                    if (entryentityMap.containsKey(nextValue) && !entryentity1Map.containsKey(nextValue)) {
                        vo = new FormulaVo();
                        vo.setFormulaType("1");
                        formulavokey = baseFormulavokey + "#vat_Amount";
                        vo.setFormulaKey(formulavokey);
                        formulavo = "{P[" + dyndynRowNo + "_" + formulavokey + "]}";
                        vo.setFormula(formulavo);
                        resultMap.put(formulavokey, vo);
                        fv = new FormulaVo();
                        fv.setFormulaType("1");
                        fvokey = baseFormulavokey + "#vat_Tax";
                        fv.setFormulaKey(fvokey);
                        fvo = "{Q[" + baseFormulavokey + "#vat_Amount]} * {Q[" + baseFormulavokey + "#vat_Tax_rate]}";
                        fv.setFormula(fvo);
                        resultMap.put(fvokey, fv);
                    }
                    if (entryentityMap.containsKey(nextValue) || !entryentity1Map.containsKey(nextValue)) continue;
                    vo = new FormulaVo();
                    vo.setFormulaType("1");
                    formulavokey = baseFormulavokey + "#vat_Amount";
                    vo.setFormulaKey(formulavokey);
                    formulavo = "if({Q[" + baseFormulavokey + "#vat_Tax_rate]} == 0,0.00,{Q[" + baseFormulavokey + "#vat_Tax]} / {Q[" + baseFormulavokey + "#vat_Tax_rate]})";
                    vo.setFormula(formulavo);
                    resultMap.put(formulavokey, vo);
                    fv = new FormulaVo();
                    vo.setFormulaType("1");
                    fvokey = baseFormulavokey + "#vat_Tax";
                    fv.setFormulaKey(fvokey);
                    fvo = "{P[" + dyndynRowNo + "_" + fvokey + "]}";
                    fv.setFormula(fvo);
                    resultMap.put(fvokey, fv);
                }
            }
        }
    }

    public abstract String getDyndynRowNo();

    public List<DynamicObject> getAllOrgMatchAccessConfigMap(DeclareRequestModel requestModel, List<Long> idList) {
        Map extendParams = requestModel.getExtendParams();
        Long templateId = requestModel.getTemplateId();
        Long taxSystemId = requestModel.getTaxationsys();
        Long taxcategoryId = Long.parseLong((String)extendParams.get("taxcategory"));
        Long taxareagroupId = Long.parseLong((String)extendParams.get("taxareagroup"));
        Long orgId = requestModel.getOrgId();
        Date startDate = DateUtils.stringToDate2((String)requestModel.getSkssqq());
        Date endDate = DateUtils.stringToDate2((String)requestModel.getSkssqz());
        QFilter taxcategoryQfilter = new QFilter("taxcategory", "=", (Object)taxcategoryId);
        QFilter taxareagroupQfilter = new QFilter("taxareagroup", "=", (Object)taxareagroupId);
        String draftpurpose = (String)extendParams.get("draftpurpose");
        QFilter accessConfigTypeQfilter = new QFilter("rulepurpose", "like", (Object)("%" + draftpurpose + "%"));
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).and(taxcategoryQfilter).and(taxareagroupQfilter).and("accessproject", "in", idList).and(accessConfigTypeQfilter);
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).and(taxcategoryQfilter).and(taxareagroupQfilter).and(new QFilter("ruleentity.rule.accessproject", "in", idList)).and(new QFilter("ruleentity.rule.rulepurpose", "like", (Object)("%" + draftpurpose + "%")));
        RuleEngineParamDto ruleEngineParamDto = new RuleEngineParamDto(orgId, startDate, endDate, taxSystemId, taxcategoryId, taxareagroupId, templateId, draftpurpose, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)startDate, (Object)"taxcategory", (Object)taxcategoryId));
        Map<Long, List<DynamicObject>> allOrgMatchAccessConfigMap = new GtcpDraftDynEngineBusiness().getAllOrgMatchAccessConfigMap(ruleEngineParamDto);
        return allOrgMatchAccessConfigMap.get(requestModel.getOrgId());
    }

    public void dealwithEntrytity(Map<String, String> entryentityMap, Map<String, String> entryentity1Map, Map<String, String> rateMap, List<DynamicObject> dynamicObjects) {
        if (!ObjectUtils.isEmpty(dynamicObjects)) {
            for (int i = 0; i < dynamicObjects.size(); ++i) {
                DynamicObjectCollection entryentity1;
                DynamicObjectCollection entryentity;
                String id = dynamicObjects.get(i).getString("accessproject.id");
                if (ObjectUtils.isEmpty((Object)id)) continue;
                String taxrate = dynamicObjects.get(i).getString("taxrate.taxrate");
                if (!ObjectUtils.isEmpty((Object)taxrate)) {
                    rateMap.put(id, "true");
                }
                if (!ObjectUtils.isEmpty((Object)(entryentity = dynamicObjects.get(i).getDynamicObjectCollection("entryentity")))) {
                    entryentityMap.put(id, "true");
                }
                if (ObjectUtils.isEmpty((Object)(entryentity1 = dynamicObjects.get(i).getDynamicObjectCollection("entryentity1")))) continue;
                entryentity1Map.put(id, "true");
            }
        }
    }
}

