/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.declare;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IPageCache;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.formplugin.basedeclare.AbstractGtcpDeclareReportMultiPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class NormalDeclareMultiPlugin
extends AbstractGtcpDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationSys = (BasedataEdit)this.getControl("taxationsys");
        taxationSys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxCategory = (BasedataEdit)this.getControl("taxcategory");
        taxCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxAreaGroup = (BasedataEdit)this.getControl("taxareagroup");
        taxAreaGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    protected String[] getTaxLimits() {
        DynamicObject org = this.getModel().getDataEntity(true).getDynamicObject("org");
        DynamicObject taxationsys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxCategory = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity(true).getDynamicObject("taxareagroup");
        Long orgId = org == null ? null : Long.valueOf(org.getLong("id"));
        Long taxationsysId = taxationsys == null ? null : Long.valueOf(taxationsys.getLong("id"));
        Long taxtypeId = taxCategory == null ? null : Long.valueOf(taxCategory.getLong("id"));
        Long taxAreaGroupId = taxAreaGroup == null ? null : Long.valueOf(taxAreaGroup.getLong("id"));
        List<String> data = GtcpTaxOrgCommonBusiness.queryHwsTaxlimit(orgId, taxationsysId, taxtypeId, (Long)(taxationsysId != null && taxtypeId != null && taxationsysId == 1636078644810086400L && taxtypeId == 1641488655174373376L ? null : taxAreaGroupId));
        ArrayList<String> taxLimits = new ArrayList<String>(8);
        if (CollectionUtils.isNotEmpty(data)) {
            if (data.contains("month")) {
                taxLimits.add("month");
            }
            if (data.contains("season")) {
                taxLimits.add("season");
            }
            if (data.contains("halfyear")) {
                taxLimits.add("halfyear");
            }
            if (data.contains("year")) {
                taxLimits.add("year");
            }
        }
        return taxLimits.toArray(new String[0]);
    }

    @Override
    protected String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    @Override
    protected boolean isDefaultOrg() {
        return Boolean.FALSE;
    }

    @Override
    protected Long getCustomOrg(Map<String, Object> customParams) {
        if (customParams.get("org.id") != null) {
            return Long.parseLong(customParams.get("org.id").toString());
        }
        List<Long> suitableOrgIds = GtcpTaxOrgCommonBusiness.queryValidTaxOrg();
        if (CollectionUtils.isEmpty(suitableOrgIds)) {
            return null;
        }
        long orgId = RequestContext.get().getOrgId();
        if (suitableOrgIds.contains(orgId)) {
            return orgId;
        }
        return suitableOrgIds.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initPeriod(IDataModel model, IPageCache pageCache, String orgIdStr, Map<String, Object> customParams) {
        try {
            String papersStatus = "A";
            Long orgId = Long.parseLong(orgIdStr);
            this.getModel().setValue("org", (Object)orgId);
            Long taxationSysId = null;
            Long taxTypeId = null;
            Long taxAreaId = null;
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"taxareagroup"});
            List<Long> taxationSysByBasTaxOrg = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false);
            if (CollectionUtils.isNotEmpty(taxationSysByBasTaxOrg)) {
                List<Long> taxAreaGroupIdList;
                taxationSysId = taxationSysByBasTaxOrg.get(0);
                List<Long> taxTypeIdList = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationSysId);
                if (CollectionUtils.isNotEmpty(taxTypeIdList)) {
                    taxTypeId = taxTypeIdList.get(0);
                }
                if (CollectionUtils.isNotEmpty(taxAreaGroupIdList = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationSysId, taxTypeId))) {
                    taxAreaId = taxAreaGroupIdList.get(0);
                    if (taxationSysId != null && taxTypeId != null && taxationSysId == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupIdList.contains(1616686278185582592L)) {
                        taxAreaId = 1616686278185582592L;
                        this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
                    }
                }
            }
            model.setValue("taxationsys", taxationSysId);
            model.setValue("taxcategory", taxTypeId);
            model.setValue("taxareagroup", taxAreaId);
            Date taxYearStartDate = this.getTaxYearStartDate(orgId, taxationSysId, taxTypeId);
            String provisionPeriod = GtcpTaxOrgCommonBusiness.queryDefaultTaxPeriod(orgId, taxationSysId, taxTypeId);
            if (taxYearStartDate != null && StringUtils.isNotEmpty((CharSequence)provisionPeriod)) {
                Date startDate = null;
                Date endDate = null;
                if (Boolean.TRUE.equals(customParams.get("readonly"))) {
                    startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
                    endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
                    papersStatus = (String)customParams.get("papers_status");
                    model.setValue("skssqq", (Object)startDate);
                    pageCache.put("skssqq", DateUtils.format((Date)startDate));
                    model.setValue("skssqz", (Object)endDate);
                    pageCache.put("skssqz", DateUtils.format((Date)endDate));
                } else {
                    ImmutablePair<Date, Date> dateImmutablePair = this.preTaxPeriod(provisionPeriod, taxYearStartDate);
                    if (dateImmutablePair != null) {
                        startDate = (Date)dateImmutablePair.left;
                        endDate = (Date)dateImmutablePair.right;
                    }
                }
                model.setValue("papers_status", (Object)papersStatus);
                pageCache.put("papers_status", papersStatus);
                this.setBillNumber(DateUtils.format((Date)startDate), DateUtils.format((Date)endDate));
            }
        }
        finally {
            pageCache.put("dateChanged", "false");
            this.getModel().setDataChanged(false);
        }
    }

    @Override
    protected boolean checkArgsBeforeOpenInnerPage() {
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        return this.isValidDates(startDate, endDate, true);
    }

    @Override
    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"org")) {
            List<Long> longs = GtcpTaxOrgCommonBusiness.queryValidTaxOrg();
            QFilter qFilter = CollectionUtils.isEmpty(longs) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", longs);
            evt.addCustomQFilter(qFilter);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxationsys") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxcategory") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxareagroup")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"NormalDeclareMultiPlugin_9", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long orgId = org.getLong("id");
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxationsys")) {
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false);
                QFilter qFilter = CollectionUtils.isEmpty(longs) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", longs);
                evt.addCustomQFilter(qFilter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxcategory")) {
                QFilter qFilter;
                DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
                if (taxationsys == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"NormalDeclareMultiPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationsys.getLong("id"));
                if (CollectionUtils.isEmpty(longs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"NormalDeclareMultiPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]));
                    qFilter = new QFilter("id", "=", (Object)0L);
                } else {
                    qFilter = new QFilter("id", "in", longs);
                }
                evt.addCustomQFilter(qFilter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxareagroup")) {
                QFilter qFilter;
                long taxCategoryId;
                DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
                DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
                if (taxationsys == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"NormalDeclareMultiPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long l = taxCategoryId = taxCategory == null ? 0L : taxCategory.getLong("id");
                if (taxCategoryId == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"NormalDeclareMultiPlugin_11", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationsys.getLong("id"), taxCategoryId);
                if (CollectionUtils.isEmpty(longs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"NormalDeclareMultiPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]));
                    qFilter = new QFilter("id", "=", (Object)0L);
                } else {
                    qFilter = new QFilter("id", "in", longs);
                }
                evt.addCustomQFilter(qFilter);
            }
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        List<Long> taxCategories;
        List<Long> sysByBasTaxOrg;
        List<Long> suitableOrgIds;
        DynamicObject taxareagroup;
        String appId = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appId == null || changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        Object newValue = changeData[0].getNewValue();
        if (newValue == null && null != changeData[0].getOldValue()) {
            this.getModel().setValue(name, changeData[0].getOldValue());
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)"remarks", (CharSequence)name)) {
            return;
        }
        boolean loadData = false;
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        DynamicObject taxationSys = (DynamicObject)this.getModel().getValue("taxationsys");
        DynamicObject taxType = (DynamicObject)this.getModel().getValue("taxcategory");
        DynamicObject taxAreaGroup = (DynamicObject)this.getModel().getValue("taxareagroup");
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Date endDate = (Date)this.getModel().getValue("skssqz");
        long orgId = org == null ? 0L : org.getLong("id");
        long taxationSysId = taxationSys == null ? 0L : taxationSys.getLong("id");
        long taxTypeId = taxType == null ? 0L : taxType.getLong("id");
        long taxAreaGroupId = taxAreaGroup == null ? 0L : taxAreaGroup.getLong("id");
        List<Long> sysTaxAreaIds = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationSysId, taxTypeId);
        if ("org".equalsIgnoreCase(name)) {
            this.getPageCache().put("orgid", String.valueOf(orgId));
            this.getModel().getDataEntity().set("taxationsys", null);
            this.getModel().getDataEntity().set("taxcategory", null);
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("taxationsys");
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxareagroup");
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            taxationSysId = 0L;
            taxTypeId = 0L;
            taxAreaGroupId = 0L;
            startDate = null;
            endDate = null;
        } else if ("taxationsys".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxationsys", String.valueOf(taxationSysId));
            this.getModel().getDataEntity().set("taxcategory", null);
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxareagroup");
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            taxTypeId = 0L;
            taxAreaGroupId = 0L;
            startDate = null;
            endDate = null;
            if (TaxationsysMappingEnum.USA.getId() != taxationSysId) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"usacitsolve"});
            }
        } else if ("taxcategory".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxcategory", Long.toString(taxTypeId));
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("taxareagroup");
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            taxAreaGroupId = 0L;
            startDate = null;
            endDate = null;
        } else if ("taxareagroup".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxareagroup", Long.toString(taxAreaGroupId));
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            startDate = null;
            endDate = null;
        } else if ("skssqq".equalsIgnoreCase(name) || "skssqz".equalsIgnoreCase(name)) {
            this.getModel().getDataEntity().set("remarks", null);
            this.getView().updateView("remarks");
        }
        this.setBillNumber(DateUtils.format((Date)startDate), DateUtils.format((Date)endDate));
        if (orgId != 0L && taxationSysId != 0L && taxTypeId != 0L && taxAreaGroupId != 0L && startDate != null && endDate != null) {
            loadData = true;
        }
        this.getView().setEnable(Boolean.valueOf(true), new String[]{"taxareagroup"});
        if (taxationSysId == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupId != 1616686278185582592L) {
            loadData = true;
            this.getPageCache().put("taxareagroup", Long.toString(1616686278185582592L));
            taxareagroup = BusinessDataServiceHelper.loadSingle((Object)1616686278185582592L, (String)"bastax_taxareagroup");
            this.getModel().getDataEntity().set("taxareagroup", (Object)taxareagroup);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
            this.getView().updateView("taxareagroup");
            sysTaxAreaIds.add(1616686278185582592L);
        }
        if (taxationSysId == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupId == 1616686278185582592L) {
            loadData = true;
            this.getPageCache().put("taxareagroup", Long.toString(1616686278185582592L));
            taxareagroup = BusinessDataServiceHelper.loadSingle((Object)1616686278185582592L, (String)"bastax_taxareagroup");
            this.getModel().getDataEntity().set("taxareagroup", (Object)taxareagroup);
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
            this.getView().updateView("taxareagroup");
            sysTaxAreaIds.add(1616686278185582592L);
        }
        if (orgId != 0L && !(suitableOrgIds = GtcpTaxOrgCommonBusiness.queryValidTaxOrg()).contains(orgId)) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u4e0d\u53ef\u7528\u6216\u65e0\u6743\u9650\u3002", (String)"NormalDeclareMultiPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]), org.getString("number"));
            this.getView().showErrorNotification(msg);
            return;
        }
        if (taxationSysId != 0L && !(sysByBasTaxOrg = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false)).contains(taxationSysId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u3002", (String)"NormalDeclareMultiPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        if (taxTypeId != 0L && !(taxCategories = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationSysId)).contains(taxTypeId)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u79cd\u3002", (String)"NormalDeclareMultiPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        if (taxAreaGroupId != 0L && (CollectionUtils.isEmpty(sysTaxAreaIds) || !sysTaxAreaIds.contains(taxAreaGroupId))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u5bf9\u5e94\u7684\u7a0e\u6536\u5236\u5ea6\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u7a0e\u6536\u8f96\u533a\u3002", (String)"NormalDeclareMultiPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        Boolean checkTemplate = this.checkTemplate(false);
        if (!checkTemplate.booleanValue()) {
            return;
        }
        if (loadData) {
            Boolean isNeedRefresh;
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((String)"tpo_declare_main_tsd", (String)"id", (QFilter[])new QFilter[]{this.setDefaultQfilter()});
            Boolean bl = isNeedRefresh = dynamicObject == null ? Boolean.TRUE : Boolean.FALSE;
            if (startDate == null || endDate == null) {
                return;
            }
            this.loadData(startDate, endDate, true, isNeedRefresh);
        }
    }

    @Override
    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        String number = customParams.get("billno") == null ? null : customParams.get("billno").toString();
        Long taxTypeId = customParams.get("taxcategory") == null ? null : Long.valueOf(Long.parseLong(customParams.get("taxcategory").toString()));
        Long taxationSys = customParams.get("taxationsys") == null ? null : Long.valueOf(Long.parseLong(customParams.get("taxationsys").toString()));
        Long taxAreaGroupId = customParams.get("taxareagroup") == null ? null : Long.valueOf(Long.parseLong(customParams.get("taxareagroup").toString()));
        String billStatus = customParams.get("papers_status") == null ? null : customParams.get("papers_status").toString();
        this.getModel().setValue("number", (Object)number);
        this.getModel().setValue("taxationsys", (Object)taxationSys);
        this.getModel().setValue("taxcategory", (Object)taxTypeId);
        this.getModel().setValue("taxareagroup", (Object)taxAreaGroupId);
        this.getModel().setValue("papers_status", (Object)billStatus);
        this.getModel().setValue("remarks", (Object)(EmptyCheckUtils.isEmpty((Object)customParams.get("remarks")) ? "" : customParams.get("remarks").toString()));
        if (taxationSys != null && taxTypeId != null && taxAreaGroupId != null && taxationSys == 1636078644810086400L && taxTypeId == 1641488655174373376L && taxAreaGroupId == 1616686278185582592L) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"taxareagroup"});
        }
        return customParams;
    }

    @Override
    public void clientCallBackMethod(Map<String, String> dataMap, String sheetid) {
    }

    @Override
    protected RuleEngineParamDto getRuleEngineParamDto(DeclareRequestModel requestModel) {
        RuleEngineParamDto dto = super.getRuleEngineParamDto(requestModel);
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        DynamicObject taxSys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        Long taxSysId = taxSys == null ? null : Long.valueOf(taxSys.getLong("id"));
        Long taxTypeId = taxType == null ? null : Long.valueOf(taxType.getLong("id"));
        GtcpFetchDataBussiness.dealWithSbRuleEngineParamDto(requestModel, dto, this.getModel().getDataEntity().getString("taxcategory.number"), orgId, taxSysId, taxTypeId, this.getDraftpurpose(), false);
        return dto;
    }

    private void setBillNumber(String skssqq, String sksqz) {
        String number;
        long orgId;
        long l = orgId = this.getModel().getValue("org") == null ? 0L : ((DynamicObject)this.getModel().getValue("org")).getLong("id");
        if (orgId == 0L || StringUtils.isEmpty((CharSequence)skssqq) || StringUtils.isEmpty((CharSequence)sksqz)) {
            return;
        }
        DynamicObject dynamicObject = YbnsrService.queryMultiDeclareMain((String)"tpo_declare_main_tsd", (long)orgId, (String)this.getTemplateType(), (String)skssqq, (String)sksqz, (QFilter)this.getDeclareMainQueryParams());
        if (dynamicObject != null) {
            number = dynamicObject.getString("billno");
        } else {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject taxcategory = (DynamicObject)this.getModel().getValue("taxcategory");
            DynamicObject taxareagroup = (DynamicObject)this.getModel().getValue("taxareagroup");
            Date startDate = DateUtils.stringToDate((String)skssqq, (String)"yyyy-MM-dd");
            Date endDate = DateUtils.stringToDate((String)sksqz, (String)"yyyy-MM-dd");
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            DynamicObject newDyo = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_normal_draft_list");
            newDyo.set("org", (Object)org);
            newDyo.set("taxtype", (Object)taxcategory);
            newDyo.set("taxareagroup", (Object)taxareagroup);
            newDyo.set("skssqq", (Object)startDate);
            newDyo.set("skssqz", (Object)endDate);
            number = codeRuleService.readNumber("gtcp_normal_draft_list", newDyo, null);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"gtcp_normal_draft_list", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
            if (obj != null) {
                codeRuleService.getNumber("gtcp_normal_draft_list", newDyo, null);
                number = codeRuleService.readNumber("gtcp_normal_draft_list", newDyo, null);
            }
        }
        this.getModel().getDataEntity().set("number", (Object)number);
        this.getView().updateView("number");
        this.getPageCache().put("billno", number);
        this.getPageCache().put("number", number);
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        List<String> list;
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        DynamicObject taxSys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity(true).getDynamicObject("taxareagroup");
        Long taxSysId = taxSys == null ? null : Long.valueOf(taxSys.getLong("id"));
        Long taxTypeId = taxType == null ? null : Long.valueOf(taxType.getLong("id"));
        Long taxAreaGroupId = taxAreaGroup == null ? null : Long.valueOf(taxAreaGroup.getLong("id"));
        List<Long> suitableOrgIds = GtcpTaxOrgCommonBusiness.queryValidTaxOrg();
        if (!suitableOrgIds.contains(orgId) && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ec4\u7ec7\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"NormalDeclareMultiPlugin_12", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if (taxSysId == null && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ec4\u7ec7\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"NormalDeclareMultiPlugin_12", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if ((taxTypeId == null || taxAreaGroupId == null) && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"NormalDeclareMultiPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        Date newStartDate = this.getTaxYearStartDate(orgId, taxSysId, taxTypeId);
        if (newStartDate == null && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u3002", (String)"NormalDeclareMultiPlugin_14", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        String provisionPeriod = GtcpTaxOrgCommonBusiness.queryDefaultTaxPeriod(orgId, taxSysId, taxTypeId);
        if (StringUtils.isEmpty((CharSequence)provisionPeriod) && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7f34\u7eb3\u671f\u9650\u3002", (String)"NormalDeclareMultiPlugin_15", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if (!this.checkTemplate(true).booleanValue()) {
            return false;
        }
        ImmutablePair<Date, Date> dateImmutablePair = this.calDate(newStartDate, startDate, endDate);
        if (dateImmutablePair == null) {
            if (needMsg.booleanValue()) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u4e0e\u9002\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u53ca\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NormalDeclareMultiPlugin_16", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            return false;
        }
        Boolean validDates = super.isValidDates((Date)dateImmutablePair.left, (Date)dateImmutablePair.right, Boolean.valueOf(false));
        if (!validDates.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u4e0e\u9002\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u53ca\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NormalDeclareMultiPlugin_16", (String)"taxc-gtcp", (Object[])new Object[0]));
        }
        if (validDates.booleanValue() && ObjectUtils.isNotEmpty(list = GtcpDraftBussiness.getDateIntersectionDraftNumber(orgId, this.getTemplateType(), DateUtils.format((Date)startDate), DateUtils.format((Date)endDate), this.getDeclareMainQueryParams()))) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0e\u540c\u4e00\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7a0e\u6536\u5236\u5ea6\u3001\u7a0e\u79cd\u3001\u7a0e\u6536\u8f96\u533a\u5e95\u7a3f\uff1a%1$s\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"NormalDeclareMultiPlugin_17", (String)"taxc-gtcp", (Object[])new Object[0]), StringUtil.join(list, (String)",")));
            return false;
        }
        return validDates;
    }

    public void save() {
        Date endDate;
        List hasPermOrgs;
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"gtcp", (String)"gtcp_normal_declare", (String)"4715a0df000000ac", (Long)RequestContext.get().getCurrUserId());
        if (!allPermOrgsByUserId.hasAllOrgPerm() && !(hasPermOrgs = allPermOrgsByUserId.getHasPermOrgs()).contains(orgId)) {
            return;
        }
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Boolean validDates = this.isValidDates(startDate, endDate = (Date)this.getModel().getValue("skssqz"), true);
        if (validDates.booleanValue()) {
            super.save();
        }
    }

    @Override
    public String getUniKey() {
        String orgId = this.getPageCache().get("orgid");
        String taxSystem = this.getModel().getDataEntity().get("taxationsys") == null ? "0" : this.getModel().getDataEntity().getString("taxationsys.id");
        String taxCategory = this.getModel().getDataEntity().get("taxcategory") == null ? "0" : this.getModel().getDataEntity().getString("taxCategory.id");
        String taxAreaGroup = this.getModel().getDataEntity().get("taxareagroup") == null ? "0" : this.getModel().getDataEntity().getString("taxareagroup.id");
        String draftpurpose = this.getModel().getDataEntity().get("draftpurpose") == null ? "" : this.getModel().getDataEntity().getString("draftpurpose");
        String skssq = DateUtils.format((Date)((Date)this.getModel().getValue("skssqq")));
        String skssz = DateUtils.format((Date)((Date)this.getModel().getValue("skssqz")));
        return String.format("%s_%s_%s_%s_%s_%s_%s_%s", orgId, taxSystem, taxCategory, taxAreaGroup, skssq, skssz, draftpurpose, this.getTemplateType());
    }

    @Override
    protected boolean viewDialog() {
        return Boolean.FALSE;
    }

    private ImmutablePair<Date, Date> preTaxPeriod(String provisionPeriod, Date taxYearStartDate) {
        int adj;
        Date startDate;
        Date now = new Date();
        int monthInt = DateUtils.getMonthOfDate((Date)taxYearStartDate) - 1;
        int dateInt = DateUtils.getDayOfDate((Date)taxYearStartDate) - 1;
        if ("season".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            adj = 3;
        } else if ("year".equals(provisionPeriod)) {
            startDate = DateUtils.getFirstDateOfYear((Date)now);
            adj = 12;
        } else if ("month".equals(provisionPeriod)) {
            Date xtqDate = DateUtils.addMonth((Date)now, (int)-1);
            startDate = DateUtils.getFirstDateOfMonth((Date)xtqDate);
            adj = 1;
        } else if ("halfyear".equals(provisionPeriod)) {
            Date date = DateUtils.addMonth((Date)now, (int)-6);
            startDate = DateUtils.getFirstDateOfHalfYear((Date)date);
            adj = 6;
        } else {
            return null;
        }
        startDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)monthInt), (int)dateInt);
        Date endDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)adj), (int)-1);
        return this.getLast(startDate, endDate, adj);
    }

    private ImmutablePair<Date, Date> getLast(Date startDate, Date endDate, int month) {
        if (endDate.compareTo(DateUtils.getDayFirst((Date)new Date())) < 0) {
            return ImmutablePair.of((Object)startDate, (Object)endDate);
        }
        startDate = DateUtils.addMonth((Date)startDate, (int)(-month));
        endDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)startDate, (int)month), (int)-1);
        return this.getLast(startDate, endDate, month);
    }

    private ImmutablePair<Date, Date> calDate(Date taxYearStartDate, Date modelStartDate, Date modelEndDate) {
        if (taxYearStartDate == null || modelStartDate == null || modelEndDate == null) {
            return null;
        }
        int monthInt = 1 - DateUtils.getMonthOfDate((Date)taxYearStartDate);
        int dataInt = 1 - DateUtils.getDayOfDate((Date)taxYearStartDate);
        Date offSetStartDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)modelStartDate, (int)monthInt), (int)dataInt);
        Integer monthBetweenInOneYear = NormalDeclareMultiPlugin.getMonthBetweenInOneYear(modelStartDate, modelEndDate);
        if (monthBetweenInOneYear != null) {
            Date offSetEndDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)offSetStartDate, (int)monthBetweenInOneYear), (int)-1);
            return ImmutablePair.of((Object)offSetStartDate, (Object)offSetEndDate);
        }
        return null;
    }

    public static Integer getMonthBetweenInOneYear(Date minDate, Date maxDate) {
        int result;
        if (minDate == null || maxDate == null || maxDate.compareTo(minDate) <= 0) {
            return null;
        }
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        max.setTime(maxDate);
        for (result = 0; min.before(max) && result < 12; ++result) {
            min.add(2, 1);
        }
        min.add(5, -1);
        if (result <= 12 && min.equals(max)) {
            return result;
        }
        return null;
    }

    public Map<String, String> getUpdateNsrxxMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("remarks", EmptyCheckUtils.isNotEmpty((Object)this.getModel().getValue("remarks")) ? (String)this.getModel().getValue("remarks") : "");
        return params;
    }
}

