/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.declare;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.Donothing;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import kd.taxc.gtcp.formplugin.basedeclare.AbstractGtcpNormalDeclareReportMultiListPlugin;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class NormalDeclareReportMultiListPlugin
extends AbstractGtcpNormalDeclareReportMultiListPlugin {
    private static final String ORG_ID = "org.id";
    private static final String CONFIRM_DECLARE = "confirmdeclare";
    private static final String CANCEL_DECLARE = "canceldeclare";
    private static final String DIALOG_APPLY_CONFIM = "gtcp_declare_apply_confim";
    private static final String DIALOG_PAYREFUND_CONFIM = "gtcp_declare_payre_confim";

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection selectedRows = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)CONFIRM_DECLARE, (CharSequence)((Donothing)args.getSource()).getOperateKey())) {
            if (ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u786e\u8ba4\u7533\u62a5\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"NormalDeclareReportMultiListPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
                return;
            }
        } else if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"confirmpayrefund", (CharSequence)((Donothing)args.getSource()).getOperateKey())) {
            if (ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
                args.setCancel(true);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u786e\u8ba4\u7f34/\u9000\u7a0e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"NormalDeclareReportMultiListPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                return;
            }
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)list.get(0).getPrimaryKeyValue(), (String)"gtcp_normal_draft_list");
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"gtcp", (String)"gtcp_taxpay_refund_bill", (String)"3OWI6VN1OS34");
            if (!hasPermOrgResult.hasAllOrgPerm() && (ObjectUtils.isEmpty((Object)hasPermOrgResult.getHasPermOrgs()) || ObjectUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs()) && !hasPermOrgResult.getHasPermOrgs().contains(dynamicObject.getLong(ORG_ID)))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s,\u5f53\u524d\u7528\u6237\u65e0'\u786e\u8ba4\u7f34/\u9000\u7a0e'\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NormalDeclareReportMultiListPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]), dynamicObject.getString("billno")));
                args.setCancel(true);
                return;
            }
        } else if (args.getSource() instanceof Donothing && StringUtil.equalsIgnoreCase((CharSequence)"viewpayrefund", (CharSequence)((Donothing)args.getSource()).getOperateKey())) {
            if (ObjectUtils.isNotEmpty((Object)selectedRows) && selectedRows.size() > 1) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u67e5\u770b\u7f34/\u9000\u5355\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"NormalDeclareReportMultiListPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
                return;
            }
            HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"gtcp", (String)"gtcp_taxpay_refund_bill", (String)"47150e89000000ac");
            BillList billlist = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection list = billlist.getSelectedRows();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)list.get(0).getPrimaryKeyValue(), (String)"gtcp_normal_draft_list");
            if (!hasPermOrgResult.hasAllOrgPerm() && (ObjectUtils.isEmpty((Object)hasPermOrgResult.getHasPermOrgs()) || ObjectUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs()) && !hasPermOrgResult.getHasPermOrgs().contains(dynamicObject.getLong(ORG_ID)))) {
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s,\u5f53\u524d\u7528\u6237\u65e0'\u67e5\u770b\u7f34/\u9000\u5355'\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"NormalDeclareReportMultiListPlugin_9", (String)"taxc-gtcp", (Object[])new Object[0]), dynamicObject.getString("billno")));
                args.setCancel(true);
                return;
            }
        }
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        ListSelectedRowCollection list;
        boolean isCheck;
        super.afterDoOperation(evt);
        BillList billlist = (BillList)this.getControl("billlistap");
        String operateKey = evt.getOperateKey();
        OperationResult operationResult = evt.getOperationResult();
        if (operationResult == null) {
            return;
        }
        if (!operationResult.isSuccess() && (CANCEL_DECLARE.equals(operateKey) || "unpayrefund".equals(operateKey)) && !(isCheck = this.setCustomCheckInfo(evt))) {
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)CONFIRM_DECLARE)) {
            if (!operationResult.isSuccess()) {
                this.setCustomCheckInfo(evt);
            } else {
                ListSelectedRowCollection list2 = billlist.getSelectedRows();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)list2.get(0).getPrimaryKeyValue(), (String)"gtcp_normal_draft_list", (String)"skssqz");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(DIALOG_APPLY_CONFIM);
                showParameter.setShowTitle(true);
                showParameter.getCustomParams().put("skssqz", dynamicObject.getDate("skssqz"));
                showParameter.getCustomParams().put("id", dynamicObject.getString("id"));
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DIALOG_APPLY_CONFIM);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"confirmpayrefund")) {
            if (!operationResult.isSuccess()) {
                this.setCustomCheckInfo(evt);
            } else {
                ListSelectedRowCollection list3 = billlist.getSelectedRows();
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)list3.get(0).getPrimaryKeyValue(), (String)"gtcp_normal_draft_list");
                FormShowParameter showParameter = new FormShowParameter();
                showParameter.setFormId(DIALOG_PAYREFUND_CONFIM);
                showParameter.setShowTitle(true);
                Date declareDate = null;
                for (DynamicObject object : dynamicObject.getDynamicObjectCollection("entryentity")) {
                    declareDate = object.getDate("declaredate");
                }
                HashMap<String, Object> parameterMap = new HashMap<String, Object>(8);
                parameterMap.put("declaredate", declareDate);
                parameterMap.put("id", dynamicObject.getString("id"));
                parameterMap.put("templatetype", dynamicObject.getString("templatetype.id"));
                parameterMap.put("taxsystem", dynamicObject.getLong("taxsystem.id"));
                parameterMap.put("taxsystem.number", dynamicObject.getString("taxsystem.number"));
                parameterMap.put("taxtype", dynamicObject.getLong("taxtype.id"));
                parameterMap.put("taxtype.number", dynamicObject.getString("taxtype.number"));
                parameterMap.put("taxareagroup", dynamicObject.getLong("taxareagroup.id"));
                showParameter.getCustomParams().putAll(parameterMap);
                showParameter.getOpenStyle().setShowType(ShowType.Modal);
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, DIALOG_PAYREFUND_CONFIM);
                showParameter.setCloseCallBack(closeCallBack);
                this.getView().showForm(showParameter);
            }
        } else if (CANCEL_DECLARE.equals(operateKey) || "unpayrefund".equals(operateKey)) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"NormalDeclareReportMultiListPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
            billlist.refresh();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)"viewpayrefund") && null != (list = billlist.getSelectedRows()) && ObjectUtils.isNotEmpty((Object)list)) {
            Long draftId = (Long)list.get(0).getPrimaryKeyValue();
            DynamicObject[] taxPayRefunds = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIdList(Collections.singletonList(draftId));
            if (ObjectUtils.isNotEmpty((Object)taxPayRefunds)) {
                this.openProvistonBillPage(draftId);
                return;
            }
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u67e5\u5230\u4e0b\u6e38\u7f34/\u9000\u5355\u3002", (String)"NormalDeclareReportMultiListPlugin_8", (String)"taxc-gtcp", (Object[])new Object[0]));
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        BillList billlist = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection list = billlist.getSelectedRows();
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtil.equalsIgnoreCase((CharSequence)actionId, (CharSequence)DIALOG_APPLY_CONFIM) && StringUtil.equalsIgnoreCase((CharSequence)((String)closedCallBackEvent.getReturnData()), (CharSequence)"success")) {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)list.get(0).getPrimaryKeyValue(), (String)"gtcp_normal_draft_list");
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"NormalDeclareReportMultiListPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
            OperatorDialogUtils.operateDialog((String)dynamicObject.getString("templatetype.id"), (String)dynamicObject.getDynamicObjectType().getName(), (String)ResManager.loadKDString((String)"\u786e\u8ba4\u7533\u62a5", (String)"NormalDeclareReportMultiListPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s,\u64cd\u4f5c\u6210\u529f", (String)"NormalDeclareReportMultiListPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]), dynamicObject.getString("billno")));
            billlist.refresh();
        } else if (StringUtil.equalsIgnoreCase((CharSequence)actionId, (CharSequence)DIALOG_PAYREFUND_CONFIM)) {
            if (StringUtil.equalsIgnoreCase((CharSequence)((String)closedCallBackEvent.getReturnData()), (CharSequence)"success")) {
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)list.get(0).getPrimaryKeyValue(), (String)"gtcp_normal_draft_list");
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u64cd\u4f5c\u6210\u529f\u3002", (String)"NormalDeclareReportMultiListPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                OperatorDialogUtils.operateDialog((String)dynamicObject.getString("templatetype.id"), (String)dynamicObject.getDynamicObjectType().getName(), (String)ResManager.loadKDString((String)"\u786e\u8ba4\u7f34/\u9000\u7a0e", (String)"NormalDeclareReportMultiListPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s,\u64cd\u4f5c\u6210\u529f", (String)"NormalDeclareReportMultiListPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]), dynamicObject.getString("billno")));
                billlist.refresh();
            } else if (ObjectUtils.isNotEmpty((Object)closedCallBackEvent.getReturnData())) {
                this.getView().showErrorNotification((String)closedCallBackEvent.getReturnData());
            }
        }
    }

    @Override
    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if (ORG_ID.equalsIgnoreCase(args.getFieldName())) {
            List<Long> taxpayers = NormalDeclareReportMultiListPlugin.queryBastaxTaxOrg(this.getView());
            QFilter orgFilter = new QFilter("id", "in", taxpayers);
            args.getQfilters().add(orgFilter);
        }
    }

    @Override
    protected void setExtendCustomParams(Map<String, Object> customParams, DynamicObject object) {
        Long taxTypeId = object.get("taxtype") == null ? 0L : ((DynamicObject)object.get("taxtype")).getLong("id");
        Long taxareagroupId = object.get("taxareagroup") == null ? 0L : ((DynamicObject)object.get("taxareagroup")).getLong("id");
        customParams.put("papers_status", object.get("billstatus"));
        customParams.put("taxationsys", ((DynamicObject)object.get("taxsystem")).getLong("id"));
        customParams.put("taxtype", taxTypeId);
        customParams.put("taxcategory", taxTypeId);
        customParams.put("taxareagroup", taxareagroupId);
        customParams.put("remarks", object.getString("remarks"));
    }

    @Override
    public String getModelNumber() {
        return MultiTableEnum.TSD001.getModel();
    }

    @Override
    protected List<String> getTemplateTypeList() {
        return Arrays.asList("Overseas_VAT", "Overseas_CIT", "USA_CIT");
    }

    @Override
    public String getDraftPurpose() {
        return "nssb";
    }

    @Override
    protected void showDeclarePage(String type, Map<String, Object> customParams, String declarestatus, DynamicObject object) {
        List orgValues = this.getControlFilters().getFilter(ORG_ID);
        try {
            if (CollectionUtils.isNotEmpty((Collection)orgValues) && orgValues.size() == 1) {
                customParams.put(ORG_ID, Long.parseLong(orgValues.get(0).toString()));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        super.showDeclarePage(type, customParams, declarestatus, object);
    }

    @Override
    public ImmutablePair<String, String> getListNameOfBillnoAndTime() {
        String billnoStr = ResManager.loadKDString((String)"\u5e95\u7a3f\u7f16\u53f7", (String)"NormalDeclareReportMultiListPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]);
        String skssqqStr = ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62", (String)"NormalDeclareReportMultiListPlugin_11", (String)"taxc-gtcp", (Object[])new Object[0]);
        return ImmutablePair.of((Object)billnoStr, (Object)skssqqStr);
    }

    private void openProvistonBillPage(Long draftId) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("gtcp_taxpay_refund_bill");
        listShowParameter.setFormId("bos_list");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("isFromDraft", "true");
        hashMap.put("draftid", draftId);
        listShowParameter.setCustomParams((Map)hashMap);
        this.getView().showForm((FormShowParameter)listShowParameter);
    }
}

