/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxccode.TaxcCodeDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.ttc.TtcCalculateServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractCodeGetValueBasePlugin;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.AbstractGtcpDynamicRateStrategy;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.GtcpDynamicRateStrategyFactory;
import org.apache.commons.lang3.ObjectUtils;

public abstract class AbstractAdditionalDynamicRateRowFetchPlugin
extends AbstractCodeGetValueBasePlugin {
    private static final Log logger = LogFactory.getLog(AbstractAdditionalDynamicRateRowFetchPlugin.class);
    private static final String BDTAXR_TAX_DETAILS = "bdtaxr_tax_details";
    private static final String param_TaxRax_sumAmount = "_sumAmount";
    private Context context;

    public AbstractAdditionalDynamicRateRowFetchPlugin() {
        this.context = ((AbstractCodeGetValueBasePlugin)this).context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryByFormulaVo(Map<String, Object> param, FormulaVo formulaVo) {
        long timeMillis = System.currentTimeMillis();
        String reportkey = formulaVo.getFormulaKey();
        DLock lock = null;
        String combineName = "0.0%";
        try {
            long orgid = 0L;
            long country = 0L;
            long taxationsys = 0L;
            long taxtype = 0L;
            long taxareagroup = 0L;
            long draftid = 0L;
            long templateid = 0L;
            String draftpurpose = "";
            String ttctag = "";
            long tabtaxareagroup = 0L;
            long taxtypeTab = 0L;
            BigDecimal tabynssde = BigDecimal.ZERO;
            Date skssqq = new Date();
            Date skssqz = new Date();
            Map taxProduct = new HashMap(16);
            Map<Long, Long> addressType = new HashMap(16);
            Map taxAptitude = new HashMap(16);
            Map process = new HashMap(16);
            if (param != null && param.size() > 0) {
                orgid = Long.parseLong((String)param.get("orgid"));
                taxationsys = Long.parseLong((String)param.get("taxationsys"));
                taxtype = Long.parseLong((String)param.get("taxtype"));
                taxProduct = (Map)param.get("taxProduct");
                addressType = (Map)param.get("addressType");
                taxAptitude = (Map)param.get("taxAptitude");
                process = (Map)param.get("process");
                draftid = (Long)param.get("reportId");
                templateid = (Long)param.get("templateId");
                taxareagroup = Long.parseLong((String)param.get("taxareagroup"));
                skssqq = DateUtils.stringToDate((String)((String)param.get("skssqq")));
                skssqz = DateUtils.stringToDate((String)((String)param.get("skssqz")));
                ttctag = (String)param.get("ttctag");
                draftpurpose = (String)param.get("draftpurpose");
                tabynssde = new BigDecimal((String)param.get("codePluginParam_" + reportkey + "_0"));
                taxtypeTab = EmptyCheckUtils.isEmpty((Object)param.get("codePluginParam_" + reportkey + "_1")) ? taxtypeTab : Long.parseLong((String)param.get("codePluginParam_" + reportkey + "_1"));
            }
            logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin: taxtypeTab: " + taxtypeTab);
            Date validDate = new Date();
            ArrayList<Long> taxTypeList = new ArrayList<Long>(16);
            taxTypeList.add(taxtypeTab);
            ArrayList taxProductList = new ArrayList(16);
            if (taxProduct != null) {
                taxProductList.add(taxProduct);
            }
            ArrayList<Map<Long, Long>> addressTypeList = new ArrayList<Map<Long, Long>>(16);
            if (addressType != null) {
                addressTypeList.add(addressType);
            } else {
                addressType = new HashMap(16);
                addressType.put(0L == tabtaxareagroup ? taxareagroup : tabtaxareagroup, 1036241275604686848L);
                addressTypeList.add(addressType);
            }
            ArrayList taxAptitudeList = new ArrayList(16);
            if (taxAptitude != null) {
                taxAptitudeList.add(taxAptitude);
            }
            ArrayList processList = new ArrayList(16);
            if (process != null) {
                processList.add(process);
            }
            logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin: \u5f00\u59cb\u6761\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7b49");
            TaxResult result = TtcCalculateServiceHelper.getTaxCodeAndRateByCondition((long)orgid, (long)country, (long)taxationsys, (String)ttctag, (Date)validDate, taxTypeList, taxProductList, addressTypeList, taxAptitudeList, processList);
            String key = String.format("%s_%s_%s_%s_%s_%s_%s_%s_%s", orgid, taxationsys, taxtypeTab, reportkey, taxareagroup, templateid, draftpurpose, skssqq, skssqz);
            logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin key: " + key);
            lock = DLock.create((String)key);
            if (lock.tryLock(10000L)) {
                logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin  lock start");
                logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin: \u7ec4\u88c5\u8fc7\u6ee4\u6761\u4ef6");
                QFilter qfilter = new QFilter("orgid", "=", (Object)orgid);
                qfilter.and(new QFilter("taxationsys", "=", (Object)taxationsys));
                qfilter.and(new QFilter("taxtype", "=", (Object)taxtype));
                List<String> reportkeys = this.getReportKeyList(reportkey);
                qfilter.and(new QFilter("reportkey", "in", reportkeys));
                qfilter.and(new QFilter("taxareagroup", "=", (Object)taxareagroup));
                qfilter.and(new QFilter("templateid", "=", (Object)templateid));
                qfilter.and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
                qfilter.and(new QFilter("skssqq", "=", (Object)skssqq));
                qfilter.and(new QFilter("skssqz", "=", (Object)skssqz));
                qfilter.and(new QFilter("datastatus", "=", (Object)"0"));
                DeleteServiceHelper.delete((String)BDTAXR_TAX_DETAILS, (QFilter[])new QFilter[]{qfilter});
                logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin: \u8fd4\u56de\u7a0e\u7801\u7f16\u53f7:" + result.getData());
                if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                    this.context.getParam().put(reportkey + param_TaxRax_sumAmount, "0.00");
                    String string = "0.00%";
                    return string;
                }
                String codenumber = (String)((List)result.getData()).get(0);
                TaxResult taxResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumber((String)codenumber);
                DynamicObject resultDynamicObject = (DynamicObject)taxResult.getData();
                if (ObjectUtils.isEmpty((Object)resultDynamicObject) || ObjectUtils.isEmpty((Object)resultDynamicObject.getDynamicObjectCollection("entryentity1"))) {
                    String string = "0.00";
                    return string;
                }
                String taxcodeName = resultDynamicObject.getString("name");
                combineName = taxcodeName + "|" + codenumber;
                ArrayList<String> codeNumerList = new ArrayList<String>(16);
                codeNumerList.add(codenumber);
                logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin: combineName:" + combineName);
                TaxResult dynamicResult = TaxcCombineBusinessDataServiceHelper.loadExtentByTaxcCodeNumbers(codeNumerList);
                if (ObjectUtils.isEmpty((Object)dynamicResult) || ObjectUtils.isEmpty((Object)dynamicResult.getData())) {
                    String string = "0.00";
                    return string;
                }
                AbstractGtcpDynamicRateStrategy gtcpDynamicRateStrategyByType = GtcpDynamicRateStrategyFactory.getGtcpDynamicRateStrategyByType("rate");
                if (ObjectUtils.isEmpty((Object)gtcpDynamicRateStrategyByType)) {
                    String string = "0.00";
                    return string;
                }
                List<DynamicObject> dynamicObjectList = gtcpDynamicRateStrategyByType.delFilterTaxrateRow((List)dynamicResult.getData());
                HashMap<String, List<DynamicObject>> rateMapWithType = new HashMap<String, List<DynamicObject>>(16);
                dynamicObjectList.stream().forEach(o -> {
                    if (o.containsProperty("taxratetype")) {
                        DynamicObject taxratetypeDy = o.getDynamicObject("taxratetype");
                        String number = taxratetypeDy.getString("number");
                        String rateMapKey = "NotSLLX-03";
                        if ("SLLX-03".equalsIgnoreCase(number)) {
                            String valuetype = o.getString("valuetype");
                            rateMapKey = "SLLX-03_" + valuetype;
                        }
                        if (!rateMapWithType.containsKey(rateMapKey)) {
                            rateMapWithType.put(rateMapKey, new ArrayList());
                        }
                        ((List)rateMapWithType.get(rateMapKey)).add(o);
                    }
                });
                ArrayList<DynamicObject> dataDynamicList = new ArrayList<DynamicObject>(16);
                combineName = this.calculate(dataDynamicList, this.context, param, rateMapWithType, tabynssde, reportkey, codenumber, taxcodeName, combineName);
                SaveServiceHelper.save((DynamicObject[])dataDynamicList.toArray(new DynamicObject[0]));
                logger.info(timeMillis + "DynamicRateRowFetchPluginkey-\u7ed3\u679c,tabtaxareagroup: {} ,: {}", (Object)tabtaxareagroup, (Object)(combineName + "\r"));
            }
            String string = combineName;
            return string;
        }
        catch (Exception e) {
            logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin throw exception : " + e.getMessage());
            this.context.getParam().put(reportkey + param_TaxRax_sumAmount, "0.00");
            String string = "0.00%";
            return string;
        }
        finally {
            if (lock != null) {
                lock.unlock();
                logger.info("AdditionalTradeTaxDynamicRateRowFetchPlugin  lock end");
            }
        }
    }

    public abstract String calculate(List<DynamicObject> var1, Context var2, Map<String, Object> var3, Map<String, List<DynamicObject>> var4, BigDecimal var5, String var6, String var7, String var8, String var9);

    public List<String> getReportKeyList(String reportKey) {
        return Collections.singletonList(reportKey);
    }

    public String query(Map<String, Object> param) {
        return null;
    }
}

