/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.dto.taxCodeCaculate.TaxcodeDetailDto;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractCodeGetValueBasePlugin;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.AbstractGtcpDynamicRateStrategy;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.GtcpDynamicRateStrategyFactory;
import org.apache.commons.lang3.ObjectUtils;

public class DynamicRateRowFetchPlugin
extends AbstractCodeGetValueBasePlugin {
    private static final Log logger = LogFactory.getLog(DynamicRateRowFetchPlugin.class);
    private static final String BDTAXR_TAX_DETAILS = "bdtaxr_tax_details";
    private static final String param_TaxRax_sumAmount = "_sumAmount";
    private Context context;

    public DynamicRateRowFetchPlugin() {
        this.context = ((AbstractCodeGetValueBasePlugin)this).context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryByFormulaVo(Map<String, Object> param, FormulaVo formulaVo) {
        long timeMillis = System.currentTimeMillis();
        String reportkey = formulaVo.getFormulaKey();
        DLock lock = null;
        String combineName = "0.0%";
        String taxrateType = "rate";
        try {
            long orgid = 0L;
            long country = 0L;
            long taxationsys = 0L;
            long taxtype = 0L;
            long taxareagroup = 0L;
            long draftid = 0L;
            long templateid = 0L;
            String draftpurpose = "";
            String ttctag = "";
            long tabtaxareagroup = 0L;
            BigDecimal tabynssde = BigDecimal.ZERO;
            Date skssqq = new Date();
            Date skssqz = new Date();
            if (param != null && param.size() > 0) {
                orgid = Long.parseLong((String)param.get("orgid"));
                taxationsys = Long.parseLong((String)param.get("taxationsys"));
                taxtype = Long.parseLong((String)param.get("taxtype"));
                templateid = (Long)param.get("templateId");
                taxareagroup = Long.parseLong((String)param.get("taxareagroup"));
                skssqq = DateUtils.stringToDate((String)((String)param.get("skssqq")));
                skssqz = DateUtils.stringToDate((String)((String)param.get("skssqz")));
                ttctag = (String)param.get("ttctag");
                draftpurpose = (String)param.get("draftpurpose");
                tabynssde = new BigDecimal((String)param.get("codePluginParam_" + reportkey + "_0"));
                tabtaxareagroup = EmptyCheckUtils.isEmpty((Object)param.get("codePluginParam_" + reportkey + "_1")) ? 0L : Long.parseLong((String)param.get("codePluginParam_" + reportkey + "_1"));
                taxrateType = EmptyCheckUtils.isEmpty((Object)param.get("codePluginParam_" + reportkey + "_2")) ? "rate" : (String)param.get("codePluginParam_" + reportkey + "_2");
            }
            logger.info("DynamicRateRowFetchPlugin: tabtaxareagroup: " + tabtaxareagroup);
            String taxcodekeyprefix = taxationsys + "_" + taxtype + "_" + (0L == tabtaxareagroup ? taxareagroup : tabtaxareagroup);
            logger.info("DynamicRateRowFetchPlugin: \u5f00\u59cb\u6761\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7b49");
            String key = String.format("%s_%s_%s_%s_%s_%s_%s_%s_%s", orgid, taxationsys, taxtype, reportkey, taxareagroup, templateid, draftpurpose, skssqq, skssqz);
            logger.info(timeMillis + "tabtaxareagroup: {}, DynamicRateRowFetchPluginkey: {}", (Object)tabtaxareagroup, (Object)key);
            lock = DLock.create((String)key);
            if (lock.tryLock(10000L)) {
                System.out.println("\u83b7\u53d6\u9501\u7684\u4fe1\u606f" + DLock.getLockInfo((String)key));
                logger.info("DynamicRateRowFetchPlugin  lock start");
                logger.info("DynamicRateRowFetchPlugin: \u7ec4\u88c5\u8fc7\u6ee4\u6761\u4ef6");
                List taxcodeResult = ObjectUtils.isNotEmpty((Object)this.context) && this.context.getBusinessParam().containsKey(taxcodekeyprefix + "_minimumtaxdetail") ? (List)this.context.getBusinessParam().get(taxcodekeyprefix + "_minimumtaxdetail") : null;
                List<String> deleteCellkeyList = new ArrayList(12);
                if (!this.context.getBusinessParam().containsKey("deleteCellkeyList")) {
                    this.context.getBusinessParam().put("deleteCellkeyList", deleteCellkeyList);
                } else {
                    deleteCellkeyList = (List)this.context.getBusinessParam().get("deleteCellkeyList");
                }
                deleteCellkeyList.add(reportkey);
                if (EmptyCheckUtils.isEmpty((Object)taxcodeResult)) {
                    logger.info(timeMillis + "DynamicRateRowFetchPluginkey-\u7ed3\u679c: \u7ed3\u679c\u4e3a\u7a7a.tabtaxareagroup: {}", (Object)tabtaxareagroup);
                    AbstractGtcpDynamicRateStrategy gtcpDynamicRateStrategyByType = GtcpDynamicRateStrategyFactory.getGtcpDynamicRateStrategyByType(taxrateType);
                    if (ObjectUtils.isNotEmpty((Object)gtcpDynamicRateStrategyByType)) {
                        String string = gtcpDynamicRateStrategyByType.setDefaultValue(this.context, reportkey);
                        return string;
                    }
                    String string = "0.00";
                    return string;
                }
                String codenumber = ((TaxcodeDetailDto)taxcodeResult.get(0)).getResultNumber();
                String taxcodeName = ((TaxcodeDetailDto)taxcodeResult.get(0)).getResultName();
                logger.info("DynamicRateRowFetchPlugin: \u8fd4\u56de\u7a0e\u7801\u7f16\u53f7:tabtaxareagroup: {}, data: {}", (Object)tabtaxareagroup, (Object)codenumber);
                combineName = taxcodeName + "|" + codenumber;
                logger.info("DynamicRateRowFetchPlugin: combineName \u5f97\u5230\u7684\u7a0e\u7801\u7f16\u7801: {}, tabtaxareagroup: {}", (Object)combineName, (Object)tabtaxareagroup);
                ArrayList<DynamicObject> objectList = new ArrayList<DynamicObject>(12);
                for (Object detailDto : taxcodeResult) {
                    objectList.add(detailDto.getResultObject());
                }
                AbstractGtcpDynamicRateStrategy gtcpDynamicRateStrategyByType = GtcpDynamicRateStrategyFactory.getGtcpDynamicRateStrategyByType(taxrateType);
                if (ObjectUtils.isEmpty((Object)gtcpDynamicRateStrategyByType)) {
                    Object detailDto;
                    detailDto = "0.00";
                    return detailDto;
                }
                List<DynamicObject> dynamicObjectList = gtcpDynamicRateStrategyByType.delFilterTaxrateRow(objectList);
                ArrayList<DynamicObject> dataDynamicList = new ArrayList<DynamicObject>(16);
                combineName = gtcpDynamicRateStrategyByType.calculateResult(this.context, param, dynamicObjectList, dataDynamicList, tabynssde, reportkey, codenumber, taxcodeName);
                List<DynamicObject> saveTaxcodeTempList = new ArrayList(12);
                if (!this.context.getBusinessParam().containsKey("saveTaxcodeTempList")) {
                    this.context.getBusinessParam().put("saveTaxcodeTempList", saveTaxcodeTempList);
                } else {
                    saveTaxcodeTempList = (List)this.context.getBusinessParam().get("saveTaxcodeTempList");
                }
                saveTaxcodeTempList.addAll(dataDynamicList);
                logger.info(timeMillis + "DynamicRateRowFetchPluginkey-\u7ed3\u679c,tabtaxareagroup: {} ,: {}", (Object)tabtaxareagroup, (Object)(combineName + "\r"));
            }
            String string = combineName;
            return string;
        }
        catch (Exception e) {
            logger.info(timeMillis + "DynamicRateRowFetchPluginkey-\u7ed3\u679c: \u62a5\u5f02\u5e38, tabtaxareagroup: {}", (Object)((String)param.get("codePluginParam_" + reportkey + "_1")));
            logger.info("throw exception : " + e.getMessage());
            AbstractGtcpDynamicRateStrategy gtcpDynamicRateStrategyByType = GtcpDynamicRateStrategyFactory.getGtcpDynamicRateStrategyByType(taxrateType);
            if (ObjectUtils.isNotEmpty((Object)gtcpDynamicRateStrategyByType)) {
                String string = gtcpDynamicRateStrategyByType.setDefaultValue(this.context, reportkey);
                return string;
            }
            String string = "0.00";
            return string;
        }
        finally {
            if (lock != null) {
                lock.unlock();
                logger.info("DynamicRateRowFetchPlugin  lock end.tabtaxareagroup:{}", (Object)((String)param.get("codePluginParam_" + reportkey + "_1")));
            }
        }
    }

    public String query(Map<String, Object> param) {
        return null;
    }
}

