/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.gtcp.business.fetchitem.FetchItemBusiness;
import kd.taxc.gtcp.common.enums.FixedCellFetchTransFormProjectEnum;
import kd.taxc.gtcp.formplugin.fetchdata.AbstractGeneralDynamicRowListFetchPlugin;

@GlobalDynamicRowPluginFlag
public class GeneralCITDynamicRowListFetchPlugin
extends AbstractGeneralDynamicRowListFetchPlugin {
    private static final Log logger = LogFactory.getLog(GeneralCITDynamicRowListFetchPlugin.class);
    private static final List<Long> additionalTaxList = Arrays.asList(TaxationsysMappingEnum.DEU.getId(), TaxationsysMappingEnum.JAP.getId());

    @Override
    protected Map<String, String> getDynRowBizTypeMap() {
        HashMap<String, String> dynRowBizTypeMap = new HashMap<String, String>(8);
        Arrays.stream(CitDynRowEnum.values()).forEach(row -> dynRowBizTypeMap.put(row.getDynRow(), row.getBizType()));
        return dynRowBizTypeMap;
    }

    @Override
    protected RuleEngineParamDto getRuleEngineParamDto(BussinessParamsVo bussinessParamsVo, Set<Long> ids) {
        QFilter sharingPlanWhereFilter;
        RuleEngineParamDto ruleEngineParamDto = super.getRuleEngineParamDto(bussinessParamsVo, ids);
        Long taxSystemId = Long.parseLong((String)bussinessParamsVo.getExtendParams().get("taxationsys"));
        if (!additionalTaxList.contains(taxSystemId)) {
            return ruleEngineParamDto;
        }
        if (null == ruleEngineParamDto) {
            return null;
        }
        List<Long> list = this.getAdditionalTaxTaxcategoryByTaxSysTList(taxSystemId);
        QFilter accessWhereFilter = ruleEngineParamDto.getAccessWhereFilter();
        if (null != accessWhereFilter) {
            QFilter[] accessWhereFilters = accessWhereFilter.recombine();
            Arrays.stream(accessWhereFilters).filter(qFilter -> StringUtil.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"taxcategory")).forEach(qFilter -> {
                list.add(qFilter.getValue() instanceof Long ? (Long)qFilter.getValue() : 0L);
                qFilter.__setCP("in");
                qFilter.__setValue((Object)list);
            });
            QFilter qFilter2 = QFilter.of((String)"1=1", (Object[])new Object[0]);
            Arrays.stream(accessWhereFilters).forEach(row -> qFilter2.and(row));
            ruleEngineParamDto.setAccessWhereFilter(qFilter2);
        }
        if (null != (sharingPlanWhereFilter = ruleEngineParamDto.getSharingPlanWhereFilter())) {
            QFilter[] sharingPlanWhereFilters = sharingPlanWhereFilter.recombine();
            Arrays.stream(sharingPlanWhereFilters).filter(qFilter -> StringUtil.equalsIgnoreCase((CharSequence)qFilter.getProperty(), (CharSequence)"taxcategory")).forEach(qFilter -> {
                list.add(qFilter.getValue() instanceof Long ? (Long)qFilter.getValue() : 0L);
                qFilter.__setCP("in");
                qFilter.__setValue((Object)list);
            });
            QFilter qFilter3 = QFilter.of((String)"1=1", (Object[])new Object[0]);
            Arrays.stream(sharingPlanWhereFilters).forEach(row -> qFilter3.and(row));
            ruleEngineParamDto.setSharingPlanWhereFilter(qFilter3);
        }
        return ruleEngineParamDto;
    }

    @Override
    protected DynamicObjectCollection getFetchItems(BussinessParamsVo bussinessParamsVo, Map<String, String> dynRowBizTypeMap) {
        Long taxSystemId = Long.parseLong(bussinessParamsVo.getExtendParams().get("taxationsys").toString());
        if (!additionalTaxList.contains(taxSystemId)) {
            return super.getFetchItems(bussinessParamsVo, dynRowBizTypeMap);
        }
        Collection<String> values = dynRowBizTypeMap.values();
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Long taxcategoryId = Long.parseLong(extendParams.get("taxcategory").toString());
        List<Long> taxcategoryIdList = this.getAdditionalTaxTaxcategoryByTaxSysTList(taxSystemId);
        taxcategoryIdList.add(taxcategoryId);
        Long taxareagroupId = Long.parseLong((String)extendParams.get("taxareagroup"));
        DynamicObjectCollection fetchItems = FetchItemBusiness.getFetchItems(orgId, taxSystemId, taxcategoryIdList, taxareagroupId, values);
        logger.info("\u83b7\u53d6\u6240\u6709\u76f8\u5173\u53d6\u6570\u9879\u76ee\u6761\u6570\uff1a{}", (Object)(ObjectUtils.isEmpty((Object)fetchItems) ? 0 : fetchItems.size()));
        return fetchItems;
    }

    @Override
    public List<Map<String, Object>> getDynListMapByDynRowNo(BussinessParamsVo bussinessParamsVo, String dynRowNo, List<DynamicObject> fetchItemsByBizType, RuleFetchMainDto ruleFetchMainDto, Map<String, Map<String, Object>> extenResultMap) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        HashMap amountResultMap = new HashMap(8);
        ruleFetchCellSummaryList.stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity".equalsIgnoreCase(cell.getFetchEntryentity())) {
                amountResultMap.put(cell.getRuleItem(), this.getAmount((RuleFetchCellSummaryDto)cell));
            }
        });
        CitDynRowEnum citDynRowEnum = CitDynRowEnum.getEnumByDynRow(dynRowNo);
        if (null == citDynRowEnum) {
            return mapList;
        }
        HashMap<String, Integer> startSequenceMap = new HashMap<String, Integer>();
        for (DynamicObject fetchItem : fetchItemsByBizType) {
            if (!startSequenceMap.containsKey(dynRowNo)) {
                startSequenceMap.put(dynRowNo, Integer.parseInt(citDynRowEnum.getStartNumber()));
            } else {
                startSequenceMap.put(dynRowNo, (Integer)startSequenceMap.get(dynRowNo) + 1);
            }
            Long xmId = fetchItem.getLong("id");
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            String prefix = dynRowNo.split("#")[0];
            map.put(prefix + "#" + citDynRowEnum.getSerialNoCol(), new StringBuilder(citDynRowEnum.getDynSerialNo()).append(".").append(((Integer)startSequenceMap.get(dynRowNo)).toString()));
            map.put(prefix + "#" + citDynRowEnum.getFetchItemCol(), xmId);
            String xmIdString = String.valueOf(xmId);
            if (amountResultMap.containsKey(xmIdString)) {
                map.put(prefix + "#" + citDynRowEnum.getFetchAmountCol(), amountResultMap.get(xmIdString));
            } else {
                map.put(prefix + "#" + citDynRowEnum.getFetchAmountCol(), "0.00");
            }
            this.setReportItem(xmId, mapList, prefix, citDynRowEnum.getFetchAmountCol(), ruleFetchMainDto);
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    protected void buildFetchDynRowList(BussinessParamsVo bussinessParamsVo, Map<String, List<Map<String, Object>>> result, Map<String, String> dynRowBizTypeMap, DynamicObjectCollection fetchItems, RuleFetchMainDto ruleFetchMainDto) {
        Long taxSystemId = Long.parseLong(bussinessParamsVo.getExtendParams().get("taxationsys").toString());
        String taxcategoryId = bussinessParamsVo.getExtendParams().get("taxcategory").toString();
        if (!additionalTaxList.contains(taxSystemId)) {
            super.buildFetchDynRowList(bussinessParamsVo, result, dynRowBizTypeMap, fetchItems, ruleFetchMainDto);
            return;
        }
        for (Map.Entry<String, String> entry : dynRowBizTypeMap.entrySet()) {
            String dynRowNo = entry.getKey();
            CitDynRowEnum citDynRowEnum = CitDynRowEnum.getEnumByDynRow(dynRowNo);
            if (null == citDynRowEnum) {
                logger.info("\u627e\u4e0d\u5230{}\u52a8\u6001\u884c\u5728CitDynRowEnum\u7c7b\u7684\u5b9a\u4e49\uff1a{}", (Object)dynRowNo, (Object)0);
                continue;
            }
            List<Object> fetchItemsByBizType = new ArrayList();
            fetchItemsByBizType = CitDynRowEnum.getBizTypeAlikeDynMainRow().contains(dynRowNo) ? fetchItems.stream().filter(m -> StringUtil.equalsIgnoreCase((CharSequence)taxcategoryId, (CharSequence)m.getString("taxcategory.id")) && StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)dynRowBizTypeMap.get(dynRowNo)), (CharSequence)m.getString("biztype.number"))).collect(Collectors.toList()) : (CitDynRowEnum.getAdditionalTaxDynRow().contains(dynRowNo) ? fetchItems.stream().filter(m -> StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)dynRowBizTypeMap.get(dynRowNo)), (CharSequence)m.getString("biztype.number"))).filter(n -> null != citDynRowEnum.getFixedCellFetchTransFormProjectEnum() && citDynRowEnum.getFixedCellFetchTransFormProjectEnum().getTaxcategory().equals(n.getLong("taxcategory.id"))).collect(Collectors.toList()) : fetchItems.stream().filter(m -> StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)dynRowBizTypeMap.get(dynRowNo)), (CharSequence)m.getString("biztype.number"))).collect(Collectors.toList()));
            if (ObjectUtils.isEmpty(fetchItemsByBizType)) {
                result.put(dynRowNo, new ArrayList());
                logger.info("\u83b7\u53d6{}\u52a8\u6001\u884c\u6807\u8bc6\u6240\u6709\u76f8\u5173\u53d6\u6570\u9879\u76ee\u6761\u6570\uff1a{}", (Object)dynRowNo, (Object)0);
                continue;
            }
            Map<String, Map<String, Object>> extendResultMap = this.getExtendResultMap(bussinessParamsVo, fetchItems);
            List<Map<String, Object>> mapList = this.getDynListMapByDynRowNo(bussinessParamsVo, dynRowNo, fetchItemsByBizType, ruleFetchMainDto, extendResultMap);
            result.put(dynRowNo, mapList);
        }
    }

    private List<Long> getAdditionalTaxTaxcategoryByTaxSysTList(Long taxSystemId) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (TaxationsysMappingEnum.DEU.getId().equals(taxSystemId)) {
            list.add(FixedCellFetchTransFormProjectEnum.DEU_TT_amount_accrued.getTaxcategory());
            list.add(FixedCellFetchTransFormProjectEnum.DEU_SS_amount_accrued.getTaxcategory());
        } else if (TaxationsysMappingEnum.JAP.getId().equals(taxSystemId)) {
            list.add(FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_ET.getTaxcategory());
            list.add(FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_IT1.getTaxcategory());
            list.add(FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_IT2.getTaxcategory());
            list.add(FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_LCIT.getTaxcategory());
            list.add(FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_SET.getTaxcategory());
        }
        return list;
    }

    static enum CitDynRowEnum {
        income_fetch_item("income_fetch_item#1", "WP-00001", "1"),
        expenses_fetch_item("expenses_fetch_item#1", "WP-00002", "2"),
        gaapadjustment_fetch_item("gaapadjustment_fetch_item#1", "WP-00003", "4"),
        taxadjustment_fetch_item("taxadjustment_fetch_item#1", "WP-00004", "6"),
        unutilisedlosse_fetch_item("unutilisedlosse_fetch_item#1", "WP-00005", "8"),
        otheradjustment_fetch_item("otheradjustment_fetch_item#1", "WP-00006", "10"),
        taxreliefcredi_fetch_item("taxreliefcredi_fetch_item#1", "WP-00007", "14"),
        taxpaid_fetch_item("taxpaid_fetch_item#1", "WP-00008", "16"),
        addition_dyn("addition_dyn#1", "WP-00034", "trade_tax_amount", "2", FixedCellFetchTransFormProjectEnum.DEU_TT_amount_accrued),
        trade_Subtraction_dyn("subtraction_dyn#1", "WP-00035", "trade_tax_amount", "7", FixedCellFetchTransFormProjectEnum.DEU_TT_amount_accrued),
        trade_Unutilised_losses_dyn("trade_Unutilised_losses_dyn#1", "WP-00005", "trade_tax_amount", "9", FixedCellFetchTransFormProjectEnum.DEU_TT_amount_accrued),
        taxpaid_solidarity_surcharge_dyn("taxpaid_solidarity_surcharge_dyn#1", "WP-00008", "solidarity_surcharge_amount", "4", FixedCellFetchTransFormProjectEnum.DEU_SS_amount_accrued),
        taxpaid_trade_tax_dyn("taxpaid_trade_tax_dyn#1", "WP-00008", "trade_tax_amount", "13", FixedCellFetchTransFormProjectEnum.DEU_TT_amount_accrued),
        taxpaid_local_income_tax_dyn("taxpaid_local_income_tax_dyn#1", "WP-00008", "local_income_tax_amount", "4", FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_LCIT),
        taxpaid_inhabitants_taxprop_dyn("taxpaid_inhabitants_taxprop_dyn#1", "WP-00008", "inhabitants_taxprop_amount", "4", FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_IT1),
        taxpaid_inhabitants_taxnorm_dyn("taxpaid_inhabitants_taxnorm_dyn#1", "WP-00008", "inhabitants_taxnorm_amount", "2", FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_IT2),
        taxpaid_enterprise_tax_dyn("taxpaid_enterprise_tax_dyn#1", "WP-00008", "enterprise_tax_amount", "4", FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_ET),
        taxpaid_special_enter_tax_dyn("taxpaid_special_enter_tax_dyn#1", "WP-00008", "special_enter_tax_amount", "4", FixedCellFetchTransFormProjectEnum.JAP_amount_accrued_SET);

        private String dynRow;
        private String bizType;
        private String serialNoCol = "common_levy_sequence_number";
        private String fetchItemCol = "generalincome_item";
        private String fetchAmountCol = "generalincome_amount";
        private String dynSerialNo;
        private String startNumber = "1";
        private FixedCellFetchTransFormProjectEnum fixedCellFetchTransFormProjectEnum;

        private CitDynRowEnum(String dynRow, String bizType, String dynSerialNo) {
            this.dynRow = dynRow;
            this.bizType = bizType;
            this.dynSerialNo = dynSerialNo;
        }

        private CitDynRowEnum(String dynRow, String bizType, String fetchAmountCol, String dynSerialNo, FixedCellFetchTransFormProjectEnum fixedCellFetchTransFormProjectEnum) {
            this.dynRow = dynRow;
            this.bizType = bizType;
            this.fetchAmountCol = fetchAmountCol;
            this.dynSerialNo = dynSerialNo;
            this.fixedCellFetchTransFormProjectEnum = fixedCellFetchTransFormProjectEnum;
        }

        public String getDynRow() {
            return this.dynRow;
        }

        public String getBizType() {
            return this.bizType;
        }

        public String getSerialNoCol() {
            return this.serialNoCol;
        }

        public String getFetchItemCol() {
            return this.fetchItemCol;
        }

        public String getFetchAmountCol() {
            return this.fetchAmountCol;
        }

        public String getDynSerialNo() {
            return this.dynSerialNo;
        }

        public String getStartNumber() {
            return this.startNumber;
        }

        public FixedCellFetchTransFormProjectEnum getFixedCellFetchTransFormProjectEnum() {
            return this.fixedCellFetchTransFormProjectEnum;
        }

        public static CitDynRowEnum getEnumByDynRow(String dynRow) {
            for (CitDynRowEnum citDynRowEnum : CitDynRowEnum.values()) {
                if (!StringUtil.equalsIgnoreCase((CharSequence)citDynRowEnum.getDynRow(), (CharSequence)dynRow)) continue;
                return citDynRowEnum;
            }
            return null;
        }

        public static List<String> getBizTypeAlikeDynMainRow() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(taxpaid_fetch_item.getDynRow());
            return list;
        }

        public static List<String> getAdditionalTaxDynRow() {
            ArrayList<String> list = new ArrayList<String>();
            list.add(addition_dyn.getDynRow());
            list.add(trade_Unutilised_losses_dyn.getDynRow());
            list.add(taxpaid_solidarity_surcharge_dyn.getDynRow());
            list.add(taxpaid_trade_tax_dyn.getDynRow());
            list.add(taxpaid_local_income_tax_dyn.getDynRow());
            list.add(taxpaid_inhabitants_taxprop_dyn.getDynRow());
            list.add(taxpaid_inhabitants_taxnorm_dyn.getDynRow());
            list.add(taxpaid_enterprise_tax_dyn.getDynRow());
            list.add(taxpaid_special_enter_tax_dyn.getDynRow());
            return list;
        }
    }
}

