/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.gtcp.business.rule.GtcpDraftDynEngineBusiness;
import kd.taxc.gtcp.formplugin.fetchdata.AbstractGeneralDynamicRowListFetchPlugin;
import org.apache.commons.collections.CollectionUtils;

@GlobalDynamicRowPluginFlag
public class GeneralVatDynamicRowListFetchPlugin
extends AbstractGeneralDynamicRowListFetchPlugin {
    private static final Log logger = LogFactory.getLog(GeneralVatDynamicRowListFetchPlugin.class);

    @Override
    protected Map<String, String> getDynRowBizTypeMap() {
        HashMap<String, String> dynRowBizTypeMap = new HashMap<String, String>(8);
        dynRowBizTypeMap.put("vat_Gtc_Sales_Fatch_Item#1", "WP-00009");
        dynRowBizTypeMap.put("vat_Gtc_Purchases_Fatch_Item#1", "WP-00010");
        dynRowBizTypeMap.put("vat_Gtc_Adjustment_Fatch_Item#1", "WP-00011");
        dynRowBizTypeMap.put("vat_stc_Sales_Fatch_Item#1", "WP-00012");
        dynRowBizTypeMap.put("vat_stc_Adjustment_Fatch_Item#1", "WP-00013");
        dynRowBizTypeMap.put("vat_total_TaxPaid_Fatch_Item#1", "WP-00008");
        return dynRowBizTypeMap;
    }

    private Map<String, String> getDynRowSequenceNumber() {
        HashMap<String, String> dynRowBizSequenceNumber = new HashMap<String, String>(8);
        dynRowBizSequenceNumber.put("vat_Gtc_Sales_Fatch_Item#1", "1");
        dynRowBizSequenceNumber.put("vat_Gtc_Purchases_Fatch_Item#1", "2");
        dynRowBizSequenceNumber.put("vat_Gtc_Adjustment_Fatch_Item#1", "3");
        dynRowBizSequenceNumber.put("vat_stc_Sales_Fatch_Item#1", "5");
        dynRowBizSequenceNumber.put("vat_stc_Adjustment_Fatch_Item#1", "6");
        dynRowBizSequenceNumber.put("vat_total_TaxPaid_Fatch_Item#1", "9");
        return dynRowBizSequenceNumber;
    }

    @Override
    public List<Map<String, Object>> getDynListMapByDynRowNo(BussinessParamsVo bussinessParamsVo, String dynRowNo, List<DynamicObject> fetchItemsByBizType, RuleFetchMainDto ruleFetchMainDto, Map<String, Map<String, Object>> extenResultMap) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
        HashMap<String, Object> taxrateMap = new HashMap<String, Object>(8);
        if (!ObjectUtils.isEmpty(extenResultMap) && !ObjectUtils.isEmpty(extenResultMap.get("taxrate"))) {
            taxrateMap.putAll(extenResultMap.get("taxrate"));
        }
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        HashMap amountResultMap = new HashMap(8);
        HashMap taxResultMap = new HashMap(8);
        ruleFetchCellSummaryList.stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity".equalsIgnoreCase(cell.getFetchEntryentity()) && !ObjectUtils.isEmpty((Object)cell.getRuleFetchCardList())) {
                amountResultMap.put(cell.getRuleItem(), this.getAmount((RuleFetchCellSummaryDto)cell));
            }
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity1".equalsIgnoreCase(cell.getFetchEntryentity()) && !ObjectUtils.isEmpty((Object)cell.getRuleFetchCardList())) {
                taxResultMap.put(cell.getRuleItem(), this.getAmount((RuleFetchCellSummaryDto)cell));
            }
        });
        int i = 1;
        Map<String, String> dynRowSequenceNumber = this.getDynRowSequenceNumber();
        for (DynamicObject fetchItem : fetchItemsByBizType) {
            BigDecimal result;
            BigDecimal taxrateResult;
            Long xmId = fetchItem.getLong("id");
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            String prefix = dynRowNo.split("#")[0];
            map.put(prefix + "#common_levy_sequence_number", new StringBuilder(dynRowSequenceNumber.get(dynRowNo)).append(".").append(i++));
            map.put(prefix + "#vat_Item", xmId);
            Object taxrate = taxrateMap.get(String.valueOf(xmId));
            if (!ObjectUtils.isEmpty(taxrate)) {
                taxrateResult = new BigDecimal(taxrate.toString()).setScale(5, 4);
                map.put(prefix + "#vat_Tax_rate", taxrateResult);
            } else {
                taxrate = new BigDecimal(0).divide(BigDecimal.valueOf(100L), 5, 4);
                map.put(prefix + "#vat_Tax_rate", "");
            }
            taxrateResult = new BigDecimal(taxrate.toString()).setScale(5, 4);
            String xmIdString = String.valueOf(xmId);
            if (dynRowNo.startsWith("vat_Gtc_Sales") || dynRowNo.startsWith("vat_Gtc_Purchases") || dynRowNo.startsWith("vat_stc_Sales")) {
                String amountResult = "0.00";
                if (amountResultMap.containsKey(xmIdString)) {
                    amountResult = (String)amountResultMap.get(xmIdString);
                } else if (taxResultMap.containsKey(xmIdString) && new BigDecimal(taxrate.toString()).doubleValue() != 0.0) {
                    result = new BigDecimal((String)taxResultMap.get(xmIdString)).divide(new BigDecimal(taxrate.toString()), 2, 4);
                    amountResult = result.toString();
                }
                this.setReportItem(xmId, mapList, prefix, "#vat_Amount", "entryentity", ruleFetchMainDto);
                map.put(prefix + "#vat_Amount", amountResult);
            }
            String taxResult = "0.00";
            if (dynRowNo.startsWith("vat_Gtc_Adjustment") || dynRowNo.startsWith("vat_stc_Adjustment") || dynRowNo.startsWith("vat_total_TaxPaid")) {
                if (taxResultMap.containsKey(xmIdString)) {
                    taxResult = (String)taxResultMap.get(xmIdString);
                }
            } else if (taxResultMap.containsKey(xmIdString)) {
                taxResult = (String)taxResultMap.get(xmIdString);
            } else if (amountResultMap.containsKey(xmIdString)) {
                result = new BigDecimal((String)amountResultMap.get(xmIdString)).multiply(taxrateResult);
                taxResult = result.toString();
            }
            this.setReportItem(xmId, mapList, prefix, "#vat_Tax", "entryentity1", ruleFetchMainDto);
            map.put(prefix + "#vat_Tax", taxResult);
            mapList.add(map);
        }
        return mapList;
    }

    @Override
    protected Map<String, Map<String, Object>> getExtendResultMap(BussinessParamsVo bussinessParamsVo, DynamicObjectCollection fetchItems) {
        HashMap<String, Map<String, Object>> resultMap = new HashMap<String, Map<String, Object>>(8);
        HashMap amountMapMap = new HashMap(8);
        if (CollectionUtils.isEmpty((Collection)fetchItems)) {
            return null;
        }
        String orgId = bussinessParamsVo.getOrgId();
        Set<Long> ids = fetchItems.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        Map<Long, List<DynamicObject>> allOrgMatchAccessConfigMap = new GtcpDraftDynEngineBusiness().getAllOrgMatchAccessConfigMap(this.getRuleEngineParamDto(bussinessParamsVo, ids));
        List<DynamicObject> dynamicObjects = allOrgMatchAccessConfigMap.get(Long.valueOf(orgId));
        if (!ObjectUtils.isEmpty(dynamicObjects)) {
            dynamicObjects.stream().forEach(dynamicObject -> {
                long accessprojectId = dynamicObject.getLong("accessproject.id");
                BigDecimal taxrate = dynamicObject.getBigDecimal("taxrate.taxrate");
                BigDecimal bigDecimal = taxrate = taxrate == null ? BigDecimal.ZERO : taxrate;
                if (dynamicObject.get("taxrate.taxrate") == null) {
                    amountMapMap.put(String.valueOf(accessprojectId), null);
                } else {
                    amountMapMap.put(String.valueOf(accessprojectId), taxrate.divide(BigDecimal.valueOf(100L), 5, 4));
                }
            });
        }
        resultMap.put("taxrate", amountMapMap);
        return resultMap;
    }

    @Override
    protected void dealWithRuleFetchMainDtoExtend(RuleFetchMainDto ruleFetchMainDto, DynamicObjectCollection fetchItems) {
        List fetchItemIds = fetchItems.stream().map(o -> o.getString("id")).collect(Collectors.toList());
        HashMap taxResultMap = new HashMap(8);
        ruleFetchMainDto.getRuleFetchCellSummaryList().stream().forEach(cell -> {
            if (!ObjectUtils.isEmpty((Object)cell.getFetchEntryentity()) && "entryentity1".equalsIgnoreCase(cell.getFetchEntryentity())) {
                taxResultMap.put(cell.getRuleItem(), this.getAmount((RuleFetchCellSummaryDto)cell));
            }
        });
        List<String> entrytity1ExcludeItems = this.getEntrytity1ExcludeItems(fetchItems);
        fetchItemIds.stream().forEach(access -> {
            if (!taxResultMap.containsKey(access) && !entrytity1ExcludeItems.contains(access)) {
                RuleFetchCellSummaryDto cellSummaryDto = new RuleFetchCellSummaryDto("gtcp_accessconfig", access, access, null, BigDecimal.ZERO, BigDecimal.ZERO, "entryentity1");
                ruleFetchMainDto.getRuleFetchCellSummaryList().add(cellSummaryDto);
            }
        });
    }

    @Override
    protected List<String> getEntrytityExcludeItems(DynamicObjectCollection fetchItems) {
        ArrayList<String> excludeItemIds = new ArrayList<String>(2);
        List<String> exccludetypes = Arrays.asList("WP-00011", "WP-00013", "WP-00008");
        fetchItems.stream().forEach(item -> {
            if (exccludetypes.contains(item.getString("biztype.number"))) {
                excludeItemIds.add(item.getString("id"));
            }
        });
        return excludeItemIds;
    }

    protected List<String> getEntrytity1ExcludeItems(DynamicObjectCollection fetchItems) {
        return new ArrayList<String>(2);
    }

    private void setReportItem(Long xmId, List<Map<String, Object>> mapList, String prefix, String suffix, String entryentity, RuleFetchMainDto fetchMainDto) {
        if (fetchMainDto == null) {
            return;
        }
        List ruleFetchCellSummaryList = fetchMainDto.getRuleFetchCellSummaryList();
        if (ruleFetchCellSummaryList == null) {
            return;
        }
        for (RuleFetchCellSummaryDto summaryDto : ruleFetchCellSummaryList) {
            if (EmptyCheckUtils.isEmpty((Object)summaryDto.getRuleItem()) || EmptyCheckUtils.isEmpty((Object)xmId) || EmptyCheckUtils.isEmpty((Object)summaryDto.getFetchEntryentity()) || !summaryDto.getRuleItem().equalsIgnoreCase(xmId.toString()) || !summaryDto.getFetchEntryentity().equalsIgnoreCase(entryentity)) continue;
            summaryDto.setReportItem(prefix + "#" + (mapList.size() + 1) + suffix);
        }
    }
}

