/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.taxc.bdtaxr.business.tctb.TaxPeriodBusiness;
import kd.taxc.bdtaxr.common.declare.initparam.InitParams;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.bastax.taxccode.TaxcCodeDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.ttc.TtcCalculateServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupColumnEnum;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpInitParams
implements InitParams {
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        Map param = super.buildBizParam(requestModel);
        param.put("orgid", requestModel.getOrgId().toString());
        param.put("taxationsys", requestModel.getTaxationsys().toString());
        if (ObjectUtils.isEmpty((Object)requestModel.getExtendParams())) {
            requestModel.setExtendParams(new HashMap());
        }
        String taxtype = requestModel.getExtendParams().containsKey("taxtype") ? requestModel.getExtendParams().get("taxtype").toString() : "0";
        String draftpurpose = requestModel.getExtendParams().containsKey("draftpurpose") ? requestModel.getExtendParams().get("draftpurpose").toString() : "nssb";
        Date firstDayOfYearByDraftPurpose = TaxPeriodBusiness.getFirstDayOfYearByDraftPurpose((Long)requestModel.getOrgId(), (Long)requestModel.getTaxationsys(), (Long)Long.parseLong(taxtype), (String)draftpurpose, (Date)DateUtils.stringToDate2((String)requestModel.getSkssqq()));
        param.put("draftpurpose", requestModel.getExtendParams().get("draftpurpose").toString());
        param.put("taxtype", requestModel.getExtendParams().get("taxtype").toString());
        param.put("taxPeriodyear", ObjectUtils.isNotEmpty((Object)firstDayOfYearByDraftPurpose) ? DateUtils.format((Date)firstDayOfYearByDraftPurpose) : "");
        param.put("skssqq", requestModel.getSkssqq());
        param.put("skssqz", requestModel.getSkssqz());
        param.put("templateid", requestModel.getTemplateId().toString());
        List<String> taxAreaGroupIdList = UsaTaxAreaGroupColumnEnum.getTaxAreaGroupIdList();
        param.put("taxAreaGroupIdList", SerializationUtils.toJsonString(taxAreaGroupIdList));
        param.put("enableCacheCP", "1");
        List<String> allTaxCodeNumberList = this.getAllTaxCodeNumberList(requestModel, taxAreaGroupIdList, param);
        param.put("allTaxCodeNumberList", SerializationUtils.toJsonString(allTaxCodeNumberList));
        return param;
    }

    private List<String> getAllTaxCodeNumberList(DeclareRequestModel requestModel, List<String> taxAreaGroupIdList, Map<String, String> param) {
        TaxResult taxCodeAndRateByCondition;
        String taxtype = requestModel.getBusinessMap().containsKey("taxtype") ? (String)requestModel.getBusinessMap().get("taxtype") : "0";
        ArrayList taxFourPList = new ArrayList(16);
        ArrayList<String> codeNumerList = new ArrayList<String>(16);
        if (ObjectUtils.isNotEmpty(taxAreaGroupIdList)) {
            for (String taxAreaGroupId : taxAreaGroupIdList) {
                HashMap<Long, Long> addressTypeMap = new HashMap<Long, Long>();
                addressTypeMap.put(Long.parseLong(taxAreaGroupId), 1036241275604686848L);
                HashMap<String, HashMap<Long, Long>> addressTypeparamMap = new HashMap<String, HashMap<Long, Long>>(16);
                addressTypeparamMap.put("addressType", addressTypeMap);
                taxFourPList.add(addressTypeparamMap);
            }
        }
        if (ObjectUtils.isNotEmpty((Object)(taxCodeAndRateByCondition = TtcCalculateServiceHelper.getTaxCodeAndRateByCondition((long)requestModel.getOrgId(), (long)0L, (long)requestModel.getTaxationsys(), (String)"taxarea", (Date)new Date(), Collections.singletonList(Long.parseLong(taxtype)), taxFourPList))) && taxCodeAndRateByCondition.isSuccess() && ObjectUtils.isNotEmpty((Object)taxCodeAndRateByCondition.getData())) {
            TaxResult taxcodeResult;
            ArrayList taxcodeNumberList = new ArrayList(12);
            HashMap taxcodeResultMap = new HashMap(16);
            ((Map)taxCodeAndRateByCondition.getData()).entrySet().stream().forEach(taxcode -> {
                if (ObjectUtils.isNotEmpty(taxcode.getValue())) {
                    taxcodeNumberList.add(((List)taxcode.getValue()).get(0));
                    taxcodeResultMap.put((String)((List)taxcode.getValue()).get(0) + "_taxcode", taxcode.getKey());
                }
            });
            if (ObjectUtils.isNotEmpty(taxcodeNumberList) && ObjectUtils.isNotEmpty((Object)(taxcodeResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumbers(taxcodeNumberList))) && taxcodeResult.isSuccess() && ObjectUtils.isNotEmpty((Object)taxcodeResult.getData())) {
                List taxcodeList = (List)taxcodeResult.getData();
                for (DynamicObject taxcode2 : taxcodeList) {
                    String codenumber = taxcode2.getString("number");
                    codeNumerList.add(codenumber);
                }
            }
            param.putAll(taxcodeResultMap);
        }
        return codeNumerList;
    }
}

