/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxccode.TaxcCodeDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.ttc.TtcCalculateServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractCodeGetValueBasePlugin;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;

public class InTaxNormDynamicRateRowFetchPlugin
extends AbstractCodeGetValueBasePlugin {
    private static final Log logger = LogFactory.getLog(InTaxNormDynamicRateRowFetchPlugin.class);
    private static final String BDTAXR_TAX_DETAILS = "bdtaxr_tax_details";
    private static final String generalincome_amount_tobe_accrued = "generalincome_amount_tobe_accrued#inhabitants_taxnorm_amount";
    private static final String generalincome_amount_due_overp = "generalincome_amount_due_overp#inhabitants_taxnorm_amount";
    private Context context;

    public InTaxNormDynamicRateRowFetchPlugin() {
        this.context = ((AbstractCodeGetValueBasePlugin)this).context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryByFormulaVo(Map<String, Object> param, FormulaVo formulaVo) {
        String reportkey = formulaVo.getFormulaKey();
        DLock lock = null;
        String combineName = "0.0%";
        try {
            long orgid = 0L;
            long country = 0L;
            long taxationsys = 0L;
            long taxtype = 0L;
            long taxareagroup = 0L;
            long draftid = 0L;
            long templateid = 0L;
            String draftpurpose = "";
            String ttctag = "";
            long tabtaxareagroup = 0L;
            long taxtypeTab = 0L;
            BigDecimal amountAccrued = BigDecimal.ZERO;
            BigDecimal taxPaid = BigDecimal.ZERO;
            Date skssqq = new Date();
            Date skssqz = new Date();
            Map taxProduct = new HashMap(16);
            Map<Long, Long> addressType = new HashMap(16);
            Map taxAptitude = new HashMap(16);
            Map process = new HashMap(16);
            if (param != null && param.size() > 0) {
                orgid = Long.parseLong((String)param.get("orgid"));
                taxationsys = Long.parseLong((String)param.get("taxationsys"));
                taxtype = Long.parseLong((String)param.get("taxtype"));
                taxProduct = (Map)param.get("taxProduct");
                addressType = (Map)param.get("addressType");
                taxAptitude = (Map)param.get("taxAptitude");
                process = (Map)param.get("process");
                draftid = (Long)param.get("reportId");
                templateid = (Long)param.get("templateId");
                taxareagroup = Long.parseLong((String)param.get("taxareagroup"));
                skssqq = DateUtils.stringToDate((String)((String)param.get("skssqq")));
                skssqz = DateUtils.stringToDate((String)((String)param.get("skssqz")));
                ttctag = (String)param.get("ttctag");
                draftpurpose = (String)param.get("draftpurpose");
                amountAccrued = new BigDecimal((String)param.get("codePluginParam_" + reportkey + "_0"));
                taxPaid = new BigDecimal((String)param.get("codePluginParam_" + reportkey + "_1"));
                taxtypeTab = EmptyCheckUtils.isEmpty((Object)param.get("codePluginParam_" + reportkey + "_2")) ? taxtypeTab : Long.parseLong((String)param.get("codePluginParam_" + reportkey + "_2"));
            }
            logger.info("InTaxNormDynamicRateRowFetchPlugin: taxtypeTab: " + taxtypeTab);
            Date validDate = new Date();
            ArrayList<Long> taxTypeList = new ArrayList<Long>(16);
            taxTypeList.add(taxtypeTab);
            ArrayList taxProductList = new ArrayList(16);
            if (taxProduct != null) {
                taxProductList.add(taxProduct);
            }
            ArrayList<Map<Long, Long>> addressTypeList = new ArrayList<Map<Long, Long>>(16);
            if (addressType != null) {
                addressTypeList.add(addressType);
            } else {
                addressType = new HashMap(16);
                addressType.put(0L == tabtaxareagroup ? taxareagroup : tabtaxareagroup, 1036241275604686848L);
                addressTypeList.add(addressType);
            }
            ArrayList taxAptitudeList = new ArrayList(16);
            if (taxAptitude != null) {
                taxAptitudeList.add(taxAptitude);
            }
            ArrayList processList = new ArrayList(16);
            if (process != null) {
                processList.add(process);
            }
            logger.info("InTaxNormDynamicRateRowFetchPlugin: \u5f00\u59cb\u6761\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7b49");
            TaxResult result = TtcCalculateServiceHelper.getTaxCodeAndRateByCondition((long)orgid, (long)country, (long)taxationsys, (String)ttctag, (Date)validDate, taxTypeList, taxProductList, addressTypeList, taxAptitudeList, processList);
            String key = String.format("%s_%s_%s_%s_%s_%s_%s_%s_%s", orgid, taxationsys, taxtypeTab, reportkey, taxareagroup, templateid, draftpurpose, skssqq, skssqz);
            logger.info("InTaxNormDynamicRateRowFetchPlugin  key: " + key);
            lock = DLock.create((String)key);
            if (lock.tryLock(10000L)) {
                logger.info("InTaxNormDynamicRateRowFetchPlugin  lock start");
                logger.info("InTaxNormDynamicRateRowFetchPlugin: \u7ec4\u88c5\u8fc7\u6ee4\u6761\u4ef6");
                QFilter qfilter = new QFilter("orgid", "=", (Object)orgid);
                qfilter.and(new QFilter("taxationsys", "=", (Object)taxationsys));
                qfilter.and(new QFilter("taxtype", "=", (Object)taxtype));
                qfilter.and(new QFilter("reportkey", "=", (Object)reportkey));
                qfilter.and(new QFilter("taxareagroup", "=", (Object)taxareagroup));
                qfilter.and(new QFilter("templateid", "=", (Object)templateid));
                qfilter.and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
                qfilter.and(new QFilter("skssqq", "=", (Object)skssqq));
                qfilter.and(new QFilter("skssqz", "=", (Object)skssqz));
                qfilter.and(new QFilter("datastatus", "=", (Object)"0"));
                DeleteServiceHelper.delete((String)BDTAXR_TAX_DETAILS, (QFilter[])new QFilter[]{qfilter});
                logger.info("InTaxNormDynamicRateRowFetchPlugin: \u8fd4\u56de\u7a0e\u7801\u7f16\u53f7:" + result.getData());
                if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                    this.context.getParam().put(generalincome_amount_tobe_accrued, "0.00");
                    this.context.getParam().put(generalincome_amount_due_overp, "0.00");
                    String string = "0.00%";
                    return string;
                }
                String codenumber = (String)((List)result.getData()).get(0);
                TaxResult taxResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumber((String)codenumber);
                DynamicObject resultDynamicObject = (DynamicObject)taxResult.getData();
                String taxcodeName = resultDynamicObject.getString("name");
                combineName = taxcodeName + "|" + codenumber;
                ArrayList<String> codeNumerList = new ArrayList<String>(16);
                codeNumerList.add(codenumber);
                logger.info("InTaxNormDynamicRateRowFetchPlugin: combineName:" + combineName);
                TaxResult dynamicResult = TaxcCombineBusinessDataServiceHelper.loadExtentByTaxcCodeNumbers(codeNumerList);
                List dynamicObjectList = ((List)dynamicResult.getData()).stream().filter(s -> s.toString().contains("bd_taxrate")).collect(Collectors.toList());
                ArrayList<DynamicObject> dataDynamicList = new ArrayList<DynamicObject>(16);
                for (DynamicObject dynamicObject : dynamicObjectList) {
                    DynamicObject taxratetypeDy = dynamicObject.getDynamicObject("taxratetype");
                    String taxratetype = taxratetypeDy.getString("number");
                    Long taxratetypeid = taxratetypeDy.getLong("id");
                    if (!"SLLX-01".equals(taxratetype)) continue;
                    BigDecimal taxRateBigDecimal = dynamicObject.getBigDecimal("taxrate");
                    BigDecimal amount = BigDecimalUtil.multiplyObject((Object)taxRateBigDecimal, (Object)new BigDecimal("100"), (int)2);
                    DynamicObject taxDetails = BusinessDataServiceHelper.newDynamicObject((String)BDTAXR_TAX_DETAILS);
                    taxDetails.set("orgid", (Object)orgid);
                    taxDetails.set("intervalamount", (Object)amount);
                    taxDetails.set("draftid", (Object)draftid);
                    taxDetails.set("intervalrateamount", (Object)amount);
                    taxDetails.set("range", (Object)ResManager.loadKDString((String)"\u533a\u95f4>0", (String)"InTaxNormDynamicRateRowFetchPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
                    taxDetails.set("reportkey", (Object)reportkey);
                    taxDetails.set("skssqq", (Object)skssqq);
                    taxDetails.set("skssqz", (Object)skssqz);
                    taxDetails.set("taxareagroup", (Object)taxareagroup);
                    taxDetails.set("taxationsys", (Object)taxationsys);
                    taxDetails.set("taxcodetype", (Object)1652818108961927168L);
                    taxDetails.set("taxrate", (Object)amount);
                    taxDetails.set("taxtype", (Object)taxtype);
                    taxDetails.set("templateid", (Object)templateid);
                    taxDetails.set("taxratetype", (Object)taxratetypeid);
                    taxDetails.set("draftpurpose", (Object)draftpurpose);
                    taxDetails.set("datastatus", (Object)"0");
                    dataDynamicList.add(taxDetails);
                    this.context.getParam().put(generalincome_amount_tobe_accrued, BigDecimalUtil.subtractObject((Object)taxRateBigDecimal, (Object)amountAccrued, (int)2));
                    this.context.getParam().put(generalincome_amount_due_overp, BigDecimalUtil.subtractObject((Object)taxRateBigDecimal, (Object)taxPaid, (int)2));
                }
                SaveServiceHelper.save((DynamicObject[])dataDynamicList.toArray(new DynamicObject[0]));
            }
            String string = combineName;
            return string;
        }
        catch (Exception e) {
            logger.info("throw exception : " + e.getMessage());
            this.context.getParam().put(generalincome_amount_tobe_accrued, "0.00");
            this.context.getParam().put(generalincome_amount_due_overp, "0.00");
            String string = "0.00%";
            return string;
        }
        finally {
            if (lock != null) {
                lock.unlock();
                logger.info("InTaxNormDynamicRateRowFetchPlugin  lock end");
            }
        }
    }

    public String query(Map<String, Object> param) {
        return null;
    }
}

