/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.helper.TaxcCombineBusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.bastax.taxccode.TaxcCodeDataServiceHelper;
import kd.taxc.bdtaxr.common.helper.ttc.TtcCalculateServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.refactor.formula.model.FormulaVo;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractCodeGetValueBasePlugin;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.AbstractGtcpDynamicRateStrategy;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.GtcpDynamicRateStrategyFactory;
import org.apache.commons.lang3.ObjectUtils;

public class OnlyRatioTaxRateRowFetchPlugin
extends AbstractCodeGetValueBasePlugin {
    private static final Log logger = LogFactory.getLog(OnlyRatioTaxRateRowFetchPlugin.class);
    private static final String BDTAXR_TAX_DETAILS = "bdtaxr_tax_details";
    private Context context;

    public OnlyRatioTaxRateRowFetchPlugin() {
        this.context = ((AbstractCodeGetValueBasePlugin)this).context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String queryByFormulaVo(Map<String, Object> param, FormulaVo formulaVo) {
        long timeMillis = System.currentTimeMillis();
        String reportkey = formulaVo.getFormulaKey();
        DLock lock = null;
        String combineName = "0.0";
        String taxrateType = "SLLX-03";
        try {
            long orgid = 0L;
            long country = 0L;
            long taxationsys = 0L;
            long taxtype = 0L;
            long taxareagroup = 0L;
            long draftid = 0L;
            long templateid = 0L;
            String draftpurpose = "";
            String ttctag = "";
            long tabtaxareagroup = 0L;
            BigDecimal tabynssde = BigDecimal.ZERO;
            Date skssqq = new Date();
            Date skssqz = new Date();
            Map taxProduct = new HashMap(16);
            Map<Long, Long> addressType = new HashMap(16);
            Map taxAptitude = new HashMap(16);
            Map process = new HashMap(16);
            if (param != null && param.size() > 0) {
                orgid = Long.parseLong((String)param.get("orgid"));
                taxationsys = Long.parseLong((String)param.get("taxationsys"));
                taxtype = Long.parseLong((String)param.get("taxtype"));
                taxProduct = (Map)param.get("taxProduct");
                addressType = (Map)param.get("addressType");
                taxAptitude = (Map)param.get("taxAptitude");
                process = (Map)param.get("process");
                templateid = (Long)param.get("templateId");
                taxareagroup = Long.parseLong((String)param.get("taxareagroup"));
                skssqq = DateUtils.stringToDate((String)((String)param.get("skssqq")));
                skssqz = DateUtils.stringToDate((String)((String)param.get("skssqz")));
                ttctag = (String)param.get("ttctag");
                draftpurpose = (String)param.get("draftpurpose");
            }
            Date validDate = new Date();
            ArrayList<Long> taxTypeList = new ArrayList<Long>(16);
            taxTypeList.add(taxtype);
            ArrayList taxProductList = new ArrayList(16);
            if (taxProduct != null) {
                taxProductList.add(taxProduct);
            }
            ArrayList addressTypeList = new ArrayList(16);
            if (addressType != null) {
                addressTypeList.add(addressType);
            } else {
                addressType = new HashMap(16);
                addressType.put(0L == tabtaxareagroup ? taxareagroup : tabtaxareagroup, 1036241275604686848L);
                addressTypeList.add(addressType);
            }
            ArrayList taxAptitudeList = new ArrayList(16);
            if (taxAptitude != null) {
                taxAptitudeList.add(taxAptitude);
            }
            ArrayList processList = new ArrayList(16);
            if (process != null) {
                processList.add(process);
            }
            logger.info("OnlyRatioTaxRateRowFetchPlugin: \u5f00\u59cb\u6761\u7528\u8ba1\u7a0e\u670d\u52a1\u627e\u7a0e\u7801\u7b49");
            TaxResult result = TtcCalculateServiceHelper.getTaxCodeAndRateByCondition((long)orgid, (long)country, (long)taxationsys, (String)ttctag, (Date)validDate, taxTypeList, taxProductList, addressTypeList, taxAptitudeList, processList);
            String key = String.format("%s_%s_%s_%s_%s_%s_%s_%s_%s", orgid, taxationsys, taxtype, reportkey, taxareagroup, templateid, draftpurpose, skssqq, skssqz);
            logger.info(timeMillis + "tabtaxareagroup: {}, OnlyRatioTaxRateRowFetchPluginkey: {}", (Object)tabtaxareagroup, (Object)key);
            lock = DLock.create((String)key);
            if (lock.tryLock(10000L)) {
                logger.info("\u83b7\u53d6\u9501\u7684\u4fe1\u606f" + DLock.getLockInfo((String)key));
                logger.info("OnlyRatioTaxRateRowFetchPlugin  lock start");
                logger.info("OnlyRatioTaxRateRowFetchPlugin: \u7ec4\u88c5\u8fc7\u6ee4\u6761\u4ef6");
                QFilter qfilter = new QFilter("orgid", "=", (Object)orgid);
                qfilter.and(new QFilter("taxationsys", "=", (Object)taxationsys));
                qfilter.and(new QFilter("taxtype", "=", (Object)taxtype));
                qfilter.and(new QFilter("reportkey", "=", (Object)reportkey));
                qfilter.and(new QFilter("taxareagroup", "=", (Object)taxareagroup));
                qfilter.and(new QFilter("templateid", "=", (Object)templateid));
                qfilter.and(new QFilter("draftpurpose", "=", (Object)draftpurpose));
                qfilter.and(new QFilter("skssqq", "=", (Object)skssqq));
                qfilter.and(new QFilter("skssqz", "=", (Object)skssqz));
                qfilter.and(new QFilter("datastatus", "=", (Object)"0"));
                DeleteServiceHelper.delete((String)BDTAXR_TAX_DETAILS, (QFilter[])new QFilter[]{qfilter});
                logger.info("\u5148\u5220\u9664\u5386\u53f2\u7ed3\u679c\u6570\u636e\u6761\u4ef6" + qfilter.toString());
                logger.info("OnlyRatioTaxRateRowFetchPlugin: \u8fd4\u56de\u7a0e\u7801\u7f16\u53f7:tabtaxareagroup: {}, data: {}", (Object)tabtaxareagroup, result.getData());
                if (EmptyCheckUtils.isEmpty((Object)result.getData())) {
                    logger.info(timeMillis + "OnlyRatioTaxRateRowFetchPluginkey-\u7ed3\u679c: \u7ed3\u679c\u4e3a\u7a7a.tabtaxareagroup: {}", (Object)tabtaxareagroup);
                    AbstractGtcpDynamicRateStrategy gtcpDynamicRateStrategyByType = GtcpDynamicRateStrategyFactory.getGtcpDynamicRateStrategyByType(taxrateType);
                    String string = "0.00";
                    return string;
                }
                String codenumber = (String)((List)result.getData()).get(0);
                TaxResult taxResult = TaxcCodeDataServiceHelper.loadTaxcCodeByNumber((String)codenumber);
                DynamicObject resultDynamicObject = (DynamicObject)taxResult.getData();
                String taxcodeName = resultDynamicObject.getString("name");
                ArrayList<String> codeNumerList = new ArrayList<String>(16);
                codeNumerList.add(codenumber);
                logger.info("OnlyRatioTaxRateRowFetchPlugin: combineName \u5f97\u5230\u7684\u7a0e\u7801\u7f16\u7801: {}, tabtaxareagroup: {}", (Object)codenumber, (Object)tabtaxareagroup);
                TaxResult dynamicResult = TaxcCombineBusinessDataServiceHelper.loadExtentByTaxcCodeNumbers(codeNumerList);
                AbstractGtcpDynamicRateStrategy gtcpDynamicRateStrategyByType = GtcpDynamicRateStrategyFactory.getGtcpDynamicRateStrategyByType(taxrateType);
                if (ObjectUtils.isEmpty((Object)gtcpDynamicRateStrategyByType)) {
                    String string = "0.00";
                    return string;
                }
                List<DynamicObject> dynamicObjectList = gtcpDynamicRateStrategyByType.delFilterTaxrateRow((List)dynamicResult.getData());
                if (ObjectUtils.isNotEmpty(dynamicObjectList)) {
                    dynamicObjectList.removeIf(row -> !StringUtil.equalsIgnoreCase((CharSequence)row.getString("taxratetype.number"), (CharSequence)"SLLX-03"));
                }
                List<Object> dataDynamicList = new ArrayList<DynamicObject>(16);
                gtcpDynamicRateStrategyByType.calculateResult(this.context, param, dynamicObjectList, dataDynamicList, tabynssde, reportkey, codenumber, taxcodeName);
                if (ObjectUtils.isNotEmpty(dataDynamicList) && dataDynamicList.size() > 0) {
                    combineName = BigDecimalUtil.multiplyObject((Object)((DynamicObject)dataDynamicList.get(0)).getBigDecimal("taxrate"), (Object)new BigDecimal("0.01"), (int)10).toString();
                    dataDynamicList = Collections.singletonList(dataDynamicList.get(0));
                } else {
                    combineName = "0.00";
                }
                SaveServiceHelper.save((DynamicObject[])dataDynamicList.toArray(new DynamicObject[0]));
                logger.info(timeMillis + "OnlyRatioTaxRateRowFetchPluginkey-\u7ed3\u679c,tabtaxareagroup: {} ,: {}", (Object)tabtaxareagroup, (Object)(combineName + "\r"));
            }
            String string = combineName;
            return string;
        }
        catch (Exception e) {
            logger.info(timeMillis + "OnlyRatioTaxRateRowFetchPluginkey-\u7ed3\u679c: \u62a5\u5f02\u5e38, tabtaxareagroup: {}", (Object)((String)param.get("codePluginParam_" + reportkey + "_1")));
            logger.info("throw exception : " + e.getMessage());
            AbstractGtcpDynamicRateStrategy gtcpDynamicRateStrategyByType = GtcpDynamicRateStrategyFactory.getGtcpDynamicRateStrategyByType(taxrateType);
            if (ObjectUtils.isNotEmpty((Object)gtcpDynamicRateStrategyByType)) {
                String string = gtcpDynamicRateStrategyByType.setDefaultValue(this.context, reportkey);
                return string;
            }
            String string = "0.00";
            return string;
        }
        finally {
            if (lock != null) {
                lock.unlock();
                logger.info("OnlyRatioTaxRateRowFetchPlugin  lock end.tabtaxareagroup:{}", (Object)((String)param.get("codePluginParam_" + reportkey + "_1")));
            }
        }
    }

    public String query(Map<String, Object> param) {
        return null;
    }
}

